/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import kd.bos.entity.property.entryfilter.EntryFilterItemInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import org.apache.commons.lang3.time.DateUtils;

public class SWCDateQFilterParserUtil {
    public static final String TODAY = "13";
    public static final String THISWEEK = "10";
    public static final String THISMONTH = "63";
    public static final String LASTMONTH = "92";
    public static final String LASTONEMONTH = "51";
    public static final String LASTTHREEMONTH = "24";
    public static final String BETWEEN = "1";
    public static final String EQUALS = "67";

    public static boolean isDateQFilter(String compareType) {
        HashSet<String> dateCompareType = new HashSet<String>(16);
        dateCompareType.add(TODAY);
        dateCompareType.add(THISWEEK);
        dateCompareType.add(THISMONTH);
        dateCompareType.add(LASTMONTH);
        dateCompareType.add(LASTONEMONTH);
        dateCompareType.add(LASTTHREEMONTH);
        dateCompareType.add(BETWEEN);
        return dateCompareType.contains(compareType);
    }

    public static QFilter buildQFilterByFilterItem(EntryFilterItemInfo filterItem) {
        QFilter qfilter = null;
        Date minDateTime = null;
        Date maxDateTime = null;
        if (TODAY.equals(filterItem.getCompareType())) {
            minDateTime = SWCDateQFilterParserUtil.addDays(0);
            maxDateTime = SWCDateQFilterParserUtil.addDays(1);
        }
        if (THISWEEK.equals(filterItem.getCompareType())) {
            minDateTime = KDDateUtils.getTheWeekStart((int)0, (Date)SWCDateQFilterParserUtil.getBaseToday());
            maxDateTime = KDDateUtils.getTheWeekEnd((int)0, (Date)SWCDateQFilterParserUtil.getBaseToday());
        }
        if (THISMONTH.equals(filterItem.getCompareType())) {
            minDateTime = KDDateUtils.getTheMonthStart((int)0, (Date)SWCDateQFilterParserUtil.getBaseToday());
            maxDateTime = KDDateUtils.getTheMonthEnd((int)0, (Date)SWCDateQFilterParserUtil.getBaseToday());
        }
        if (LASTMONTH.equals(filterItem.getCompareType())) {
            minDateTime = KDDateUtils.getTheMonthStart((int)-1, (Date)SWCDateQFilterParserUtil.getBaseToday());
            maxDateTime = KDDateUtils.getTheMonthEnd((int)-1, (Date)SWCDateQFilterParserUtil.getBaseToday());
        }
        if (LASTONEMONTH.equals(filterItem.getCompareType())) {
            minDateTime = SWCDateQFilterParserUtil.getTheMonthWithoutOffsetStart(-1);
            maxDateTime = SWCDateQFilterParserUtil.addDays(1);
        }
        if (LASTTHREEMONTH.equals(filterItem.getCompareType())) {
            minDateTime = SWCDateQFilterParserUtil.getTheMonthWithoutOffsetStart(-3);
            maxDateTime = SWCDateQFilterParserUtil.addDays(1);
        }
        if (BETWEEN.equals(filterItem.getCompareType())) {
            List list = (List)filterItem.getValue();
            minDateTime = KDDateUtils.parseDate((String)list.get(0).toString());
            maxDateTime = KDDateUtils.parseDate((String)list.get(1).toString());
        }
        qfilter = new QFilter(filterItem.getPropName(), ">=", (Object)minDateTime).and(new QFilter(filterItem.getPropName(), "<", (Object)maxDateTime));
        return qfilter;
    }

    private static Date getBaseToday() {
        return KDDateUtils.today();
    }

    private static Date addDays(int diff) {
        return DateUtils.addDays((Date)SWCDateQFilterParserUtil.getBaseToday(), (int)diff);
    }

    private static Date getTheMonthWithoutOffsetStart(int diff) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(SWCDateQFilterParserUtil.getBaseToday());
        ((Calendar)calendar).add(2, diff);
        return calendar.getTime();
    }
}

