/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.util;

import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;
import kd.bos.service.KDDateUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class SWCDateUtils {
    public static boolean isEqual(Date param1, Date param2) {
        if (param1 == null && param2 == null) {
            return true;
        }
        if (param1 == null || param2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal1.setTime(param1);
        Calendar cal2 = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal2.setTime(param2);
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5);
    }

    public static boolean after(Date param1, Date param2) {
        if (param1 == null) {
            return false;
        }
        if (param2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal1.setTime(param1);
        Calendar cal2 = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal2.setTime(param2);
        if (cal1.get(1) > cal2.get(1)) {
            return true;
        }
        if (cal1.get(1) < cal2.get(1)) {
            return false;
        }
        if (cal1.get(2) > cal2.get(2)) {
            return true;
        }
        if (cal1.get(2) < cal2.get(2)) {
            return false;
        }
        return cal1.get(5) > cal2.get(5);
    }

    public static boolean before(Date param1, Date param2) {
        if (param1 == null) {
            return false;
        }
        if (param2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal1.setTime(param1);
        Calendar cal2 = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal2.setTime(param2);
        if (cal1.get(1) < cal2.get(1)) {
            return true;
        }
        if (cal1.get(1) > cal2.get(1)) {
            return false;
        }
        if (cal1.get(2) < cal2.get(2)) {
            return true;
        }
        if (cal1.get(2) > cal2.get(2)) {
            return false;
        }
        return cal1.get(5) < cal2.get(5);
    }

    public static Date parseStringToDate(String dateStr) throws ParseException {
        try {
            Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
            String[] arr = dateStr.split("-");
            int year = Integer.parseInt(arr[0]);
            int month = Integer.parseInt(arr[1]);
            int day = Integer.parseInt(arr[2]);
            cal.set(1, year);
            cal.set(2, month - 1);
            cal.set(5, day);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        catch (Exception exception) {
            return SWCDateTimeUtils.parseDate(dateStr);
        }
    }

    public static Date lastDayOfMonth(Date date) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate lastDayOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth());
        return Date.from(lastDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static Date firstDayOfMonth(Date date) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate firstDayOfMonth = localDate.with(TemporalAdjusters.firstDayOfMonth());
        return Date.from(firstDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }
}

