/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.util;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class SWCJSONUtils {
    private static final Log logger = LogFactory.getLog(SWCJSONUtils.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String toString(Object source) throws IOException {
        return SWCJSONUtils.toString(source, false);
    }

    public static String toString(Object source, boolean indent) throws IOException {
        try {
            String result;
            if (indent) {
                mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            }
            String string = result = mapper.writeValueAsString(source);
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (indent) {
                mapper.configure(SerializationFeature.INDENT_OUTPUT, false);
            }
        }
    }

    public static <T> T cast(String source, Class<T> type) throws IOException {
        return SWCJSONUtils.cast(source, type, false);
    }

    public static <T> T cast(String source, Class<T> type, boolean ignoreUnkownField) throws IOException {
        try {
            Object result;
            if (ignoreUnkownField) {
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
            Object object = result = mapper.readValue(source, type);
            return (T)object;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (ignoreUnkownField) {
                mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
        }
    }

    public static <T> T cast(String source, Class<?> collectionType, Class<?> ... elementType) throws IOException {
        return SWCJSONUtils.cast(source, true, collectionType, elementType);
    }

    public static <T> T cast(String source, boolean ignoreUnkownField, Class<?> collectionType, Class<?> ... elementType) throws IOException {
        try {
            Object result;
            if (ignoreUnkownField) {
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
            JavaType type = SWCJSONUtils.getCollectionType(collectionType, elementType);
            Object object = result = mapper.readValue(source, type);
            return (T)object;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (ignoreUnkownField) {
                mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
        }
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static String getEmpty() {
        return "{}";
    }

    public static Map convertObjectToMap(Object obj) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                Method getter = property.getReadMethod();
                Object value = getter != null ? getter.invoke(obj, new Object[0]) : null;
                map.put(key, value);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        return map;
    }

    public static Map convertJSONObjectToMap(Object obj) throws Exception {
        if (obj == null) {
            return new HashMap();
        }
        JSONObject jsonObj = JSONObject.fromObject((Object)obj);
        return SWCJSONUtils.convertJSONMap(jsonObj);
    }

    public static HashMap convertJSONMap(JSONObject jsonObj) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator iter = jsonObj.keys();
        String key = null;
        while (iter.hasNext()) {
            key = iter.next().toString();
            Object obj = jsonObj.get(key);
            if (obj == null) {
                result.put(key, null);
                continue;
            }
            if (obj instanceof JSONArray) {
                result.put(key, SWCJSONUtils.convertJSONArray((JSONArray)obj));
                continue;
            }
            if (obj instanceof JSONObject) {
                result.put(key, SWCJSONUtils.convertJSONMap((JSONObject)obj));
                continue;
            }
            result.put(key, obj);
        }
        return result;
    }

    public static ArrayList convertJSONArray(JSONArray jsonArray) throws Exception {
        if (jsonArray == null) {
            return null;
        }
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObj = jsonArray.getJSONObject(i);
            list.add(SWCJSONUtils.convertJSONMap(jsonObj));
        }
        return list;
    }

    public static Long getLongValOfCustomParam(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        String value = String.valueOf(obj);
        return Long.valueOf(value);
    }

    public static Map<String, Object> jsonToMap(Object jsonObj) {
        JSONObject jsonObject;
        JSONObject map = jsonObject = JSONObject.fromObject((Object)jsonObj);
        return map;
    }

    public static <T> T map2Bean(Map<String, Object> map, Class<T> clazz) {
        if (map == null) {
            return null;
        }
        Object bean = null;
        try {
            bean = JSON.parseObject((String)JSON.toJSONString(map), clazz);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return (T)bean;
    }
}

