/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class SWCNumberGenerater {
    private SWCNumberGenerater() {
    }

    public static SWCNumberGenerater getInstance() {
        return Holder.numberGenerater;
    }

    public synchronized String generaterNextNumber(Date date, String prefix) {
        int code = UUID.randomUUID().toString().hashCode();
        if (code < 0) {
            code = -code;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String number = prefix + sdf.format(date) + String.format(Locale.ROOT, "%05d", code % 100000);
        ArrayList<String> numberList = (ArrayList<String>)SWCAppCache.get("hsbp").get(prefix, List.class);
        if (numberList == null) {
            numberList = new ArrayList<String>();
        }
        if (numberList.contains(number)) {
            code = UUID.randomUUID().toString().hashCode();
            number = prefix + sdf.format(date) + String.format(Locale.ROOT, "%05d", code % 100000);
        }
        numberList.add(number);
        SWCAppCache.get("hsbp").put(prefix, numberList);
        return number;
    }

    private static class Holder {
        private static SWCNumberGenerater numberGenerater = new SWCNumberGenerater();

        private Holder() {
        }
    }
}

