/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.addperson.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.addperson.filter.FilterSalaryFileByBaseRule;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CalPayRollTaskVO;
import kd.swc.hsbp.common.vo.SceneGroupVO;

public class FilterSalaryFileBaseRuleForRefresh
extends FilterSalaryFileByBaseRule {
    public static FilterSalaryFileBaseRuleForRefresh createInstance() {
        return new FilterSalaryFileBaseRuleForRefresh();
    }

    @Override
    public List<Long> getEnableSalaryFileIdList(CalPayRollTaskVO payRollTask, SceneGroupVO group) {
        Set<Long> lastSalaryFileIdSet;
        String taskType = payRollTask.getTaskType();
        if (SWCStringUtils.isEmpty((String)taskType)) {
            lastSalaryFileIdSet = this.queryAllSalaryFileIdSet(payRollTask.getPayrollgroupId());
        } else {
            lastSalaryFileIdSet = this.getSalaryFileInCalPersonIdSet(payRollTask);
            if (SWCStringUtils.equals((String)taskType, (String)"0")) {
                Set<Long> allSalaryFileIdSet = this.queryAllSalaryFileIdSet(payRollTask.getPayrollgroupId());
                allSalaryFileIdSet.removeAll(this.exceptionFileBoIdInTask(payRollTask));
                allSalaryFileIdSet.removeAll(lastSalaryFileIdSet);
                lastSalaryFileIdSet = allSalaryFileIdSet;
            } else if (SWCStringUtils.equals((String)taskType, (String)"1") && !payRollTask.isIslimitadd()) {
                lastSalaryFileIdSet = this.queryAllSalaryFileIdSet(payRollTask.getPayrollgroupId());
            }
        }
        if (lastSalaryFileIdSet.size() == 0) {
            return new ArrayList<Long>(0);
        }
        CalPersonHelper.setGetUpdateFileVidsProgress(payRollTask.getId(), 10);
        return this.filterSalaryFileIdList(payRollTask, lastSalaryFileIdSet, group);
    }

    @Override
    protected String getCalPayRollTaskSql(CalPayRollTaskVO calPayRollTask) {
        StringBuilder sql = new StringBuilder("SELECT M.FID id FROM T_HSAS_CALPAYROLLTASK M INNER JOIN T_HSAS_CALPAYROLLTASK_A E ON M.FID = E.FID");
        sql.append(" AND M.FPAYROLLSCENEID = ").append(calPayRollTask.getPayrollsceneId()).append(" AND M.FPAYROLLGROUPID = ").append(calPayRollTask.getPayrollgroupId()).append(" AND E.FPERIODID = ").append(calPayRollTask.getPeriodId()).append(" AND M.FTASKTYPE = '0'").append(" AND M.FID != ").append(calPayRollTask.getId());
        return sql.toString();
    }

    private Set<Long> exceptionFileBoIdInTask(CalPayRollTaskVO calPayRollTaskVO) {
        long calTaskId = calPayRollTaskVO.getId();
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calTaskFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        QFilter exceptionFiler = new QFilter("addfiletype", "=", (Object)"1");
        DynamicObject[] exceptionCalPerson = calPersonHelper.query("salaryfilev.boid", new QFilter[]{calTaskFilter, exceptionFiler});
        HashSet<Long> exceptionFileBoIds = new HashSet<Long>(16);
        for (DynamicObject calPerson : exceptionCalPerson) {
            exceptionFileBoIds.add(calPerson.getLong("salaryfilev.boid"));
        }
        return exceptionFileBoIds;
    }

    public Set<Long> getExistFileIdForRefresh(CalPayRollTaskVO calPayRollTaskVO) {
        String taskType = calPayRollTaskVO.getTaskType();
        if (SWCStringUtils.equals((String)taskType, (String)"0")) {
            return this.getSalaryFileInCalPersonIdSet(calPayRollTaskVO);
        }
        return new HashSet<Long>(CalPersonHelper.getFileIdsByTask(calPayRollTaskVO.getId()));
    }
}

