/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.addperson.filter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.addperson.filter.FilterSalaryFileService;
import kd.swc.hsbp.business.addperson.rulefilte.AddPersonByRuleHelper;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.proration.HandleProrationHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CalPayRollTaskVO;
import kd.swc.hsbp.common.vo.MatchedSalaryFileVO;
import kd.swc.hsbp.common.vo.SceneGroupVO;
import kd.swc.hsbp.common.vo.SceneRuleVO;

public class FilterSalaryFileByBaseRule {
    private static final Log logger = LogFactory.getLog(FilterSalaryFileByBaseRule.class);
    public static final String SALARY_CALC_STYLE = "salarycalcstyle";
    public static final String SALARY_CALC_STYLE_ID = "salarycalcstyle.id";
    public static final String ATTACH_CONDITION = "attachcondition";
    public static final String NOT_NEED_BIZ_DATA = "0";
    public static final String MULTI_BIZ_DATA = "calbordermulbd";
    public static final int DEFAULT_SIZE = 10000;

    public static FilterSalaryFileByBaseRule createInstance() {
        return new FilterSalaryFileByBaseRule();
    }

    public List<Long> getEnableSalaryFileIdList(CalPayRollTaskVO payRollTask, SceneGroupVO group) {
        logger.info("FilterSalaryFileByBaseRule.getEnableSalaryFileIdList begin: task id = {}.", (Object)payRollTask.getId());
        long startTime = System.currentTimeMillis();
        String taskType = payRollTask.getTaskType();
        Set<Object> lastSalaryFileIdSet = new HashSet(16);
        if (SWCStringUtils.isEmpty((String)taskType)) {
            lastSalaryFileIdSet = this.queryAllSalaryFileIdSet(payRollTask.getPayrollgroupId());
        } else {
            lastSalaryFileIdSet = this.getSalaryFileInCalPersonIdSet(payRollTask);
            if (SWCStringUtils.equals((String)taskType, (String)NOT_NEED_BIZ_DATA)) {
                lastSalaryFileIdSet = this.getSalaryFileInCalPersonIdSet(payRollTask);
                Set<Long> allSalaryFileIdSet = this.queryAllSalaryFileIdSet(payRollTask.getPayrollgroupId());
                allSalaryFileIdSet.removeAll(lastSalaryFileIdSet);
                lastSalaryFileIdSet = allSalaryFileIdSet;
            } else if ("1".equals(payRollTask.getTaskType())) {
                Set<Long> salaryFileIdInCalPersonSet = this.getSalaryFileIdInCalPersonSet(Collections.singletonList(payRollTask.getId()));
                lastSalaryFileIdSet = !payRollTask.isIslimitadd() ? this.queryAllSalaryFileIdSet(payRollTask.getPayrollgroupId()) : this.getSalaryFileInCalPersonIdSet(payRollTask);
                lastSalaryFileIdSet.removeAll(salaryFileIdInCalPersonSet);
            }
        }
        if (lastSalaryFileIdSet.size() == 0) {
            return new ArrayList<Long>(0);
        }
        CalPersonHelper.setGetFileVidsProgress(payRollTask.getId(), 10, null);
        long costTime = System.currentTimeMillis() - startTime;
        List<Long> enableSalaryFileIdList = this.filterSalaryFileIdList(payRollTask, lastSalaryFileIdSet, group);
        logger.info("FilterSalaryFileByBaseRule.getEnableSalaryFileIdList end: task id = {}, it takes {} milliseconds.", (Object)payRollTask.getId(), (Object)costTime);
        return enableSalaryFileIdList;
    }

    public List<Long> filterSalaryFileIdList(CalPayRollTaskVO payRollTask, Set<Long> allSalaryFileIdSet, SceneGroupVO group) {
        logger.info("FilterSalaryFileByBaseRule.filterSalaryFileIdList begin.");
        if (allSalaryFileIdSet == null || allSalaryFileIdSet.size() == 0) {
            return new ArrayList<Long>(0);
        }
        List<Long> salaryFileIdList = this.filterOnHoldBySalaryFileIds(payRollTask, allSalaryFileIdSet);
        CalPersonHelper.setGetUpdateFileVidsProgress(payRollTask.getId(), 30);
        CalPersonHelper.setGetFileVidsProgress(payRollTask.getId(), 30, null);
        List<Long> salaryFileVidList = this.matchSalaryFileVIdList(salaryFileIdList, payRollTask, group);
        CalPersonHelper.setGetUpdateFileVidsProgress(payRollTask.getId(), 50);
        CalPersonHelper.setGetFileVidsProgress(payRollTask.getId(), 50, null);
        return salaryFileVidList;
    }

    public List<Long> filterSalaryFileBoIdsOnlyInBizData(Long taskId, Long currUserId, List<Long> salaryFileIdList) {
        boolean isInvalid;
        if (currUserId == null) {
            currUserId = 0L;
        }
        Long trackerId = 0L;
        CalPayRollTaskVO calPayRollTaskVO = null;
        try {
            calPayRollTaskVO = CalPersonHelper.queryCalPayRollTask(taskId, trackerId);
        }
        catch (Exception ex) {
            logger.error("FilterSalaryFileByBaseRule.filterSalaryFileBoIdsOnlyInBizData: ", (Throwable)ex);
        }
        boolean bl = isInvalid = calPayRollTaskVO == null || CalPayRollTaskVO.TaskTypeEnum.CAL_HISTORY_IMPORT.getTaskType().equals(calPayRollTaskVO.getTaskType()) || Long.valueOf(0L).equals(calPayRollTaskVO.getPayrollgroupId()) || Long.valueOf(0L).equals(calPayRollTaskVO.getPayrollsceneVid()) || Long.valueOf(0L).equals(calPayRollTaskVO.getPeriodId());
        if (isInvalid) {
            return new ArrayList<Long>(0);
        }
        List<Long> allFileVids = CalPersonHelper.getSalaryFileHisByRule(new HashSet<Long>(salaryFileIdList), calPayRollTaskVO);
        List groups = calPayRollTaskVO.getGroups();
        ArrayList<Long> noBizDataFileVids = new ArrayList<Long>();
        for (SceneGroupVO group : groups) {
            List<Long> sumSalaryStyleIdList = new ArrayList<Long>();
            List rules = group.getRules();
            if (!SWCListUtils.isEmpty((List)rules)) {
                sumSalaryStyleIdList = rules.stream().filter(o -> NOT_NEED_BIZ_DATA.equals(o.getAttachcondition())).map(SceneRuleVO::getCalcstyle).collect(Collectors.toList());
            }
            Long calListRuleId = group.getCalListRuleId();
            List<Long> salaryFileHisIdList = this.querySalaryFileHis(calPayRollTaskVO, salaryFileIdList, sumSalaryStyleIdList);
            if (calListRuleId != null && calListRuleId != 0L) {
                salaryFileHisIdList = AddPersonByRuleHelper.filterPersonWithRule(salaryFileHisIdList, calPayRollTaskVO, calPayRollTaskVO.getStartdate(), calPayRollTaskVO.getEnddate(), group);
            }
            noBizDataFileVids.addAll(salaryFileHisIdList);
        }
        SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObjectCollection noBizDataFiles = fileHelper.queryOriginalCollection("boid", new QFilter("id", "in", noBizDataFileVids).toArray());
        QFilter allFileFilter = new QFilter("id", "in", allFileVids);
        allFileFilter.and("payrollgroup", "=", (Object)calPayRollTaskVO.getPayrollgroupId());
        DynamicObjectCollection allFiles = fileHelper.queryOriginalCollection("boid", allFileFilter.toArray());
        List<Long> resultIds = allFiles.stream().map(o -> o.getLong("boid")).collect(Collectors.toList());
        List noBizDataFileBoids = noBizDataFiles.stream().map(o -> o.getLong("boid")).collect(Collectors.toList());
        resultIds.removeAll(noBizDataFileBoids);
        return resultIds;
    }

    private List<Long> querySalaryFileHis(CalPayRollTaskVO calPayRollTask, List<Long> salaryFileBoIdList, List<Long> sumSalaryStyleIdList) {
        Date calPeriodEndTime = calPayRollTask.getEnddate();
        Date calPeriodStartTime = calPayRollTask.getStartdate();
        QFilter qFilter = new QFilter("boid", "in", salaryFileBoIdList);
        BaseDataHisHelper.addHisVerFilter(qFilter);
        QFilter payStatusFilter = new QFilter("paystatus", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)calPeriodEndTime);
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)calPeriodStartTime);
        QFilter salaryCalStyleFilter = new QFilter(SALARY_CALC_STYLE_ID, "in", sumSalaryStyleIdList);
        qFilter.and(payStatusFilter);
        qFilter.and(dataStatusFilter);
        qFilter.and(bsedFilter);
        qFilter.and(bsledFilter);
        qFilter.and(salaryCalStyleFilter);
        SWCDataServiceHelper salaryFileHisHelper = new SWCDataServiceHelper("hsas_salaryfile");
        Object[] salaryFileHisDyArr = salaryFileHisHelper.queryOriginalArray("id,boid,salarycalcstyle.id,bsed", qFilter.toArray());
        if (SWCArrayUtils.isEmpty((Object[])salaryFileHisDyArr)) {
            return new ArrayList<Long>(0);
        }
        return Arrays.stream(salaryFileHisDyArr).map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> matchSalaryFileVIdList(List<Long> salaryFileIdList, CalPayRollTaskVO payRollTask, SceneGroupVO group) {
        List<MatchedSalaryFileVO> matchedSalaryFileVOS = this.getMatchedSalaryFileVOList(salaryFileIdList, payRollTask, group);
        List<Long> lastSalaryFileVids = matchedSalaryFileVOS.stream().map(MatchedSalaryFileVO::getFileVId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        matchedSalaryFileVOS.clear();
        return lastSalaryFileVids;
    }

    private List<MatchedSalaryFileVO> getMatchedSalaryFileVOList(List<Long> salaryFileIdList, CalPayRollTaskVO payRollTask, SceneGroupVO group) {
        long startTime = System.currentTimeMillis();
        HashSet<Long> salaryStyleWithoutBizItemSet = new HashSet<Long>(16);
        Map<Long, List<Long>> salaryStyleWithBizItemMap = FilterSalaryFileByBaseRule.getPayRollScopeInfoMap(group, salaryStyleWithoutBizItemSet);
        List<QFilter> authorizedFilterList = this.getAuthorizedFilterArr(payRollTask.getTrackerId());
        if (salaryStyleWithBizItemMap.isEmpty() && salaryStyleWithoutBizItemSet.isEmpty() || authorizedFilterList == null) {
            return new ArrayList<MatchedSalaryFileVO>(0);
        }
        CopyOnWriteArrayList sumEnableSalaryFileVIdList = new CopyOnWriteArrayList();
        RequestContext ctx = RequestContext.get();
        List subList = Lists.partition(salaryFileIdList, (int)10000);
        CountDownLatch countDownLatch = new CountDownLatch(subList.size());
        for (List list : subList) {
            SWCThreadPoolFactory.getCalpersonQueryThreadPool().execute(() -> {
                List<MatchedSalaryFileVO> subEnableSalaryFileVoList;
                try {
                    FilterSalaryFileService service = new FilterSalaryFileService(payRollTask, list, salaryStyleWithBizItemMap, salaryStyleWithoutBizItemSet, authorizedFilterList, ctx);
                    subEnableSalaryFileVoList = service.filterSalaryFileVoList();
                }
                catch (Exception e) {
                    logger.error("FilterSalaryFileByBaseRule.getMatchedSalaryFileVOList, filter salary file failed:  ", (Throwable)e);
                    countDownLatch.countDown();
                    throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
                }
                if (!SWCListUtils.isEmpty(subEnableSalaryFileVoList)) {
                    sumEnableSalaryFileVIdList.addAll(subEnableSalaryFileVoList);
                }
                countDownLatch.countDown();
            });
        }
        boolean await = false;
        try {
            await = countDownLatch.await(120L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            logger.error("FilterSalaryFileByBaseRule.getMatchedSalaryFileVOList error: the current thread is interrupted while waiting.");
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
        if (!await) {
            logger.error("FilterSalaryFileByBaseRule.filterSalaryFileId error: time out.");
        }
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("FilterSalaryFileByBaseRule.getMatchedSalaryFileVOList end: task id = {}, it takes {} milliseconds, sum size is {}", new Object[]{payRollTask.getId(), costTime, sumEnableSalaryFileVIdList.size()});
        return new ArrayList<MatchedSalaryFileVO>(sumEnableSalaryFileVIdList);
    }

    public Set<Long> filterOnHold(CalPayRollTaskVO payRollTask) {
        logger.info("FilterSalaryFileByBaseRule.filterOnHold begin: taskId = {}", (Object)payRollTask.getId());
        long startTime = System.currentTimeMillis();
        Date taskStartDate = HandleProrationHelper.replaceDateTime(payRollTask.getStartdate(), "00:00:00");
        Date taskEndDate = HandleProrationHelper.replaceDateTime(payRollTask.getEnddate(), "23:59:59");
        SWCDataServiceHelper onHoldFileHelper = new SWCDataServiceHelper("hsas_onholdfile");
        QFilter filter = new QFilter("status", "!=", (Object)String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()));
        filter.and("startdate", "<=", (Object)taskEndDate);
        filter.and("enddate", ">=", (Object)taskStartDate);
        Object[] onHoldFileDyArr = onHoldFileHelper.queryOriginalArray("salaryfile.id", filter.toArray());
        if (SWCArrayUtils.isEmpty((Object[])onHoldFileDyArr)) {
            return new HashSet<Long>(0);
        }
        Set<Long> onHoldSalaryFileIdSet = Arrays.stream(onHoldFileDyArr).map(onHoldFileDy -> onHoldFileDy.getLong("salaryfile.id")).collect(Collectors.toSet());
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("FilterSalaryFileByBaseRule.filterOnHold end: taskId = {}, cost time = {}", (Object)payRollTask.getId(), (Object)costTime);
        return onHoldSalaryFileIdSet;
    }

    public List<Long> filterOnHoldBySalaryFileIds(CalPayRollTaskVO payRollTask, Set<Long> allSalaryFileIdSet) {
        HashSet<Long> retSalaryFileIdSet = new HashSet<Long>(allSalaryFileIdSet.size());
        logger.info("FilterSalaryFileByBaseRule.filterOnHoldBySalaryFileIds begin: taskId = {}", (Object)payRollTask.getId());
        SWCDataServiceHelper onHoldFileHelper = new SWCDataServiceHelper("hsas_onholdfile");
        QFilter filter = new QFilter("salaryfile.id", "in", allSalaryFileIdSet);
        DynamicObjectCollection onHoldFileDyArr = onHoldFileHelper.queryOriginalCollection("salaryfile.id,status,startdate,isallowcal", filter.toArray(), "createtime asc");
        if (onHoldFileDyArr == null || onHoldFileDyArr.size() == 0) {
            return new ArrayList<Long>(allSalaryFileIdSet);
        }
        HashMap<Long, ArrayList<DynamicObject>> onHoldMap = new HashMap<Long, ArrayList<DynamicObject>>(16);
        for (DynamicObject onHoldFileObj : onHoldFileDyArr) {
            Long salaryFileId = onHoldFileObj.getLong("salaryfile.id");
            ArrayList<DynamicObject> onHoldFileList = (ArrayList<DynamicObject>)onHoldMap.get(salaryFileId);
            if (onHoldFileList == null) {
                onHoldFileList = new ArrayList<DynamicObject>(10);
            }
            onHoldFileList.add(onHoldFileObj);
            onHoldMap.put(salaryFileId, onHoldFileList);
        }
        for (Long salaryFileId : allSalaryFileIdSet) {
            List onHoldFileList = (List)onHoldMap.get(salaryFileId);
            if (onHoldFileList == null || onHoldFileList.size() == 0) {
                retSalaryFileIdSet.add(salaryFileId);
                continue;
            }
            for (DynamicObject onHoldFileObj : onHoldFileList) {
                Date startDate;
                String isAllowCal = onHoldFileObj.getString("isallowcal");
                if (SWCStringUtils.equals((String)isAllowCal, (String)"1")) {
                    retSalaryFileIdSet.add(salaryFileId);
                    continue;
                }
                String status = onHoldFileObj.getString("status");
                if (SWCStringUtils.equals((String)status, (String)" ") || SWCStringUtils.equals((String)status, (String)String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()))) {
                    retSalaryFileIdSet.add(salaryFileId);
                    continue;
                }
                if (!SWCStringUtils.equals((String)status, (String)String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode())) && !SWCStringUtils.equals((String)status, (String)String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode())) && !SWCStringUtils.equals((String)status, (String)String.valueOf(OnHoldStatusEnum.STATUS_TOPAY.getCode())) || (startDate = onHoldFileObj.getDate("startdate")) == null) continue;
                startDate = HandleProrationHelper.replaceDateTime(startDate, "23:59:59");
                Date taskEndDate = HandleProrationHelper.replaceDateTime(payRollTask.getEnddate(), "23:59:59");
                if (startDate.getTime() > taskEndDate.getTime()) {
                    retSalaryFileIdSet.add(salaryFileId);
                    continue;
                }
                retSalaryFileIdSet.remove(salaryFileId);
            }
        }
        return new ArrayList<Long>(retSalaryFileIdSet);
    }

    private static Map<Long, List<Long>> getPayRollScopeInfoMap(SceneGroupVO group, Set<Long> salaryStyleWithoutBizItemSet) {
        logger.info("FilterSalaryFileByBaseRule.getPayRollScopeInfoMap begin.");
        if (group == null) {
            return new HashMap<Long, List<Long>>(0);
        }
        long startTime = System.currentTimeMillis();
        HashMap<Long, List<Long>> salaryStyleWithBizItemsMap = new HashMap<Long, List<Long>>(16);
        List rules = group.getRules();
        for (SceneRuleVO rule : rules) {
            Long salaryCalStyleId = rule.getCalcstyle();
            if (NOT_NEED_BIZ_DATA.equals(rule.getAttachcondition())) {
                salaryStyleWithoutBizItemSet.add(salaryCalStyleId);
                continue;
            }
            if (rule.getBizItems() == null || rule.getBizItems().isEmpty()) continue;
            salaryStyleWithBizItemsMap.put(salaryCalStyleId, rule.getBizItems());
        }
        long costTime = System.currentTimeMillis() - startTime;
        int salaryStyleWithoutBizItemSize = salaryStyleWithoutBizItemSet.size();
        int salaryStyleWithBizItemSize = salaryStyleWithBizItemsMap.size();
        logger.info("FilterSalaryFileByBaseRule.getPayRollScopeInfoMap end: it takes {} milliseconds, salary style without biz item size is {}, salary style with biz item size is {}", new Object[]{costTime, salaryStyleWithoutBizItemSize, salaryStyleWithBizItemSize});
        return salaryStyleWithBizItemsMap;
    }

    protected Set<Long> queryAllSalaryFileIdSet(Long payrollGroupId) {
        long startTime = System.currentTimeMillis();
        String sql = "SELECT FID id FROM T_HSAS_SALARYFILE WHERE FPAYROLLGROUPID = ? AND FSTATUS = 'C'";
        try (DataSet queryDataSet = DB.queryDataSet((String)(this.getClass().getName() + ".queryAllSalaryFileIdSet"), (DBRoute)SWCConstants.SWC_ROUETE, (String)sql, (Object[])new Object[]{payrollGroupId});){
            if (queryDataSet != null) {
                HashSet<Long> usedSalaryFileIdSet = new HashSet<Long>(16);
                while (queryDataSet.hasNext()) {
                    Row row = queryDataSet.next();
                    usedSalaryFileIdSet.add(row.getLong("id"));
                }
                HashSet<Long> hashSet = usedSalaryFileIdSet;
                return hashSet;
            }
        }
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("FilterSalaryFileByBaseRule.queryAllSalaryFileIdSet end: task id = {}, it takes {} milliseconds.", (Object)costTime);
        return new HashSet<Long>(0);
    }

    private List<QFilter> getAuthorizedFilterArr(Long trackerId) {
        if (trackerId == 0L) {
            return Arrays.asList(new QFilter("1", "=", (Object)1).toArray());
        }
        List<QFilter> qFilterList = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter(trackerId, "/UHMBBGZQ65X", "hsas_salaryfile", "47150e89000000ac");
        if (qFilterList == null) {
            logger.info("FilterSalaryFileByBaseRule.getAuthorizedFilter: the tracker does not have any permission.");
        } else if (qFilterList.isEmpty()) {
            logger.info("FilterSalaryFileByBaseRule.getAuthorizedFilter: the tracker haves all permission.");
        } else {
            logger.info("FilterSalaryFileByBaseRule.getAuthorizedFilter: the filter info is [{}]", (Object)qFilterList.get(0).toString());
        }
        return qFilterList;
    }

    public Set<Long> getSalaryFileInCalPersonIdSet(CalPayRollTaskVO calPayRollTask) {
        long startTime = System.currentTimeMillis();
        Set<Long> sumTaskPkIdSet = this.getCalPayRollTaskIdSet(calPayRollTask);
        if (sumTaskPkIdSet.isEmpty()) {
            return new HashSet<Long>(0);
        }
        Set<Long> salaryFileIdInCalPersonSet = this.getSalaryFileIdInCalPersonSet(sumTaskPkIdSet);
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("FilterSalaryFileByBaseRule.getSalaryFileInCalPersonIdSet end: task id = {}, it takes {} milliseconds.", (Object)calPayRollTask.getId(), (Object)costTime);
        return salaryFileIdInCalPersonSet;
    }

    public Set<Long> getSalaryFileIdInCalPersonSet(Collection<Long> sumTaskPkIds) {
        if (sumTaskPkIds.isEmpty()) {
            return new HashSet<Long>(0);
        }
        StringJoiner calTaskIdSj = new StringJoiner(",");
        for (Long sumTaskPkId : sumTaskPkIds) {
            calTaskIdSj.add(((Object)sumTaskPkId).toString());
        }
        String sql = "SELECT FSALARYFILEID FROM T_HSAS_CALPERSON WHERE FCALTASKID IN (" + calTaskIdSj + ')';
        try (DataSet queryDataSet = DB.queryDataSet((String)(this.getClass().getName() + ".getSalaryFileIdInCalPersonSet"), (DBRoute)SWCConstants.SWC_ROUETE, (String)sql);){
            if (queryDataSet != null) {
                HashSet<Long> salaryFileIdSet = new HashSet<Long>(sumTaskPkIds.size());
                while (queryDataSet.hasNext()) {
                    Row row = queryDataSet.next();
                    salaryFileIdSet.add(row.getLong("FSALARYFILEID"));
                }
                HashSet<Long> hashSet = salaryFileIdSet;
                return hashSet;
            }
        }
        return new HashSet<Long>(0);
    }

    private Set<Long> getCalPayRollTaskIdSet(CalPayRollTaskVO calPayRollTask) {
        String sql = this.getCalPayRollTaskSql(calPayRollTask);
        try (DataSet queryDataSet = DB.queryDataSet((String)(this.getClass().getName() + ".getCalPayRollTaskIdSet"), (DBRoute)SWCConstants.SWC_ROUETE, (String)sql);){
            if (queryDataSet != null) {
                HashSet<Long> sumTaskPkIdSet = new HashSet<Long>(16);
                while (queryDataSet.hasNext()) {
                    Row row = queryDataSet.next();
                    sumTaskPkIdSet.add(row.getLong("id"));
                }
                HashSet<Long> hashSet = sumTaskPkIdSet;
                return hashSet;
            }
        }
        return new HashSet<Long>(0);
    }

    protected String getCalPayRollTaskSql(CalPayRollTaskVO calPayRollTask) {
        StringBuilder sql = new StringBuilder("SELECT M.FID id FROM T_HSAS_CALPAYROLLTASK M INNER JOIN T_HSAS_CALPAYROLLTASK_A E ON M.FID = E.FID");
        sql.append(" AND M.FPAYROLLGROUPID = ").append(calPayRollTask.getPayrollgroupId()).append(" AND M.FPAYROLLSCENEID = ").append(calPayRollTask.getPayrollsceneId()).append(" AND E.FPERIODID = ").append(calPayRollTask.getPeriodId()).append(" AND M.FTASKTYPE = '0'");
        return sql.toString();
    }
}

