/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.addperson.rulefilte;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.addperson.rulefilte.AnalysisRuleService;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.report.AdminOrgHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.enums.RuleOperatorEnum;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CalPayRollTaskVO;
import kd.swc.hsbp.common.vo.ConditionInfo;
import kd.swc.hsbp.common.vo.RuleConditionInfo;
import kd.swc.hsbp.common.vo.SceneGroupVO;

public class AddPersonByRuleHelper {
    private static final Log log = LogFactory.getLog(AddPersonByRuleHelper.class);
    public static int BATCH_SIZE = 1000;

    public static List<Long> filterPersonWithRule(List<Long> filevIds, CalPayRollTaskVO task, Date startDate, Date endDate, SceneGroupVO group) {
        Vector<Long> filterList = new Vector<Long>(filevIds.size());
        try {
            long t1 = System.currentTimeMillis();
            RuleConditionInfo ruleConditionInfo = AddPersonByRuleHelper.queryRuleInfo(startDate, endDate, task, group);
            Map<String, Set<String>> entityFiledMap = AddPersonByRuleHelper.getUsedsEntityAndFileds(ruleConditionInfo);
            Map<String, Set<String>> subAdminOrgMap = AddPersonByRuleHelper.getSubAdminOrgMap(ruleConditionInfo, endDate);
            List subList = Lists.partition(filevIds, (int)BATCH_SIZE);
            HashMap<String, Object> taskMap = new HashMap<String, Object>(16);
            taskMap.put("startdate", startDate);
            taskMap.put("enddate", endDate);
            AddPersonByRuleHelper.getTaskMap(task, taskMap);
            AddPersonByRuleHelper.getLastPeriodDate(task, startDate, taskMap);
            RequestContext ctx = RequestContext.get();
            CountDownLatch countDownLatch = new CountDownLatch(subList.size());
            for (List filevIdsBatch : subList) {
                SWCThreadPoolFactory.getCalpersonMatchThreadPool().execute(() -> {
                    RequestContext.copyAndSet((RequestContext)ctx);
                    try {
                        AnalysisRuleService analysisRuleService = new AnalysisRuleService(taskMap, filevIdsBatch, entityFiledMap, ruleConditionInfo, filterList, subAdminOrgMap);
                        analysisRuleService.filterFilev();
                    }
                    catch (Exception e) {
                        log.error("\u5206\u6279\u89e3\u6790\u89c4\u5219\u62a5\u9519", (Throwable)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
            boolean await = countDownLatch.await(30L, TimeUnit.MINUTES);
            if (!await) {
                log.error("\u89e3\u6790\u89c4\u5219\u8d85\u65f6");
            }
            long t2 = System.currentTimeMillis();
            log.info("all analysis rule cost: {}ms", (Object)(t2 - t1));
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u89c4\u5219\u62a5\u9519", (Throwable)e);
            return new ArrayList<Long>(10);
        }
        return filterList;
    }

    private static void getLastPeriodDate(CalPayRollTaskVO task, Date startDate, Map<String, Object> taskMap) {
        Long periodTypeId = task.getPeriodTypeId();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_calperiod");
        QFilter qFilter = new QFilter("periodtypeid", "=", (Object)periodTypeId);
        qFilter.and("startdate", "<", (Object)startDate);
        DynamicObject lastPeriod = helper.queryOne("startdate,enddate", qFilter.toArray(), "startdate desc");
        if (lastPeriod != null) {
            taskMap.put("lastPeriodStartDate", lastPeriod.getDate("startdate"));
            taskMap.put("lastPeriodEndDate", lastPeriod.getDate("enddate"));
        }
    }

    private static void getTaskMap(CalPayRollTaskVO task, Map<String, Object> taskMap) {
        taskMap.put("enddate", task.getEnddate());
        taskMap.put("startdate", task.getStartdate());
        taskMap.put("exratedate", task.getExratedate());
        taskMap.put("paydate", task.getPaydate());
        taskMap.put("country", task.getCountryId());
        taskMap.put("payrollmonth", task.getPayrollmonth());
        taskMap.put("payrollyear", task.getPayrollyear());
    }

    private static Map<String, Set<String>> getUsedsEntityAndFileds(RuleConditionInfo ruleConditionInfo) {
        HashMap<String, Set<String>> entityFiledMap = new HashMap<String, Set<String>>(16);
        List conditionList = ruleConditionInfo.getConditionList();
        for (ConditionInfo conditionInfo : conditionList) {
            String param = conditionInfo.getParam();
            param = param.toLowerCase();
            String[] splitArr = param.split("\\.");
            String entity = splitArr[0];
            String filed = splitArr[1];
            Set fileds = entityFiledMap.computeIfAbsent(entity, val -> new HashSet(10));
            fileds.add(filed);
            if (!SWCStringUtils.equals((String)conditionInfo.getValueType(), (String)"1")) continue;
            param = conditionInfo.getValue();
            param = param.toLowerCase();
            splitArr = param.split("\\.");
            entity = splitArr[0];
            filed = splitArr[1];
            fileds = entityFiledMap.computeIfAbsent(entity, val -> new HashSet(10));
            fileds.add(filed);
        }
        return entityFiledMap;
    }

    private static Map<String, Set<String>> getSubAdminOrgMap(RuleConditionInfo ruleConditionInfo, Date enddate) {
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>(16);
        List conditionList = ruleConditionInfo.getConditionList();
        for (ConditionInfo conditionInfo : conditionList) {
            String value;
            Set allAdminOrgIds;
            String operators = conditionInfo.getOperators();
            if (!SWCStringUtils.equals((String)operators, (String)RuleOperatorEnum.IS_OR_IS_SUB.getValue()) && !SWCStringUtils.equals((String)operators, (String)RuleOperatorEnum.NOT_AND_NOTSUB.getValue()) || (allAdminOrgIds = resultMap.computeIfAbsent(value = conditionInfo.getValue(), key -> new HashSet(10))).size() > 0) continue;
            String[] adminOrgIdstrs = value.split(",");
            ArrayList<Long> adminOrgIds = new ArrayList<Long>(10);
            for (String adminOrgIdstr : adminOrgIdstrs) {
                adminOrgIds.add(Long.valueOf(adminOrgIdstr));
                allAdminOrgIds.add(adminOrgIdstr);
            }
            List<Map<String, Object>> allSubAdminOrg = AdminOrgHelper.getAllSubAdminOrg(adminOrgIds, enddate);
            for (Map<String, Object> map : allSubAdminOrg) {
                allAdminOrgIds.add(map.get("orgId").toString());
            }
        }
        return resultMap;
    }

    private static RuleConditionInfo queryRuleInfo(Date startDate, Date endDate, CalPayRollTaskVO task, SceneGroupVO group) {
        String ruleContent = task.getRuleContent();
        if (SWCStringUtils.isEmpty((String)ruleContent)) {
            SWCDataServiceHelper ruleHelper = new SWCDataServiceHelper("hsas_callistrule");
            QFilter qFilter = new QFilter("boid", "=", (Object)group.getCalListRuleId());
            qFilter.and(AddPersonByRuleHelper.getDateFilter(startDate, endDate));
            qFilter.and(new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus()));
            BaseDataHisHelper.addHisVerFilter(qFilter);
            DynamicObject rule = ruleHelper.queryOne("rulecontent", new QFilter[]{qFilter}, "bsed desc");
            if (rule == null) {
                throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u8be5\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0a\u7684\u6838\u7b97\u540d\u5355\u89c4\u5219\u65e0\u53ef\u7528\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u85aa\u8d44\u6838\u7b97\u573a\u666f\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u4fee\u6539\u3002", (String)"AddPersonByRuleHelper_0", (String)"swc-hsbp-business", (Object[])new Object[0])), new Object[0]);
            }
            ruleContent = rule.getString("rulecontent");
        }
        return (RuleConditionInfo)JSON.parseObject((String)ruleContent, RuleConditionInfo.class);
    }

    private static QFilter getDateFilter(Date startDate, Date endDate) {
        QFilter filter = new QFilter("bsed", "<=", (Object)endDate);
        QFilter brledFilter = new QFilter("bsled", ">", (Object)startDate);
        brledFilter.or(QFilter.isNull((String)"bsled"));
        filter.and(brledFilter);
        return filter;
    }
}

