/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.addperson.rulefilte;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.business.extpoint.calperson.IAddCalPersonExtService;
import kd.sdk.swc.hsas.common.events.calperson.AfterQueryDataForRuleEvent;
import kd.swc.hsbp.business.addperson.rulefilte.AddPersonByRuleHelper;
import kd.swc.hsbp.business.addperson.rulefilte.AnalysisRuleExtService;
import kd.swc.hsbp.business.addperson.rulefilte.JudeConditionHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCBooleanPareUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.ConditionExpressInfo;
import kd.swc.hsbp.common.vo.ConditionInfo;
import kd.swc.hsbp.common.vo.RuleConditionInfo;

public class AnalysisRuleService {
    public static final Log log = LogFactory.getLog(AnalysisRuleService.class);
    private List<Long> fileVids;
    private Map<String, Set<String>> entityFiledMap;
    private Map<String, Set<String>> subAdminOrgMap;
    private List<Long> personhrIds = new ArrayList<Long>(AddPersonByRuleHelper.BATCH_SIZE);
    private List<Long> empolyeeIds = new ArrayList<Long>(AddPersonByRuleHelper.BATCH_SIZE);
    private List<Long> empposorgrelIds = new ArrayList<Long>(AddPersonByRuleHelper.BATCH_SIZE);
    private List<Long> manascoperecordIds = new ArrayList<Long>(AddPersonByRuleHelper.BATCH_SIZE);
    private Date startDate;
    private Date endDate;
    private Map<String, Object> taskMap;
    private List<DynamicObject> filevObjs;
    private Map<Long, List<DynamicObject>> empposorgrelMap;
    private Map<Long, List<DynamicObject>> manascoperecordMap;
    private Map<Long, List<DynamicObject>> personMap;
    private Map<Long, List<DynamicObject>> pernontspropMap;
    private Map<Long, List<DynamicObject>> employeeMap;
    private Map<Long, List<DynamicObject>> empjobrelMap;
    private Map<Long, List<DynamicObject>> empentrelMap;
    private Map<Long, List<DynamicObject>> trialperiodMap;
    private Map<Long, List<DynamicObject>> perserlenMap;
    private RuleConditionInfo conditionInfo;
    private String tid;
    private List<Long> filterList;

    public AnalysisRuleService(Map<String, Object> task, List<Long> fileIds, Map<String, Set<String>> entityFiledMap, RuleConditionInfo conditionInfo, List<Long> filterList, Map<String, Set<String>> subAdminOrgMap) {
        this.taskMap = task;
        this.fileVids = new ArrayList<Long>(fileIds);
        this.startDate = (Date)task.get("startdate");
        this.endDate = (Date)task.get("enddate");
        this.entityFiledMap = entityFiledMap;
        this.conditionInfo = conditionInfo;
        this.filterList = filterList;
        this.subAdminOrgMap = subAdminOrgMap;
    }

    public void filterFilev() {
        this.tid = String.valueOf(Thread.currentThread().getId());
        this.queryFile();
        this.queryData();
        ArrayList<Map<String, Object>> infos = new ArrayList<Map<String, Object>>(AddPersonByRuleHelper.BATCH_SIZE);
        this.packInfo(infos);
        this.callExtService(infos);
        List conditionList = this.conditionInfo.getConditionList();
        this.judeFitFileByInfos(infos, conditionList);
    }

    private void callExtService(List<Map<String, Object>> infos) {
        AnalysisRuleExtService analysisRuleExtService = new AnalysisRuleExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)analysisRuleExtService, IAddCalPersonExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.calperson.IAddCalPersonExtService#afterQueryDataForRule", null);
        AfterQueryDataForRuleEvent event = new AfterQueryDataForRuleEvent(this.entityFiledMap, infos);
        event.setStartDate(this.startDate);
        event.setEndDate(this.endDate);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterQueryDataForRule(event);
            return null;
        });
    }

    private void judeFitFileByInfos(List<Map<String, Object>> infos, List<ConditionInfo> conditionList) {
        for (Map<String, Object> data : infos) {
            HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(conditionList.size());
            for (ConditionInfo conditionInfo : conditionList) {
                JudeConditionHelper.judeCondition(data, resultMap, conditionInfo, this.subAdminOrgMap, this.taskMap);
            }
            List conditionExpressList = this.conditionInfo.getConditionExpressList();
            this.judeFileIsFit(data, resultMap, conditionExpressList);
        }
    }

    private void judeFileIsFit(Map<String, Object> data, Map<String, Boolean> resultMap, List<ConditionExpressInfo> conditionExpressList) {
        StringBuilder sb = this.getExpressStr(resultMap, conditionExpressList);
        String resultRxpress = sb.toString();
        boolean isfit = SWCBooleanPareUtils.dealBrackets((String)resultRxpress);
        if (isfit) {
            this.filterList.add((Long)data.get("vid"));
        }
    }

    private StringBuilder getExpressStr(Map<String, Boolean> resultMap, List<ConditionExpressInfo> conditionExpressList) {
        StringBuilder sb = new StringBuilder();
        for (ConditionExpressInfo conditionExpressInfo : conditionExpressList) {
            Boolean result;
            String leftBracket = conditionExpressInfo.getLeftBracket();
            String name = conditionExpressInfo.getName();
            String rightBracket = conditionExpressInfo.getRightBracket();
            String logical = conditionExpressInfo.getLogical();
            if (SWCStringUtils.isNotEmpty((String)leftBracket)) {
                sb.append(leftBracket);
            }
            if ((result = resultMap.get(name)) == null) {
                result = Boolean.FALSE;
            }
            sb.append(result);
            if (SWCStringUtils.isNotEmpty((String)rightBracket)) {
                sb.append(rightBracket);
            }
            if (!SWCStringUtils.isNotEmpty((String)logical)) continue;
            if (SWCStringUtils.equals((String)"and", (String)(logical = logical.replaceAll(" ", "")))) {
                sb.append('&');
                continue;
            }
            sb.append('|');
        }
        return sb;
    }

    private void packInfo(List<Map<String, Object>> infos) {
        for (DynamicObject filevObj : this.filevObjs) {
            HashMap<String, Object> info = new HashMap<String, Object>(16);
            info.put("vid", filevObj.getLong("id"));
            Long personId = filevObj.getLong("person.id");
            info.put("person.id", personId);
            Long employeeId = filevObj.getLong("employee.id");
            info.put("employee.id", employeeId);
            info.put("caltask.enddate", this.endDate);
            info.put("caltask.startdate", this.startDate);
            Long empposinfoId = filevObj.getLong("empposinfo.id");
            Long managingscopeId = filevObj.getLong("managingscope.id");
            for (Map.Entry<String, Set<String>> entityFiledEntry : this.entityFiledMap.entrySet()) {
                Set<String> taskFields;
                String entity = entityFiledEntry.getKey();
                Set<String> fileds = entityFiledEntry.getValue();
                DynamicObject obj = null;
                switch (entity) {
                    case "hsas_salaryfile": {
                        obj = filevObj;
                        break;
                    }
                    case "hsas_personhr": {
                        List<DynamicObject> persons = this.personMap.get(personId);
                        obj = this.getLastDy(persons);
                        break;
                    }
                    case "hsas_employee": {
                        List<DynamicObject> employees = this.employeeMap.get(employeeId);
                        obj = this.getLastDy(employees);
                        break;
                    }
                    case "hsas_empposorgrelhr": {
                        List<DynamicObject> empposorgrels = this.empposorgrelMap.get(empposinfoId);
                        obj = this.getLastDy(empposorgrels);
                        break;
                    }
                    case "hsas_managingscope": {
                        List<DynamicObject> manascoperecords = this.manascoperecordMap.get(managingscopeId);
                        obj = this.getLastDy(manascoperecords);
                        break;
                    }
                    case "hsas_pernontsprop": {
                        List<DynamicObject> pernontsprops = this.pernontspropMap.get(personId);
                        obj = this.getLastDy(pernontsprops);
                        break;
                    }
                    case "hsas_empjobrel": {
                        List<DynamicObject> empjobrels = this.empjobrelMap.get(employeeId);
                        obj = this.getLastDy(empjobrels);
                        break;
                    }
                    case "hsas_empentrel": {
                        List<DynamicObject> empentrels = this.empentrelMap.get(employeeId);
                        obj = this.getLastDy(empentrels);
                        break;
                    }
                    case "hsas_perserlen": {
                        List<DynamicObject> perserlens = this.perserlenMap.get(employeeId);
                        obj = this.getLastDy(perserlens);
                        break;
                    }
                    case "hsas_trialperiod": {
                        List<DynamicObject> trialperiods = this.trialperiodMap.get(employeeId);
                        obj = this.getLastDy(trialperiods);
                        break;
                    }
                }
                if (obj != null) {
                    for (String filed : fileds) {
                        Object filedValue = obj.get(filed);
                        if (filedValue instanceof DynamicObject) {
                            filedValue = ((DynamicObject)filedValue).getPkValue();
                        }
                        info.put(entity + "." + filed, filedValue);
                    }
                }
                if (!SWCStringUtils.equals((String)entity, (String)"hsas_calpayrolltask") || (taskFields = this.entityFiledMap.get("hsas_calpayrolltask")) == null) continue;
                for (String taskField : taskFields) {
                    info.put(entity + "." + taskField, this.taskMap.get(taskField));
                }
            }
            infos.add(info);
        }
    }

    private void queryData() {
        for (Map.Entry<String, Set<String>> entityFiledEntry : this.entityFiledMap.entrySet()) {
            String entity = entityFiledEntry.getKey();
            Set<String> fileds = entityFiledEntry.getValue();
            switch (entity) {
                case "hsas_personhr": {
                    this.queryPerson(fileds);
                    break;
                }
                case "hsas_employee": {
                    this.queryEmployee(fileds);
                    break;
                }
                case "hsas_empposorgrelhr": {
                    this.getEmpposorgrel(fileds);
                    break;
                }
                case "hsas_managingscope": {
                    this.getManagingscope(fileds);
                    break;
                }
                case "hsas_pernontsprop": {
                    this.getPernontsprop(fileds);
                    break;
                }
                case "hsas_empjobrel": {
                    this.getEmpjobrel(fileds);
                    break;
                }
                case "hsas_empentrel": {
                    this.getEmpentrel(fileds);
                    break;
                }
                case "hsas_perserlen": {
                    this.getPerserlen(fileds);
                    break;
                }
                case "hsas_trialperiod": {
                    this.getTrialperiod(fileds);
                    break;
                }
            }
        }
    }

    private void queryFile() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        String selectFields = "id,empgroup.id,empposinfo.id,managingscope.id,employee.id,person.id,boid";
        Set<String> fileds = this.entityFiledMap.get("hsas_salaryfile");
        if (fileds != null) {
            selectFields = this.getSelectProperties(fileds, selectFields);
        }
        this.filevObjs = helper.queryOriginalCollection(selectFields, new QFilter[]{new QFilter("id", "in", this.fileVids)});
        for (DynamicObject fileObj : this.filevObjs) {
            this.personhrIds.add(fileObj.getLong("person.id"));
            this.empolyeeIds.add(fileObj.getLong("employee.id"));
            this.empposorgrelIds.add(fileObj.getLong("empposinfo.id"));
            this.manascoperecordIds.add(fileObj.getLong("managingscope.id"));
        }
    }

    public DynamicObject getLastDy(List<DynamicObject> dys) {
        if (dys == null) {
            return null;
        }
        return dys.size() > 0 ? dys.get(dys.size() - 1) : null;
    }

    private void queryPerson(Set<String> fileds) {
        SWCDataServiceHelper personHelper = new SWCDataServiceHelper("hsas_personhr");
        String selectProperties = this.getSelectProperties(fileds, "id,boid,sourcevid");
        QFilter qFilter = new QFilter("boid", "in", this.personhrIds);
        BaseDataHisHelper.addHisCurrFilter(qFilter);
        DynamicObjectCollection persons = personHelper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter});
        this.personMap = persons.stream().collect(Collectors.groupingBy(person -> person.getLong("boid")));
    }

    private void queryEmployee(Set<String> fileds) {
        SWCDataServiceHelper personHelper = new SWCDataServiceHelper("hsas_employee");
        String selectProperties = this.getSelectProperties(fileds, "id,boid,bsed");
        QFilter qFilter = new QFilter("boid", "in", this.empolyeeIds);
        BaseDataHisHelper.addHisVerFilter(qFilter);
        qFilter.and(AnalysisRuleService.getDateFilter(this.startDate, this.endDate));
        qFilter.and(new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus()));
        DynamicObjectCollection employees = personHelper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter}, "boid,bsed");
        this.employeeMap = employees.stream().collect(Collectors.groupingBy(emp -> emp.getLong("boid")));
    }

    public void getEmpposorgrel(Set<String> fileds) {
        DynamicObjectCollection empPosOrgRels;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_empposorgrelhr");
        QFilter qFilter = new QFilter("boid", "in", this.empposorgrelIds);
        BaseDataHisHelper.addHisVerFilter(qFilter);
        qFilter.and(AnalysisRuleService.getDateFilter(this.startDate, this.endDate));
        qFilter.and(new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus()));
        String selectProperties = "id,boid,bsed,job.id";
        if (fileds != null && fileds.size() > 0) {
            selectProperties = this.getSelectProperties(fileds, selectProperties);
        }
        this.empposorgrelMap = CollectionUtils.isEmpty((Collection)(empPosOrgRels = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter}, "boid,bsed"))) ? new HashMap<Long, List<DynamicObject>>(0) : empPosOrgRels.stream().collect(Collectors.groupingBy(empPosRogRel -> empPosRogRel.getLong("boid")));
    }

    public void getManagingscope(Set<String> fileds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_managingscope");
        QFilter qFilter = new QFilter("boid", "in", this.manascoperecordIds);
        BaseDataHisHelper.addHisVerFilter(qFilter);
        qFilter.and(AnalysisRuleService.getDateFilter(this.startDate, this.endDate));
        qFilter.and(new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus()));
        String selectProperties = this.getSelectProperties(fileds, "id,boid,bsed");
        DynamicObjectCollection manascoperecords = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter}, "boid,bsed");
        this.manascoperecordMap = CollectionUtils.isEmpty((Collection)manascoperecords) ? new HashMap<Long, List<DynamicObject>>(0) : manascoperecords.stream().collect(Collectors.groupingBy(record -> record.getLong("boid")));
    }

    public void getPernontsprop(Set<String> fileds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_pernontsprop");
        QFilter qFilter = new QFilter("person", "in", this.personhrIds);
        BaseDataHisHelper.addHisCurrFilter(qFilter);
        String selectProperties = this.getSelectProperties(fileds, "id,person.id,sourcevid");
        DynamicObjectCollection pernontprops = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter});
        this.pernontspropMap = CollectionUtils.isEmpty((Collection)pernontprops) ? new HashMap<Long, List<DynamicObject>>(0) : pernontprops.stream().collect(Collectors.groupingBy(person -> person.getLong("person.id")));
    }

    public void getEmpjobrel(Set<String> fileds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_empjobrel");
        QFilter qFilter = new QFilter("employee", "in", this.empolyeeIds);
        BaseDataHisHelper.addHisVerFilter(qFilter);
        QFilter dateFilter = AnalysisRuleService.getDateFilter(this.startDate, this.endDate);
        qFilter.and(new QFilter("startdate", "<=", (Object)this.endDate));
        QFilter brledFilter = new QFilter("enddate", ">=", (Object)this.startDate);
        brledFilter.or(QFilter.isNull((String)"enddate"));
        qFilter.and(brledFilter);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        String selectProperties = this.getSelectProperties(fileds, "id,employee.id,bsed,job.id,startdate,enddate");
        DynamicObjectCollection empPosOrgRels = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter, dateFilter, statusFilter}, "employee.id,startdate,bsed");
        this.empjobrelMap = CollectionUtils.isEmpty((Collection)empPosOrgRels) ? new HashMap<Long, List<DynamicObject>>(0) : empPosOrgRels.stream().collect(Collectors.groupingBy(rel -> rel.getLong("employee.id")));
    }

    private String getSelectProperties(Set<String> fileds, String selectProperties) {
        if (fileds == null) {
            return selectProperties;
        }
        String[] oriFileds = selectProperties.split(",");
        Set selectFileds = Arrays.stream(oriFileds).collect(Collectors.toSet());
        String ruleFileds = fileds.stream().filter(filed -> !selectFileds.contains(filed)).collect(Collectors.joining(","));
        if (SWCStringUtils.isNotEmpty((String)ruleFileds)) {
            selectProperties = selectProperties + "," + ruleFileds;
        }
        return selectProperties;
    }

    public void getEmpentrel(Set<String> fileds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_empentrel");
        QFilter qFilter = new QFilter("employee", "in", this.empolyeeIds);
        BaseDataHisHelper.addHisVerFilter(qFilter);
        QFilter dateFilter = AnalysisRuleService.getDateFilter(this.startDate, this.endDate);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        String selectProperties = this.getSelectProperties(fileds, "id,employee.id,bsed");
        DynamicObjectCollection objvs = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter, dateFilter, statusFilter}, "employee.id,bsed");
        this.empentrelMap = CollectionUtils.isEmpty((Collection)objvs) ? new HashMap<Long, List<DynamicObject>>(0) : objvs.stream().collect(Collectors.groupingBy(obj -> obj.getLong("employee.id")));
    }

    public void getPerserlen(Set<String> fileds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_perserlen");
        QFilter qFilter = new QFilter("employee", "in", this.empolyeeIds);
        BaseDataHisHelper.addHisCurrFilter(qFilter);
        String selectProperties = this.getSelectProperties(fileds, "id,employee.id,sourcevid");
        DynamicObjectCollection objvs = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter});
        this.perserlenMap = CollectionUtils.isEmpty((Collection)objvs) ? new HashMap<Long, List<DynamicObject>>(0) : objvs.stream().collect(Collectors.groupingBy(obj -> obj.getLong("employee.id")));
    }

    public void getTrialperiod(Set<String> fileds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_trialperiod");
        QFilter qFilter = new QFilter("employee", "in", this.empolyeeIds);
        BaseDataHisHelper.addHisVerFilter(qFilter);
        QFilter dateFilter = AnalysisRuleService.getDateFilter(this.startDate, this.endDate);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        String selectProperties = this.getSelectProperties(fileds, "id,employee.id,bsed");
        DynamicObjectCollection objvs = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter, statusFilter, dateFilter}, "employee.id,bsed");
        this.trialperiodMap = CollectionUtils.isEmpty((Collection)objvs) ? new HashMap<Long, List<DynamicObject>>(0) : objvs.stream().collect(Collectors.groupingBy(obj -> obj.getLong("employee.id")));
    }

    private static QFilter getDateFilter(Date startDate, Date endDate) {
        QFilter filter = new QFilter("bsed", "<=", (Object)endDate);
        QFilter brledFilter = new QFilter("bsled", ">=", (Object)startDate);
        brledFilter.or(QFilter.isNull((String)"bsled"));
        filter.and(brledFilter);
        return filter;
    }
}

