/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.addperson.rulefilte;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.swc.hsbp.common.enums.RuleOperatorEnum;
import kd.swc.hsbp.common.enums.RuleParamTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.ConditionInfo;

public class JudeConditionHelper {
    public static final Log log = LogFactory.getLog(JudeConditionHelper.class);

    public static void judeCondition(Map<String, Object> data, Map<String, Boolean> resultMap, ConditionInfo conditionInfo, Map<String, Set<String>> subAdminOrgMap, Map<String, Object> taskMap) {
        String paramName = conditionInfo.getParam().toLowerCase();
        Object value = conditionInfo.getValue();
        if (SWCStringUtils.equals((String)conditionInfo.getValueType(), (String)"1")) {
            value = ((String)value).toLowerCase();
            value = data.get(value);
        }
        Object paramValue = data.get(paramName);
        String operators = conditionInfo.getOperators();
        String paramType = conditionInfo.getParamType();
        RuleParamTypeEnum typeEnum = RuleParamTypeEnum.getEnum((String)paramType);
        RuleOperatorEnum operatorEnum = RuleOperatorEnum.getEnum((String)operators);
        boolean isFit = false;
        switch (typeEnum) {
            case BOOLEAN: {
                isFit = JudeConditionHelper.judgeBooleanCondition(value, paramValue, operatorEnum);
                break;
            }
            case DATE: {
                isFit = JudeConditionHelper.judgeDateCondition(value, paramValue, operatorEnum, taskMap);
                break;
            }
            case STRING: {
                isFit = JudeConditionHelper.judgeStringCondition(value, paramValue, operatorEnum);
                break;
            }
            case NUMBER: {
                isFit = JudeConditionHelper.judgeNumberCondition(value, paramValue, operatorEnum);
                break;
            }
            case ENUM: {
                isFit = JudeConditionHelper.judgeEnumCondition(value, paramValue, operatorEnum);
                break;
            }
            case DYNAMICOBJECT: {
                isFit = JudeConditionHelper.judgeObjCondition(value, paramValue, operatorEnum, subAdminOrgMap);
                break;
            }
        }
        resultMap.put(conditionInfo.getName(), isFit);
    }

    public static boolean judgeBooleanCondition(Object value, Object paramValue, RuleOperatorEnum operatorEnum) {
        boolean isFit = false;
        switch (operatorEnum) {
            case EQUAL: {
                isFit = JudeConditionHelper.booleanEquals(value, paramValue);
                break;
            }
            case NOT_EQUAL: {
                isFit = JudeConditionHelper.booleanNotEquals(value, paramValue);
                break;
            }
        }
        return isFit;
    }

    public static boolean booleanNotEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = !SWCStringUtils.equals((String)paramValue.toString(), (String)value.toString());
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }

    public static boolean booleanEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = SWCStringUtils.equals((String)paramValue.toString(), (String)value.toString());
        }
        return isFit;
    }

    public static boolean judgeDateCondition(Object value, Object paramValue, RuleOperatorEnum operatorEnum, Map<String, Object> taskMap) {
        boolean isFit = false;
        switch (operatorEnum) {
            case EQUAL: {
                isFit = JudeConditionHelper.dateEquals(value, paramValue);
                break;
            }
            case NOT_EQUAL: {
                isFit = JudeConditionHelper.dateNotEquals(value, paramValue);
                break;
            }
            case IS_NULL: {
                isFit = paramValue == null;
                break;
            }
            case IS_NOT_NULL: {
                isFit = paramValue != null;
                break;
            }
            case LESS_THAN: {
                isFit = JudeConditionHelper.dateLessThan(value, paramValue);
                break;
            }
            case LESS_OR_EQUAL: {
                isFit = JudeConditionHelper.dateLessOrEqual(value, paramValue);
                break;
            }
            case GREATER_THAN: {
                isFit = JudeConditionHelper.dateGreaterThan(value, paramValue);
                break;
            }
            case GREATER_OR_EQUAL: {
                isFit = JudeConditionHelper.dateGreaterOrEqual(value, paramValue);
                break;
            }
            case TODAY: {
                isFit = JudeConditionHelper.dateToday(paramValue);
                break;
            }
            case YESTERDAY: {
                isFit = JudeConditionHelper.dateYesterday(paramValue);
                break;
            }
            case TOMORROW: {
                isFit = JudeConditionHelper.dateTomorrow(paramValue);
                break;
            }
            case THIS_WEEK: {
                isFit = JudeConditionHelper.dateThisWeek(paramValue);
                break;
            }
            case LAST_WEEK: {
                isFit = JudeConditionHelper.dateLastWeek(paramValue);
                break;
            }
            case NEXT_WEEK: {
                isFit = JudeConditionHelper.dateNextWeek(paramValue);
                break;
            }
            case THIS_MONTH: {
                isFit = JudeConditionHelper.dateThisMonth(paramValue);
                break;
            }
            case LAST_MONTH: {
                isFit = JudeConditionHelper.dateLastMonth(paramValue);
                break;
            }
            case NEXT_MONTH: {
                isFit = JudeConditionHelper.dateNextMonth(paramValue);
                break;
            }
            case LAST3MONTH: {
                isFit = JudeConditionHelper.dateLast3Month(paramValue);
                break;
            }
            case NEXT3MONTH: {
                isFit = JudeConditionHelper.dateNext3Month(paramValue);
                break;
            }
            case THIS_QUARTER: {
                isFit = JudeConditionHelper.dateThisQuarter(paramValue);
                break;
            }
            case LAST_QUARTER: {
                isFit = JudeConditionHelper.dateLastQuarter(paramValue);
                break;
            }
            case NEXT_QUARTER: {
                isFit = JudeConditionHelper.dateNextQuarter(paramValue);
                break;
            }
            case THIS_YEAR: {
                isFit = JudeConditionHelper.dateThisYear(paramValue);
                break;
            }
            case LAST_YEAR: {
                isFit = JudeConditionHelper.dateLastYear(paramValue);
                break;
            }
            case NEXT_YEAR: {
                isFit = JudeConditionHelper.dateNextYear(paramValue);
                break;
            }
            case LESS_THAN_DAY: {
                isFit = JudeConditionHelper.dateLessThanDay(value, paramValue);
                break;
            }
            case GREATER_THAN_DAY: {
                isFit = JudeConditionHelper.dateGreaterThanDay(value, paramValue);
                break;
            }
            case LESS_OR_EQUAL_DAY: {
                isFit = JudeConditionHelper.dateLessOrEqualDay(value, paramValue);
                break;
            }
            case GREATER_OR_EQUAL_DAY: {
                isFit = JudeConditionHelper.dateGreateROrEqualDay(value, paramValue);
                break;
            }
            case LAST_PERIOD: {
                isFit = JudeConditionHelper.dateLastPeriod(paramValue, taskMap);
                break;
            }
        }
        return isFit;
    }

    public static boolean dateEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            value = JudeConditionHelper.tranStrToDate(value);
            paramValue = JudeConditionHelper.tranStrToDate(paramValue);
            isFit = value.equals(paramValue);
        }
        return isFit;
    }

    public static boolean dateNotEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = !(value = JudeConditionHelper.tranStrToDate(value)).equals(paramValue = JudeConditionHelper.tranStrToDate(paramValue));
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }

    public static boolean dateLessThan(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            Date valueDate = JudeConditionHelper.tranStrToDate(value);
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            isFit = paramValueDate.before(valueDate);
        }
        return isFit;
    }

    public static boolean dateLessOrEqual(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            Date valueDate = JudeConditionHelper.tranStrToDate(value);
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            isFit = !paramValueDate.after(valueDate);
        }
        return isFit;
    }

    public static boolean dateGreaterThan(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            Date valueDate = JudeConditionHelper.tranStrToDate(value);
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            isFit = paramValueDate.after(valueDate);
        }
        return isFit;
    }

    public static boolean dateGreaterOrEqual(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            Date valueDate = JudeConditionHelper.tranStrToDate(value);
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            isFit = !paramValueDate.before(valueDate);
        }
        return isFit;
    }

    public static boolean dateToday(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Date today = JudeConditionHelper.tranStrToDate(new Date());
            isFit = paramValueDate.equals(today);
        }
        return isFit;
    }

    public static boolean dateYesterday(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            Date yesterday = JudeConditionHelper.tranStrToDate(calendar.getTime());
            isFit = paramValueDate.equals(yesterday);
        }
        return isFit;
    }

    public static boolean dateTomorrow(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, 1);
            Date tomorrow = JudeConditionHelper.tranStrToDate(calendar.getTime());
            isFit = paramValueDate.equals(tomorrow);
        }
        return isFit;
    }

    public static boolean dateThisWeek(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheWeekStart((int)0));
            Date endDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheWeekEnd((int)0));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateLastWeek(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheWeekStart((int)-1));
            Date endDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheWeekEnd((int)-1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateNextWeek(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheWeekStart((int)1));
            Date endDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheWeekEnd((int)1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateThisMonth(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheMonthStart((int)0));
            Date endDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheMonthEnd((int)0));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateLastMonth(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheMonthStart((int)-1));
            Date endDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheMonthEnd((int)-1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateLastPeriod(Object paramValue, Map<String, Object> taskMap) {
        boolean isFit = false;
        Date lastPeriodStartDate = (Date)taskMap.get("lastPeriodStartDate");
        Date lastPeriodEndDate = (Date)taskMap.get("lastPeriodEndDate");
        if (paramValue != null && lastPeriodStartDate != null && lastPeriodEndDate != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudeConditionHelper.tranStrToDate(lastPeriodStartDate);
            Date endDate = JudeConditionHelper.tranStrToDate(SWCDateTimeUtils.addDay((Date)lastPeriodEndDate, (long)1L));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateNextMonth(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheMonthStart((int)1));
            Date endDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheMonthEnd((int)1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateLast3Month(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(new Date());
            ((Calendar)calendar).add(2, -3);
            Date startDate = JudeConditionHelper.tranStrToDate(calendar.getTime());
            Date endDate = JudeConditionHelper.tranStrToDate(KDDateUtils.addDays((Date)new Date(), (int)1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateNext3Month(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(new Date());
            ((Calendar)calendar).add(2, 3);
            Date endDate = JudeConditionHelper.tranStrToDate(calendar.getTime());
            Date startDate = JudeConditionHelper.tranStrToDate(new Date());
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateThisQuarter(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheQuarterStart((int)0));
            Date endDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheQuarterEnd((int)0));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateLastQuarter(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheQuarterStart((int)-1));
            Date endDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheQuarterEnd((int)-1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateNextQuarter(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheQuarterStart((int)1));
            Date endDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheQuarterEnd((int)1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateThisYear(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheYearStart((int)0));
            Date endDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheYearEnd((int)0));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateLastYear(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheYearStart((int)-1));
            Date endDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheYearEnd((int)-1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateNextYear(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheYearStart((int)1));
            Date endDate = JudeConditionHelper.tranStrToDate(KDDateUtils.getTheYearEnd((int)1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateLessThanDay(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            int valueDay;
            if (value instanceof String) {
                valueDay = Integer.parseInt((String)value);
            } else {
                Date valueDate = JudeConditionHelper.tranStrToDate(value);
                valueDay = SWCDateTimeUtils.getDay((Date)valueDate);
            }
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            int paramValueDay = SWCDateTimeUtils.getDay((Date)paramValueDate);
            isFit = paramValueDay < valueDay;
        }
        return isFit;
    }

    public static boolean dateGreaterThanDay(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            int valueDay;
            if (value instanceof String) {
                valueDay = Integer.parseInt((String)value);
            } else {
                Date valueDate = JudeConditionHelper.tranStrToDate(value);
                valueDay = SWCDateTimeUtils.getDay((Date)valueDate);
            }
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            int paramValueDay = SWCDateTimeUtils.getDay((Date)paramValueDate);
            isFit = paramValueDay > valueDay;
        }
        return isFit;
    }

    public static boolean dateLessOrEqualDay(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            int valueDay;
            if (value instanceof String) {
                valueDay = Integer.parseInt((String)value);
            } else {
                Date valueDate = JudeConditionHelper.tranStrToDate(value);
                valueDay = SWCDateTimeUtils.getDay((Date)valueDate);
            }
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            int paramValueDay = SWCDateTimeUtils.getDay((Date)paramValueDate);
            isFit = paramValueDay <= valueDay;
        }
        return isFit;
    }

    public static boolean dateGreateROrEqualDay(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            int valueDay;
            if (value instanceof String) {
                valueDay = Integer.parseInt((String)value);
            } else {
                Date valueDate = JudeConditionHelper.tranStrToDate(value);
                valueDay = SWCDateTimeUtils.getDay((Date)valueDate);
            }
            Date paramValueDate = JudeConditionHelper.tranStrToDate(paramValue);
            int paramValueDay = SWCDateTimeUtils.getDay((Date)paramValueDate);
            isFit = paramValueDay >= valueDay;
        }
        return isFit;
    }

    public static Date tranStrToDate(Object value) {
        if (value instanceof String) {
            try {
                value = SWCDateTimeUtils.parseDate((String)((String)value), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                log.error("\u65f6\u95f4\u8f6c\u5316\u62a5\u9519", (Throwable)e);
            }
        } else if (value instanceof Date) {
            value = SWCDateTimeUtils.getDateWithoutTime((Date)((Date)value));
        }
        return (Date)value;
    }

    public static boolean judgeStringCondition(Object value, Object paramValue, RuleOperatorEnum operatorEnum) {
        boolean isFit = false;
        switch (operatorEnum) {
            case EQUAL: {
                isFit = JudeConditionHelper.stringEquals(value, paramValue);
                break;
            }
            case NOT_EQUAL: {
                isFit = JudeConditionHelper.stringNotEquals(value, paramValue);
                break;
            }
            case IN: {
                isFit = JudeConditionHelper.stringIn((String)value, (String)paramValue);
                break;
            }
            case NOT_IN: {
                isFit = JudeConditionHelper.stringNotIn((String)value, (String)paramValue);
                break;
            }
            case IS_NULL: {
                isFit = SWCStringUtils.isEmpty((String)((String)paramValue));
                break;
            }
            case IS_NOT_NULL: {
                isFit = SWCStringUtils.isNotEmpty((String)((String)paramValue));
                break;
            }
            case CONTAINS: {
                isFit = JudeConditionHelper.stringContains((String)value, (String)paramValue);
                break;
            }
            case NOT_CONTAINS: {
                isFit = JudeConditionHelper.stringNotContains((String)value, (String)paramValue);
                break;
            }
            case STARTS_WITH: {
                isFit = JudeConditionHelper.stringStartsWith((String)value, (String)paramValue);
                break;
            }
            case ENDS_WITH: {
                isFit = JudeConditionHelper.stringEndsWith((String)value, (String)paramValue);
                break;
            }
        }
        return isFit;
    }

    public static boolean judgeNumberCondition(Object value, Object paramValue, RuleOperatorEnum operatorEnum) {
        boolean isFit = false;
        switch (operatorEnum) {
            case EQUAL: {
                isFit = JudeConditionHelper.numberEquals(value, paramValue);
                break;
            }
            case NOT_EQUAL: {
                isFit = JudeConditionHelper.numberNotEquals(value, paramValue);
                break;
            }
            case LESS_THAN: {
                isFit = JudeConditionHelper.numberLessThanEquals(value, paramValue);
                break;
            }
            case GREATER_THAN: {
                isFit = JudeConditionHelper.numberGreaterThanEquals(value, paramValue);
                break;
            }
            case LESS_OR_EQUAL: {
                isFit = JudeConditionHelper.numberLessOrEquals(value, paramValue);
                break;
            }
            case GREATER_OR_EQUAL: {
                isFit = JudeConditionHelper.numberGreaterOrEquals(value, paramValue);
                break;
            }
        }
        return isFit;
    }

    public static boolean judgeEnumCondition(Object value, Object paramValue, RuleOperatorEnum operatorEnum) {
        boolean isFit = false;
        switch (operatorEnum) {
            case EQUAL: {
                isFit = JudeConditionHelper.stringEquals(value, paramValue);
                break;
            }
            case NOT_EQUAL: {
                isFit = JudeConditionHelper.stringNotEquals(value, paramValue);
                break;
            }
            case IN: {
                isFit = JudeConditionHelper.stringIn((String)value, (String)paramValue);
                break;
            }
            case NOT_IN: {
                isFit = JudeConditionHelper.stringNotIn((String)value, (String)paramValue);
                break;
            }
            case IS_NULL: {
                isFit = SWCStringUtils.isEmpty((String)((String)paramValue));
                break;
            }
            case IS_NOT_NULL: {
                isFit = SWCStringUtils.isNotEmpty((String)((String)paramValue));
                break;
            }
        }
        return isFit;
    }

    public static boolean judgeObjCondition(Object value, Object paramValue, RuleOperatorEnum operatorEnum, Map<String, Set<String>> subAdminOrgMap) {
        boolean isFit = false;
        switch (operatorEnum) {
            case EQUAL: {
                isFit = JudeConditionHelper.objEquals(value, paramValue);
                break;
            }
            case NOT_EQUAL: {
                isFit = JudeConditionHelper.objNotEquals(value, paramValue);
                break;
            }
            case IN: {
                isFit = JudeConditionHelper.objIn(value, paramValue);
                break;
            }
            case NOT_IN: {
                isFit = JudeConditionHelper.objNotIn(value, paramValue);
                break;
            }
            case IS_NULL: {
                isFit = paramValue == null || SWCStringUtils.equals((String)paramValue.toString(), (String)"0");
                break;
            }
            case IS_NOT_NULL: {
                isFit = paramValue != null && !SWCStringUtils.equals((String)paramValue.toString(), (String)"0");
                break;
            }
            case IS_OR_IS_SUB: {
                isFit = JudeConditionHelper.isSub(value, paramValue, subAdminOrgMap);
                break;
            }
            case NOT_AND_NOTSUB: {
                isFit = !JudeConditionHelper.isSub(value, paramValue, subAdminOrgMap);
                break;
            }
        }
        return isFit;
    }

    private static boolean isSub(Object value, Object paramValue, Map<String, Set<String>> subAdminOrgMap) {
        Set<String> allSub;
        boolean isFit = false;
        if (value != null && (allSub = subAdminOrgMap.get(value.toString())) != null) {
            isFit = paramValue != null && allSub.contains(paramValue.toString());
        }
        return isFit;
    }

    public static boolean stringEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = SWCStringUtils.equals((String)value.toString(), (String)paramValue.toString());
        }
        return isFit;
    }

    public static boolean stringNotEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = !SWCStringUtils.equals((String)value.toString(), (String)paramValue.toString());
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }

    public static boolean stringIn(String value, String paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            String[] strs;
            for (String str : strs = value.split(",")) {
                if (!SWCStringUtils.equals((String)str, (String)paramValue)) continue;
                isFit = true;
            }
        }
        return isFit;
    }

    public static boolean stringNotIn(String value, String paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            String[] strs;
            isFit = true;
            for (String str : strs = value.split(",")) {
                if (!SWCStringUtils.equals((String)str, (String)paramValue)) continue;
                isFit = false;
                break;
            }
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }

    public static boolean stringNotContains(String value, String paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = !paramValue.contains(value);
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }

    public static boolean stringContains(String value, String paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = paramValue.contains(value);
        }
        return isFit;
    }

    public static boolean stringStartsWith(String value, String paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = paramValue.startsWith(value);
        }
        return isFit;
    }

    public static boolean stringEndsWith(String value, String paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = paramValue.endsWith(value);
        }
        return isFit;
    }

    public static boolean numberEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            BigDecimal decimalParamValue;
            BigDecimal decimalValue = new BigDecimal(value.toString());
            isFit = decimalValue.compareTo(decimalParamValue = new BigDecimal(paramValue.toString())) == 0;
        }
        return isFit;
    }

    public static boolean numberNotEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            BigDecimal decimalParamValue;
            BigDecimal decimalValue = new BigDecimal(value.toString());
            isFit = decimalValue.compareTo(decimalParamValue = new BigDecimal(paramValue.toString())) != 0;
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }

    public static boolean numberLessThanEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            BigDecimal decimalValue = new BigDecimal(value.toString());
            BigDecimal decimalParamValue = new BigDecimal(paramValue.toString());
            isFit = decimalParamValue.compareTo(decimalValue) < 0;
        }
        return isFit;
    }

    public static boolean numberGreaterThanEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            BigDecimal decimalValue = new BigDecimal(value.toString());
            BigDecimal decimalParamValue = new BigDecimal(paramValue.toString());
            isFit = decimalParamValue.compareTo(decimalValue) > 0;
        }
        return isFit;
    }

    public static boolean numberLessOrEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            BigDecimal decimalValue = new BigDecimal(value.toString());
            BigDecimal decimalParamValue = new BigDecimal(paramValue.toString());
            isFit = decimalParamValue.compareTo(decimalValue) <= 0;
        }
        return isFit;
    }

    public static boolean numberGreaterOrEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            BigDecimal decimalValue = new BigDecimal(value.toString());
            BigDecimal decimalParamValue = new BigDecimal(paramValue.toString());
            isFit = decimalParamValue.compareTo(decimalValue) >= 0;
        }
        return isFit;
    }

    public static boolean objEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = SWCStringUtils.equals((String)value.toString(), (String)paramValue.toString());
        }
        return isFit;
    }

    public static boolean objNotEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = !SWCStringUtils.equals((String)value.toString(), (String)paramValue.toString());
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }

    public static boolean objIn(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            String[] strs;
            String valueStr = value.toString();
            for (String str : strs = valueStr.split(",")) {
                if (!SWCStringUtils.equals((String)str, (String)paramValue.toString())) continue;
                isFit = true;
            }
        }
        return isFit;
    }

    public static boolean objNotIn(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            String[] strs;
            isFit = true;
            String valueStr = value.toString();
            for (String str : strs = valueStr.split(",")) {
                if (!SWCStringUtils.equals((String)str, (String)paramValue.toString())) continue;
                isFit = false;
                break;
            }
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }
}

