/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.area;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AreaHelper {
    public static QFilter addCountryFilter(long countryId) {
        HashSet<Long> set = new HashSet<Long>(2);
        set.add(countryId);
        set.add(0L);
        return new QFilter("country.id", "in", set);
    }

    public static QFilter addAreaFilter(long countryId, String areaType) {
        if (SWCStringUtils.isEmpty((String)areaType)) {
            return null;
        }
        if (areaType.equals("1")) {
            return new QFilter("areatype", "=", (Object)"1");
        }
        HashSet<Long> set = new HashSet<Long>(2);
        set.add(countryId);
        set.add(0L);
        return new QFilter("country.id", "in", set);
    }

    public static boolean checkArea(DynamicObject dataEntity) {
        String arealtype = dataEntity.getString("areatype");
        long countryId = dataEntity.getLong("country.id");
        return !SWCStringUtils.isEmpty((String)arealtype) && (!SWCStringUtils.equals((String)"2", (String)arealtype) || 0L != countryId);
    }

    public static void setAreaTypeAndcountryStatus(IDataModel model, IFormView view) {
        DynamicObject dataEntity = model.getDataEntity();
        String arealtype = dataEntity.getString("areatype");
        if (SWCStringUtils.equals((String)arealtype, (String)"1")) {
            model.beginInit();
            model.setValue("country", null);
            view.setVisible(Boolean.FALSE, new String[]{"country"});
            model.endInit();
            view.updateView("country");
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"country"});
            BasedataEdit country = (BasedataEdit)view.getControl("country");
            country.setMustInput(true);
            view.updateView("country");
        }
    }

    public static void initAreaTypeAndcountryStatus(IDataModel model, IFormView view) {
        DynamicObject dataEntity = model.getDataEntity();
        String arealtype = dataEntity.getString("areatype");
        if (SWCStringUtils.equals((String)arealtype, (String)"1")) {
            view.setVisible(Boolean.FALSE, new String[]{"country"});
            view.updateView("country");
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"country"});
            BasedataEdit country = (BasedataEdit)view.getControl("country");
            country.setMustInput(true);
            view.updateView("country");
        }
    }

    public static void confirmAfterModifyAraeType(MessageBoxClosedEvent event, IDataModel model, IFormView view, String[] keys, String[] entryEntityKeys) {
        if (null == keys && null == entryEntityKeys) {
            return;
        }
        if (MessageBoxResult.Cancel.equals((Object)event.getResult())) {
            String customVaule = event.getCustomVaule();
            model.beginInit();
            model.setValue("areatype", (Object)customVaule);
            model.endInit();
            view.updateView("areatype");
        } else {
            AreaHelper.setAreaTypeAndcountryStatus(model, view);
            AreaHelper.updateView(model, view, keys);
            AreaHelper.updateEntryEntityView(model, view, entryEntityKeys);
        }
    }

    public static void confirmAfterModifyCountry(MessageBoxClosedEvent event, IDataModel model, IFormView view, String[] keys, String[] entryEntityKeys) {
        if (MessageBoxResult.Cancel.equals((Object)event.getResult())) {
            String customVaule = event.getCustomVaule();
            model.beginInit();
            model.setValue("country", (Object)customVaule);
            model.endInit();
            view.updateView("country");
        } else {
            AreaHelper.updateView(model, view, keys);
            AreaHelper.updateEntryEntityView(model, view, entryEntityKeys);
        }
    }

    private static void updateView(IDataModel model, IFormView view, String ... keys) {
        if (null == keys || keys.length == 0) {
            return;
        }
        for (String key : keys) {
            model.getDataEntity().set(key, null);
            view.updateView(key);
        }
    }

    private static void updateEntryEntityView(IDataModel model, IFormView view, String ... entryEntityKeys) {
        if (null == entryEntityKeys || entryEntityKeys.length == 0) {
            return;
        }
        for (String key : entryEntityKeys) {
            DynamicObjectCollection entryEntity = model.getEntryEntity(key);
            if (null == entryEntity) continue;
            model.deleteEntryData(key);
            view.updateView(key);
        }
    }
}

