/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.cal.calitemtree.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.cal.calitemtree.AccuMulatorServiceImpl;
import kd.swc.hsbp.business.cal.calitemtree.BizItemTreeServiceImpl;
import kd.swc.hsbp.business.cal.calitemtree.FetchItemTreeServiceImpl;
import kd.swc.hsbp.business.cal.calitemtree.ICalItemTreeService;
import kd.swc.hsbp.business.cal.calitemtree.SalaryItemTreeImpl;
import kd.swc.hsbp.business.cal.calitemtree.SupportItemServiceImpl;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.constants.CalItemTreeConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalItemTreeService
implements CalItemTreeConstants {
    protected static final Log log = LogFactory.getLog(CalItemTreeService.class);
    private static final Map<String, ICalItemTreeService> TREE_SERVICE_MAP = ImmutableMap.builder().put((Object)"hsbs_fetchitem", (Object)new FetchItemTreeServiceImpl()).put((Object)"hsbs_salaryitem", (Object)new SalaryItemTreeImpl()).put((Object)"hsbs_bizitem", (Object)new BizItemTreeServiceImpl()).put((Object)"hsbs_supportitem", (Object)new SupportItemServiceImpl()).put((Object)"hsas_accumulator", (Object)new AccuMulatorServiceImpl()).build();
    protected TreeView treeView;
    protected IFormView view;
    protected SWCPageCache pageCache;
    protected List<String> itemKeyList;

    public CalItemTreeService(TreeView treeView, IFormView view, List<String> itemKeyList) {
        this.treeView = treeView;
        this.view = view;
        this.pageCache = new SWCPageCache(view);
        this.itemKeyList = itemKeyList;
    }

    public List<TreeNode> initTree(Map<String, String> filterMap) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(10);
        if (filterMap == null) {
            return list;
        }
        Map<String, List<Map<String, Object>>> allItemData = this.getAllItemData(filterMap);
        this.itemKeyList.forEach(itemKey -> {
            ICalItemTreeService treeService = TREE_SERVICE_MAP.get(itemKey);
            if (treeService != null) {
                list.addAll(treeService.getTreeNodeList(false, null, (List)allItemData.get(itemKey)));
            }
        });
        this.treeView.deleteAllNodes();
        this.treeView.addNodes(list);
        Map treeNodeMap = list.stream().collect(Collectors.toMap(TreeNode::getId, Function.identity(), (entity1, entity2) -> entity2));
        this.pageCache.put("cacheTree", (Object)JSON.toJSONString(treeNodeMap));
        this.pageCache.put("allItemData", allItemData);
        return list;
    }

    public void checkSelectedTreeNode(List<TreeNode> nodeList, Set<String> uniqueCodeSet) {
        if (CollectionUtils.isEmpty(uniqueCodeSet)) {
            return;
        }
        ArrayList<TreeNode> checkNodeList = new ArrayList<TreeNode>(10);
        this.getCheckTreeNode(nodeList, uniqueCodeSet, checkNodeList);
        if (!CollectionUtils.isEmpty(checkNodeList)) {
            this.treeView.checkNodes(checkNodeList);
        }
    }

    public List<TreeNode> searchTree(String searchText) {
        ArrayList<TreeNode> nodeItemList = new ArrayList<TreeNode>(10);
        Map dataMap = (Map)this.pageCache.get("allItemData", Map.class);
        boolean isExpend = SWCStringUtils.isNotEmpty((String)searchText);
        this.itemKeyList.forEach(itemKey -> {
            ICalItemTreeService treeService = TREE_SERVICE_MAP.get(itemKey);
            if (treeService != null) {
                nodeItemList.addAll(treeService.getTreeNodeList(isExpend, searchText, (List)dataMap.get(itemKey)));
            }
        });
        if (CollectionUtils.isEmpty(nodeItemList)) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"CalItemTreeService_0", (String)"swc-hsbp-business", (Object[])new Object[0]));
            return nodeItemList;
        }
        this.treeView.deleteAllNodes();
        this.treeView.addNodes(nodeItemList);
        return nodeItemList;
    }

    private Map<String, List<Map<String, Object>>> getAllItemData(Map<String, String> filterMap) {
        ICalItemTreeService treeService;
        HashMap<String, List<Map<String, Object>>> dataMap = new HashMap<String, List<Map<String, Object>>>(16);
        if (filterMap == null) {
            return dataMap;
        }
        if (filterMap.get("hsbs_fetchitem") != null) {
            treeService = TREE_SERVICE_MAP.get("hsbs_fetchitem");
            List<Map<String, Object>> ftItemList = treeService.getItemDataList("hsbs_fetchitem", "id,number,name,fetchitemgroupid.number,fetchitemgroupid.name,uniquecode,datatype.id,datatype.showtype", (QFilter)SerializationUtils.deSerializeFromBase64((String)filterMap.get("hsbs_fetchitem")), "index asc");
            dataMap.put("hsbs_fetchitem", ftItemList);
        }
        if (filterMap.get("hsbs_salaryitem") != null) {
            treeService = TREE_SERVICE_MAP.get("hsbs_salaryitem");
            List<Map<String, Object>> salaryItemList = treeService.getItemDataList("hsbs_salaryitem", "id,number,name,salaryitemtype.number,salaryitemtype.name,uniquecode,datatype.id,datatype.showtype,salaryitemtype.index", (QFilter)SerializationUtils.deSerializeFromBase64((String)filterMap.get("hsbs_salaryitem")), "salaryitemtype.index asc,salaryitemtype.number asc,index asc,number asc");
            dataMap.put("hsbs_salaryitem", salaryItemList);
        }
        if (filterMap.get("hsbs_bizitem") != null) {
            treeService = TREE_SERVICE_MAP.get("hsbs_bizitem");
            List<Map<String, Object>> bsItemList = treeService.getItemDataList("hsbs_bizitem", "id,number,name,bizitemcategory.number,bizitemcategory.name,uniquecode,datatype.id,datatype.showtype,isextprop,classification,attitemtype", (QFilter)SerializationUtils.deSerializeFromBase64((String)filterMap.get("hsbs_bizitem")), "index asc");
            dataMap.put("hsbs_bizitem", bsItemList);
        }
        if (filterMap.get("hsbs_supportitem") != null) {
            treeService = TREE_SERVICE_MAP.get("hsbs_supportitem");
            List<Map<String, Object>> spItemList = treeService.getItemDataList("hsbs_supportitem", "id,number,name,uniquecode,datatype.id,datatype.showtype", (QFilter)SerializationUtils.deSerializeFromBase64((String)filterMap.get("hsbs_supportitem")), "index asc");
            dataMap.put("hsbs_supportitem", spItemList);
        }
        if (filterMap.get("hsas_accumulator") != null) {
            treeService = TREE_SERVICE_MAP.get("hsas_accumulator");
            List<Map<String, Object>> accItemList = treeService.getItemDataList("hsas_accumulator", "id,number,name,datatype.id,datatype.showtype,uniquecode", (QFilter)SerializationUtils.deSerializeFromBase64((String)filterMap.get("hsas_accumulator")), "number asc");
            dataMap.put("hsas_accumulator", accItemList);
        }
        return dataMap;
    }

    private void getCheckTreeNode(List<TreeNode> nodeList, Set<String> uniqueCodeSet, List<TreeNode> checkNodeList) {
        nodeList.forEach(node -> {
            if (uniqueCodeSet.contains(node.getId())) {
                checkNodeList.add((TreeNode)node);
            }
            if (!CollectionUtils.isEmpty((Collection)node.getChildren())) {
                this.getCheckTreeNode(node.getChildren(), uniqueCodeSet, checkNodeList);
            }
        });
    }
}

