/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.calperson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.addperson.entity.CalGetCouldAddPersonProgressInfo;
import kd.swc.hsbp.business.addperson.filter.FilterSalaryFileBaseRuleForRefresh;
import kd.swc.hsbp.business.addperson.filter.FilterSalaryFileByBaseRule;
import kd.swc.hsbp.business.addperson.rulefilte.AddPersonByRuleHelper;
import kd.swc.hsbp.business.calperson.entity.CalPersonLockInfo;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.refreshperson.entity.CalPersonRefreshProgressInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonLockEnum;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CalPayRollTaskVO;
import kd.swc.hsbp.common.vo.SceneGroupVO;

public class CalPersonHelper {
    private static Log logger = LogFactory.getLog(CalPersonHelper.class);

    public static List<Long> getCalPersonIdsByTask(Long taskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObjectCollection datas = helper.queryOriginalCollection("id", new QFilter[]{new QFilter("caltask", "=", (Object)taskId)});
        return datas.stream().map(object -> object.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> getFileIdsByTask(Long taskId) {
        return CalPersonHelper.getFileIdsByTask(taskId, null);
    }

    public static List<Long> getFileIdsByTask(Long taskId, List<Long> fileIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("caltask", "=", (Object)taskId);
        if (fileIds != null && fileIds.size() != 0) {
            filter.and(new QFilter("salaryfile.id", "in", fileIds));
        }
        DynamicObjectCollection datas = helper.queryOriginalCollection("salaryfile.id", new QFilter[]{filter});
        return datas.stream().map(obj -> obj.getLong("salaryfile.id")).collect(Collectors.toList());
    }

    public static List<Long> getSamePeriodFileIdsByTask(Long taskId) {
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject task = taskHelper.queryOriginalOne("payrollgroup.id,payrollscene.id,period.id", taskId);
        QFilter qFilter = new QFilter("payrollgroup", "=", (Object)task.getLong("payrollgroup.id")).and(new QFilter("payrollscene", "=", (Object)task.getLong("payrollscene.id"))).and(new QFilter("period", "=", (Object)task.getLong("period.id"))).and(new QFilter("tasktype", "=", (Object)"0"));
        DynamicObjectCollection tasks = taskHelper.queryOriginalCollection("id", qFilter.toArray());
        List taskIds = tasks.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObjectCollection datas = helper.queryOriginalCollection("salaryfile.id", new QFilter[]{new QFilter("caltask", "in", taskIds)});
        return datas.stream().map(dy -> dy.getLong("salaryfile.id")).collect(Collectors.toList());
    }

    public static List<Long> getFileIdsByCalPersonIds(List<Long> calPersonIds) {
        if (SWCListUtils.isEmpty(calPersonIds)) {
            return new ArrayList<Long>(10);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObjectCollection datas = helper.queryOriginalCollection("salaryfile.id", new QFilter[]{new QFilter("id", "in", calPersonIds)});
        return datas.stream().map(dy -> dy.getLong("salaryfile.id")).collect(Collectors.toList());
    }

    public static List<Long> getCouldAddPersonList(CalPayRollTaskVO task) {
        ArrayList<Long> fileVids = new ArrayList<Long>(10);
        List groups = task.getGroups();
        for (SceneGroupVO group : groups) {
            List<Long> salaryFileVIdList = FilterSalaryFileByBaseRule.createInstance().getEnableSalaryFileIdList(task, group);
            if (SWCListUtils.isEmpty(salaryFileVIdList)) continue;
            Date startdate = task.getStartdate();
            Date enddate = task.getEnddate();
            Long ruleId = group.getCalListRuleId();
            if (!(task.isPre() || ruleId != null && ruleId != 0L)) {
                fileVids.addAll(salaryFileVIdList);
                continue;
            }
            fileVids.addAll(AddPersonByRuleHelper.filterPersonWithRule(salaryFileVIdList, task, startdate, enddate, group));
        }
        return CalPersonHelper.removeRepeatFile(fileVids);
    }

    private static List<Long> removeRepeatFile(List<Long> fileVids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        if (fileVids.isEmpty()) {
            return fileVids;
        }
        DynamicObjectCollection fileColl = helper.queryOriginalCollection("id,boid,bsed", new QFilter("id", "in", fileVids).toArray(), "boid,bsed desc");
        ArrayList<Long> resultIds = new ArrayList<Long>(fileColl.size());
        HashSet<Long> boidSet = new HashSet<Long>(fileColl.size());
        for (DynamicObject file : fileColl) {
            if (!boidSet.add(file.getLong("boid"))) continue;
            resultIds.add(file.getLong("id"));
        }
        return resultIds;
    }

    public static List<Long> getCouldAddPersonList(Long taskid, Long trackerId) {
        CalPayRollTaskVO taskVO = CalPersonHelper.queryCalPayRollTask(taskid, trackerId);
        return CalPersonHelper.getCouldAddPersonList(taskVO);
    }

    public static List<Long> getCouldAddPersonList(Long taskid) {
        return CalPersonHelper.getCouldAddPersonList(taskid, null);
    }

    public static CalPayRollTaskVO queryCalPayRollTask(Long payRollTaskId, Long trackerId) {
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject task = swcDataServiceHelper.queryOne("id,payrollgroup.id,period.id,period.startdate,period.enddate,calperiod.startdate,payrollscene.id,tasktype,payrollscenev.groupcontent,exratedate,paydate,country.id,payrollmonth,payrollyear,payrollscenev.id,islimitadd,periodtype.id", payRollTaskId);
        CalPayRollTaskVO taskVO = new CalPayRollTaskVO();
        taskVO.setEnddate(task.getDate("period.enddate"));
        taskVO.setStartdate(task.getDate("period.startdate"));
        taskVO.setPeriodId(Long.valueOf(task.getLong("period.id")));
        taskVO.setPayrollgroupId(Long.valueOf(task.getLong("payrollgroup.id")));
        taskVO.setPayrollsceneId(Long.valueOf(task.getLong("payrollscene.id")));
        taskVO.setPayrollsceneVid(Long.valueOf(task.getLong("payrollscenev.id")));
        taskVO.setTaskType(task.getString("tasktype"));
        taskVO.setExratedate(task.getDate("exratedate"));
        taskVO.setPaydate(task.getDate("paydate"));
        taskVO.setCountryId(Long.valueOf(task.getLong("country.id")));
        taskVO.setPayrollmonth(task.getInt("payrollmonth"));
        taskVO.setPayrollyear(task.getInt("payrollyear"));
        taskVO.setId(Long.valueOf(task.getLong("id")));
        taskVO.setIslimitadd(task.getBoolean("islimitadd"));
        taskVO.setPeriodTypeId(Long.valueOf(task.getLong("periodtype.id")));
        String groupcontent = task.getString("payrollscenev.groupcontent");
        List sceneGroupVOS = (List)JSON.parseObject((String)groupcontent, (TypeReference)new TypeReference<List<SceneGroupVO>>(){}, (Feature[])new Feature[0]);
        taskVO.setGroups(sceneGroupVOS);
        if (trackerId == null) {
            taskVO.setTrackerId(Long.valueOf(RequestContext.get().getCurrUserId()));
        } else {
            taskVO.setTrackerId(trackerId);
        }
        return taskVO;
    }

    public static CalPayRollTaskVO queryCalPayRollTask(Long payRollTaskId) {
        return CalPersonHelper.queryCalPayRollTask(payRollTaskId, null);
    }

    public static void showAddPersonProgress(Long payrolltaskId, String taskName, IFormView view, boolean isAuto, boolean isExc) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_addpersonprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("taskId", (Object)payrolltaskId);
        showParameter.setCustomParam("name", (Object)taskName);
        if (isAuto) {
            showParameter.setCustomParam("isAuto", (Object)Boolean.TRUE);
        }
        if (isExc) {
            showParameter.setCustomParam("isExc", (Object)Boolean.TRUE);
        }
        view.showForm(showParameter);
    }

    public static void showDelPersonProgress(Long payrolltaskId, IFormView view) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_delcalpersonprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("taskId", (Object)payrolltaskId);
        view.showForm(showParameter);
    }

    public static List<Long> getCouldAddPersonListForRefresh(Long taskId) {
        CalPayRollTaskVO taskVO = CalPersonHelper.queryCalPayRollTask(taskId);
        ArrayList<Long> fileVids = new ArrayList<Long>(10);
        List groups = taskVO.getGroups();
        for (SceneGroupVO group : groups) {
            List<Long> salaryFileVIdList = FilterSalaryFileBaseRuleForRefresh.createInstance().getEnableSalaryFileIdList(taskVO, group);
            Long ruleId = group.getCalListRuleId();
            Date startdate = taskVO.getStartdate();
            Date enddate = taskVO.getEnddate();
            if (ruleId == null || ruleId == 0L) {
                fileVids.addAll(salaryFileVIdList);
                continue;
            }
            fileVids.addAll(AddPersonByRuleHelper.filterPersonWithRule(salaryFileVIdList, taskVO, startdate, enddate, group));
        }
        return CalPersonHelper.removeRepeatFile(fileVids);
    }

    public static List<Long> getSalaryFileHis(Long taskId, Set<Long> exceptionSalaryFileIds) {
        CalPayRollTaskVO taskVO = CalPersonHelper.queryCalPayRollTask(taskId);
        ArrayList<Long> fileVids = new ArrayList<Long>(10);
        List groups = taskVO.getGroups();
        for (SceneGroupVO group : groups) {
            fileVids.addAll(FilterSalaryFileByBaseRule.createInstance().filterSalaryFileIdList(taskVO, exceptionSalaryFileIds, group));
        }
        return CalPersonHelper.removeRepeatFile(fileVids);
    }

    public static List<Long> getSalaryFileHis(Long taskId, List<Long> salaryFileIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter idFilter = new QFilter("id", "in", salaryFileIds);
        DynamicObject[] salaryFiles = helper.query("id", new QFilter[]{idFilter});
        CalPayRollTaskVO calPayRollTask = CalPersonHelper.queryCalPayRollTask(taskId);
        Set<Long> salaryFileIdSet = Arrays.stream(salaryFiles).map(salaryFile -> salaryFile.getLong("id")).collect(Collectors.toSet());
        ArrayList<Long> fileVids = new ArrayList<Long>(10);
        List groups = calPayRollTask.getGroups();
        for (SceneGroupVO group : groups) {
            fileVids.addAll(FilterSalaryFileByBaseRule.createInstance().filterSalaryFileIdList(calPayRollTask, salaryFileIdSet, group));
        }
        return CalPersonHelper.removeRepeatFile(fileVids);
    }

    public static List<Long> getSalaryFileHisByRule(Long taskId, Set<Long> salaryFileIds) {
        CalPayRollTaskVO taskVO = CalPersonHelper.queryCalPayRollTask(taskId);
        return CalPersonHelper.getSalaryFileHisByRule(salaryFileIds, taskVO);
    }

    public static List<Long> getSalaryFileHisByRule(Set<Long> salaryFileIds, CalPayRollTaskVO taskVO) {
        ArrayList<Long> fileVids = new ArrayList<Long>(10);
        List groups = taskVO.getGroups();
        for (SceneGroupVO group : groups) {
            List<Long> salaryFileVIdList = FilterSalaryFileByBaseRule.createInstance().filterSalaryFileIdList(taskVO, salaryFileIds, group);
            Long ruleId = group.getCalListRuleId();
            Date startdate = taskVO.getStartdate();
            Date enddate = taskVO.getEnddate();
            if (ruleId == null || ruleId == 0L) {
                fileVids.addAll(salaryFileVIdList);
                continue;
            }
            fileVids.addAll(AddPersonByRuleHelper.filterPersonWithRule(salaryFileVIdList, taskVO, startdate, enddate, group));
        }
        return CalPersonHelper.removeRepeatFile(fileVids);
    }

    public static List<Long> getExceptionForRefresh(Long taskId, List<Long> salaryFileBoId) {
        DynamicObject[] salaryFileHisIds;
        CalPayRollTaskVO taskVO = CalPersonHelper.queryCalPayRollTask(taskId);
        List<QFilter> authorizedFilterList = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter(taskVO.getTrackerId(), "/UHMBBGZQ65X", "hsas_salaryfile", "47150e89000000ac");
        if (authorizedFilterList == null) {
            return new ArrayList<Long>(0);
        }
        SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        HashMap<Long, Date> salaryFileBsedMap = new HashMap<Long, Date>(16);
        HashMap<Long, Long> salaryFileHisMap = new HashMap<Long, Long>(16);
        Date calPeriodEndTime = taskVO.getEnddate();
        Date calPeriodStartTime = taskVO.getStartdate();
        QFilter boIdFilter = new QFilter("boid", "in", salaryFileBoId);
        QFilter payStatusFilter = new QFilter("paystatus", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)calPeriodEndTime);
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)calPeriodStartTime);
        if (!authorizedFilterList.isEmpty()) {
            boIdFilter.and(authorizedFilterList.get(0));
        }
        BaseDataHisHelper.addHisVerFilter(boIdFilter);
        boIdFilter.and(payStatusFilter).and(statusFilter).and(dataStatusFilter).and(bsedFilter).and(bsledFilter);
        for (DynamicObject salaryFile : salaryFileHisIds = salaryFileHelper.queryOriginalArray("id,boid,bsed", boIdFilter.toArray())) {
            Long boId = salaryFile.getLong("boid");
            Long hisId = salaryFile.getLong("id");
            Date currBsed = salaryFile.getDate("bsed");
            Date oldBsed = (Date)salaryFileBsedMap.get(boId);
            if (oldBsed != null) {
                if (!currBsed.after(oldBsed)) continue;
                salaryFileBsedMap.put(boId, currBsed);
                salaryFileHisMap.put(boId, hisId);
                continue;
            }
            salaryFileBsedMap.put(boId, currBsed);
            salaryFileHisMap.put(boId, hisId);
        }
        ArrayList allSalaryFileIdSet = new ArrayList(10);
        for (Map.Entry salaryFile : salaryFileHisMap.entrySet()) {
            allSalaryFileIdSet.add(salaryFile.getValue());
        }
        List<Long> salaryFileIdSet = FilterSalaryFileByBaseRule.createInstance().filterOnHoldBySalaryFileIds(taskVO, new HashSet<Long>(allSalaryFileIdSet));
        return salaryFileIdSet;
    }

    @Deprecated
    private static DynamicObject getCalTaskInfo(Long calTaskId) {
        SWCDataServiceHelper calPayrollHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String fields = "id,number,name,tasktype,calrulev.id,startdate,enddate,country.id,ishandleproration,paydate,periodtype.id,period.id,payrollgroup.id,payrollgroupv.id,payrollgroupv.currency.id,payrollgroupv.exratetable.id,exratedate,payrollgroupv.currency.amtprecision,calfrequency.id,calfrequency.coefficient,payrollscene.id,calversionno,org.id";
        return calPayrollHelper.queryOne(fields, calTaskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tryLock(Long taskId, CalPersonLockEnum type) {
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject task = taskHelper.queryOriginalOne("payrollgroup.id,payrollscene.id,period.id", taskId);
        long payrollgroupId = task.getLong("payrollgroup.id");
        long payrollsceneId = task.getLong("payrollscene.id");
        long periodId = task.getLong("period.id");
        String lockKey = payrollgroupId + "&" + payrollsceneId + "&" + periodId;
        DLock lock = DLock.create((String)lockKey);
        try {
            if (lock.tryLock(300000L)) {
                CalPersonLockInfo info = (CalPersonLockInfo)SWCAppCache.get((String)"hsas").get(lockKey, CalPersonLockInfo.class);
                if (info == null || SWCStringUtils.isEmpty((String)info.getOp()) || new Date().after(SWCDateTimeUtils.addHour((Date)info.getStartTime(), (long)1L))) {
                    CalPersonLockInfo newLockInfo = new CalPersonLockInfo();
                    newLockInfo.setOp(type.getCode());
                    newLockInfo.setStartTime(new Date());
                    SWCAppCache.get((String)"hsas").put(lockKey, (Object)newLockInfo);
                    String string = null;
                    return string;
                }
                String string = info.getOp();
                return string;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8d85\u65f6", (Throwable)e);
        }
        finally {
            lock.unlock();
            lock.close();
        }
        return null;
    }

    public static String checkLock(Long taskId) {
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject task = taskHelper.queryOriginalOne("payrollgroup.id,payrollscene.id,period.id", taskId);
        long payrollgroupId = task.getLong("payrollgroup.id");
        long payrollsceneId = task.getLong("payrollscene.id");
        long periodId = task.getLong("period.id");
        String lockKey = payrollgroupId + "&" + payrollsceneId + "&" + periodId;
        CalPersonLockInfo info = (CalPersonLockInfo)SWCAppCache.get((String)"hsas").get(lockKey, CalPersonLockInfo.class);
        if (info == null || SWCStringUtils.isEmpty((String)info.getOp()) || new Date().after(SWCDateTimeUtils.addHour((Date)info.getStartTime(), (long)1L))) {
            return null;
        }
        return info.getOp();
    }

    public static void releaseLock(Long taskId) {
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject task = taskHelper.queryOriginalOne("payrollgroup.id,payrollscene.id,period.id", taskId);
        long payrollgroupId = task.getLong("payrollgroup.id");
        long payrollsceneId = task.getLong("payrollscene.id");
        long periodId = task.getLong("period.id");
        String lockKey = payrollgroupId + "&" + payrollsceneId + "&" + periodId;
        SWCAppCache.get((String)"hsas").remove(lockKey);
    }

    public static void asyncGetCouldAddFileVids(Long calTaskId) {
        CalGetCouldAddPersonProgressInfo progress = new CalGetCouldAddPersonProgressInfo();
        progress.setStartDate(new Date());
        progress.setPercent(0);
        ISWCAppCache appCache = SWCAppCache.get((String)"cache_getperson_key_%s");
        appCache.put(String.format(Locale.ROOT, "cache_getperson_key_%s", calTaskId), (Object)progress);
        SWCThreadPoolFactory.getCalpersonQueryThreadPool().execute(() -> {
            try {
                CalPersonHelper.setGetFileVidsProgress(calTaskId, 100, CalPersonHelper.getCouldAddPersonList(calTaskId));
            }
            catch (Throwable t) {
                logger.error("\u83b7\u53d6\u6dfb\u52a0\u4eba\u5458\u62a5\u9519", t);
                CalPersonHelper.setGetFileVidsProgress(calTaskId, 100, new ArrayList<Long>(10));
            }
        }, RequestContext.get());
    }

    public static void setGetFileVidsProgress(Long calTaskId, int percent, List<Long> fileVids) {
        ISWCAppCache appCache = SWCAppCache.get((String)"cache_getperson_key_%s");
        CalGetCouldAddPersonProgressInfo progress = (CalGetCouldAddPersonProgressInfo)appCache.get(String.format(Locale.ROOT, "cache_getperson_key_%s", calTaskId), CalGetCouldAddPersonProgressInfo.class);
        if (progress == null) {
            return;
        }
        int oldProgress = progress.getPercent();
        if (percent > oldProgress) {
            progress.setPercent(percent);
        }
        if (percent == 100) {
            progress.setFileIds(fileVids);
            progress.setEndDate(new Date());
        }
        appCache.put(String.format(Locale.ROOT, "cache_getperson_key_%s", calTaskId), (Object)progress);
    }

    public static void setGetUpdateFileVidsProgress(Long calTaskId, int percent) {
        ISWCAppCache appCache = SWCAppCache.get((String)"cachekey_hsas_calperson_refresh");
        CalPersonRefreshProgressInfo progress = (CalPersonRefreshProgressInfo)appCache.get(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", calTaskId), CalPersonRefreshProgressInfo.class);
        if (progress == null) {
            return;
        }
        int oldProgress = progress.getProgress();
        if (percent > oldProgress) {
            progress.setProgress(percent);
        }
        appCache.put(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", calTaskId), (Object)progress);
    }
}

