/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.cloudcolla;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.enums.CollaRuleErrorCodeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.AbstractCloudCollaExecutePlugin;
import kd.swc.hsbp.common.vo.CollaActContext;
import kd.swc.hsbp.common.vo.CollaRuleExecuteContext;
import kd.swc.hsbp.common.vo.CollaTriggerEntity;
import org.apache.commons.collections4.MapUtils;

public class StandardCloudCollaTaskExecuteHelper {
    private static final Log log = LogFactory.getLog(StandardCloudCollaTaskExecuteHelper.class);
    private CollaRuleExecuteContext executeInfo;
    private List<String> errorMsgs;
    private List<String> warnMsgs;

    public StandardCloudCollaTaskExecuteHelper(CollaRuleExecuteContext executeInfo) {
        this.executeInfo = executeInfo;
        this.errorMsgs = executeInfo.getErrorMsgs();
        this.warnMsgs = executeInfo.getWarnMsgs();
    }

    public Map<String, Object> executeCloudCollaTask() {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        if (null != this.executeInfo && null != this.executeInfo.getPayRollActGrpId()) {
            CollaActContext payRollAct = null;
            int lastSize = this.warnMsgs.size();
            HashMap<String, Object> commonDatas = new HashMap<String, Object>();
            try {
                log.info("[colla]: executeCloudCollaTask begin,payRollActGrpId = {}", (Object)this.executeInfo.getPayRollActGrpId());
                List collaActContexts = this.executeInfo.getCollaActContext();
                commonDatas.put("orgId", this.executeInfo.getOrgId());
                commonDatas.put("orgNumber", this.executeInfo.getOrgNumber());
                commonDatas.put("isInbound", this.executeInfo.getInBound());
                commonDatas.put("flowType", this.executeInfo.getFlowType());
                commonDatas.put("effectTime", this.executeInfo.getEffectTime());
                commonDatas.put("executeInfo", this.executeInfo);
                commonDatas.put("executeInfoMap", this.executeInfo.toMap());
                Map<String, List<Map<String, Object>>> ruleEngineResult = this.callRuleEngine(this.executeInfo);
                for (int i = 0; i < collaActContexts.size(); ++i) {
                    log.info("[colla]: run {} action,payRollActGrpId = {}", (Object)i, (Object)this.executeInfo.getPayRollActGrpId());
                    payRollAct = (CollaActContext)collaActContexts.get(i);
                    lastSize = this.warnMsgs.size();
                    String key = payRollAct.getPolicyId() + "_" + payRollAct.getRuleId();
                    Long ruleId = payRollAct.getRuleId();
                    commonDatas.put("currentPayRollActId", payRollAct.getPayRollActId());
                    if (this.executeInfo.isValidPreCondition() && (ruleEngineResult == null || !ruleEngineResult.containsKey(key) && ruleId != null && ruleId != 0L)) {
                        String msg = ResManager.loadKDString((String)"\u6267\u884c\u524d\u63d0\u6761\u4ef6\u4e0d\u6ee1\u8db3\u3002", (String)"StandardCloudCollaTaskExecuteHelper_0", (String)"swc-hsbp-business", (Object[])new Object[0]);
                        this.errorMsgs.add(this.addMsgPrefix(payRollAct.getPayRollActName(), msg));
                        this.executeInfo.setErrorCode(CollaRuleErrorCodeEnum.CONDITION_ERROR);
                        this.publishSyncMsg();
                        result.put("success", Boolean.TRUE);
                        result.put("msg", this.errorMsgs.stream().collect(Collectors.joining(System.lineSeparator())));
                        return result;
                    }
                    payRollAct.setRuleEngineResult(ruleEngineResult);
                    this.assembleDyobjs(payRollAct, commonDatas);
                }
                commonDatas.put("currentPayRollActId", null);
                this.beginTransactionSave(this.executeInfo.getCollaRuleExeResultDatas(), commonDatas);
            }
            catch (Exception e) {
                log.info("[colla] executeCloudCollaTask error", (Object)e);
                if (payRollAct != null) {
                    this.errorMsgs.add(this.addMsgPrefix(payRollAct.getPayRollActName(), e.getMessage()));
                    this.batchAddWarnPrefix(payRollAct.getPayRollActName(), lastSize);
                } else {
                    this.errorMsgs.add(e.getMessage());
                }
                this.executeInfo.setErrorCode(CollaRuleErrorCodeEnum.DEFAULT_ERROR);
                this.publishSyncMsg();
            }
        } else {
            this.errorMsgs.add(ResManager.loadKDString((String)"\u534f\u4f5c\u89c4\u5219\u4e0d\u5b58\u5728, \u65e0\u6cd5\u6267\u884c\u8de8\u4e1a\u52a1\u534f\u4f5c\u3002", (String)"StandardCloudCollaTaskExecuteHelper_1", (String)"swc-hsbp-business", (Object[])new Object[0]));
            this.publishSyncMsg();
        }
        result.put("success", Boolean.TRUE);
        if (!this.errorMsgs.isEmpty()) {
            result.put("success", Boolean.FALSE);
            result.put("msg", this.errorMsgs.stream().collect(Collectors.joining(System.lineSeparator())));
        }
        return result;
    }

    private void batchAddWarnPrefix(String payRollActName, int lastSize) {
        int size = this.warnMsgs.size();
        if (lastSize >= size) {
            return;
        }
        for (int i = lastSize; i < size; ++i) {
            String newValue = ResManager.loadKDString((String)"[{0}]{1}", (String)"StandardCloudCollaTaskExecuteHelper_2", (String)"swc-hsbp-business", (Object[])new Object[]{payRollActName, this.warnMsgs.get(i)});
            this.warnMsgs.set(i, newValue);
        }
    }

    private void assembleDyobjs(CollaActContext payRollAct, Map<String, Object> commonDatas) {
        CollaRuleExecuteContext collaRuleContext = payRollAct.getParentCollaRuleExecuteContext();
        Map originalApiDatas = collaRuleContext.getOriginalApiDatas();
        List triggers = payRollAct.getTriggers();
        CollaRuleExecuteContext parentCollaRuleExecuteContext = payRollAct.getParentCollaRuleExecuteContext();
        Map payRollActFieldMapRel = parentCollaRuleExecuteContext.getPayRollActFieldMapRel();
        for (CollaTriggerEntity trigger : triggers) {
            String objectName = trigger.getObjectName();
            if ("1".equals(trigger.getFieldMap())) {
                List<DynamicObject> fieldMapResult = this.executeFieldMap(originalApiDatas, objectName, (DynamicObject)payRollActFieldMapRel.get(payRollAct.getPayRollActId() + "|" + objectName));
                log.info("[colla]:assembleDyobjs get field map data success, objectName = {}", (Object)objectName);
                payRollAct.getFieldMapResultData().put(objectName, fieldMapResult);
                continue;
            }
            log.info("[colla]:assembleDyobjs get field rule data success, objectName = {}", (Object)objectName);
            List<Object> datas = new ArrayList(10);
            datas = this.executeInfo.getRuleDataSource() == 1 ? this.executeFromVerifyBill(objectName) : this.executeFieldRule(trigger, payRollAct.getRuleEngineResult(), payRollAct.getRuleEngineCustomizedResult());
            payRollAct.getFieldRuleResultData().put(objectName, datas);
        }
        int lastSize = this.warnMsgs.size();
        for (CollaTriggerEntity trigger : triggers) {
            List plugins = trigger.getPlugins();
            String objectName = trigger.getObjectName();
            commonDatas.put("currentTriggerId", trigger.getTriggerId());
            for (AbstractCloudCollaExecutePlugin plugin : plugins) {
                List executeMsg = plugin.afterAssembleData(payRollAct.getFieldMapResultData(), payRollAct.getFieldRuleResultData(), this.executeInfo.getCollaRuleExeResultDatas(), commonDatas, this.formatRuleEngineMap(payRollAct.getRuleEngineResult()), objectName);
                if (CollectionUtils.isEmpty((Collection)executeMsg)) continue;
                this.errorMsgs.addAll(this.batchAddMsgPrefix(payRollAct.getPayRollActName(), executeMsg));
            }
        }
        commonDatas.put("currentTriggerId", null);
        this.batchAddWarnPrefix(payRollAct.getPayRollActName(), lastSize);
    }

    private List<DynamicObject> executeFromVerifyBill(String objectName) {
        Map verifyBillData = this.executeInfo.getVerifyBillData();
        if (CollectionUtils.isEmpty((Map)verifyBillData)) {
            log.info("[colla] verifyBillData is null, objectName = {} ,payRollActGrpId ={}", (Object)objectName, (Object)this.executeInfo.getPayRollActGrpId());
        }
        return (List)MapUtils.getObject((Map)verifyBillData, (Object)objectName, Collections.emptyList());
    }

    private String addMsgPrefix(String actionName, String msg) {
        return ResManager.loadKDString((String)"[{0}]{1}", (String)"StandardCloudCollaTaskExecuteHelper_2", (String)"swc-hsbp-business", (Object[])new Object[]{actionName, msg});
    }

    private List<String> batchAddMsgPrefix(String actionName, List<String> msgs) {
        ArrayList<String> result = new ArrayList<String>(10);
        if (CollectionUtils.isEmpty(msgs)) {
            return result;
        }
        for (String msg : msgs) {
            result.add(ResManager.loadKDString((String)"[{0}]{1}", (String)"StandardCloudCollaTaskExecuteHelper_2", (String)"swc-hsbp-business", (Object[])new Object[]{actionName, msg}));
        }
        return result;
    }

    private void assembleFieldMap(Map<String, String> fieldMap, DynamicObject entryentity, boolean isCustomAPI) {
        DynamicObjectCollection subEntryentities = entryentity.getDynamicObjectCollection("fieldmapdetail");
        fieldMap.put("bsed", "bsed");
        fieldMap.put("bsled", "bsled");
        fieldMap.put("boid", "boid");
        fieldMap.put("iscurrentversion", "iscurrentversion");
        fieldMap.put("datastatus", "datastatus");
        fieldMap.put("ismodify", "ismodify");
        fieldMap.put("sourcevid", "sourcevid");
        fieldMap.put("firstbsed", "firstbsed");
        fieldMap.put("changebsed", "changebsed");
        fieldMap.put("bred", "bred");
        fieldMap.put("brled", "brled");
        fieldMap.put("brfd", "brfd");
        for (DynamicObject subEntryentity : subEntryentities) {
            String key = subEntryentity.getString("targetobjectfield");
            String value = subEntryentity.getString("subscibeapifield");
            if (!isCustomAPI) {
                value = subEntryentity.getString("subscibeobject") + "." + subEntryentity.getString("subscibeapifield");
            }
            fieldMap.put(key, value);
        }
    }

    private List<DynamicObject> executeFieldMap(Map<String, List<Map<String, Object>>> apiDatas, String entityObjectId, DynamicObject fieldMapDyobj) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        if (apiDatas == null || apiDatas.isEmpty()) {
            log.info("[colla]: the api data of [{}] is null.map data fail.", (Object)entityObjectId);
            return result;
        }
        if (!this.validateFieldMap(entityObjectId, fieldMapDyobj)) {
            return result;
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        DynamicObjectCollection entryentities = fieldMapDyobj.getDynamicObjectCollection("entryentity");
        String apiNumber = null;
        for (DynamicObject entryentity : entryentities) {
            if (!SWCStringUtils.equals((String)entryentity.getString("entityobject.id"), (String)entityObjectId)) continue;
            this.assembleFieldMap(fieldMap, entryentity, "2".equals(entryentity.getString("apideploy.type")));
            apiNumber = entryentity.getString("apideploy.number");
            break;
        }
        if (SWCStringUtils.isEmpty(apiNumber)) {
            return result;
        }
        List<Map<String, Object>> singleApiDatas = apiDatas.get(apiNumber);
        if (CollectionUtils.isEmpty(singleApiDatas)) {
            return result;
        }
        SWCDataServiceHelper targetOrm = new SWCDataServiceHelper(entityObjectId);
        for (Map<String, Object> apiData : singleApiDatas) {
            DynamicObject targetObject = targetOrm.generateEmptyDynamicObject();
            DynamicObjectType dyobjType = targetObject.getDynamicObjectType();
            this.setComboDefValue(targetObject, dyobjType);
            log.info("[colla]: start map data. entityObjectId = {}", (Object)entityObjectId);
            DataEntityPropertyCollection properties = targetObject.getDataEntityType().getProperties();
            for (Map.Entry fieldMapEntry : fieldMap.entrySet()) {
                String fieldKey = (String)fieldMapEntry.getKey();
                Object fieldVal = apiData.get(fieldMapEntry.getValue());
                if (null == fieldVal || !properties.containsKey((Object)fieldKey)) continue;
                DynamicProperty dynamicProp = dyobjType.getProperty(fieldKey);
                if (dynamicProp instanceof BasedataProp) {
                    String basedataEntityId = ((BasedataProp)dynamicProp).getBaseEntityId();
                    SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(basedataEntityId);
                    DynamicObject emptyDyobj = serviceHelper.generateEmptyDynamicObject();
                    emptyDyobj.set("id", fieldVal);
                    targetObject.set(fieldKey, (Object)emptyDyobj);
                    continue;
                }
                targetObject.set(fieldKey, fieldVal);
            }
            result.add(targetObject);
        }
        return result;
    }

    private void setComboDefValue(DynamicObject dyobj, DynamicObjectType dyobjType) {
        Map fields = ((MainEntityType)dyobjType).getAllFields();
        Date date = new Date();
        for (Map.Entry fieldEntry : fields.entrySet()) {
            IDataEntityProperty entityProp = (IDataEntityProperty)fieldEntry.getValue();
            if (entityProp instanceof ComboProp) {
                Object defVal = ((ComboProp)entityProp).getDefValue();
                if (null != defVal) {
                    // empty if block
                }
                dyobj.set((String)fieldEntry.getKey(), defVal);
                continue;
            }
            if (!(entityProp instanceof CreateDateProp) && !(entityProp instanceof ModifyDateProp)) continue;
            dyobj.set((String)fieldEntry.getKey(), (Object)date);
        }
    }

    private boolean validateFieldMap(String entityNumber, DynamicObject fieldMapDyobj) {
        String name;
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper(entityNumber);
        DynamicObject entity = swcDataServiceHelper.generateEmptyDynamicObject();
        IDataEntityType dataEntityType = entity.getDataEntityType();
        LocaleString displayName = dataEntityType.getDisplayName();
        String string = name = displayName == null ? dataEntityType.getAlias() : displayName.getLocaleValue();
        if (null == fieldMapDyobj) {
            throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u5b9e\u4f53 \u201c{0}\u201d\uff0c\u5b57\u6bb5\u6620\u5c04\u65b9\u6848\u5df2\u88ab\u5220\u9664\u3002", (String)"HSASCloudCollaRuleConstructHelper_1", (String)"swc-hsas-business", (Object[])new Object[]{name})), new Object[0]);
        }
        if (!SWCStringUtils.equals((String)fieldMapDyobj.getString("status"), (String)"C")) {
            throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u5b9e\u4f53 \u201c{0}\u201d\uff0c\u5b57\u6bb5\u6620\u5c04\u65b9\u6848\u201c{1}\u201d\u6570\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6838\u3002", (String)"HSASCloudCollaRuleConstructHelper_2", (String)"swc-hsas-business", (Object[])new Object[]{name, fieldMapDyobj.getString("name")})), new Object[0]);
        }
        if (!SWCStringUtils.equals((String)fieldMapDyobj.getString("enable"), (String)"1")) {
            throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u5b9e\u4f53 \u201c{0}\u201d\uff0c\u5b57\u6bb5\u6620\u5c04\u65b9\u6848\u201c{1}\u201d\u5df2\u88ab\u7981\u7528\u3002", (String)"HSASCloudCollaRuleConstructHelper_3", (String)"swc-hsas-business", (Object[])new Object[]{name, fieldMapDyobj.getString("name")})), new Object[0]);
        }
        return true;
    }

    @Deprecated
    private Map<String, List<Map<String, Object>>> callRuleEngine(CollaRuleExecuteContext executeInfo) throws Exception {
        if (executeInfo.getRuleDataSource() != 0) {
            return null;
        }
        Map<String, Object> resultMap = this.callRuleEngineOriginal(executeInfo);
        return this.convertRuleResponseMap(resultMap);
    }

    public Map<String, Object> callRuleEngineOriginal(CollaRuleExecuteContext executeInfo) {
        List collaActContext = executeInfo.getCollaActContext();
        if (CollectionUtils.isEmpty((Collection)collaActContext)) {
            return Collections.emptyMap();
        }
        CollaActContext actContext = (CollaActContext)collaActContext.get(0);
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        requestMap.put("tenantId", "");
        requestMap.put("cloudId", "/U+QDTL900//");
        requestMap.put("bizApp", SWCStringUtils.isNotEmpty((String)actContext.getSceneAppNumber()) ? actContext.getSceneAppNumber() : "hsas");
        requestMap.put("sceneNumber", actContext.getSceneNumber());
        requestMap.put("buNumber", executeInfo.getOrgNumber());
        requestMap.put("inputParams", this.getRuleEngineInputParams(executeInfo));
        requestMap.put("executePolicyIds", this.getPolicyIds(executeInfo));
        return (Map)SWCMServiceUtils.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"callRuleEngineForOriginal", (Object[])new Object[]{requestMap});
    }

    private List<Long> getPolicyIds(CollaRuleExecuteContext executeInfo) {
        ArrayList<Long> result = new ArrayList<Long>(10);
        List collaActContext = executeInfo.getCollaActContext();
        if (CollectionUtils.isEmpty((Collection)collaActContext)) {
            return result;
        }
        collaActContext.stream().forEach(item -> {
            result.addAll(item.getPolicyIds());
            result.add(item.getPolicyId());
        });
        return result;
    }

    private Map<String, Object> getRuleEngineInputParams(CollaRuleExecuteContext collaRuleContext) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        Map convertedApiDatas = collaRuleContext.getConvertedApiDatas();
        if (CollectionUtils.isEmpty((Map)convertedApiDatas)) {
            return result;
        }
        convertedApiDatas.forEach((key, dataList) -> {
            Object tempResult = this.pickRuleEngineDataFromList((List<Object>)dataList);
            if (tempResult instanceof Map) {
                ((Map)tempResult).forEach((resultKey, resultValue) -> result.put(resultKey.replaceAll("\\.", "_"), resultValue));
                return;
            }
            if (tempResult instanceof DynamicObject) {
                result.put(((DynamicObject)tempResult).getDataEntityType().getName(), tempResult);
                return;
            }
            result.put((String)key, tempResult);
        });
        Map msgEntity = collaRuleContext.getMsgEntity();
        if (!CollectionUtils.isEmpty((Map)msgEntity)) {
            msgEntity.forEach((key, value) -> result.putIfAbsent((String)key, value));
        }
        return result;
    }

    private Object pickRuleEngineDataFromList(List<Object> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return null;
        }
        Object firstData = dataList.get(0);
        if (firstData instanceof Map) {
            return firstData;
        }
        if (firstData instanceof DynamicObject) {
            IDataEntityType dataEntityType = ((DynamicObject)firstData).getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            boolean isContainCurrentVersion = properties.containsKey((Object)"iscurrentversion");
            if (!isContainCurrentVersion) {
                return firstData;
            }
            for (Object data : dataList) {
                DynamicObject tempData = (DynamicObject)data;
                if (!tempData.getBoolean("iscurrentversion")) continue;
                return tempData;
            }
        }
        return firstData;
    }

    private Map<String, List<Map<String, Object>>> convertRuleResponseMap(Map<String, Object> resultMap) throws Exception {
        HashMap<String, List<Map<String, Object>>> ruleResponseMap = new HashMap<String, List<Map<String, Object>>>(16);
        String responseCode = String.valueOf(resultMap.get("responseCode"));
        if (!"200".equals(responseCode)) {
            Object errorMsg = resultMap.get("errorMsg");
            if (errorMsg == null) {
                errorMsg = resultMap.get("responseDesc");
            }
            throw new Exception(String.valueOf(errorMsg));
        }
        List policys = (List)resultMap.get("policyResults");
        if (CollectionUtils.isEmpty((Collection)policys)) {
            return ruleResponseMap;
        }
        for (Map policy : policys) {
            String policyId = String.valueOf(policy.get("policyId"));
            List matchRules = (List)policy.get("ruleResults");
            List defaultResult = (List)policy.get("defaultResults");
            if (CollectionUtils.isEmpty((Collection)matchRules) && !CollectionUtils.isEmpty((Collection)defaultResult)) {
                ruleResponseMap.put(String.valueOf(policyId), defaultResult);
                continue;
            }
            ArrayList matchResultsAll = new ArrayList(10);
            for (Map matchRule : matchRules) {
                String ruledesignid = String.valueOf(matchRule.get("ruleDesignId"));
                List matchResults = (List)matchRule.get("matchResults");
                String key = policyId + "_" + ruledesignid;
                ruleResponseMap.put(key, matchResults);
                matchResultsAll.addAll(matchResults);
            }
            ruleResponseMap.put(String.valueOf(policyId), matchResultsAll);
        }
        return ruleResponseMap;
    }

    private void beginTransactionSave(Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonDatas) {
        try {
            log.info("[colla] beginTransactionSave errorMsgs = {}", this.errorMsgs);
            if (CollectionUtils.isEmpty(this.errorMsgs)) {
                this.transactionSaveRequireNew(assembleSaveData, commonDatas);
            }
        }
        finally {
            log.info("[colla] beginTransactionSave finally errorMsgs = {}", this.errorMsgs);
            this.publishSyncMsg();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transactionSaveRequireNew(Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonDatas) {
        boolean isSaveSuccess = true;
        TXHandle saveTx = TX.requiresNew();
        CollaActContext tempPayRollAct = null;
        try {
            List collaActContext = this.executeInfo.getCollaActContext();
            for (CollaActContext payRollAct : collaActContext) {
                commonDatas.put("currentPayRollActId", payRollAct.getPayRollActId());
                tempPayRollAct = payRollAct;
                int lastSize = this.warnMsgs.size();
                List triggers = payRollAct.getTriggers();
                for (CollaTriggerEntity trigger : triggers) {
                    commonDatas.put("currentTriggerId", trigger.getTriggerId());
                    List plugins = trigger.getPlugins();
                    String objectName = trigger.getObjectName();
                    for (AbstractCloudCollaExecutePlugin plugin : plugins) {
                        List execute = plugin.execute((List)this.executeInfo.getCollaRuleExeResultDatas().get(objectName), this.formatRuleEngineMap(payRollAct.getRuleEngineResult()));
                        if (CollectionUtils.isEmpty((Collection)execute)) continue;
                        this.errorMsgs.addAll(this.batchAddMsgPrefix(payRollAct.getPayRollActName(), execute));
                        isSaveSuccess = false;
                        return;
                    }
                }
                commonDatas.put("currentTriggerId", null);
                this.batchAddWarnPrefix(payRollAct.getPayRollActName(), lastSize);
            }
            commonDatas.put("currentPayRollActId", null);
            saveTx.commit();
            this.afterCommit(collaActContext);
        }
        catch (Exception e) {
            isSaveSuccess = false;
            String msg = tempPayRollAct != null ? this.addMsgPrefix(tempPayRollAct.getPayRollActName(), e.getMessage()) : e.getMessage();
            this.errorMsgs.add(msg);
            log.error(msg, (Throwable)e);
        }
        finally {
            if (!isSaveSuccess) {
                saveTx.markRollback();
            }
            saveTx.close();
        }
    }

    private void afterCommit(List<CollaActContext> collaActContext) {
        CollaActContext tempPayRollAct = null;
        try {
            Iterator<CollaActContext> iterator = collaActContext.iterator();
            while (iterator.hasNext()) {
                CollaActContext payRollAct;
                tempPayRollAct = payRollAct = iterator.next();
                int lastSize = this.warnMsgs.size();
                List triggers = payRollAct.getTriggers();
                for (CollaTriggerEntity trigger : triggers) {
                    List plugins = trigger.getPlugins();
                    String objectName = trigger.getObjectName();
                    for (AbstractCloudCollaExecutePlugin plugin : plugins) {
                        plugin.afterCommit((List)this.executeInfo.getCollaRuleExeResultDatas().get(objectName), this.formatRuleEngineMap(payRollAct.getRuleEngineResult()));
                    }
                }
                this.batchAddWarnPrefix(payRollAct.getPayRollActName(), lastSize);
            }
        }
        catch (Exception ex) {
            log.info("[colla] afterCommit error.", (Object)ex);
        }
    }

    private Map<String, Object> formatRuleEngineMap(Map<String, List<Map<String, Object>>> fieldRuleResultData) {
        if (this.executeInfo.getRuleDataSource() == 1) {
            return this.executeInfo.getVerifyBillData();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (CollectionUtils.isEmpty(fieldRuleResultData)) {
            return result;
        }
        fieldRuleResultData.forEach((policyId, ruleResults) -> {
            if (CollectionUtils.isEmpty((Collection)ruleResults)) {
                return;
            }
            Map ruleResult = (Map)ruleResults.get(0);
            String key = (String)ruleResult.get("field");
            Object value = ruleResult.get("value");
            result.put(key, value);
        });
        return result;
    }

    private void publishSyncMsg() {
        log.info("\u8de8\u4e1a\u52a1\u534f\u4f5c ---> \u5f00\u59cb\u53cd\u5199\u534f\u4f5c\u4efb\u52a1\u7ba1\u7406 <---");
        Map<String, Object> assembleMsgData = this.assembleMsgData();
        this.publishSyncMsg(assembleMsgData);
        log.info("\u8de8\u4e1a\u52a1\u534f\u4f5c ---> \u7ed3\u675f\u53cd\u5199\u534f\u4f5c\u4efb\u52a1\u7ba1\u7406 <---");
    }

    private void publishSyncMsg(Map<String, Object> messageData) {
        try (MessagePublisher publisher = MQFactory.get().createSimplePublisher("swc", "hpdi_opsync_queue");){
            publisher.publish(messageData);
        }
    }

    private Map<String, Object> assembleMsgData() {
        HashMap<String, Object> messageData = new HashMap<String, Object>(16);
        messageData.put("tag", "writebacktaskcenter");
        messageData.put("entity", this.executeInfo.getTaskCenterClass());
        HashMap<String, Object> collaData = new HashMap<String, Object>(16);
        collaData.put("id", this.executeInfo.getTaskCenterId());
        collaData.put("entryentity.id", this.executeInfo.getTaskCenterEntryId());
        CollaRuleErrorCodeEnum errorCode = this.executeInfo.getErrorCode();
        if (!this.errorMsgs.isEmpty()) {
            collaData.put("entryentity.taskexecutestatusent", CollaRuleErrorCodeEnum.CONDITION_ERROR == errorCode ? "G" : "E");
            collaData.put("entryentity.result", null);
        } else {
            collaData.put("entryentity.taskexecutestatusent", "D");
            collaData.put("entryentity.result", this.toJson(this.executeInfo.getResult()));
        }
        ArrayList<String> msg = new ArrayList<String>(10);
        if (!CollectionUtils.isEmpty(this.warnMsgs)) {
            msg.addAll(this.warnMsgs);
        }
        if (!CollectionUtils.isEmpty(this.errorMsgs)) {
            msg.addAll(this.errorMsgs);
        }
        collaData.put("entryentity.executefailmsgent", String.join((CharSequence)System.lineSeparator(), msg));
        collaData.put("entryentity.taskexecutetime", new Date());
        collaData.put("entryentity.taskexecuser", RequestContext.get().getCurrUserId());
        collaData.put("entryentity.taskexecmanner", this.executeInfo.getTaskExecManner());
        messageData.put("data", collaData);
        return messageData;
    }

    private String toJson(Map<String, List<Map<String, Object>>> data) {
        if (CollectionUtils.isEmpty(data)) {
            return "";
        }
        return SerializationUtils.toJsonString(data);
    }

    private List<DynamicObject> executeFieldRule(CollaTriggerEntity trigger, Map<String, List<Map<String, Object>>> ruleEngineResult, Map<String, Map<String, String>> ruleEngineCustomizedResult) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        String objectName = trigger.getObjectName();
        if (SWCStringUtils.isEmpty((String)objectName)) {
            return result;
        }
        SWCDataServiceHelper objectOrm = new SWCDataServiceHelper(objectName);
        DynamicObject dyObj = objectOrm.generateEmptyDynamicObject();
        result.add(dyObj);
        Map fieldRules = trigger.getFieldRules();
        if (CollectionUtils.isEmpty((Map)fieldRules)) {
            return result;
        }
        Set entrySet = fieldRules.entrySet();
        for (Map.Entry rule : entrySet) {
            Object value;
            String propertyName = (String)rule.getKey();
            Long frPolicyId = (Long)rule.getValue();
            List<Map<String, Object>> ruleResponseArray = ruleEngineResult.get(String.valueOf(frPolicyId));
            if (ruleResponseArray == null || ruleResponseArray.size() == 0) continue;
            Object type = dyObj.getDataEntityType().getProperties().get((Object)propertyName);
            Map<String, Object> ruleResult = ruleResponseArray.get(0);
            String field = MapUtils.getString(ruleResult, (Object)"field");
            if ("result_customize".equalsIgnoreCase(field)) {
                Map tempMap = ruleEngineCustomizedResult.computeIfAbsent(objectName, item -> new HashMap(16));
                tempMap.put(propertyName, MapUtils.getString(ruleResult, (Object)"value"));
                continue;
            }
            Object convertValue = value = MapUtils.getObject(ruleResult, (Object)"value");
            if (type instanceof BasedataProp) {
                convertValue = this.parseDynamicObjectValue(dyObj, propertyName, (BasedataProp)type, value);
            } else if (type instanceof DateTimeProp) {
                convertValue = this.parseDateValue(propertyName, value);
            } else if (type instanceof BigIntProp) {
                convertValue = this.parseBigIntValue(value);
            } else if (type instanceof IntegerProp) {
                convertValue = this.parseIntegerValue(value);
            }
            if (convertValue == null) continue;
            dyObj.set(propertyName, convertValue);
        }
        return result;
    }

    private Object parseIntegerValue(Object value) {
        if (value == null || "null".equals(value)) {
            return null;
        }
        if (value instanceof String) {
            BigDecimal temp = new BigDecimal(String.valueOf(value));
            return temp.intValue();
        }
        return value;
    }

    private Object parseBigIntValue(Object value) {
        if (value == null || "null".equals(value)) {
            return null;
        }
        if (value instanceof String) {
            BigDecimal temp = new BigDecimal(String.valueOf(value));
            return temp.longValue();
        }
        return value;
    }

    private Date parseDateValue(String propertyName, Object value) {
        Date parseDate = null;
        try {
            if (value != null && !"null".equals(value)) {
                parseDate = SWCDateTimeUtils.parseDate((String)String.valueOf(value));
            } else {
                log.info("value is null propertyName: {}", (Object)propertyName);
            }
        }
        catch (ParseException e) {
            log.error("propertyName: {}, value:{}", (Object)propertyName, value);
            log.error((Throwable)e);
            this.errorMsgs.add(e.getMessage());
        }
        return parseDate;
    }

    private DynamicObject parseDynamicObjectValue(DynamicObject dyobj, String propertyName, BasedataProp type, Object value) {
        String baseEntityId = type.getBaseEntityId();
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(baseEntityId);
        String stringValue = String.valueOf(value);
        if (value == null || "null".equals(stringValue)) {
            dyobj.set(propertyName, null);
            return null;
        }
        if (SWCStringUtils.isNotEmpty((String)stringValue) && stringValue.contains(",")) {
            this.errorMsgs.add(ResManager.loadKDString((String)"\u5b9e\u4f53 \u201c{0}\u201d\uff0c{1}\u5b57\u6bb5\u89c4\u5219\u914d\u7f6e\u9519\u8bef\u3002", (String)"StandardCloudCollaTaskExecuteHelper_3", (String)"swc-hsbp-business", (Object[])new Object[]{dyobj.getDataEntityType().getDisplayName().getLocaleValue(), type.getDisplayName()}));
            return null;
        }
        if (0L == Long.parseLong(stringValue)) {
            return null;
        }
        DynamicObject dy = serviceHelper.queryOne(SWCHisBaseDataHelper.getSelectProperties(baseEntityId), stringValue);
        if (dy == null) {
            this.errorMsgs.add(ResManager.loadKDString((String)"\u5b9e\u4f53 \u201c{0}\u201d\uff0c\u534f\u4f5c\u89c4\u5219\u914d\u7f6e\u7684{1}\u4e0d\u5b58\u5728\u3002", (String)"StandardCloudCollaTaskExecuteHelper_4", (String)"swc-hsbp-business", (Object[])new Object[]{dyobj.getDataEntityType().getDisplayName().getLocaleValue(), type.getDisplayName()}));
            return null;
        }
        return dy;
    }
}

