/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.cloudcolla.verify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.cloudcolla.verify.handler.IVerifyBillDataHandler;
import kd.swc.hsbp.business.cloudcolla.verify.handler.factory.VerifyBillHandlerFactory;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.VerifyBillHandlerType;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class VerifyBillDataService {
    public static VerifyBillDataService getInstance() {
        return Load.INSTANCE;
    }

    private VerifyBillDataService() {
    }

    private Map<String, Map<String, String>> getVerifyBillRpcServiceData() {
        LinkedHashMap<String, Map<String, String>> verifyBillRpcServiceData = new LinkedHashMap<String, Map<String, String>>(16);
        SWCDataServiceHelper orm = new SWCDataServiceHelper("hpdi_verifybillconfig");
        DynamicObject[] configs = orm.queryOriginalArray("formid,cloudnumber,appnumber,verifyapp,servicename", new QFilter[]{new QFilter("group", "=", (Object)"SUMMARY_VERIFY_BILL")});
        if (configs == null || configs.length == 0) {
            return Collections.emptyMap();
        }
        for (DynamicObject config : configs) {
            String formId = config.getString("formid");
            String cloudNumber = config.getString("cloudnumber");
            String appNumber = config.getString("appnumber");
            String verifyApp = config.getString("verifyapp");
            String serviceName = config.getString("servicename");
            HashMap<String, String> appConfig = new HashMap<String, String>();
            appConfig.put("cloudNumber", cloudNumber);
            appConfig.put("appNumber", appNumber);
            appConfig.put("verifyApp", verifyApp);
            appConfig.put("serviceName", serviceName);
            appConfig.put("formId", formId);
            verifyBillRpcServiceData.put(formId, appConfig);
        }
        return verifyBillRpcServiceData;
    }

    private Map<String, Map<String, Object>> dispatchAction(IVerifyBillDataHandler handler, Map<String, Object> param) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(16);
        Set excludeFormIds = param.getOrDefault("excludeFormIds", Collections.emptySet());
        this.getVerifyBillRpcServiceData().entrySet().stream().forEach(item -> {
            String key = (String)item.getKey();
            Map data = (Map)item.getValue();
            String formId = (String)data.get("formId");
            if (excludeFormIds.contains(formId)) {
                return;
            }
            String cloudId = (String)data.get("cloudNumber");
            String appId = (String)data.get("appNumber");
            String verifyApp = (String)data.get("verifyApp");
            String serviceName = (String)data.get("serviceName");
            HashMap<String, Object> tempParam = new HashMap<String, Object>(16);
            tempParam.put("formId", formId);
            tempParam.put("verifyApp", verifyApp);
            tempParam.putAll(param);
            Map<String, Object> queryResult = this.accept(handler, verifyApp, formId, tempParam);
            result.put(key, queryResult);
        });
        return result;
    }

    public Map<String, Object> accept(IVerifyBillDataHandler handler, String verifyApp, String formId, Map<String, Object> data) {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("appNumber", verifyApp);
        param.put("formId", formId);
        param.put("data", data);
        return handler.accept(param);
    }

    public Map<String, Map<String, Object>> getAllRelVerifyBillByTaskId(Long relBillId) {
        ConcurrentHashMap<String, Map<String, Object>> result = new ConcurrentHashMap<String, Map<String, Object>>(this.getVerifyBillRpcServiceData().size());
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("relBillId", relBillId);
        Map<String, Map<String, Object>> dispatchAction = this.dispatchAction(VerifyBillHandlerFactory.create(VerifyBillHandlerType.QUERY_BY_TASK_ID), param);
        if (CollectionUtils.isEmpty(dispatchAction)) {
            return null;
        }
        dispatchAction.forEach((app, data) -> {
            if (!((Boolean)data.get("success")).booleanValue()) {
                return;
            }
            Map subData = (Map)data.get("data");
            result.put((String)app, subData);
        });
        return result;
    }

    public Map<String, Object> queryVerifyBillBySummaryId(Long summaryId) {
        if (summaryId == null || summaryId == 0L) {
            return VerifyBillDataService.success(null);
        }
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("summaryId", summaryId);
        Map<String, Map<String, Object>> dispatchResult = this.dispatchAction(VerifyBillHandlerFactory.create(VerifyBillHandlerType.QUERY_BY_SUMMARY_ID), param);
        ArrayList billList = new ArrayList(dispatchResult.size());
        dispatchResult.forEach((app, data) -> {
            if (CollectionUtils.isEmpty((Map)data)) {
                return;
            }
            if (!((Boolean)data.get("success")).booleanValue()) {
                return;
            }
            billList.add((DynamicObject)data.get("data"));
        });
        return VerifyBillDataService.success(billList);
    }

    private static Map<String, Object> success(Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", Boolean.TRUE);
        result.put("data", data);
        return result;
    }

    private static Map<String, Object> success() {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", Boolean.TRUE);
        return result;
    }

    private static Map<String, Object> error(String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", Boolean.FALSE);
        result.put("data", null);
        result.put("msg", msg);
        return result;
    }

    @Deprecated
    public Map<String, Object> invokeOperateBySummaryIdsD(String auditStatus, String formId, List<Long> ids) {
        if (SWCStringUtils.isEmpty((String)auditStatus) || SWCStringUtils.isEmpty((String)formId) || CollectionUtils.isEmpty(ids)) {
            return VerifyBillDataService.success(null);
        }
        SWCDataServiceHelper orm = new SWCDataServiceHelper(formId);
        DynamicObject[] bills = orm.query("id,billstatus,auditstatus,relbillid", new QFilter[]{new QFilter("relbillid", "in", ids)});
        if (bills == null || bills.length == 0) {
            return VerifyBillDataService.success();
        }
        for (DynamicObject bill : bills) {
            bill.set("billstatus", (Object)auditStatus);
            bill.set("auditstatus", (Object)auditStatus);
        }
        orm.save(bills);
        return VerifyBillDataService.success();
    }

    public Map<String, Object> invokeOperateBySummaryIds(DynamicObject[] dataList, String formId) {
        if (dataList == null || dataList.length == 0 || SWCStringUtils.isEmpty((String)formId)) {
            return VerifyBillDataService.success(null);
        }
        SWCDataServiceHelper orm = new SWCDataServiceHelper(formId);
        Map relBills = Arrays.stream(dataList).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
        DynamicObject[] bills = orm.query("id,billstatus,auditstatus,auditdate,relbillid", new QFilter[]{new QFilter("relbillid", "in", relBills.keySet())});
        if (bills == null || bills.length == 0) {
            return VerifyBillDataService.success();
        }
        for (DynamicObject bill : bills) {
            DynamicObject relBill = (DynamicObject)relBills.get(bill.getLong("relbillid"));
            if (relBill == null) continue;
            bill.set("billstatus", (Object)relBill.getString("billstatus"));
            bill.set("auditstatus", (Object)relBill.getString("auditstatus"));
            bill.set("auditdate", (Object)relBill.getDate("auditdate"));
        }
        orm.save(bills);
        return VerifyBillDataService.success();
    }

    public String formatFieldNumber(String fieldNumber, String objectNumber) {
        if (SWCStringUtils.isEmpty((String)objectNumber) || SWCStringUtils.isEmpty((String)fieldNumber)) {
            return fieldNumber;
        }
        String result = fieldNumber;
        if (fieldNumber.startsWith(objectNumber + "_")) {
            result = fieldNumber.substring(objectNumber.length() + 1);
        }
        return result;
    }

    static class Load {
        private static final VerifyBillDataService INSTANCE = new VerifyBillDataService();

        Load() {
        }
    }
}

