/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.cloudcolla.verify.dynamic;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.cloudcolla.verify.dynamic.BasedataPropHandler;
import kd.swc.hsbp.business.cloudcolla.verify.dynamic.BigIntPropHandler;
import kd.swc.hsbp.business.cloudcolla.verify.dynamic.BooleanPropHandler;
import kd.swc.hsbp.business.cloudcolla.verify.dynamic.ComboPropHandler;
import kd.swc.hsbp.business.cloudcolla.verify.dynamic.DatePropHandler;
import kd.swc.hsbp.business.cloudcolla.verify.dynamic.DateTimePropHandler;
import kd.swc.hsbp.business.cloudcolla.verify.dynamic.DecimalPropHandler;
import kd.swc.hsbp.business.cloudcolla.verify.dynamic.IDynamicPropHandler;
import kd.swc.hsbp.business.cloudcolla.verify.dynamic.IntegerPropHandler;
import kd.swc.hsbp.business.cloudcolla.verify.dynamic.MainOrgPropHandler;
import kd.swc.hsbp.business.cloudcolla.verify.dynamic.TextPropHandler;

public class DynamicPropCreatorFactory {
    private static final Log LOGGER = LogFactory.getLog(DynamicPropCreatorFactory.class);
    private static final Map<String, String> CREATOR_MAP;

    public static IDynamicPropHandler create(String type) {
        try {
            String clazzName = CREATOR_MAP.get(type);
            if (clazzName == null) {
                Object typeObject = Class.forName(type).newInstance();
                if (typeObject instanceof BasedataProp) {
                    clazzName = CREATOR_MAP.get(BasedataProp.class.getName());
                } else if (typeObject instanceof TextProp) {
                    clazzName = CREATOR_MAP.get(TextProp.class.getName());
                } else if (typeObject instanceof DateProp) {
                    clazzName = CREATOR_MAP.get(DateProp.class.getName());
                } else if (typeObject instanceof ComboProp) {
                    clazzName = CREATOR_MAP.get(ComboProp.class.getName());
                } else if (typeObject instanceof BooleanProp) {
                    clazzName = CREATOR_MAP.get(BooleanProp.class.getName());
                } else if (typeObject instanceof BigIntProp) {
                    clazzName = CREATOR_MAP.get(BigIntProp.class.getName());
                } else if (typeObject instanceof IntegerProp) {
                    clazzName = CREATOR_MAP.get(IntegerProp.class.getName());
                } else if (typeObject instanceof DecimalProp) {
                    clazzName = CREATOR_MAP.get(DecimalProp.class.getName());
                } else if (typeObject instanceof DateTimeProp) {
                    clazzName = CREATOR_MAP.get(DateTimeProp.class.getName());
                } else {
                    throw new KDBizException(type + " not supported yet");
                }
            }
            Class<?> clazz = Class.forName(clazzName);
            return (IDynamicPropHandler)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            LOGGER.info("[colla] DynamicPropCreatorFactory.create error", (Object)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
    }

    static {
        HashMap<String, String> creatorMap = new HashMap<String, String>(30);
        creatorMap.put("java.lang.Boolean", BooleanPropHandler.class.getName());
        creatorMap.put("java.lang.String", TextPropHandler.class.getName());
        creatorMap.put("java.lang.Long", BigIntPropHandler.class.getName());
        creatorMap.put("java.lang.Integer", IntegerPropHandler.class.getName());
        creatorMap.put("java.util.Date", DatePropHandler.class.getName());
        creatorMap.put("java.math.BigDecimal", DecimalPropHandler.class.getName());
        creatorMap.put("kd.bos.dataentity.entity.DynamicObject", BasedataPropHandler.class.getName());
        creatorMap.put("kd.bos.entity.property.TextProp", TextPropHandler.class.getName());
        creatorMap.put("kd.bos.entity.property.DateProp", DatePropHandler.class.getName());
        creatorMap.put("kd.bos.entity.property.DateTimeProp", DateTimePropHandler.class.getName());
        creatorMap.put("kd.bos.entity.property.ComboProp", ComboPropHandler.class.getName());
        creatorMap.put("kd.bos.entity.property.BooleanProp", BooleanPropHandler.class.getName());
        creatorMap.put("kd.bos.entity.property.BasedataProp", BasedataPropHandler.class.getName());
        creatorMap.put("kd.bos.entity.property.IntegerProp", IntegerPropHandler.class.getName());
        creatorMap.put("kd.bos.entity.property.BigIntProp", BigIntPropHandler.class.getName());
        creatorMap.put("kd.bos.entity.property.DecimalProp", DecimalPropHandler.class.getName());
        creatorMap.put("kd.bos.entity.property.MainOrgProp", MainOrgPropHandler.class.getName());
        CREATOR_MAP = Collections.unmodifiableMap(creatorMap);
    }
}

