/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.cloudcolla.verify.handler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.swc.hsbp.business.cloudcolla.verify.handler.IVerifyBillDataHandler;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class SubVerifyBillConvertHandler
implements IVerifyBillDataHandler,
Serializable {
    private static final long serialVersionUID = -8668155937385710885L;

    @Override
    public Map<String, Object> accept(Map<String, Object> param) {
        String appNumber = this.getAppNumber(param);
        String formId = this.getFormId(param);
        Map<String, Object> data = this.getData(param);
        return this.saveVerifyBill(appNumber, formId, data);
    }

    private Map<String, Object> saveVerifyBill(String appNumber, String formId, Map<String, Object> data) {
        DynamicObject[] summaryVerifyBill = (DynamicObject[])data.get("summaryVerifyBill");
        SWCDataServiceHelper formHelper = new SWCDataServiceHelper(formId);
        ArrayList<DynamicObject> saveDataObject = new ArrayList<DynamicObject>(summaryVerifyBill.length);
        Set billIds = Arrays.stream(summaryVerifyBill).map(item -> item.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] relbillids = formHelper.query(SWCHisBaseDataHelper.getSelectProperties(formId), new QFilter[]{new QFilter("relbillid", "in", billIds)});
        Map<Object, Object> idRels = new HashMap(16);
        if (relbillids != null && relbillids.length > 0) {
            idRels = Arrays.stream(relbillids).collect(Collectors.toMap(item -> item.getLong("relbillid"), Function.identity(), (first, second) -> first));
        }
        Map billFieldValues = (Map)data.get("billFieldValues");
        for (DynamicObject entity : summaryVerifyBill) {
            Map finalData;
            long billId = entity.getLong("id");
            DynamicObject targetObject = this.generateDynamicObject(formHelper, (DynamicObject)idRels.get(billId), entity);
            targetObject.set("relbillid", (Object)billId);
            targetObject.set("auditstatus", (Object)entity.getString("auditstatus"));
            targetObject.set("billstatus", (Object)entity.getString("billstatus"));
            targetObject.set("auditdate", (Object)entity.getDate("auditdate"));
            targetObject.set("createtime", (Object)entity.getDate("createtime"));
            targetObject.set("modifytime", (Object)entity.getDate("modifytime"));
            targetObject.set("changetime", (Object)entity.getDate("changetime"));
            targetObject.set("creator", entity.get("creator"));
            targetObject.set("auditor", entity.get("auditor"));
            DynamicObjectCollection entryEntity = formHelper.generateEmptyEntryCollection(targetObject, "entryentity");
            if (CollectionUtils.isEmpty((Map)billFieldValues) || CollectionUtils.isEmpty((Map)(finalData = (Map)billFieldValues.get(billId)))) continue;
            finalData.forEach((triggerId, collaValue) -> {
                DynamicObject dynamicObject;
                String dataAppNumber = (String)collaValue.get("appNumber");
                if (!appNumber.equalsIgnoreCase(dataAppNumber)) {
                    return;
                }
                DynamicObject rowEntry = formHelper.generateEmptyEntryDynamicObject(targetObject, "entryentity");
                entryEntity.add((Object)rowEntry);
                rowEntry.set("bizapp", (Object)new SWCDataServiceHelper("hbp_devportal_bizapp").queryOne(new QFilter[]{new QFilter("number", "=", (Object)appNumber)}));
                rowEntry.set("cardtype", collaValue.get("cardType"));
                rowEntry.set("bizobject", collaValue.get("objectNumber"));
                rowEntry.set("bizobject", (Object)new SWCDataServiceHelper("bos_entityobject").queryOne(new QFilter[]{new QFilter("number", "=", collaValue.get("objectNumber"))}));
                rowEntry.set("triggercolla", (Object)new SWCDataServiceHelper("hsbs_triggercolla").generateDynamicObject(triggerId, "id,name,number"));
                DynamicObjectCollection subEntryEntity = formHelper.generateEmptySubEntryCollection(targetObject, rowEntry, "subentryentity");
                List objectValues = (List)collaValue.get("objectValues");
                List exeParams = (List)collaValue.get("exeParams");
                if (!CollectionUtils.isEmpty((Collection)objectValues)) {
                    for (Map objectValue : objectValues) {
                        dynamicObject = formHelper.generateEmptyEntryDynamicObject(targetObject, "subentryentity");
                        subEntryEntity.add((Object)dynamicObject);
                        dynamicObject.set("fieldnumber", objectValue.get("fieldNumber"));
                        dynamicObject.set("fieldvalue", this.getFieldValue(objectValue.get("fieldValue")));
                        dynamicObject.set("groupindex", (Object)0);
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)exeParams)) {
                    for (Map objectValue : exeParams) {
                        dynamicObject = formHelper.generateEmptyEntryDynamicObject(targetObject, "subentryentity");
                        subEntryEntity.add((Object)dynamicObject);
                        dynamicObject.set("fieldnumber", objectValue.get("fieldNumber"));
                        dynamicObject.set("fieldValue", this.getFieldValue(objectValue.get("fieldValue")));
                        dynamicObject.set("groupindex", (Object)0);
                    }
                }
            });
            targetObject.set("entryentity", (Object)entryEntity);
            saveDataObject.add(targetObject);
        }
        return this.success(saveDataObject);
    }

    public DynamicObject generateDynamicObject(SWCDataServiceHelper formHelper, DynamicObject existObject, DynamicObject entity) {
        if (existObject != null) {
            return existObject;
        }
        DynamicObject dynamicObject = formHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)entity, (DynamicObject)dynamicObject);
        return dynamicObject;
    }

    private Object getFieldValue(Object fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof DynamicObject) {
            return ((DynamicObject)fieldValue).getPkValue();
        }
        if (fieldValue instanceof Date) {
            return SWCDateTimeUtils.format((Date)((Date)fieldValue));
        }
        return fieldValue;
    }
}

