/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.cloudcolla.verify.handler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.cloudcolla.verify.handler.IVerifyBillDataHandler;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class WriteBackTaskIdHandler
implements IVerifyBillDataHandler,
Serializable {
    private static final long serialVersionUID = 4222300055341912308L;

    @Override
    public Map<String, Object> accept(Map<String, Object> param) {
        String formId = (String)param.get("formId");
        Map data = (Map)param.get("data");
        String appNumber = this.getAppNumber(param);
        return this.writeBackTaskId(formId, appNumber, data);
    }

    private Map<String, Object> writeBackTaskId(String formId, String appNumber, Map<String, Object> data) {
        if (SWCStringUtils.isEmpty((String)formId) || CollectionUtils.isEmpty(data)) {
            return this.error(null);
        }
        Map idMap = MapUtils.getMap(data, (Object)"idMap", Collections.emptyMap());
        HashSet sumBillIds = new HashSet(idMap.keySet());
        if (CollectionUtils.isEmpty(sumBillIds)) {
            return this.success(null);
        }
        SWCDataServiceHelper orm = new SWCDataServiceHelper(formId);
        String fieldKey = "hpdi_summaryvbill".equalsIgnoreCase(formId) ? "id" : "relbillid";
        DynamicObject[] query = orm.query("id,relbillid,taskcenter,taskcentern,collatask,collataskclass", new QFilter[]{new QFilter(fieldKey, "in", sumBillIds)});
        if (query == null || query.length == 0) {
            return this.success(null);
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(query.length * 2);
        for (DynamicObject tmp : query) {
            long sumBillId = tmp.getLong(fieldKey);
            List tempList = (List)MapUtils.getObject((Map)idMap, (Object)sumBillId, Collections.emptyList());
            if (CollectionUtils.isEmpty((Collection)tempList)) continue;
            for (Map temp : tempList) {
                Set collaAppSet = (Set)MapUtils.getObject((Map)temp, (Object)"collaAppSet", Collections.emptySet());
                if (!collaAppSet.contains(appNumber)) continue;
                Long collaTaskId = MapUtils.getLongValue((Map)temp, (Object)"collaTaskId", (long)0L);
                String collaTaskClass = MapUtils.getString((Map)temp, (Object)"collaTaskClass");
                if (collaTaskId == 0L || SWCStringUtils.isEmpty((String)collaTaskClass)) continue;
                tmp.set("collataskclass", (Object)collaTaskClass);
                tmp.set("collatask", (Object)collaTaskId);
                if ("hpdi_taskcenter".equalsIgnoreCase(collaTaskClass)) {
                    tmp.set("taskcenter", (Object)collaTaskId);
                } else {
                    tmp.set("taskcentern", (Object)collaTaskId);
                }
                saveList.add(tmp);
            }
        }
        orm.save(saveList.toArray(new DynamicObject[0]));
        return this.success(null);
    }
}

