/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.cloudcolla.verify.handler.factory;

import kd.bos.exception.KDBizException;
import kd.swc.hsbp.business.cloudcolla.verify.handler.DeleteTaskIdHandler;
import kd.swc.hsbp.business.cloudcolla.verify.handler.IVerifyBillDataHandler;
import kd.swc.hsbp.business.cloudcolla.verify.handler.QueryVerifyBillBySummaryIdHandler;
import kd.swc.hsbp.business.cloudcolla.verify.handler.QueryVerifyBillByTaskIdHandler;
import kd.swc.hsbp.business.cloudcolla.verify.handler.SubVerifyBillAuditHandler;
import kd.swc.hsbp.business.cloudcolla.verify.handler.SubVerifyBillChangeStatusHandler;
import kd.swc.hsbp.business.cloudcolla.verify.handler.SubVerifyBillConvertHandler;
import kd.swc.hsbp.business.cloudcolla.verify.handler.SubVerifyBillDeleteHandler;
import kd.swc.hsbp.business.cloudcolla.verify.handler.SubVerifyBillDiscardHandler;
import kd.swc.hsbp.business.cloudcolla.verify.handler.SubVerifyBillSaveHandler;
import kd.swc.hsbp.business.cloudcolla.verify.handler.SubVerifyBillSubmitHandler;
import kd.swc.hsbp.business.cloudcolla.verify.handler.SubVerifyBillUnauditHandler;
import kd.swc.hsbp.business.cloudcolla.verify.handler.WriteBackTaskIdHandler;
import kd.swc.hsbp.common.enums.VerifyBillHandlerType;

public class VerifyBillHandlerFactory {
    public static IVerifyBillDataHandler create(VerifyBillHandlerType type) {
        switch (type) {
            case SAVE: {
                return new SubVerifyBillSaveHandler();
            }
            case DELETE: {
                return new SubVerifyBillDeleteHandler();
            }
            case AUDIT: {
                return new SubVerifyBillAuditHandler();
            }
            case QUERY_BY_TASK_ID: {
                return new QueryVerifyBillByTaskIdHandler();
            }
            case QUERY_BY_SUMMARY_ID: {
                return new QueryVerifyBillBySummaryIdHandler();
            }
            case WRITE_BACK_TASK_ID: {
                return new WriteBackTaskIdHandler();
            }
            case SUBMIT: {
                return new SubVerifyBillSubmitHandler();
            }
            case UNAUDIT: {
                return new SubVerifyBillUnauditHandler();
            }
            case DISCARD: {
                return new SubVerifyBillDiscardHandler();
            }
            case BATCH_CLEAR_TASK_ID: {
                return new DeleteTaskIdHandler();
            }
            case RULE_ENGINE_CONVERT: {
                return new SubVerifyBillConvertHandler();
            }
            case CHANGE_STATUS: {
                return new SubVerifyBillChangeStatusHandler();
            }
        }
        throw new KDBizException(type + " not support yet.");
    }
}

