/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.encrypt.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CompressUtils {
    private static final Log log = LogFactory.getLog(CompressUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compress(String compressData) {
        if (SWCStringUtils.isEmpty((String)compressData)) {
            return compressData;
        }
        ByteArrayOutputStream outputStream = null;
        GZIPOutputStream gzipOut = null;
        try {
            outputStream = new ByteArrayOutputStream();
            gzipOut = new GZIPOutputStream(outputStream);
            gzipOut.write(compressData.getBytes(StandardCharsets.UTF_8));
            gzipOut.close();
            String string = SerializationUtils.serializeToBase64((Object)outputStream.toByteArray());
            return string;
        }
        catch (IOException ex) {
            log.info("compress error : {}", (Object)ex.getMessage());
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (gzipOut != null) {
                    gzipOut.close();
                }
            }
            catch (IOException ex) {
                log.info("compress close error : {}", (Object)ex.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uncompress(String unCompressData) {
        if (SWCStringUtils.isEmpty((String)unCompressData)) {
            return unCompressData;
        }
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream ungZip = null;
        try {
            int number;
            out = new ByteArrayOutputStream();
            in = new ByteArrayInputStream((byte[])SerializationUtils.deSerializeFromBase64((String)unCompressData));
            ungZip = new GZIPInputStream(in);
            byte[] buffer = new byte[1024];
            while ((number = ungZip.read(buffer)) >= 0) {
                out.write(buffer, 0, number);
            }
            String string = out.toString(StandardCharsets.UTF_8.name());
            return string;
        }
        catch (IOException ex) {
            log.info("uncompress error : {}", (Object)ex.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (ungZip != null) {
                    ungZip.close();
                }
            }
            catch (IOException ex) {
                log.info("uncompress close error : {}", (Object)ex.getMessage());
            }
        }
        return null;
    }
}

