/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.encrypt.util;

import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;

public class SecretTableUtil {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final int BIG_ROW = 50;
    private static final int BIG_COLUMN = 200;
    private static final String UTF_8 = "utf-8";
    private static final int NUM_0 = 0;
    private static final int NUM_3 = 3;
    private static final int NUM_10 = 10;
    private static final int NUM_26 = 26;
    private static final int NUM_48 = 48;
    private static final int NUM_65 = 65;
    private static final int NUM_97 = 97;

    public static String getEncryptKey(String secretKey) {
        String bigArrayString = "";
        try {
            int[][] bigIntArray = new int[50][200];
            int[][] indexArray = SecretTableUtil.storeSecretToBigArray(bigIntArray, secretKey);
            SecretTableUtil.interfereBigArray(bigIntArray);
            SecretTableUtil.storeIndexToBigArray(bigIntArray, indexArray);
            bigArrayString = SecretTableUtil.getBigIndexArrayString(bigIntArray);
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
        return bigArrayString;
    }

    public static String getDecryptKey(String encryptType, String bigArrayString) {
        int[][] bigArray = SecretTableUtil.bigIntArrayByBigString(bigArrayString);
        String result = "";
        int indexLen = 64;
        int[] bigArray0 = bigArray[0];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indexLen; i += 2) {
            int row = bigArray0[i];
            int column = bigArray0[i + 1];
            char bc = (char)bigArray[row][column];
            sb.append(bc);
        }
        result = sb.toString();
        return result;
    }

    private static int[][] bigIntArrayByBigString(String bigString) {
        int[][] bigArray = new int[50][200];
        int size = 0;
        int columnSize = bigArray[0].length;
        for (int i = 0; i < bigArray.length; ++i) {
            for (int j = 0; j < columnSize; ++j) {
                char bc = bigString.charAt(size);
                bigArray[i][j] = bc;
                ++size;
            }
        }
        return bigArray;
    }

    private static String getBigIndexArrayString(int[][] bigIndexArray) {
        StringBuilder sb = new StringBuilder();
        int columnSize = bigIndexArray[0].length;
        for (int i = 0; i < bigIndexArray.length; ++i) {
            for (int j = 0; j < columnSize; ++j) {
                char bc = (char)bigIndexArray[i][j];
                sb.append(bc);
            }
        }
        return sb.toString();
    }

    private static int[][] storeSecretToBigArray(int[][] bigIntArray, String secret) throws UnsupportedEncodingException {
        byte[] secretBytes = secret.getBytes(UTF_8);
        int bigRow = bigIntArray.length;
        int bigColumn = bigIntArray[0].length;
        int secretSize = secretBytes.length;
        int[][] indexArray = new int[secretSize][2];
        for (int i = 0; i < secretSize; ++i) {
            int column;
            int row;
            int bc = secretBytes[i];
            while (bigIntArray[row = RANDOM.nextInt(bigRow - 2) + 1][column = RANDOM.nextInt(bigColumn - 1) + 1] != 0) {
            }
            bigIntArray[row][column] = bc;
            indexArray[i][0] = row;
            indexArray[i][1] = column;
        }
        return indexArray;
    }

    private static void storeIndexToBigArray(int[][] bigIntArray, int[][] indexArray) {
        int row0size = 0;
        int columnSize = indexArray[0].length;
        int[] bigIntArray0 = bigIntArray[0];
        for (int i = 0; i < indexArray.length; ++i) {
            for (int j = 0; j < columnSize; ++j) {
                bigIntArray0[row0size] = indexArray[i][j];
                ++row0size;
            }
        }
    }

    private static void interfereBigArray(int[][] bigArray) {
        int columnSize = bigArray[0].length;
        for (int i = 0; i < bigArray.length; ++i) {
            for (int j = 0; j < columnSize; ++j) {
                if (bigArray[i][j] != 0) continue;
                bigArray[i][j] = SecretTableUtil.getInterfere();
            }
        }
    }

    private static int getInterfere() {
        int nextInt = RANDOM.nextInt(3);
        switch (nextInt) {
            case 1: {
                return SecretTableUtil.getUpperInterfere();
            }
        }
        return SecretTableUtil.getLowwerInterfere();
    }

    private static int getNumberInterfere() {
        return RANDOM.nextInt(10) + 48;
    }

    private static int getUpperInterfere() {
        return RANDOM.nextInt(26) + 65;
    }

    private static int getLowwerInterfere() {
        return RANDOM.nextInt(26) + 97;
    }
}

