/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.exchangerate.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;

public class ExchangeRateHelper {
    public static ExchangeRateInfo getExchangeRateInfo(Long originalCurrencyId, Long targetCurrencyId, Long exchangeRateTypeId, Date conversionDate) {
        if (originalCurrencyId == null || originalCurrencyId == 0L || targetCurrencyId == null || targetCurrencyId == 0L || exchangeRateTypeId == null || exchangeRateTypeId == 0L || conversionDate == null) {
            return null;
        }
        if (originalCurrencyId.equals(targetCurrencyId)) {
            return null;
        }
        Map exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)originalCurrencyId, (Long)targetCurrencyId, (Long)exchangeRateTypeId, (Date)conversionDate);
        if (exchangeRateByRules == null) {
            return null;
        }
        Boolean quoteType = (Boolean)exchangeRateByRules.get("quoteType");
        BigDecimal exchangeRate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
        if (exchangeRate == null || quoteType == null) {
            return null;
        }
        return new ExchangeRateInfo(quoteType, exchangeRate);
    }
}

