/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.export;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.swc.hsbp.business.export.ListExporter;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.common.entity.EntryColumnContainer;
import kd.swc.hsbp.common.util.ReflectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ListTemplateExporter
extends ListExporter {
    private static final int templateFixedRowNum = 3;
    private static final String[] dataColArr = new String[]{"A", "B", "C", "D", "E", "F", "G", "H"};
    protected int templateHeadHeight = 4;

    public SXSSFWorkbook getWb() {
        return this.wb;
    }

    public ListTemplateExporter(List<EntryColumnContainer> container, EntityType entryType, ImportConfig importConfig) {
        this.sheet = this.wb.createSheet(entryType.getDisplayName().getLocaleValue());
        this.styles = new ExportSheetStyle(this.wb);
        this.entryType = entryType;
        this.importConfig = importConfig;
        Map<String, KeyValue> captions = SWCExportEntryHelper.getEntryFieldCaptions(container);
        this.fieldCaptions = new ArrayList<KeyValue>(captions.values());
        int headHeight = SWCExportEntryHelper.calcSheetHeadHeight(container);
        String[][] headArray = new String[headHeight + 3][captions.size()];
        this.templateHeadHeight = headArray.length;
        SWCExportEntryHelper.fillTemplateFixedInfo(headArray, importConfig.getTemplateCaption(), importConfig.getTemplateWarningInfo(), this.fieldCaptions);
        SWCExportEntryHelper.fillSheetHeadArray(container, headArray, 3, 0);
        SWCExportEntryHelper.setTemplateFixedInfoCell(this.sheet, headArray, this.styles, this.wb);
        SWCExportEntryHelper.setAndMergeHeadCell(this.sheet, headArray, this.styles, 3, container);
        int[] colLenArray = this.getMaxColWidth(headArray, 3);
        this.setColumnWidth(colLenArray, container);
        this.setBorderStyle(this.styles.getTitleStyle());
        SXSSFRow lastFieldRow = this.sheet.getRow(headArray.length - 1);
        List<EntryColumnContainer> fieldContainer = this.getFieldContainer(container);
        XSSFCellStyle colStyle = this.wb.getXSSFWorkbook().createCellStyle();
        DataFormat dataFormat = this.wb.createDataFormat();
        colStyle.setDataFormat(dataFormat.getFormat("@"));
        SXSSFDrawing drawingPatriarch = this.sheet.createDrawingPatriarch();
        HashSet<String> keySet = new HashSet<String>(16);
        Set<String> mustInputFields = importConfig.getMustInputFields();
        Set<String> notMustInputFields = importConfig.getNotMustInputFields();
        for (int i = 0; i < this.fieldCaptions.size(); ++i) {
            String annotationStr;
            Map<String, String> fieldAnnotation;
            KeyValue keyValue = (KeyValue)this.fieldCaptions.get(i);
            DynamicProperty property = entryType.getProperty(keyValue.key);
            keySet.add(keyValue.key);
            String keyOrg = keyValue.key.replace("_name", "");
            if (property == null && keyValue.key.endsWith("_name") && !keySet.contains(keyOrg)) {
                property = entryType.getProperty(keyOrg);
            }
            Object value = ReflectUtils.getFieldValue((String)"mustInput", (Object)property);
            boolean isMustInput = false;
            if (value != null) {
                isMustInput = (Boolean)value;
            }
            if (mustInputFields != null && mustInputFields.contains(keyValue.key)) {
                isMustInput = true;
            }
            if (notMustInputFields != null && notMustInputFields.contains(keyValue.key)) {
                isMustInput = false;
            }
            SXSSFCell cell = lastFieldRow.getCell(i);
            XSSFCellStyle borderStyle = SWCExportEntryHelper.createBorderStyle(this.wb.getXSSFWorkbook());
            this.setCellOtherStyle(borderStyle, i, fieldContainer);
            cell.setCellStyle((CellStyle)borderStyle);
            if (isMustInput) {
                String original = cell.getStringCellValue();
                cell.setCellValue("*" + original);
                borderStyle.setFont(this.styles.getRedFont());
            }
            if ((fieldAnnotation = importConfig.getFieldAnnotation()) != null && StringUtils.isNotEmpty((CharSequence)(annotationStr = fieldAnnotation.get(keyValue.key)))) {
                Comment comment = drawingPatriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + 1, cell.getRowIndex() + 2, cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + 1, cell.getRowIndex() + 2));
                comment.setString((RichTextString)new XSSFRichTextString(annotationStr));
                comment.setAuthor("kindee");
                cell.setCellComment(comment);
            }
            if (!HorizontalAlignment.LEFT.equals((Object)borderStyle.getAlignment()) || property instanceof DateProp) continue;
            this.sheet.setDefaultColumnStyle(i, (CellStyle)colStyle);
        }
        this.setConstraintInfo(this.templateHeadHeight);
    }

    private List<EntryColumnContainer> getFieldContainer(List<EntryColumnContainer> container) {
        return SWCExportEntryHelper.getFieldContainer(container);
    }

    private void setCellOtherStyle(XSSFCellStyle borderStyle, int index, List<EntryColumnContainer> containers) {
        int isHasRk = 0;
        if (containers != null && containers.size() >= 1 && "rk".equals(containers.get(0).getKey())) {
            isHasRk = 1;
        }
        if (containers == null || containers.size() <= index + isHasRk) {
            return;
        }
        EntryColumnContainer entryColumn = containers.get(index + isHasRk);
        String textAlign = entryColumn.getTextAlign();
        HorizontalAlignment alignment = HorizontalAlignment.CENTER;
        if ("left".equals(textAlign)) {
            alignment = HorizontalAlignment.LEFT;
            borderStyle.setAlignment(alignment);
        } else if ("right".equals(textAlign)) {
            alignment = HorizontalAlignment.RIGHT;
        }
        borderStyle.setAlignment(alignment);
    }

    private void setConstraintInfo(int startRow) {
        int lastRow = startRow + this.importConfig.getRowCount();
        if (this.importConfig.getRowCount() == 0) {
            lastRow = startRow + 1000;
        }
        String errorBoxMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0b\u62c9\u6846\u4e2d\u7684\u6570\u636e\u3002", (String)"ListTemplateExporter_0", (String)"swc-hsbp-business", (Object[])new Object[0]);
        String promptBoxTip = ResManager.loadKDString((String)"\u63d0\u793a", (String)"ListTemplateExporter_1", (String)"swc-hsbp-business", (Object[])new Object[0]);
        String promptBoxMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0b\u62c9\u6846\u4e2d\u7684\u6570\u636e\u3002", (String)"ListTemplateExporter_2", (String)"swc-hsbp-business", (Object[])new Object[0]);
        for (int i = 0; i < this.fieldCaptions.size(); ++i) {
            KeyValue keyValue = (KeyValue)this.fieldCaptions.get(i);
            DynamicProperty property = this.entryType.getProperty(keyValue.key);
            if (!(property instanceof ComboProp)) continue;
            List comboItems = ((ComboProp)property).getComboItems();
            String[] textlist = (String[])comboItems.stream().filter(ValueMapItem::isItemVisible).map(item -> item.getName().getLocaleValue()).toArray(String[]::new);
            XSSFDataValidationConstraint constraint = new XSSFDataValidationConstraint(textlist);
            CellRangeAddressList regions = new CellRangeAddressList(startRow, lastRow - 1, i, i);
            XSSFDataValidationHelper help = new XSSFDataValidationHelper(this.wb.getXSSFWorkbook().getSheet(this.sheet.getSheetName()));
            DataValidation validation = help.createValidation((DataValidationConstraint)constraint, regions);
            validation.setShowPromptBox(true);
            validation.setShowErrorBox(true);
            validation.createErrorBox("Error", errorBoxMsg);
            validation.createPromptBox(promptBoxTip, promptBoxMsg);
            this.sheet.addValidationData(validation);
        }
    }

    public void addConstraintSheet(String sheetName, Map<String, String[]> constraintMap) {
        SXSSFSheet sheetNew = this.wb.createSheet(sheetName);
        this.wb.setSheetHidden(1, true);
        CellStyle cellStyle = this.wb.createCellStyle();
        this.setBorderStyle(cellStyle);
        String align = "default";
        SXSSFRow keyRow = sheetNew.createRow(0);
        int colIndex = 0;
        for (Map.Entry<String, String[]> entry : constraintMap.entrySet()) {
            String[] dataArr = entry.getValue();
            if (dataArr == null || dataArr.length == 0) continue;
            sheetNew.setColumnWidth(colIndex, 5120);
            SXSSFCell fieldKeyCell = keyRow.createCell(colIndex);
            fieldKeyCell.setCellStyle(cellStyle);
            fieldKeyCell.setCellValue(entry.getKey());
            for (int j = 0; j < dataArr.length; ++j) {
                String value = dataArr[j];
                ListTemplateExporter.createCell((SXSSFWorkbook)this.wb, (SXSSFRow)ListTemplateExporter.getRow((SXSSFSheet)sheetNew, (int)(j + 1)), (int)colIndex, (CellStyle)this.styles.getTextStyle(align)).setCellValue(value == null ? "" : value);
            }
            ++colIndex;
        }
    }

    public void addConstraintInfo(Map<String, String[]> constraintMap) {
        this.addConstraintSheet("dropdown_items_sheet", constraintMap);
        this.addConstraintInfo("dropdown_items_sheet", constraintMap);
    }

    public void addConstraintInfo(String sheetName, Map<String, String[]> constraintMap) {
        int lastRow = this.templateHeadHeight + this.importConfig.getRowCount();
        if (this.importConfig.getRowCount() == 0) {
            lastRow = this.templateHeadHeight + 1000;
        }
        String errorBoxMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0b\u62c9\u6846\u4e2d\u7684\u6570\u636e\u3002", (String)"ListTemplateExporter_0", (String)"swc-hsbp-business", (Object[])new Object[0]);
        String promptBoxTip = ResManager.loadKDString((String)"\u63d0\u793a", (String)"ListTemplateExporter_1", (String)"swc-hsbp-business", (Object[])new Object[0]);
        String promptBoxMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0b\u62c9\u6846\u4e2d\u7684\u6570\u636e\u3002", (String)"ListTemplateExporter_2", (String)"swc-hsbp-business", (Object[])new Object[0]);
        int dataColIndex = 0;
        for (int i = 0; i < this.fieldCaptions.size(); ++i) {
            String[] textlist;
            KeyValue keyValue = (KeyValue)this.fieldCaptions.get(i);
            DynamicProperty property = this.entryType.getProperty(keyValue.key);
            if (property == null) {
                property = this.entryType.getProperty(keyValue.key.replace("_name", ""));
            }
            if (property == null || (textlist = constraintMap.get(property.getName())) == null || textlist.length < 1) continue;
            String strFormula = sheetName + "!$" + dataColArr[dataColIndex] + "$2:$" + dataColArr[dataColIndex++] + "$501";
            XSSFDataValidationConstraint constraint = new XSSFDataValidationConstraint(3, strFormula);
            CellRangeAddressList regions = new CellRangeAddressList(this.templateHeadHeight, lastRow - 1, i, i);
            XSSFDataValidationHelper help = new XSSFDataValidationHelper(this.wb.getXSSFWorkbook().getSheet(this.sheet.getSheetName()));
            DataValidation validation = help.createValidation((DataValidationConstraint)constraint, regions);
            validation.setShowPromptBox(true);
            validation.setShowErrorBox(true);
            validation.createErrorBox("Error", errorBoxMsg);
            validation.createPromptBox(promptBoxTip, promptBoxMsg);
            this.sheet.addValidationData(validation);
        }
    }
}

