/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.export;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.Features;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;
import kd.swc.hsbp.common.entity.EntryColumnContainer;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SWCExportEntryHelper {
    private static final Log logger = LogFactory.getLog(SWCExportEntryHelper.class);

    public static EntryColumnWrapper readEntryColumnInfo(IFormView entryView, String entryKey) {
        return SWCExportEntryHelper.convertToEntryColumnInfo(SWCExportEntryHelper.readRuntimeEntryColumn(entryView, entryKey));
    }

    public static List<Map<String, Object>> readRuntimeEntryColumn(IFormView entryView, String entryKey) {
        Map<String, Object> map = SWCExportEntryHelper.invokeLoadCustomControlMetas(entryView);
        return SWCExportEntryHelper.getEntryColumnsFromMeta((Map)map.get("metas"), entryKey);
    }

    public static List<EntryColumnContainer> getEntryColumnContainers(List<Map<String, Object>> columns, Set<String> ignoreSet) {
        EntryColumnWrapper wrapper = SWCExportEntryHelper.convertToEntryColumnInfo(columns);
        List containers = wrapper.getContainers();
        SWCExportEntryHelper.removeIgnoreColumn(containers, ignoreSet);
        return containers;
    }

    public static void removeIgnoreColumn(List<EntryColumnContainer> containers, Set<String> ignoreColumns) {
        if (CollectionUtils.isEmpty(ignoreColumns) || CollectionUtils.isEmpty(containers)) {
            return;
        }
        Iterator<EntryColumnContainer> iterator = containers.iterator();
        while (iterator.hasNext()) {
            EntryColumnContainer next = iterator.next();
            if (ignoreColumns.contains(next.getKey())) {
                iterator.remove();
                continue;
            }
            SWCExportEntryHelper.removeIgnoreColumn(next.getChild(), ignoreColumns);
            if (EntryColumnContainer.EntryColumnTypeEnum.ENTRY_GROUP.getCode() != next.getType() || !CollectionUtils.isEmpty((Collection)next.getChild())) continue;
            iterator.remove();
        }
    }

    public static Map<String, Object> invokeLoadCustomControlMetas(IFormView entryView) {
        FormShowParameter parameter = entryView.getFormShowParameter();
        List plugins = parameter.createPlugin();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Method customControlMetas = FormShowParameter.class.getDeclaredMethod("loadCustomControlMetas", List.class, Map.class);
            ReflectionUtils.makeAccessible((Method)customControlMetas);
            customControlMetas.invoke((Object)parameter, plugins, map);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public static Map<String, Object> getEntryMeta(Map<String, Object> metas, String entryKey) {
        String id = (String)metas.get("id");
        if (SWCStringUtils.equals((String)entryKey, (String)id)) {
            return metas;
        }
        List items = (List)metas.get("items");
        if (!CollectionUtils.isEmpty((Collection)items)) {
            for (Map item : items) {
                Map<String, Object> res = SWCExportEntryHelper.getEntryMeta(item, entryKey);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    public static List<Map<String, Object>> getEntryColumnsFromMeta(Map<String, Object> metas, String entryKey) {
        Object obj;
        Map<String, Object> entryMeta = SWCExportEntryHelper.getEntryMeta(metas, entryKey);
        if (null != entryMeta && entryMeta.size() > 0 && !SWCObjectUtils.isEmpty((Object)(obj = entryMeta.get("columns")))) {
            return (List)obj;
        }
        return null;
    }

    public static Set<String> getIgnoreColumn(List<Map<String, Object>> columns) {
        HashSet ignoreSet = Sets.newHashSet();
        SWCExportEntryHelper.getIgnoreColumn(columns, ignoreSet);
        return ignoreSet;
    }

    private static void getIgnoreColumn(List<Map<String, Object>> columns, Set<String> ignoreColSet) {
        for (Map<String, Object> col : columns) {
            String backColor = (String)col.get("bc");
            String dataIndex = (String)col.get("dataIndex");
            List children = (List)col.get("children");
            if (null != backColor && !backColor.isEmpty() || "dgff&lookup".equals(dataIndex)) {
                ignoreColSet.add(dataIndex);
            }
            if (null == children || children.isEmpty()) continue;
            SWCExportEntryHelper.getIgnoreColumn(children, ignoreColSet);
        }
    }

    public static EntryColumnWrapper convertToEntryColumnInfo(List<Map<String, Object>> columns) {
        EntryColumnWrapper wrapper = new EntryColumnWrapper((List)Lists.newArrayList());
        HashSet defaultColSet = Sets.newHashSet((Object[])new String[]{"rk", "seq"});
        SWCExportEntryHelper.convertToEntryColumn(columns, wrapper.getContainers(), defaultColSet);
        return wrapper;
    }

    public static void convertToEntryColumn(List<Map<String, Object>> columns, List<EntryColumnContainer> containers, Set<String> defaultColSet) {
        for (Map<String, Object> col : columns) {
            String dataIndex = (String)col.get("dataIndex");
            String textAlign = (String)col.get("text-align");
            Integer width = SWCExportEntryHelper.getWidth(col);
            List children = (List)col.get("children");
            LocaleString header = (LocaleString)col.get("header");
            boolean visible = false;
            Object visibleValue = col.get("visible");
            if (visibleValue != null && ((Boolean)visibleValue).booleanValue()) {
                visible = true;
            } else {
                Object vi = col.get("vi");
                boolean bl = visible = vi instanceof Integer && (Integer)vi == 63;
            }
            if (defaultColSet.contains(dataIndex) || col.containsKey("editor")) {
                String type;
                EntryColumnContainer entryField = new EntryColumnContainer();
                entryField.setKey(dataIndex);
                entryField.setHeader(header);
                entryField.setVisible(visible);
                entryField.setType(EntryColumnContainer.EntryColumnTypeEnum.ENTRY_FILED.getCode());
                entryField.setTextAlign(textAlign);
                entryField.setWidth(width);
                containers.add(entryField);
                Map editorMap = (Map)col.get("editor");
                if (editorMap == null || !"date".equals(type = String.valueOf(editorMap.get("type")))) continue;
                entryField.setTextAlign("center");
                continue;
            }
            if (children == null || children.isEmpty()) continue;
            EntryColumnContainer group = new EntryColumnContainer();
            group.setHeader(header);
            group.setKey(dataIndex);
            group.setVisible(visible);
            group.setType(EntryColumnContainer.EntryColumnTypeEnum.ENTRY_GROUP.getCode());
            group.setChild(new ArrayList());
            group.setTextAlign(textAlign);
            group.setWidth(width);
            containers.add(group);
            SWCExportEntryHelper.convertToEntryColumn(children, group.getChild(), defaultColSet);
        }
    }

    private static Integer getWidth(Map<String, Object> col) {
        Integer width = 200;
        try {
            Object wObj = col.get("w");
            if (wObj != null) {
                String widthStr = wObj.toString();
                widthStr = widthStr.replace("px", "");
                width = wObj == null ? null : Integer.valueOf(new Double(widthStr).intValue());
            }
        }
        catch (Exception e) {
            logger.error("SWCExportEntryHelper.getWidth...", (Throwable)e);
        }
        return width;
    }

    public static List<Map<String, Object>> getAllFields(List<Map<String, Object>> columns) {
        ArrayList result = Lists.newArrayListWithCapacity((int)columns.size());
        for (Map<String, Object> col : columns) {
            Object children = col.get("children");
            if (children != null) {
                result.addAll(SWCExportEntryHelper.getAllFields((List)children));
                continue;
            }
            result.add(col);
        }
        return result;
    }

    public static Map<String, KeyValue> getEntryFieldCaptions(List<EntryColumnContainer> containers) {
        ArrayList<EntryColumnContainer> tempList = new ArrayList<EntryColumnContainer>(10);
        for (EntryColumnContainer container : containers) {
            SWCExportEntryHelper.fetchEntryFieldCaption(container, tempList);
        }
        LinkedHashMap<String, KeyValue> captions = new LinkedHashMap<String, KeyValue>(16);
        for (EntryColumnContainer column : tempList) {
            captions.put(column.getKey(), new KeyValue(column.getKey(), (Object)column.getHeader().toString()));
        }
        return captions;
    }

    public static void fetchEntryFieldCaption(EntryColumnContainer container, List<EntryColumnContainer> list) {
        if (container.getType() == EntryColumnContainer.EntryColumnTypeEnum.ENTRY_GROUP.getCode()) {
            for (EntryColumnContainer childContainer : container.getChild()) {
                SWCExportEntryHelper.fetchEntryFieldCaption(childContainer, list);
            }
        } else if (container.getType() == EntryColumnContainer.EntryColumnTypeEnum.ENTRY_FILED.getCode() && container.isVisible()) {
            list.add(container);
        }
    }

    public static int calcSheetHeadHeight(List<EntryColumnContainer> containers) {
        int height = 0;
        for (EntryColumnContainer container : containers) {
            int tempHeight = 1;
            if (container.getType() == EntryColumnContainer.EntryColumnTypeEnum.ENTRY_GROUP.getCode()) {
                tempHeight += SWCExportEntryHelper.calcSheetHeadHeight(container.getChild());
            }
            if (tempHeight <= height) continue;
            height = tempHeight;
        }
        return height;
    }

    public static List<List<String>> initSheetHeadContainer(int width, int height) {
        ArrayList<List<String>> containerArr = new ArrayList<List<String>>(height);
        for (int i = 0; i < height; ++i) {
            containerArr.add(new ArrayList<Object>(Collections.nCopies(width, null)));
        }
        return containerArr;
    }

    public static void fillSheetHead(List<EntryColumnContainer> containers, List<List<String>> headlist, int rowStart, int columnStart) {
        int row = rowStart;
        int col = columnStart;
        if (rowStart >= headlist.size() || columnStart >= headlist.get(0).size()) {
            return;
        }
        for (int i = 0; i < containers.size(); ++i) {
            if (!containers.get(i).isVisible()) continue;
            String headerName = containers.get(i).getHeader().toString();
            headlist.get(row).set(col, headerName);
            if (EntryColumnContainer.EntryColumnTypeEnum.ENTRY_GROUP.getCode() == containers.get(i).getType()) {
                EntryColumnContainer entryGroup = containers.get(i);
                SWCExportEntryHelper.fillSheetHead(entryGroup.getChild(), headlist, row + 1, col);
                int fieldCount = SWCExportEntryHelper.getEntryFieldNum(entryGroup);
                for (int j = col; j < col + fieldCount; ++j) {
                    headlist.get(row).set(j, headerName);
                }
                col += fieldCount;
            } else {
                ++col;
            }
            if (col >= headlist.get(0).size()) break;
        }
    }

    private static int getEntryFieldNum(EntryColumnContainer container) {
        int sum = 0;
        if (EntryColumnContainer.EntryColumnTypeEnum.ENTRY_GROUP.getCode() == container.getType()) {
            for (EntryColumnContainer columnContainer : container.getChild()) {
                sum += SWCExportEntryHelper.getEntryFieldNum(columnContainer);
            }
        } else {
            ++sum;
        }
        return sum;
    }

    public static void mergeSheetHeadCell(List<List<String>> headlist, SXSSFSheet sheet) {
        int height = headlist.size();
        int width = headlist.get(0).size();
        block0: for (int r = 0; r < height; ++r) {
            int colsource = 0;
            int coltarget = 1;
            while (colsource < width && coltarget < width) {
                if (headlist.get(r).get(colsource) == null) {
                    ++colsource;
                    ++coltarget;
                    continue;
                }
                if (headlist.get(r).get(coltarget) == null && coltarget == width - 1) continue block0;
                if (headlist.get(r).get(coltarget) != null) {
                    if (!headlist.get(r).get(coltarget).equals(headlist.get(r).get(colsource)) && colsource == coltarget - 1) {
                        ++colsource;
                    }
                    if (!(coltarget + 1 > width || headlist.get(r).get(colsource).equals(headlist.get(r).get(coltarget + 1)) && headlist.get(r).get(coltarget + 1) != null)) {
                        sheet.addMergedRegion(new CellRangeAddress(r, r, colsource, coltarget));
                    }
                }
                ++coltarget;
            }
        }
        block2: for (int c = 0; c < width; ++c) {
            int rowsource = 0;
            int rowtarget = 1;
            while (rowsource < height && rowtarget < height) {
                if (headlist.get(rowsource).get(c) == null) {
                    ++rowsource;
                    ++rowtarget;
                    continue;
                }
                if (headlist.get(rowtarget).get(c) == null && rowtarget == height - 1 && rowsource < rowtarget) {
                    sheet.addMergedRegion(new CellRangeAddress(rowsource, rowtarget, c, c));
                    continue block2;
                }
                if (headlist.get(rowtarget).get(c) != null) {
                    if (rowsource == rowtarget - 1) {
                        ++rowsource;
                    }
                    if (rowsource < rowtarget - 1) {
                        sheet.addMergedRegion(new CellRangeAddress(rowsource, rowtarget - 1, c, c));
                        rowsource = rowtarget;
                    }
                }
                ++rowtarget;
            }
        }
    }

    public static void fillSheetHeadArray(List<EntryColumnContainer> containers, String[][] arr, int rowStart, int columnStart) {
        int row = rowStart;
        int col = columnStart;
        if (rowStart >= arr.length || columnStart >= arr[0].length) {
            return;
        }
        for (int i = 0; i < containers.size(); ++i) {
            String headerName;
            if (!containers.get(i).isVisible()) continue;
            arr[row][col] = headerName = containers.get(i).getHeader().toString();
            if (EntryColumnContainer.EntryColumnTypeEnum.ENTRY_GROUP.getCode() == containers.get(i).getType()) {
                EntryColumnContainer entryGroup = containers.get(i);
                SWCExportEntryHelper.fillSheetHeadArray(entryGroup.getChild(), arr, row + 1, col);
                int fieldCount = SWCExportEntryHelper.getEntryFieldNum(entryGroup);
                col += fieldCount;
            } else {
                ++col;
            }
            if (col >= arr[0].length) break;
        }
    }

    public static void setAndMergeHeadCell(SXSSFSheet sheet, String[][] array, ExportSheetStyle styles, int startRow, List<EntryColumnContainer> containers) {
        SWCExportEntryHelper.setAndMergeHeadCellCore(sheet, array, null, startRow, styles, containers);
    }

    public static void setAndMergeHeadCell(SXSSFSheet sheet, String[][] array, CellStyle style, int startRow) {
        SWCExportEntryHelper.setAndMergeHeadCellCore(sheet, array, style, startRow, null, null);
    }

    private static void setAndMergeHeadCellCore(SXSSFSheet sheet, String[][] array, CellStyle style, int startRow, ExportSheetStyle styles, List<EntryColumnContainer> containers) {
        List<Integer> list;
        for (int i = startRow; i < array.length; ++i) {
            SXSSFRow row = sheet.createRow(i);
            for (int j = 0; j < array[i].length; ++j) {
                SXSSFCell cell = row.createCell(j);
                CellStyle cellStyle = SWCExportEntryHelper.getCellStyle(j, style, styles, containers);
                cell.setCellStyle(cellStyle);
                cell.setCellValue(array[i][j]);
            }
        }
        HashMap<Integer, ArrayList<Integer>> map = new HashMap<Integer, ArrayList<Integer>>();
        block2: for (int c = 0; c < array[array.length - 1].length; ++c) {
            String value = array[array.length - 1][c];
            if (!SWCStringUtils.isEmpty((String)value)) continue;
            for (int r = array.length - 2; r >= startRow; --r) {
                if (SWCStringUtils.isNotEmpty((String)array[r][c])) {
                    sheet.addMergedRegion(new CellRangeAddress(r, array.length - 1, c, c));
                    continue block2;
                }
                list = (List)map.get(r);
                if (null != list && !list.isEmpty()) {
                    list.add(c);
                    map.put(r, (ArrayList<Integer>)list);
                    continue;
                }
                list = new ArrayList<Integer>();
                list.add(c);
                map.put(r, (ArrayList<Integer>)list);
            }
        }
        int mergerNum = 0;
        for (int r = startRow; r < array.length - 1; ++r) {
            for (int c = 0; c < array[r].length; ++c) {
                list = (ArrayList<Integer>)map.get(r);
                if (list == null || list != null && !list.contains(c)) {
                    if (SWCStringUtils.isEmpty((String)array[r][c])) {
                        if (++mergerNum != 0 && c == array[r].length - 1) {
                            sheet.addMergedRegion(new CellRangeAddress(r, r, c - mergerNum, c));
                            mergerNum = 0;
                        }
                    } else if (mergerNum != 0) {
                        sheet.addMergedRegion(new CellRangeAddress(r, r, c - mergerNum - 1, c - 1));
                        mergerNum = 0;
                    }
                }
                if (mergerNum == 0 || list == null || !list.contains(c)) continue;
                sheet.addMergedRegion(new CellRangeAddress(r, r, c - mergerNum - 1, c - 1));
                mergerNum = 0;
            }
        }
    }

    private static CellStyle getCellStyle(int index, CellStyle style, ExportSheetStyle styles, List<EntryColumnContainer> containers) {
        if (style != null) {
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            return style;
        }
        int isHasRk = 0;
        if (containers != null && containers.size() >= 1 && "rk".equals(containers.get(0).getKey())) {
            isHasRk = 1;
        }
        if (containers == null || containers.size() <= index + isHasRk) {
            return styles.getTitleStyle();
        }
        EntryColumnContainer entryColumn = containers.get(index + isHasRk);
        String textAlign = entryColumn.getTextAlign();
        HorizontalAlignment alignment = HorizontalAlignment.CENTER;
        if ("left".equals(textAlign)) {
            alignment = HorizontalAlignment.LEFT;
        } else if ("right".equals(textAlign)) {
            alignment = HorizontalAlignment.RIGHT;
        }
        CellStyle styleCell = styles.getTitleStyle(alignment.name());
        styleCell.setVerticalAlignment(VerticalAlignment.CENTER);
        styleCell.setBorderTop(BorderStyle.THIN);
        styleCell.setBorderBottom(BorderStyle.THIN);
        styleCell.setBorderLeft(BorderStyle.THIN);
        styleCell.setBorderRight(BorderStyle.THIN);
        return styleCell;
    }

    public static void fillTemplateFixedInfo(String[][] templateFixedInfoArr, String templateCaption, String warningInfo, List<KeyValue> captions) {
        for (int i = 0; i < templateFixedInfoArr.length; ++i) {
            if (i == 0) {
                templateFixedInfoArr[i][0] = templateCaption;
            }
            if (i == 1) {
                templateFixedInfoArr[i][0] = warningInfo;
            }
            if (i != 2) continue;
            for (int j = 0; j < captions.size(); ++j) {
                templateFixedInfoArr[i][j] = captions.get((int)j).key;
            }
        }
    }

    public static void setTemplateFixedInfoCell(SXSSFSheet sheet, String[][] templateFixedInfoArr, ExportSheetStyle styles, SXSSFWorkbook wb) {
        for (int i = 0; i < templateFixedInfoArr.length; ++i) {
            if (i == 0) {
                SXSSFRow captionRow = sheet.createRow(i);
                SXSSFCell captionCell = captionRow.createCell(i);
                captionCell.setCellValue(templateFixedInfoArr[i][0]);
                CellStyle cellStyle = wb.createCellStyle();
                captionCell.setCellStyle(cellStyle);
                Font headerFont = wb.createFont();
                headerFont.setBold(true);
                cellStyle.setFont(headerFont);
            }
            if (i == 1) {
                SXSSFRow warningRow = sheet.createRow(i);
                SXSSFCell warningCell = warningRow.createCell(0);
                warningCell.setCellValue(templateFixedInfoArr[i][0]);
                CellStyle warningStyle = wb.createCellStyle();
                warningCell.setCellStyle(warningStyle);
                Font font = wb.createFont();
                warningStyle.setFont(font);
                font.setColor((short)10);
            }
            if (i != 2) continue;
            SXSSFRow keyRow = sheet.createRow(i);
            keyRow.setHidden(Boolean.TRUE);
            for (int j = 0; j < templateFixedInfoArr[i].length; ++j) {
                SXSSFCell fieldKeyCell = keyRow.createCell(j);
                fieldKeyCell.setCellValue(templateFixedInfoArr[i][j]);
            }
        }
    }

    public static XSSFCellStyle createBorderStyle(XSSFWorkbook workbook) {
        XSSFCellStyle style = workbook.createCellStyle();
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    public static Set<String> getIgnoreColumnByFeatures(DataEntityPropertyCollection properties, boolean importFlag) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)properties.size());
        Features initFeature = EntryParamContainerBaseHelper.createInitFeature((boolean)false);
        if (importFlag) {
            initFeature.setImportable(true);
        } else {
            initFeature.setExportable(true);
        }
        int value = initFeature.getValue();
        for (IDataEntityProperty prop : properties) {
            int features = ((IFieldHandle)prop).getFeatures();
            if ((features & value) != 0) continue;
            result.add(prop.getName());
        }
        return result;
    }

    public static List<EntryColumnContainer> getFieldContainer(List<EntryColumnContainer> container) {
        ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)container.size());
        for (EntryColumnContainer columnContainer : container) {
            SWCExportEntryHelper.getFieldContainerFromOne(columnContainer, fieldList);
        }
        return fieldList;
    }

    private static void getFieldContainerFromOne(EntryColumnContainer columnContainer, List<EntryColumnContainer> fieldList) {
        if (EntryColumnContainer.EntryColumnTypeEnum.ENTRY_GROUP.getCode() == columnContainer.getType()) {
            if (!CollectionUtils.isEmpty((Collection)columnContainer.getChild())) {
                for (EntryColumnContainer entryColumnContainer : columnContainer.getChild()) {
                    SWCExportEntryHelper.getFieldContainerFromOne(entryColumnContainer, fieldList);
                }
            }
        } else {
            fieldList.add(columnContainer);
        }
    }
}

