/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.imports;

import com.google.common.collect.Maps;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.rpc.holders.StringHolder;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.imports.ImportEntRowEntity;
import kd.swc.hsbp.business.imports.converter.DecimalConverter;
import kd.swc.hsbp.business.imports.perm.IPermissionHandler;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DynamicEntryImportConvertHelper {
    private static final Log LOGGER = LogFactory.getLog(DynamicEntryImportConvertHelper.class);
    private static final String SUFFIX_NAME = "_name";
    private static final String SPLIT = ",";

    public static Map<String, Map<String, DynamicObject>> loadBaseDataWithPermission(List<ImportEntRowEntity> bizDataEntList, Map<Integer, String> colKeyIndexMap, IDataModel model, Map<String, String> bdQueryPropMap, Map<String, IPermissionHandler> permissionHandlerMap) {
        HashMap<String, Map<String, DynamicObject>> map = new HashMap<String, Map<String, DynamicObject>>();
        for (Map.Entry<Integer, String> entry : colKeyIndexMap.entrySet()) {
            String prop;
            BasedataProp basedataProp;
            int colIndex = entry.getKey();
            String propName = entry.getValue();
            DynamicProperty property = (DynamicProperty)model.getProperty(propName);
            if (!(property instanceof BasedataProp) && !(property instanceof MulBasedataProp)) continue;
            String baseEntityId = null;
            StringHolder displayProp = new StringHolder();
            HashSet values = new HashSet();
            if (property instanceof BasedataProp) {
                basedataProp = (BasedataProp)property;
                baseEntityId = basedataProp.getBaseEntityId();
                displayProp.value = basedataProp.getDisplayProp();
                bizDataEntList.stream().filter(o1 -> StringUtils.isNotEmpty((CharSequence)o1.getData().get(colIndex))).forEach(o1 -> values.add(o1.getData().get(colIndex)));
            }
            if (property instanceof MulBasedataProp) {
                basedataProp = (MulBasedataProp)property;
                bizDataEntList.stream().filter(o2 -> StringUtils.isNotEmpty((CharSequence)o2.getData().get(colIndex))).forEach(o2 -> values.addAll(Arrays.asList(o2.getData().get(colIndex).split(";"))));
                baseEntityId = basedataProp.getBaseEntityId();
                displayProp.value = basedataProp.getDisplayProp();
            }
            if (StringUtils.isEmpty(baseEntityId) || StringUtils.isEmpty((CharSequence)displayProp.value) || values.isEmpty()) {
                map.put(propName, Maps.newHashMap());
                continue;
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            String string = prop = bdQueryPropMap != null ? bdQueryPropMap.get(propName) : null;
            if (prop != null) {
                displayProp.value = prop;
            }
            QFilter valueFilter = new QFilter(displayProp.value, "in", values);
            Object[] allFilter = new QFilter[]{valueFilter};
            IPermissionHandler permissionHandler = permissionHandlerMap.get(propName);
            if (permissionHandler != null) {
                Object[] permissionFilter = permissionHandler.getPermissionFilter();
                allFilter = (QFilter[])ArrayUtils.addAll((Object[])permissionFilter, (Object[])allFilter);
            }
            if (dataEntityType.getProperty("iscurrentversion") != null) {
                allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE), new QFilter("datastatus", "!=", (Object)"-1")});
            }
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(baseEntityId);
            DynamicObject[] objects = serviceHelper.query(SWCHisBaseDataHelper.getSelectProperties(baseEntityId), (QFilter[])allFilter);
            Map dbData = Arrays.stream(objects).collect(Collectors.toMap(o3 -> o3.getString(displayProp.value), Function.identity()));
            map.putIfAbsent(propName, dbData);
        }
        return map;
    }

    public static Map<String, Map<String, List<DynamicObject>>> loadBaseDataWithPermission(List<ImportEntRowEntity> bizDataEntList, Map<Integer, String> colKeyIndexMap, Map<String, Map<String, Object>> entryEntityPropMap, Map<String, String> bdQueryPropMap, Map<String, IPermissionHandler> permissionHandlerMap) {
        return DynamicEntryImportConvertHelper.loadBaseDataWithPermission(bizDataEntList, colKeyIndexMap, entryEntityPropMap, bdQueryPropMap, permissionHandlerMap, null);
    }

    public static Map<String, Map<String, List<DynamicObject>>> loadBaseDataWithPermission(List<ImportEntRowEntity> bizDataEntList, Map<Integer, String> colKeyIndexMap, Map<String, Map<String, Object>> entryEntityPropMap, Map<String, String> bdQueryPropMap, Map<String, IPermissionHandler> permissionHandlerMap, Set<String> queryAllKeySet) {
        HashMap<String, Map<String, List<DynamicObject>>> map = new HashMap<String, Map<String, List<DynamicObject>>>();
        for (Map.Entry<Integer, String> entry : colKeyIndexMap.entrySet()) {
            String prop;
            String type;
            int colIndex = entry.getKey();
            String propName = entry.getValue();
            Map<String, Object> property = entryEntityPropMap.get(propName);
            if (property == null || !"BasedataProp".equals(type = String.valueOf(property.get("type"))) && !"MulBasedataProp".equals(type)) continue;
            String baseEntityId = null;
            StringHolder displayProp = new StringHolder();
            HashSet values = new HashSet();
            if ("BasedataProp".equals(type)) {
                baseEntityId = String.valueOf(property.get("baseEntityId"));
                displayProp.value = String.valueOf(property.get("displayProp"));
                bizDataEntList.stream().filter(o1 -> StringUtils.isNotEmpty((CharSequence)o1.getData().get(colIndex))).forEach(o1 -> values.add(o1.getData().get(colIndex)));
            }
            if ("MulBasedataProp".equals(type)) {
                bizDataEntList.stream().filter(o2 -> StringUtils.isNotEmpty((CharSequence)o2.getData().get(colIndex))).forEach(o2 -> values.addAll(Arrays.asList(o2.getData().get(colIndex).split(";"))));
                baseEntityId = String.valueOf(property.get("baseEntityId"));
                displayProp.value = String.valueOf(property.get("displayProp"));
            }
            if (StringUtils.isEmpty((CharSequence)baseEntityId) || StringUtils.isEmpty((CharSequence)displayProp.value) || values.isEmpty()) {
                map.put(propName, Maps.newHashMap());
                continue;
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            String string = prop = bdQueryPropMap != null ? bdQueryPropMap.get(propName) : null;
            if (prop != null) {
                displayProp.value = prop;
            }
            QFilter valueFilter = new QFilter(displayProp.value, "in", values);
            Object[] allFilter = new QFilter[]{valueFilter};
            IPermissionHandler permissionHandler = permissionHandlerMap.get(propName);
            if (permissionHandler != null) {
                Object[] permissionFilter = permissionHandler.getPermissionFilter();
                allFilter = (QFilter[])ArrayUtils.addAll((Object[])permissionFilter, (Object[])allFilter);
            }
            if (dataEntityType.getProperty("iscurrentversion") != null) {
                allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE), new QFilter("datastatus", "!=", (Object)"-1")});
            }
            String props = SWCHisBaseDataHelper.getSelectProperties(baseEntityId);
            if (queryAllKeySet == null || !queryAllKeySet.contains(propName)) {
                if (props.contains(",enable,") || props.startsWith("enable,") || props.startsWith(",enable")) {
                    allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
                }
                if (props.contains(",status,") || props.startsWith("status,") || props.startsWith(",status")) {
                    allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{new QFilter("status", "=", (Object)"C")});
                }
            }
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(baseEntityId);
            DynamicObject[] objects = serviceHelper.query(props, (QFilter[])allFilter);
            Map<String, List<DynamicObject>> dbData = DynamicEntryImportConvertHelper.convertToMap(displayProp, objects);
            map.putIfAbsent(propName, dbData);
        }
        return map;
    }

    private static Map<String, List<DynamicObject>> convertToMap(StringHolder displayProp, DynamicObject[] objects) {
        HashMap<String, List<DynamicObject>> dbData = new HashMap<String, List<DynamicObject>>(16);
        if (objects == null) {
            return dbData;
        }
        for (DynamicObject obj : objects) {
            String propKey = obj.getString(displayProp.value);
            ArrayList<DynamicObject> datas = (ArrayList<DynamicObject>)dbData.get(propKey);
            if (datas == null) {
                datas = new ArrayList<DynamicObject>(10);
                dbData.put(propKey, datas);
            }
            datas.add(obj);
        }
        return dbData;
    }

    public static Map<String, Map<String, Object>> convertToModelValue(List<ImportEntRowEntity> bizDataEntList, Map<String, Integer> colIdMap, Map<String, Map<String, DynamicObject>> baseDataMap, IDataModel model) {
        HashMap map = Maps.newHashMap();
        for (ImportEntRowEntity cellrowEntity : bizDataEntList) {
            Map<Integer, String> cellrow = cellrowEntity.getData();
            Map<String, Object> rowData = cellrowEntity.getDataMap();
            for (Map.Entry<String, Integer> keyIndexEntry : colIdMap.entrySet()) {
                String propName = keyIndexEntry.getKey();
                DynamicProperty property = (DynamicProperty)model.getProperty(propName);
                Integer colIndex = keyIndexEntry.getValue();
                String cellValue = cellrow.get(colIndex);
                Object cellObject = cellValue;
                if (!StringUtils.isNotEmpty((CharSequence)cellValue)) continue;
                if (property instanceof DecimalProp) {
                    DecimalProp decimalProp = (DecimalProp)property;
                    DecimalConverter converter = new DecimalConverter(decimalProp.getDataScope(), decimalProp.getPrecision(), decimalProp.getScale());
                    cellObject = converter.convert(cellValue);
                }
                if (property instanceof ComboProp) {
                    ComboProp comboProp = (ComboProp)property;
                    ValueMapItem valueMapItem = DynamicEntryImportConvertHelper.getComboItemByLocaleValue(cellValue, comboProp);
                    Object object = cellObject = valueMapItem == null ? null : valueMapItem.getValue();
                }
                if (property instanceof BasedataProp) {
                    cellObject = baseDataMap.get(propName).get(cellValue);
                }
                if (property instanceof DateProp) {
                    DateProp dateProp = (DateProp)property;
                    cellObject = DynamicEntryImportConvertHelper.getDateValue(cellValue, dateProp);
                }
                rowData.putIfAbsent(propName, cellObject);
            }
        }
        return map;
    }

    public static Map<String, Map<String, Object>> convertToModelValue(List<ImportEntRowEntity> bizDataEntList, Map<String, Integer> colIdMap, Map<String, Map<String, DynamicObject>> baseDataMap, Map<String, Map<String, Object>> entryEntityPropMap) {
        HashMap map = Maps.newHashMap();
        for (ImportEntRowEntity cellrowEntity : bizDataEntList) {
            Map<Integer, String> cellrow = cellrowEntity.getData();
            Map<String, Object> rowData = cellrowEntity.getDataMap();
            for (Map.Entry<String, Integer> keyIndexEntry : colIdMap.entrySet()) {
                String propName = keyIndexEntry.getKey();
                Map<String, Object> property = entryEntityPropMap.get(propName);
                if (property == null) continue;
                String type = String.valueOf(property.get("type"));
                Integer colIndex = keyIndexEntry.getValue();
                String cellValue = cellrow.get(colIndex);
                Object cellObject = cellValue;
                if (StringUtils.isNotEmpty((CharSequence)cellValue)) {
                    if ("DecimalProp".equals(type)) {
                        DecimalConverter converter = new DecimalConverter(String.valueOf(property.get("dataScope")), (Integer)property.get("precision"), (Integer)property.get("scale"));
                        cellObject = converter.convert(cellValue);
                    }
                    if ("ComboProp".equals(type)) {
                        ValueMapItem valueMapItem = DynamicEntryImportConvertHelper.getComboItemByLocaleValue(cellValue, (List)property.get("comboItems"));
                        Object object = cellObject = valueMapItem == null ? null : valueMapItem.getValue();
                    }
                    if ("BasedataProp".equals(type)) {
                        cellObject = baseDataMap.get(propName).get(cellValue);
                    }
                    if ("DateProp".equals(type)) {
                        cellObject = DynamicEntryImportConvertHelper.getDateValue(cellValue, (DateFormat)property.get("dateFormat"));
                    }
                    rowData.putIfAbsent(propName, cellObject);
                    continue;
                }
                if (!"BasedataProp".equals(type) || propName.endsWith(SUFFIX_NAME)) continue;
                Integer nameColIndex = colIdMap.get(propName + SUFFIX_NAME);
                String nameCellValue = cellrow.get(nameColIndex);
                Map<String, DynamicObject> namebdMap = baseDataMap.get(propName + SUFFIX_NAME);
                if (namebdMap == null) continue;
                cellObject = namebdMap.get(nameCellValue);
                rowData.putIfAbsent(propName, cellObject);
            }
        }
        return map;
    }

    private static Object getDateValue(String cellValue, DateProp dateProp) {
        DateFormat df = dateProp.getDateFormat();
        try {
            return df.parse(cellValue);
        }
        catch (ParseException e) {
            LOGGER.error("parseDateValue error...", (Throwable)e);
            return null;
        }
    }

    public static Object getDateValue(String cellValue, DateFormat df) {
        try {
            return df.parse(cellValue);
        }
        catch (ParseException e) {
            LOGGER.error("parseDateValue error...", (Throwable)e);
            return null;
        }
    }

    private static ValueMapItem getComboItemByLocaleValue(String value, ComboProp comboProp) {
        for (ValueMapItem comboItem : comboProp.getComboItems()) {
            if (!StringUtils.equals((CharSequence)comboItem.getName().getLocaleValue(), (CharSequence)value)) continue;
            return comboItem;
        }
        return null;
    }

    public static ValueMapItem getComboItemByLocaleValue(String value, List<ValueMapItem> comboItems) {
        for (ValueMapItem comboItem : comboItems) {
            if (!StringUtils.equals((CharSequence)comboItem.getName().getLocaleValue(), (CharSequence)value)) continue;
            return comboItem;
        }
        return null;
    }
}

