/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.job;

import java.time.ZonedDateTime;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class JobDispatcherService {
    private static JobDispatcherService instance = new JobDispatcherService();

    private JobDispatcherService() {
    }

    public static JobDispatcherService getInstance() {
        return instance;
    }

    public String createJob(JobInfo jobInfo) {
        jobInfo.setRunByOrgId(0L);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.zh_CN);
        jobInfo.setRunConcurrently(false);
        String jobId = ScheduleServiceHelper.createJob((JobInfo)jobInfo);
        return jobId;
    }

    public String createPlan(PlanInfo planInfo) {
        String planId = ScheduleServiceHelper.createPlan((PlanInfo)planInfo);
        return planId;
    }

    public boolean deletePlan(String planId) {
        SWCDataServiceHelper scheduleHelper = new SWCDataServiceHelper("sch_schedule");
        boolean isExist = scheduleHelper.isExists(planId);
        boolean isDeleteSuccess = true;
        if (isExist) {
            new ScheduleServiceHelper();
            isDeleteSuccess = ScheduleServiceHelper.deletePlan((String)planId);
        }
        return isDeleteSuccess;
    }

    public boolean deleteJob(String jobId) {
        SWCDataServiceHelper jobHelper = new SWCDataServiceHelper("sch_job");
        boolean isExist = jobHelper.isExists(jobId);
        boolean isDeleteSuccess = true;
        if (isExist) {
            new ScheduleServiceHelper();
            isDeleteSuccess = ScheduleServiceHelper.deleteJob((String)jobId);
        }
        return isDeleteSuccess;
    }

    public Map<String, ZonedDateTime> getExecuteTime(String[] idArray) {
        return ScheduleServiceHelper.queryNextExecuteTime((String[])idArray);
    }
}

