/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.paysubject;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class PaySubjectLawHelper {
    private static final String LAW_ENTITY = "lawentity";

    public static Boolean getLawIsMust() {
        Map<String, Object> paramMap = SWCSalaryParameterServiceHelper.getSalaryParam("paysubject");
        if (paramMap == null) {
            return Boolean.FALSE;
        }
        return (Boolean)paramMap.getOrDefault("needlaw", Boolean.FALSE);
    }

    public static void relLawEntityAfterHis(DynamicObject[] dataEntities, List<Long> ids) {
        ArrayList<DynamicObject> dataEntityDeleteList = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<DynamicObject> dataEntityAuditList = new ArrayList<DynamicObject>(dataEntities.length);
        SWCDataServiceHelper paySubjectHelper = new SWCDataServiceHelper("hsbs_paysubject");
        Map<Long, DynamicObject> curMap = PaySubjectLawHelper.buildOldMap(ids);
        Date dateNow = new Date();
        Map<Long, DynamicObject> map = PaySubjectLawHelper.buildPreVersionMap(dataEntities, ids);
        for (DynamicObject dataEntity : dataEntities) {
            Long newOrgId = PaySubjectLawHelper.buildNewOrgId(dataEntity);
            DynamicObject perData = map.get(dataEntity.getLong("boid"));
            DynamicObject curObj = curMap.get(dataEntity.getLong("boid"));
            if (perData == null) {
                if (newOrgId == 0L) continue;
                dataEntityAuditList.add(curObj);
                continue;
            }
            Long oldOrgId = perData.getLong("lawentity.id");
            if (newOrgId.equals(oldOrgId) || !SWCDateTimeUtils.isCover((Date)dateNow, (Date)dataEntity.getDate("bsed"), (Date)dataEntity.getDate("bsled"))) continue;
            DynamicObject paySubject = paySubjectHelper.generateEmptyDynamicObject();
            paySubject.set("id", (Object)curObj.getLong("id"));
            paySubject.set(LAW_ENTITY, (Object)PaySubjectLawHelper.getDynamicObjectById("hbss_lawentity", oldOrgId));
            dataEntityDeleteList.add(paySubject);
            if (newOrgId == 0L) continue;
            dataEntityAuditList.add(curObj);
        }
        if (!dataEntityDeleteList.isEmpty()) {
            SWCMServiceUtils.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSService", (String)"relLawEntity", (Object[])new Object[]{"hsbs_paysubject", "delete", dataEntityDeleteList.toArray(new DynamicObject[0])});
        }
        if (!dataEntityAuditList.isEmpty()) {
            SWCMServiceUtils.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSService", (String)"relLawEntity", (Object[])new Object[]{"hsbs_paysubject", "audit", dataEntityAuditList.toArray(new DynamicObject[0])});
        }
    }

    public static void relLawEntity(DynamicObject[] dataEntities, List<Long> ids) {
        ArrayList<DynamicObject> dataEntitySaveList = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<DynamicObject> dataEntityDeleteList = new ArrayList<DynamicObject>(dataEntities.length);
        Map<Long, DynamicObject> map = PaySubjectLawHelper.buildOldMap(ids);
        Date dateNow = new Date();
        for (DynamicObject dataEntity : dataEntities) {
            Long oldOrgId;
            Long newOrgId = PaySubjectLawHelper.buildNewOrgId(dataEntity);
            DynamicObject curObj = map.get(dataEntity.getLong("boid"));
            if (curObj == null || newOrgId.equals(oldOrgId = Long.valueOf(curObj.getLong("lawentity.id"))) || !SWCDateTimeUtils.isCover((Date)dateNow, (Date)dataEntity.getDate("bsed"), (Date)dataEntity.getDate("bsled"))) continue;
            curObj.set(LAW_ENTITY, dataEntity.get(LAW_ENTITY));
            if (newOrgId == 0L) {
                dataEntityDeleteList.add(curObj);
                continue;
            }
            dataEntitySaveList.add(curObj);
        }
        if (!dataEntitySaveList.isEmpty()) {
            SWCMServiceUtils.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSService", (String)"relLawEntity", (Object[])new Object[]{"hsbs_paysubject", "save", dataEntitySaveList.toArray(new DynamicObject[0])});
        }
        if (!dataEntityDeleteList.isEmpty()) {
            SWCMServiceUtils.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSService", (String)"relLawEntity", (Object[])new Object[]{"hsbs_paysubject", "delete", dataEntityDeleteList.toArray(new DynamicObject[0])});
        }
    }

    private static Map<Long, DynamicObject> buildPreVersionMap(DynamicObject[] dataEntities, List<Long> ids) {
        ArrayList<Long> sourceIdList = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject data : dataEntities) {
            sourceIdList.add(data.getLong("sourcevid"));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_paysubject");
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        if (!sourceIdList.isEmpty()) {
            DynamicObject[] dataArray;
            QFilter filter = new QFilter("id", "in", sourceIdList);
            for (DynamicObject data : dataArray = helper.query("lawentity,boid", new QFilter[]{filter})) {
                map.put(data.getLong("boid"), data);
            }
        }
        return map;
    }

    private static Map<Long, DynamicObject> buildOldMap(List<Long> ids) {
        SWCDataServiceHelper currEntityHelper = new SWCDataServiceHelper("hsbs_paysubject");
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        if (!ids.isEmpty()) {
            DynamicObject[] dataArray;
            QFilter filter = new QFilter("id", "in", ids);
            for (DynamicObject data : dataArray = currEntityHelper.query(LAW_ENTITY, new QFilter[]{filter})) {
                map.put(data.getLong("id"), data);
            }
        }
        return map;
    }

    private static Long buildNewOrgId(DynamicObject dataEntity) {
        DynamicObject newCorporateOrg = (DynamicObject)dataEntity.get(LAW_ENTITY);
        if (!Objects.isNull(newCorporateOrg)) {
            return (Long)newCorporateOrg.getPkValue();
        }
        return 0L;
    }

    private static DynamicObject getDynamicObjectById(String entityName, Long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return id == null || id == 0L ? null : new DynamicObject((DynamicObjectType)type, (Object)id);
    }
}

