/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.perbankcard;

import com.google.common.collect.HashBasedTable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.swc.hsbp.common.vo.PerBankCardVO;

public class PerBankCardVerifyHelper {
    private static final Pattern PATTERN = Pattern.compile("[0-9]*");

    public static void saveValidate(List<PerBankCardVO> perBankCardList) {
        ArrayList<PerBankCardVO> dataEntityList = new ArrayList<PerBankCardVO>(10);
        for (PerBankCardVO dataEntity : perBankCardList) {
            if (!PerBankCardVerifyHelper.isBankCardNotEmpty(dataEntity)) continue;
            dataEntityList.add(dataEntity);
        }
        PerBankCardVerifyHelper.validateBankCard(dataEntityList);
    }

    public static void changeValidate(List<PerBankCardVO> perBankCardList) {
        HashSet<Long> perBankCardSet = new HashSet<Long>(16);
        ArrayList<PerBankCardVO> dataEntityList = new ArrayList<PerBankCardVO>(10);
        for (PerBankCardVO perBankCard : perBankCardList) {
            perBankCardSet.add(perBankCard.getId());
            dataEntityList.add(perBankCard);
        }
        PerBankCardVerifyHelper.validateDeleteBankCard(perBankCardSet, dataEntityList);
        PerBankCardVerifyHelper.saveValidate(dataEntityList);
    }

    private static DynamicObjectCollection getBankCardCol(QFilter[] filters) {
        HRBaseServiceHelper perBankCardServiceHelper = new HRBaseServiceHelper("hrpi_perbankcard");
        return perBankCardServiceHelper.queryOriginalCollection("id,bankcardnum,person.id", filters);
    }

    private static void validateBankCard(List<PerBankCardVO> dataEntityList) {
        dataEntityList.removeIf(PerBankCardVerifyHelper::isBankCardNumber);
        HashBasedTable<Long, String, PerBankCardVO> personDataTable = PerBankCardVerifyHelper.getPersonTable(dataEntityList);
        Set personIdSet = personDataTable.rowKeySet();
        for (Long personId : personIdSet) {
            Map dataEntityMap = personDataTable.row((Object)personId);
            QFilter personFilter = new QFilter("person", "=", (Object)personId);
            QFilter bankCardNumFilter = new QFilter("bankcardnum", "in", dataEntityMap.keySet());
            QFilter isDeleteFilter = new QFilter("isdelete", "=", (Object)"0");
            QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            DynamicObjectCollection bankCardCol = PerBankCardVerifyHelper.getBankCardCol(new QFilter[]{personFilter, bankCardNumFilter, isDeleteFilter, isCurrentVersionFilter});
            for (DynamicObject perBankCard : bankCardCol) {
                Long id;
                Long perBankCardId;
                String bankCardNum = perBankCard.getString("bankcardnum");
                PerBankCardVO entity = (PerBankCardVO)personDataTable.get((Object)personId, (Object)bankCardNum);
                if (entity == null || (perBankCardId = Long.valueOf(perBankCard.getLong("id"))).equals(id = entity.getId())) continue;
                entity.setErrorMsg(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u5df2\u5b58\u5728\u3002", (String)"PerBankCardVerifyHelper_0", (String)"swc-hsbp-business", (Object[])new Object[0]));
            }
        }
    }

    private static HashBasedTable<Long, String, PerBankCardVO> getPersonTable(List<PerBankCardVO> dataEntityList) {
        HashBasedTable personDataTable = HashBasedTable.create();
        for (PerBankCardVO perBankCard : dataEntityList) {
            String bankCardNum;
            Long personId = perBankCard.getPersonId();
            PerBankCardVO entity = (PerBankCardVO)personDataTable.get((Object)personId, (Object)(bankCardNum = perBankCard.getBankCardNum()));
            if (entity != null) {
                entity.setErrorMsg(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u5df2\u5b58\u5728\u3002", (String)"PerBankCardVerifyHelper_0", (String)"swc-hsbp-business", (Object[])new Object[0]));
                perBankCard.setErrorMsg(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u5df2\u5b58\u5728\u3002", (String)"PerBankCardVerifyHelper_0", (String)"swc-hsbp-business", (Object[])new Object[0]));
                continue;
            }
            personDataTable.put((Object)personId, (Object)bankCardNum, (Object)perBankCard);
        }
        return personDataTable;
    }

    private static boolean isBankCardNotEmpty(PerBankCardVO dataEntity) {
        String cardNum = dataEntity.getBankCardNum();
        return HRStringUtils.isNotEmpty((String)cardNum);
    }

    private static boolean isBankCardNumber(PerBankCardVO dataEntity) {
        String cardNum = dataEntity.getBankCardNum();
        boolean match = PATTERN.matcher(cardNum).matches();
        if (!match) {
            dataEntity.setErrorMsg(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u4ec5\u5141\u8bb8\u5f55\u5165\u6570\u5b57\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PerBankCardVerifyHelper_1", (String)"swc-hsbp-business", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private static void validateDeleteBankCard(Set<Long> perBankCardSet, List<PerBankCardVO> perBankCardList) {
        QFilter idFilter = new QFilter("id", "in", perBankCardSet);
        QFilter deleteFilter = new QFilter("isdelete", "=", (Object)"1");
        DynamicObjectCollection bankCardCol = PerBankCardVerifyHelper.getBankCardCol(new QFilter[]{idFilter, deleteFilter});
        Set idDeleteSet = bankCardCol.stream().map(data -> data.getLong("id")).collect(Collectors.toSet());
        perBankCardList.removeIf(perBankCard -> {
            Long perBankCardId = perBankCard.getId();
            if (idDeleteSet.contains(perBankCardId)) {
                perBankCard.setErrorMsg(ResManager.loadKDString((String)"\u94f6\u884c\u5361\u5df2\u88ab\u5220\u9664\u3002", (String)"PerBankCardVerifyHelper_2", (String)"swc-hsbp-business", (Object[])new Object[0]));
                return true;
            }
            return false;
        });
    }
}

