/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import org.apache.commons.lang3.StringUtils;

public class AdminOrgHelper {
    public static final char REGEX_ORGLONGNUMBER_SPLIT = '!';
    public static final String KEY_ORGID = "orgId";
    public static final String KEY_ORGNUMBER = "orgNumber";
    public static final String KEY_ORGLEVEL = "orgLevel";
    public static final String KEY_ORGNAME = "orgName";
    public static final String KEY_STRUCTLONGNUMBER = "structLongNumber";
    public static final String KEY_ORGLONGNUMBER = "longnumber";

    public static int getAdminOrgLevel(String longNumber) {
        if (StringUtils.isBlank((CharSequence)longNumber)) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = longNumber.indexOf(33, index)) != -1) {
            ++index;
            ++count;
        }
        return count + 1;
    }

    public static String getAdminOrgNumberByLevel(String longNumber, int level) {
        if (StringUtils.isBlank((CharSequence)longNumber) || level < 1) {
            return "";
        }
        StringBuilder orgNumber = new StringBuilder();
        String[] orgNumberArray = longNumber.split("!");
        for (int i = 0; i < orgNumberArray.length && i < level; ++i) {
            if (i == 0) {
                orgNumber.append(orgNumberArray[i]);
                continue;
            }
            orgNumber.append('!').append(orgNumberArray[i]);
        }
        return orgNumber.toString();
    }

    public static List<Map<String, Object>> getAllSubAdminOrg(Long adminOrgId) {
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(adminOrgId);
        return AdminOrgHelper.getAllSubAdminOrg(orgIdList, new Date());
    }

    public static List<Map<String, Object>> getAllSubAdminOrg(List<Long> adminOrgIds, Date date) {
        List adminOrgMapList = (List)SWCMServiceUtils.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"batchGetAllSubOrg", (Object[])new Object[]{adminOrgIds, date});
        return adminOrgMapList;
    }

    public static Map<String, Object> getAdminOrgDataMap(Long adminOrgId) {
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(adminOrgId);
        Map adminOrgMap = (Map)SWCMServiceUtils.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgStructQueryService", (String)"adminOrgStructQuery", (Object[])new Object[]{orgIdList, new Date(), Boolean.TRUE});
        return (Map)adminOrgMap.get(String.valueOf(adminOrgId));
    }
}

