/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.swc.hsbp.business.report.RptShowNodeHelper;
import kd.swc.hsbp.business.report.RptShowNodeVo;
import kd.swc.hsbp.business.report.RptTypeHelper;
import kd.swc.hsbp.common.entity.RptDisplayColumnEntity;

public class RptDisplayService {
    public static int getDefaultColWidth(String rptTypeId) {
        DynamicObject rptTypeDyn = RptTypeHelper.querytRptTypeDyn(rptTypeId);
        if (rptTypeDyn == null) {
            return 120;
        }
        return rptTypeDyn.getInt("columnwidth");
    }

    public static List<RptDisplayColumnEntity> getFixColumns(String rptFormId) {
        List<RptShowNodeVo> nodeVos = RptShowNodeHelper.queryFixFieldNodes(rptFormId);
        if (CollectionUtils.isEmpty(nodeVos)) {
            return null;
        }
        return nodeVos.stream().map(obj -> RptDisplayService.createColEntity(obj)).collect(Collectors.toList());
    }

    public static List<RptDisplayColumnEntity> getRptDisplayColumnEntity(String rptFormId) {
        Map<String, RptShowNodeVo> nodeVoMap = RptShowNodeHelper.queryRptShowNodeMap(rptFormId);
        if (CollectionUtils.isEmpty(nodeVoMap)) {
            return null;
        }
        ArrayList colList = Lists.newArrayListWithExpectedSize((int)nodeVoMap.size());
        LinkedHashMap colMap = Maps.newLinkedHashMapWithExpectedSize((int)nodeVoMap.size());
        for (Map.Entry<String, RptShowNodeVo> nodeVoEntry : nodeVoMap.entrySet()) {
            String nodeNum = nodeVoEntry.getKey();
            RptShowNodeVo nodeVo = nodeVoEntry.getValue();
            if (!nodeVo.isShow()) continue;
            RptDisplayColumnEntity colEntity = colMap.computeIfAbsent(nodeNum, val -> RptDisplayService.createColEntity(nodeVo));
            String parentNumber = nodeVo.getParentNumber();
            if (StringUtils.isEmpty((Object)parentNumber)) {
                colList.add(colEntity);
                continue;
            }
            RptDisplayColumnEntity parentColEntity = colMap.computeIfAbsent(parentNumber, val -> RptDisplayService.createColEntity((RptShowNodeVo)nodeVoMap.get(val)));
            parentColEntity.addChildren(colEntity);
        }
        return colList;
    }

    public static RptDisplayColumnEntity createColEntity(RptShowNodeVo nodeVo) {
        if (nodeVo == null) {
            return null;
        }
        RptDisplayColumnEntity colEntity = new RptDisplayColumnEntity();
        colEntity.setFieldName(nodeVo.getName());
        colEntity.setFieldValue(nodeVo.getNumber());
        colEntity.setColumnWidth(nodeVo.getColumnWidth());
        colEntity.setAlignment(nodeVo.getAlignment());
        colEntity.setFieldAlias(nodeVo.getQueryField());
        colEntity.setFieldType(nodeVo.getFieldType());
        colEntity.addCustomParam("isdimension", (Object)(nodeVo.isDimension() ? "1" : "0"));
        colEntity.setSecondaryHeader(nodeVo.getSecondHeadName());
        return colEntity;
    }
}

