/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.report;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hsbp.business.report.RptShowNodeVo;

public class RptShowNodeHelper {
    public static String select = "number,name,group.id,parent.number,index,queryfield,secondheadname,fieldtype,columnwidth,alignment,isshow,fixfieldindex,isdimension,ismorefilter,morefiltername,morefilterindex";
    public static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hsbs_rptshownode");

    public static DynamicObject[] queryRptShowNodeDyns(String rptFormId) {
        return serviceHelper.query(select, new QFilter[]{new QFilter("group.number", "=", (Object)rptFormId)}, "parent,index");
    }

    public static List<RptShowNodeVo> getMoreFilterNodes(String rptFormId) {
        QFilter filter = new QFilter("group.number", "=", (Object)rptFormId);
        filter.and("ismorefilter", "=", (Object)"1");
        DynamicObject[] nodeDyns = serviceHelper.query(select, new QFilter[]{filter}, "parent,index");
        if (nodeDyns == null || nodeDyns.length == 0) {
            return null;
        }
        return Arrays.stream(nodeDyns).map(obj -> RptShowNodeHelper.createRptShowNodeVo(obj)).collect(Collectors.toList());
    }

    public static List<RptShowNodeVo> queryFixFieldNodes(String rptFormId) {
        QFilter filter = new QFilter("group.number", "=", (Object)rptFormId);
        filter.and("fixfieldindex", ">", (Object)0);
        DynamicObject[] nodeDyns = serviceHelper.query(select, new QFilter[]{filter}, "fixfieldindex");
        if (nodeDyns == null || nodeDyns.length == 0) {
            return null;
        }
        return Arrays.stream(nodeDyns).map(obj -> RptShowNodeHelper.createRptShowNodeVo(obj)).collect(Collectors.toList());
    }

    public static Map<String, RptShowNodeVo> queryRptShowNodeMap(String rptFormId) {
        DynamicObject[] nodeDyns = RptShowNodeHelper.queryRptShowNodeDyns(rptFormId);
        if (nodeDyns == null || nodeDyns.length == 0) {
            return null;
        }
        LinkedHashMap nodeVoMap = Maps.newLinkedHashMapWithExpectedSize((int)nodeDyns.length);
        for (DynamicObject nodeDyn : nodeDyns) {
            RptShowNodeVo nodeVo = RptShowNodeHelper.createRptShowNodeVo(nodeDyn);
            nodeVoMap.put(nodeVo.getNumber(), nodeVo);
        }
        return nodeVoMap;
    }

    public static RptShowNodeVo createRptShowNodeVo(DynamicObject nodeDyn) {
        RptShowNodeVo nodeVo = new RptShowNodeVo();
        nodeVo.setNumber(nodeDyn.getString("number"));
        nodeVo.setName(nodeDyn.getString("name"));
        nodeVo.setGroupId(nodeDyn.getLong("group.id"));
        nodeVo.setParentNumber(nodeDyn.getString("parent.number"));
        nodeVo.setIndex(nodeDyn.getInt("index"));
        nodeVo.setQueryField(nodeDyn.getString("queryfield"));
        nodeVo.setSecondHeadName(nodeDyn.getString("secondheadname"));
        nodeVo.setFieldType(nodeDyn.getString("fieldtype"));
        nodeVo.setColumnWidth(nodeDyn.getInt("columnwidth"));
        nodeVo.setAlignment(nodeDyn.getString("alignment"));
        nodeVo.setShow(nodeDyn.getBoolean("isshow"));
        nodeVo.setFixfieldindex(nodeDyn.getInt("fixfieldindex"));
        nodeVo.setDimension(nodeDyn.getBoolean("isdimension"));
        nodeVo.setMoreFilter(nodeDyn.getBoolean("ismorefilter"));
        nodeVo.setMoreFilterName(nodeDyn.getString("morefiltername"));
        return nodeVo;
    }
}

