/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.salaryitem.filter;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.proration.HandleProrationHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCListUtils;

public class GetValidSalaryItemInSalaryFileService {
    public static GetValidSalaryItemInSalaryFileService createInstance() {
        return new GetValidSalaryItemInSalaryFileService();
    }

    public HashSet<Long> getSalaryItemInCalRuleList(DynamicObjectCollection calRuleItemColl) {
        return calRuleItemColl.stream().map(calRuleItem -> calRuleItem.getLong("salaryitem.id")).collect(Collectors.toCollection(HashSet::new));
    }

    public Map<Long, HashSet<Long>> getValidSalaryItemMap(Collection<Long> validSalaryFileIdList, Date startDate, Date endDate, HashSet<Long> salaryItemIDInCalRuleSet) {
        HashMap<Long, HashSet<Long>> allValidSalaryItemInSalaryFileMap = new HashMap<Long, HashSet<Long>>(16);
        if (salaryItemIDInCalRuleSet == null || salaryItemIDInCalRuleSet.isEmpty()) {
            return allValidSalaryItemInSalaryFileMap;
        }
        for (Long salaryFileId : validSalaryFileIdList) {
            HashSet<Long> defaultSalaryItemIdSet = new HashSet<Long>(salaryItemIDInCalRuleSet);
            allValidSalaryItemInSalaryFileMap.put(salaryFileId, defaultSalaryItemIdSet);
        }
        HashSet<Long> excludeSalaryFileIdSet = new HashSet<Long>(16);
        Map<Long, HashSet<Long>> itemGrpIdSetGroupBySalaryFileIdMap = this.getItemGrpIdSetGroupBySalaryFileIdMap(validSalaryFileIdList, startDate, endDate, excludeSalaryFileIdSet);
        if (itemGrpIdSetGroupBySalaryFileIdMap.isEmpty()) {
            return allValidSalaryItemInSalaryFileMap;
        }
        startDate = HandleProrationHelper.replaceDateTime(startDate, "00:00:00");
        endDate = HandleProrationHelper.replaceDateTime(endDate, "23:59:59");
        Map<Long, HashSet<Long>> salaryItemIdInSalaryGroupByItemGrpMap = this.getValidSalaryItemGroupByItemGrpIdMap(itemGrpIdSetGroupBySalaryFileIdMap.values(), startDate, endDate);
        if (salaryItemIdInSalaryGroupByItemGrpMap.isEmpty()) {
            return allValidSalaryItemInSalaryFileMap;
        }
        for (Map.Entry allValidSalaryItemMapInSalaryFileEntry : allValidSalaryItemInSalaryFileMap.entrySet()) {
            HashSet<Long> itemGrpIdSet;
            Long salaryFileId = (Long)allValidSalaryItemMapInSalaryFileEntry.getKey();
            if (excludeSalaryFileIdSet.contains(salaryFileId) || (itemGrpIdSet = itemGrpIdSetGroupBySalaryFileIdMap.get(salaryFileId)) == null) continue;
            HashSet<Long> sumSalaryItemIdSet = new HashSet<Long>(16);
            for (Long itemGrpId : itemGrpIdSet) {
                HashSet<Long> salaryItemIdSet = salaryItemIdInSalaryGroupByItemGrpMap.get(itemGrpId);
                if (salaryItemIdSet == null || salaryItemIdSet.isEmpty()) continue;
                sumSalaryItemIdSet.addAll(salaryItemIdSet);
            }
            sumSalaryItemIdSet.retainAll(salaryItemIDInCalRuleSet);
            allValidSalaryItemInSalaryFileMap.put(salaryFileId, sumSalaryItemIdSet);
        }
        return allValidSalaryItemInSalaryFileMap;
    }

    private Map<Long, HashSet<Long>> getItemGrpIdSetGroupBySalaryFileIdMap(Collection<Long> validSalaryFileIdList, Date startDate, Date endDate, HashSet<Long> excludeSalaryFileIdSet) {
        HashMap<Long, HashSet<Long>> itemGrpMap = new HashMap<Long, HashSet<Long>>(16);
        SWCDataServiceHelper itemGrpCfgHisHelper = new SWCDataServiceHelper("hsas_itemgrpcfg");
        QFilter dateFilter = HandleProrationHelper.getDateFilter(startDate, endDate);
        QFilter salaryFileFilter = new QFilter("salaryfile", "in", validSalaryFileIdList);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        BaseDataHisHelper.addHisVerFilter(salaryFileFilter);
        String selectProperties = "bsed,type,salaryfile.id,itemgrp.id,id";
        String orderBy = "salaryfile.id, bsed asc";
        DynamicObject[] itemGrpCfgHisDyObjArr = itemGrpCfgHisHelper.query(selectProperties, new QFilter[]{dateFilter, salaryFileFilter, dataStatusFilter}, orderBy);
        if (itemGrpCfgHisDyObjArr == null || itemGrpCfgHisDyObjArr.length == 0) {
            return itemGrpMap;
        }
        long tmpSalaryFileId = -1L;
        for (int i = 0; i < itemGrpCfgHisDyObjArr.length; ++i) {
            DynamicObject itemGrpCfgHis = itemGrpCfgHisDyObjArr[i];
            long salaryFileId = itemGrpCfgHis.getLong("salaryfile.id");
            boolean isDifferent = tmpSalaryFileId != salaryFileId;
            tmpSalaryFileId = isDifferent ? salaryFileId : tmpSalaryFileId;
            String itemGrpType = itemGrpCfgHis.getString("type");
            if (excludeSalaryFileIdSet.contains(salaryFileId)) continue;
            if (!"1".equals(itemGrpType)) {
                excludeSalaryFileIdSet.add(salaryFileId);
                continue;
            }
            if (isDifferent && startDate.before(itemGrpCfgHis.getDate("bsed"))) {
                excludeSalaryFileIdSet.add(salaryFileId);
                continue;
            }
            long itemGrpId = itemGrpCfgHis.getLong("itemgrp.id");
            HashSet itemGrpSet = itemGrpMap.computeIfAbsent(salaryFileId, val -> new HashSet(16));
            itemGrpSet.add(itemGrpId);
        }
        return itemGrpMap;
    }

    private Map<Long, HashSet<Long>> getValidSalaryItemGroupByItemGrpIdMap(Collection<HashSet<Long>> itemGrpIdCollInSalaryFiles, Date startDate, Date endDate) {
        HashMap<Long, HashSet<Long>> salaryItemIdSetInSalaryGroupByItemGrpIdMap = new HashMap<Long, HashSet<Long>>(16);
        if (itemGrpIdCollInSalaryFiles.isEmpty()) {
            return salaryItemIdSetInSalaryGroupByItemGrpIdMap;
        }
        HashSet<Long> allItemGroupIdSet = new HashSet<Long>(16);
        itemGrpIdCollInSalaryFiles.forEach(allItemGroupIdSet::addAll);
        DynamicObject[] itemGroupHisDyObjArr = this.getItemGroupHisDyObjArr(startDate, endDate, allItemGroupIdSet);
        if (itemGroupHisDyObjArr == null || itemGroupHisDyObjArr.length == 0) {
            return salaryItemIdSetInSalaryGroupByItemGrpIdMap;
        }
        HashMap salaryItemIdGroupByItemGroupIdMap = new HashMap(16);
        HashMap salaryItemTypeIdGroupByItemGroupIdMap = new HashMap(16);
        HashMap<Long, HashSet<Long>> excludeSalaryItemIdGroupByItemGroupIdMap = new HashMap<Long, HashSet<Long>>(16);
        HashSet<Long> allSalaryItemTypeIdSet = new HashSet<Long>(16);
        for (DynamicObject salaryItemDyObj : itemGroupHisDyObjArr) {
            HashSet<Long> salaryItemSet = new HashSet<Long>(16);
            HashSet<Long> salaryItemTypeIdSet = new HashSet<Long>(16);
            HashSet<Long> excludeSalaryItemIdSet = new HashSet<Long>(16);
            long itemGrpId = salaryItemDyObj.getLong("boid");
            DynamicObjectCollection salaryItemList = salaryItemDyObj.getDynamicObjectCollection("slitementry");
            DynamicObjectCollection salaryItemTypeList = salaryItemDyObj.getDynamicObjectCollection("slitemtypeentry");
            if (!SWCListUtils.isEmpty((List)salaryItemList)) {
                for (DynamicObject salaryItem : salaryItemList) {
                    long salaryItemId = salaryItem.getLong("salaryitem.id");
                    salaryItemSet.add(salaryItemId);
                }
            }
            if (!SWCListUtils.isEmpty((List)salaryItemTypeList)) {
                for (DynamicObject salaryItemType : salaryItemTypeList) {
                    long salaryItemTypeId = salaryItemType.getLong("salaryitemtype.id");
                    salaryItemTypeIdSet.add(salaryItemTypeId);
                    allSalaryItemTypeIdSet.add(salaryItemTypeId);
                    DynamicObjectCollection excludeSalaryItemSubEntry = salaryItemType.getDynamicObjectCollection("excslitemsubentry");
                    if (SWCListUtils.isEmpty((List)excludeSalaryItemSubEntry)) continue;
                    this.addExcludeSalaryItemIdSet(excludeSalaryItemIdSet, excludeSalaryItemSubEntry, "excsalaryitem.id");
                }
            }
            salaryItemIdGroupByItemGroupIdMap.put(itemGrpId, salaryItemSet);
            salaryItemTypeIdGroupByItemGroupIdMap.put(itemGrpId, salaryItemTypeIdSet);
            excludeSalaryItemIdGroupByItemGroupIdMap.put(itemGrpId, excludeSalaryItemIdSet);
        }
        Map<Long, HashSet<Long>> salaryItemMapGroupByTypeMap = this.getSalaryItemMapGroupByTypeMap(allSalaryItemTypeIdSet);
        for (Map.Entry salaryItemIdGroupByItemGroupIdEntry : salaryItemIdGroupByItemGroupIdMap.entrySet()) {
            HashSet lastSalaryItemSet = null;
            long itemGrpId = (Long)salaryItemIdGroupByItemGroupIdEntry.getKey();
            HashSet firstSalaryItemSet = (HashSet)salaryItemIdGroupByItemGroupIdEntry.getValue();
            HashSet excludeSalaryItemIdSet = (HashSet)excludeSalaryItemIdGroupByItemGroupIdMap.get(itemGrpId);
            lastSalaryItemSet = firstSalaryItemSet;
            if (!salaryItemMapGroupByTypeMap.isEmpty()) {
                HashSet salaryItemTypeIdSet = (HashSet)salaryItemTypeIdGroupByItemGroupIdMap.get(itemGrpId);
                for (Long salaryItemTypeId : salaryItemTypeIdSet) {
                    HashSet<Long> tempSalaryItemSetInType = salaryItemMapGroupByTypeMap.get(salaryItemTypeId);
                    if (tempSalaryItemSetInType == null || tempSalaryItemSetInType.isEmpty()) continue;
                    lastSalaryItemSet.addAll(tempSalaryItemSetInType);
                }
                if (lastSalaryItemSet != null && !lastSalaryItemSet.isEmpty()) {
                    lastSalaryItemSet.removeAll(excludeSalaryItemIdSet);
                }
            }
            salaryItemIdSetInSalaryGroupByItemGrpIdMap.put(itemGrpId, lastSalaryItemSet);
        }
        return salaryItemIdSetInSalaryGroupByItemGrpIdMap;
    }

    private void addExcludeSalaryItemIdSet(HashSet<Long> excludeSalaryItemIdSet, DynamicObjectCollection excludeSalaryItemSubEntry, String itemIdKey) {
        for (DynamicObject excludeSalaryItem : excludeSalaryItemSubEntry) {
            long excludeSalaryItemId = excludeSalaryItem.getLong(itemIdKey);
            excludeSalaryItemIdSet.add(excludeSalaryItemId);
        }
    }

    private DynamicObject[] getItemGroupHisDyObjArr(Date startDate, Date endDate, HashSet<Long> allItemGroupIdSet) {
        SWCDataServiceHelper itemGroupHisHelper = new SWCDataServiceHelper("hsas_itemgroup");
        QFilter dateFilter = HandleProrationHelper.getDateFilter(startDate, endDate);
        QFilter pkIdFileFilter = new QFilter("boid", "in", allItemGroupIdSet);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        String selectProperties = "boid,slitementry.salaryitem,slitemtypeentry.salaryitemtype,excslitemsubentry.excsalaryitem";
        BaseDataHisHelper.addHisVerFilter(pkIdFileFilter);
        return itemGroupHisHelper.query(selectProperties, new QFilter[]{dateFilter, pkIdFileFilter, dataStatusFilter});
    }

    private Map<Long, HashSet<Long>> getSalaryItemMapGroupByTypeMap(HashSet<Long> allSalaryItemTypeIdSet) {
        HashMap<Long, HashSet<Long>> salaryItemMapGroupByTypeMap = new HashMap<Long, HashSet<Long>>(16);
        if (allSalaryItemTypeIdSet.isEmpty()) {
            return salaryItemMapGroupByTypeMap;
        }
        SWCDataServiceHelper salaryItemHelper = new SWCDataServiceHelper("hsbs_salaryitem");
        QFilter statusFilter = new QFilter("status", "in", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "in", (Object)"1");
        QFilter salaryItemTypeFilter = new QFilter("salaryitemtype", "in", allSalaryItemTypeIdSet);
        Object[] salaryItemDyObjArr = salaryItemHelper.query("salaryitemtype,id", new QFilter[]{statusFilter, enableFilter, salaryItemTypeFilter});
        if (SWCArrayUtils.isEmpty((Object[])salaryItemDyObjArr)) {
            return salaryItemMapGroupByTypeMap;
        }
        for (Object salaryItemDyObj : salaryItemDyObjArr) {
            HashSet tempSalaryItemIdSet = salaryItemMapGroupByTypeMap.computeIfAbsent(salaryItemDyObj.getLong("salaryitemtype.id"), salaryItemTypeId -> new HashSet(16));
            tempSalaryItemIdSet.add(salaryItemDyObj.getLong("id"));
        }
        return salaryItemMapGroupByTypeMap;
    }
}

