/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.servicehelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCBaseDataHelper {
    private SWCBaseDataHelper() {
    }

    public static Map<String, Long> buildBaseDataIdAndNumberRelation(String entityName, List<String> numberList) {
        return SWCBaseDataHelper.buildBaseDataIdAndNumberRelation(entityName, numberList, null, null);
    }

    public static Map<String, Long> buildBaseDataIdAndNumberRelation(String entityName, List<String> numberList, List<QFilter> filterList) {
        return SWCBaseDataHelper.buildBaseDataIdAndNumberRelation(entityName, numberList, filterList, null);
    }

    public static Map<String, Long> buildBaseDataIdAndNumberRelation(String entityName, List<String> numberList, List<QFilter> filterList, String numberPropName) {
        String numberProp = "number";
        if (SWCStringUtils.isNotEmpty((String)numberPropName)) {
            numberProp = numberPropName;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        String field = "id," + numberProp;
        ArrayList<QFilter> queryList = new ArrayList<QFilter>(10);
        QFilter filter = new QFilter(numberProp, "in", numberList);
        queryList.add(filter);
        if (filterList != null && filterList.size() > 0) {
            queryList.addAll(filterList);
        }
        HashMap<String, Long> retMap = new HashMap<String, Long>(16);
        QFilter[] filters = new QFilter[queryList.size()];
        queryList.toArray(filters);
        DynamicObjectCollection dataColl = helper.queryOriginalCollection(field, filters);
        if (dataColl == null || dataColl.size() == 0) {
            return retMap;
        }
        for (DynamicObject dataObj : dataColl) {
            Long id = dataObj.getLong("id");
            String number = dataObj.getString(numberProp);
            retMap.put(number, id);
        }
        return retMap;
    }

    public static String getEntityPropKey(String entityNumber, String propEntityNumber) {
        String fileProp = null;
        Map mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber).getFields();
        for (Map.Entry entry : mainEntityType.entrySet()) {
            BasedataProp prop;
            if (!(entry.getValue() instanceof BasedataProp) || !propEntityNumber.equals((prop = (BasedataProp)entry.getValue()).getBaseEntityId())) continue;
            fileProp = (String)entry.getKey();
            break;
        }
        return fileProp;
    }
}

