/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.servicehelper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.bussiness.cert.HRBizCertSignHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCUnifiedThreadPoolFactory;
import kd.swc.hsbp.common.enums.SWCUnifiedTaskTypeEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public final class SWCCertCommonHelper {
    public static final String PAYROLL_CERTENTITY = "hsbs_certdetail";
    public static final String PAYROLL_CERTSCENEENTITY = "hsbs_certscenedetail";
    public static final String HCDM_CERTENTITY = "hcdm_certdetail";
    public static final String HCDM_CERTSCENEENTITY = "hcdm_certscenedetail";
    private static final Log logger = LogFactory.getLog(SWCCertCommonHelper.class);
    private static final ExecutorService UPDATEBIZASSIGNDATA_POOL = ThreadPools.newExecutorService((String)"SWC_UPDATEBIZASSIGNDATA_POOL", (int)2);
    private static final Map<String, Pair<String, String>> appToCertEntityMap = Maps.newHashMap();
    private static final Map<String, String> appToSceneMap = Maps.newHashMap();
    private static final Map<String, String> groupToCertEntityMap = Maps.newHashMap();

    public static Map<String, Object> verifyCert(String appId, String formId, List<Long> pids) {
        SWCCertCommonHelper.checkWhiteList(true);
        HashSet pidSet = Sets.newHashSet(pids);
        Map map = HRCertCommonHelper.verifyCertCount((String)appId, (String)formId);
        logger.info("verifyCert: {}", (Object)JSON.toJSONString((Object)map));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)5);
        if (StringUtils.equals((String)((String)map.get("infoType")), (String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            resultMap.put("result", Boolean.FALSE);
            resultMap.put("datas", pidSet);
            resultMap.put("msg", map);
            map.put("showMessageType", "1");
            resultMap.put("isforbidden", Boolean.TRUE);
            logger.info("verifyCertresultMap1: {}", (Object)JSON.toJSONString((Object)resultMap));
            return resultMap;
        }
        String groupId = SWCCertCommonHelper.getGroupId(appId, formId);
        Set<Long> hasCertPid = SWCCertCommonHelper.checkForged(appId, formId, Lists.newArrayList((Iterable)pidSet), groupId);
        if (hasCertPid.size() == pidSet.size()) {
            resultMap.put("result", Boolean.TRUE);
            resultMap.put("datas", Collections.emptyList());
            map.put("showMessageType", SWCCertCommonHelper.calcShowMessageTypeWithInfoType((String)map.get("infoType")));
            resultMap.put("msg", map);
            resultMap.put("isforbidden", Boolean.FALSE);
        } else {
            List collection = ListUtils.removeAll((Collection)pidSet, hasCertPid);
            resultMap.put("result", Boolean.FALSE);
            resultMap.put("datas", collection);
            map.put("showMessageType", "1");
            String errorMessage = MessageFormat.format(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u5173\u4eba\u5458\u6ca1\u6709\u5206\u914d\u201c{0}\u201d\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SWCCertCommonHelper_1", (String)"swc-hsbp-business", (Object[])new Object[0]), HRCertCommonHelper.getGroupName((String)groupId));
            map.put("message", errorMessage);
            map.put("showMessage", "true");
            resultMap.put("msg", map);
            resultMap.put("isforbidden", Boolean.TRUE);
        }
        logger.info("verifyCertresultMap2: {}", (Object)JSON.toJSONString((Object)resultMap));
        return resultMap;
    }

    private static String getGroupId(String appId, String formId) {
        return HRCertCommonHelper.getGroupIdByBizObjID((String)appId, (String)formId);
    }

    public static Map<String, String> verifyCertCount(String appId, String formId) {
        return HRCertCommonHelper.verifyCertCount((String)appId, (String)formId);
    }

    public static Map<String, Object> verifyCertForApply(String appId, String formId, List<Long> pids) {
        SWCCertCommonHelper.checkWhiteList(true);
        Map map = HRCertCommonHelper.verifyCertCount((String)appId, (String)formId);
        logger.info("verifyCertForApply1: {}", (Object)JSON.toJSONString((Object)map));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)5);
        if (StringUtils.equals((String)((String)map.get("infoType")), (String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            resultMap.put("result", Boolean.FALSE);
            resultMap.put("datas", pids);
            resultMap.put("msg", map);
            map.put("showMessageType", "1");
            resultMap.put("isforbidden", Boolean.TRUE);
            logger.info("verifyCertForApplyresultMap1: {}", (Object)JSON.toJSONString((Object)resultMap));
            return resultMap;
        }
        String groupId = SWCCertCommonHelper.getGroupId(appId, formId);
        Set<Long> hasCertPid = SWCCertCommonHelper.checkForged(appId, formId, pids, groupId);
        List collection = ListUtils.removeAll(pids, hasCertPid);
        if (collection.size() == 0) {
            resultMap.put("result", Boolean.TRUE);
            resultMap.put("datas", collection);
            resultMap.put("msg", map);
            map.put("showMessageType", SWCCertCommonHelper.calcShowMessageTypeWithInfoType((String)map.get("infoType")));
            resultMap.put("isforbidden", Boolean.FALSE);
            logger.info("verifyCertForApplyresultMap2: {}", (Object)JSON.toJSONString((Object)resultMap));
            return resultMap;
        }
        Map checkCountMap = HRCertCommonHelper.verifyCertCount((String)groupId, (int)collection.size());
        logger.info("verifyCertForApply2: {}", (Object)JSON.toJSONString((Object)checkCountMap));
        boolean forbidden = StringUtils.equals((String)((String)checkCountMap.get("infoType")), (String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName());
        resultMap.put("result", !forbidden);
        resultMap.put("datas", collection);
        resultMap.put("msg", checkCountMap);
        checkCountMap.put("showMessageType", SWCCertCommonHelper.calcShowMessageTypeWithInfoType((String)checkCountMap.get("infoType")));
        resultMap.put("isforbidden", forbidden);
        logger.info("verifyCertForApplyresultMap3: {}", (Object)JSON.toJSONString((Object)resultMap));
        return resultMap;
    }

    public static Map<String, Object> updateCert(String appId, String formId, List<Long> pids) {
        SWCCertCommonHelper.checkWhiteList(true);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)5);
        resultMap.put("result", Boolean.TRUE);
        resultMap.put("isforbidden", Boolean.FALSE);
        resultMap.put("datas", Collections.emptyList());
        String groupId = SWCCertCommonHelper.getGroupId(appId, formId);
        String scene = SWCCertCommonHelper.getScene(appId);
        Set<Long> hasCertPid = SWCCertCommonHelper.checkForged(appId, formId, pids, groupId);
        SWCCertCommonHelper.insertCertSceneDetail(hasCertPid, appId, formId, scene);
        List collection = ListUtils.removeAll(pids, hasCertPid);
        ArrayList leftPidForApply = Lists.newArrayList((Iterable)collection);
        if (SWCListUtils.isEmpty((List)leftPidForApply)) {
            return resultMap;
        }
        Map map = HRCertCommonHelper.updateUsedCertCount((String)appId, (String)formId, (int)collection.size());
        logger.info("updateCert: {}", (Object)JSON.toJSONString((Object)map));
        if (!leftPidForApply.isEmpty()) {
            try (TXHandle td = TX.required();){
                try {
                    DynamicObject[] certDetails = SWCCertCommonHelper.generateCertDetail(appId, groupId, leftPidForApply);
                    SWCCertCommonHelper.generateCertSceneDetail(certDetails, appId, scene);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    td.markRollback();
                    throw e;
                }
            }
        }
        resultMap.put("result", Boolean.TRUE);
        resultMap.put("datas", Collections.emptyList());
        resultMap.put("msg", map);
        map.put("showMessageType", SWCCertCommonHelper.calcShowMessageTypeWithInfoType((String)map.get("infoType")));
        resultMap.put("isforbidden", Boolean.FALSE);
        logger.info("updateCertresultMap: {}", (Object)JSON.toJSONString((Object)resultMap));
        return resultMap;
    }

    private static void insertCertSceneDetail(Set<Long> hasCertPid, String appId, String formId, String scene) {
        DynamicObject[] certDetails = SWCCertCommonHelper.queryCertDetail(appId, formId, Lists.newArrayList(hasCertPid));
        List<Long> certDetailPkIds = SWCCertCommonHelper.fetchPk(certDetails);
        String certSceneEntity = SWCCertCommonHelper.getCertEntity(appId, false);
        DynamicObject[] certSceneDetailIds = SWCCertCommonHelper.queryCertScene(certSceneEntity, certDetailPkIds, scene);
        Set existSceneOfCertDetail = Arrays.stream(certSceneDetailIds).map(dy -> dy.getLong("certdetail_id")).collect(Collectors.toSet());
        HashSet certDetailOfNeedAdd = Sets.newHashSet();
        for (DynamicObject certDetail : certDetails) {
            if (existSceneOfCertDetail.contains(certDetail.getLong("id"))) continue;
            certDetailOfNeedAdd.add(certDetail);
        }
        if (!certDetailOfNeedAdd.isEmpty()) {
            SWCCertCommonHelper.generateCertSceneDetail(certDetailOfNeedAdd.toArray(new DynamicObject[0]), appId, scene);
        }
    }

    private static void generateCertSceneDetail(DynamicObject[] certDetails, String appId, String scene) {
        String certSceneEntity = SWCCertCommonHelper.getCertEntity(appId, false);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)certSceneEntity);
        long[] pkIds = IDService.get().genLongIds(certDetails.length);
        ArrayList rows = Lists.newArrayListWithExpectedSize((int)certDetails.length);
        Date now = new Date();
        for (int i = 0; i < certDetails.length; ++i) {
            DynamicObject certDetail = certDetails[i];
            long certDetailPkId = certDetail.getLong("id");
            DynamicObject row = new DynamicObject((DynamicObjectType)entityType);
            row.set("scene", (Object)scene);
            row.set("createtime", (Object)now);
            row.set("certdetail", (Object)certDetailPkId);
            row.set("id", (Object)pkIds[i]);
            rows.add(row);
        }
        SaveServiceHelper.save((DynamicObject[])rows.toArray(new DynamicObject[0]));
    }

    private static String getScene(String appId) {
        String scene = appToSceneMap.get(appId);
        if (scene == null) {
            throw new KDBizException(MessageFormat.format("appToScene config is error, appid={0}", scene));
        }
        return scene;
    }

    public static void releaseCert(String appId, String formId, List<Long> pids) {
        SWCCertCommonHelper.checkWhiteList(true);
        String scene = SWCCertCommonHelper.getScene(appId);
        DynamicObject[] certDetailObjs = SWCCertCommonHelper.queryCertDetail(appId, formId, pids);
        List<Long> certDetailPkIds = SWCCertCommonHelper.fetchPk(certDetailObjs);
        String certSceneEntity = SWCCertCommonHelper.getCertEntity(appId, false);
        DynamicObject[] certSceneDetailObjs = SWCCertCommonHelper.queryCertScene(certSceneEntity, certDetailPkIds, scene);
        List<Long> certSceneDetailIds = SWCCertCommonHelper.fetchPk(certSceneDetailObjs);
        try (TXHandle td = TX.required();){
            try {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)certSceneEntity), (Object[])certSceneDetailIds.toArray(new Long[0]));
                SWCCertCommonHelper.deleteCertDetailBySceneCount(appId, certDetailPkIds);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                td.markRollback();
            }
        }
    }

    private static List<Long> fetchPk(DynamicObject[] certDetailObjs) {
        return Arrays.stream(certDetailObjs).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    private static DynamicObject[] queryCertScene(String certSceneEntity, List<Long> certDetailPkIds, String scene) {
        QFilter certDetailFilter = new QFilter("certdetail.id", "in", certDetailPkIds);
        QFilter sceneFilter = new QFilter("scene", "=", (Object)scene);
        return BusinessDataServiceHelper.load((String)certSceneEntity, (String)"id,scene,certdetail", (QFilter[])new QFilter[]{certDetailFilter, sceneFilter});
    }

    @NotNull
    private static Set<Long> checkForged(String appId, String formId, List<Long> pids, String groupId) {
        DynamicObject[] details = SWCCertCommonHelper.queryCertDetail(appId, formId, pids);
        boolean isForged = false;
        HashSet hasCertPid = Sets.newHashSetWithExpectedSize((int)pids.size());
        for (DynamicObject detail : details) {
            long pid = detail.getLong("pid");
            String pidStr = String.valueOf(pid);
            String shaStr = detail.getString("shastr");
            String signData = SWCCertCommonHelper.getSignData(groupId, pidStr);
            if (StringUtils.isEmpty((String)shaStr) || !StringUtils.equals((String)signData, (String)shaStr)) {
                isForged = true;
                break;
            }
            hasCertPid.add(pid);
        }
        if (isForged) {
            String errorMessage = MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SWCCertCommonHelper_0", (String)"swc-hsbp-business", (Object[])new Object[0]), HRCertCommonHelper.getGroupName((String)groupId));
            throw new KDBizException(errorMessage);
        }
        return hasCertPid;
    }

    private static String calcShowMessageTypeWithInfoType(String infoType) {
        String showMessageType = "2";
        if (StringUtils.equals((String)infoType, (String)HRCertPromptInfoTypeEnum.WARNING.getName()) || StringUtils.equals((String)infoType, (String)HRCertPromptInfoTypeEnum.EXCEED.getName())) {
            showMessageType = "2";
        }
        if (StringUtils.equals((String)infoType, (String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            showMessageType = "1";
        }
        return showMessageType;
    }

    private static DynamicObject[] generateCertDetail(String appId, String groupId, List<Long> pids) {
        String certEntity = SWCCertCommonHelper.getCertEntity(appId, true);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)certEntity);
        ArrayList rows = Lists.newArrayListWithExpectedSize((int)pids.size());
        long[] pkIds = IDService.get().genLongIds(pids.size());
        for (int i = 0; i < pids.size(); ++i) {
            Long pid = pids.get(i);
            DynamicObject row = new DynamicObject((DynamicObjectType)entityType);
            String pidStr = String.valueOf(pid);
            String signData = SWCCertCommonHelper.getSignData(groupId, pidStr);
            row.set("pid", (Object)pid);
            row.set("shastr", (Object)signData);
            row.set("groupid", (Object)groupId);
            row.set("id", (Object)pkIds[i]);
            rows.add(row);
        }
        DynamicObject[] dynamicObjects = rows.toArray(new DynamicObject[0]);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        return rows.toArray(new DynamicObject[0]);
    }

    private static String getSignData(String groupId, String pidStr) {
        RequestContext requestContext = RequestContext.get();
        String accountId = requestContext.getAccountId();
        String salt = MessageFormat.format("{0}-{1}-{2}", pidStr, groupId, accountId);
        return HRBizCertSignHelper.getSignData((String)pidStr, (String)salt);
    }

    private static void deleteCertDetail(String appId, String groupId, List<Long> pids) {
        String certEntity = SWCCertCommonHelper.getCertEntity(appId, true);
        QFilter pidFilter = new QFilter("pid", "in", pids);
        QFilter groupFilter = new QFilter("groupid", "=", (Object)groupId);
        DeleteServiceHelper.delete((String)certEntity, (QFilter[])new QFilter[]{pidFilter, groupFilter});
    }

    private static void deleteCertDetailBySceneCount(String appId, List<Long> certDetailIds) {
        String certSceneEntity = SWCCertCommonHelper.getCertEntity(appId, false);
        String certEntity = SWCCertCommonHelper.getCertEntity(appId, true);
        QFilter certDetailIdFilter = new QFilter("certdetail.id", "in", certDetailIds);
        DynamicObject[] sceneDetail = BusinessDataServiceHelper.load((String)certSceneEntity, (String)"id,certdetail,scene", (QFilter[])new QFilter[]{certDetailIdFilter});
        Set holdDetailIds = Arrays.stream(sceneDetail).map(dy -> dy.getLong("certdetail_id")).collect(Collectors.toSet());
        Collection needDeleteDetailIds = CollectionUtils.removeAll(certDetailIds, holdDetailIds);
        if (!needDeleteDetailIds.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)certEntity), (Object[])needDeleteDetailIds.toArray());
        }
    }

    public static DynamicObject[] queryCertDetail(String appId, String formId, List<Long> pids) {
        String certEntity = SWCCertCommonHelper.getCertEntity(appId, true);
        String groupId = SWCCertCommonHelper.getGroupId(appId, formId);
        QFilter groupFilter = QFilter.of((String)"groupid=?", (Object[])new Object[]{groupId});
        QFilter pidFilter = new QFilter("pid", "in", pids);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)certEntity, (String)"id,pid,shastr,", (QFilter[])new QFilter[]{groupFilter, pidFilter});
        return objects;
    }

    private static String getCertEntity(String appId, boolean isMainEntity) {
        Pair<String, String> certEntity = appToCertEntityMap.get(appId);
        if (certEntity == null) {
            throw new KDBizException(MessageFormat.format("current appid not found cert entity, appid is {0}", appId));
        }
        return isMainEntity ? (String)certEntity.getLeft() : (String)certEntity.getRight();
    }

    private static void checkWhiteList(boolean ignore) {
        if (ignore) {
            return;
        }
        ArrayList whiteList = Lists.newArrayList((Object[])new String[]{"kd.swc.hsas.formplugin.web.guide.CalPayrollTaskCalList", "kd.swc.hsas.formplugin.web.calpersonlist.CalPersonCalOperateList", "kd.swc.hspp.formplugin.web.login.SalaryPwdInitPlugin"});
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        Set stackClass = Arrays.stream(stackTrace).map(StackTraceElement::getClassName).collect(Collectors.toSet());
        boolean exist = false;
        for (String white : whiteList) {
            if (!stackClass.contains(white)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            throw new KDBizException(ResManager.loadKDString((String)"HRLicenseManage error: current call is not allowed.", (String)"SWCCertCommonHelper_2", (String)"swc-hsbp-business", (Object[])new Object[0]));
        }
    }

    public static void updateCertDetail(String groupId) {
        String certEntity = groupToCertEntityMap.get(groupId);
        if (certEntity == null) {
            return;
        }
        SWCUnifiedThreadPoolFactory.SERVICE.execute(() -> {
            QFilter idFilter;
            QFilter groupFilter;
            DynamicObject[] objects;
            Map checkCountMap = HRCertCommonHelper.verifyCertCount((String)groupId);
            if (null == checkCountMap || HRCertPromptInfoTypeEnum.FORBIDDEN.getName().equals(checkCountMap.get("infoType"))) {
                logger.error("updateCertDetail verifyCertCount return FORBIDDEN");
                return;
            }
            Long maxId = 0L;
            while ((objects = BusinessDataServiceHelper.load((String)certEntity, (String)"id,pid,shastr,groupid", (QFilter[])new QFilter[]{groupFilter = QFilter.of((String)"groupid=?", (Object[])new Object[]{groupId}), idFilter = new QFilter("id", ">", (Object)maxId)}, (String)"id", (int)10000)) != null && objects.length != 0) {
                maxId = objects[objects.length - 1].getLong("id");
                for (DynamicObject obj : objects) {
                    String signData = SWCCertCommonHelper.getSignData(obj.getString("groupid"), obj.getString("pid"));
                    obj.set("shastr", (Object)signData);
                }
                SaveServiceHelper.update((DynamicObject[])objects);
            }
        }, SWCUnifiedTaskTypeEnum.SWC_CERTUPDATETHREADPOOL.getKey(), RequestContext.get(), OperationContext.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCertDate(String appId) {
        logger.info("clearCertDate...begin");
        String certEntity = SWCCertCommonHelper.getCertEntity(appId, true);
        String certSceneEntity = SWCCertCommonHelper.getCertEntity(appId, false);
        SWCDataServiceHelper certHelper = new SWCDataServiceHelper(certEntity);
        DynamicObject[] certArr = certHelper.query("id, pid, groupid", null);
        logger.info("clearCertDate...certArr.length={}", (Object)certArr.length);
        HashMap<String, ArrayList<DynamicObject>> certMap = new HashMap<String, ArrayList<DynamicObject>>(10000);
        ArrayList<Long> waitDelCerts = new ArrayList<Long>(10);
        for (DynamicObject cert : certArr) {
            String ckey = cert.getString("pid") + "|" + cert.getString("groupid");
            ArrayList<DynamicObject> certList = (ArrayList<DynamicObject>)certMap.get(ckey);
            if (certList == null) {
                certList = new ArrayList<DynamicObject>(10);
                certMap.put(ckey, certList);
            }
            certList.add(cert);
        }
        for (List certs : certMap.values()) {
            if (certs.size() == 1) continue;
            for (int i = 1; i < certs.size(); ++i) {
                waitDelCerts.add(((DynamicObject)certs.get(i)).getLong("id"));
            }
        }
        if (waitDelCerts.isEmpty()) {
            logger.info("clearCertDate...no waitDelCerts");
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            certHelper.delete(waitDelCerts.toArray());
            SWCDataServiceHelper certSceneHelper = new SWCDataServiceHelper(certSceneEntity);
            QFilter detailFilter = new QFilter("certdetail", "in", waitDelCerts);
            certSceneHelper.deleteByFilter(new QFilter[]{detailFilter});
            txHandle.commit();
        }
        logger.info("clearCertDate...end");
    }

    static {
        appToCertEntityMap.put("/US+X3ECAB+C", (Pair<String, String>)Pair.of((Object)PAYROLL_CERTENTITY, (Object)PAYROLL_CERTSCENEENTITY));
        appToCertEntityMap.put("0B1N=ELCC71V", (Pair<String, String>)Pair.of((Object)PAYROLL_CERTENTITY, (Object)PAYROLL_CERTSCENEENTITY));
        appToCertEntityMap.put("1ANC8T4UC434", (Pair<String, String>)Pair.of((Object)PAYROLL_CERTENTITY, (Object)PAYROLL_CERTSCENEENTITY));
        appToCertEntityMap.put("/UHLXNRR9KPZ", (Pair<String, String>)Pair.of((Object)PAYROLL_CERTENTITY, (Object)PAYROLL_CERTSCENEENTITY));
        appToCertEntityMap.put("0NXW1VOPH+QV", (Pair<String, String>)Pair.of((Object)PAYROLL_CERTENTITY, (Object)PAYROLL_CERTSCENEENTITY));
        appToCertEntityMap.put("/UHMBBGZQ65X", (Pair<String, String>)Pair.of((Object)PAYROLL_CERTENTITY, (Object)PAYROLL_CERTSCENEENTITY));
        appToCertEntityMap.put("0VO5EV13=I9W", (Pair<String, String>)Pair.of((Object)HCDM_CERTENTITY, (Object)HCDM_CERTSCENEENTITY));
        appToSceneMap.put("/US+X3ECAB+C", "payroll");
        appToSceneMap.put("0B1N=ELCC71V", "payroll");
        appToSceneMap.put("1ANC8T4UC434", "payroll");
        appToSceneMap.put("/UHLXNRR9KPZ", "payroll");
        appToSceneMap.put("0NXW1VOPH+QV", "payroll");
        appToSceneMap.put("/UHMBBGZQ65X", "payroll");
        appToSceneMap.put("0VO5EV13=I9W", "hcdm");
        groupToCertEntityMap.put("518", PAYROLL_CERTENTITY);
        groupToCertEntityMap.put("580", HCDM_CERTENTITY);
    }
}

