/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.servicehelper;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.SWCExrateInfo;

public class SWCExrateServiceHelper {
    private SWCExrateServiceHelper() {
    }

    public static SWCExrateInfo getExrate(Long curId, Long orgcurId, Date exratedate, Long exratetableId, String exctype) {
        BigDecimal one = new BigDecimal("1");
        SWCExrateInfo exrateInfo = new SWCExrateInfo();
        if (0L == curId || 0L == orgcurId) {
            return null;
        }
        if (SWCObjectUtils.equals((Object)curId, (Object)orgcurId)) {
            exrateInfo.setExrateValue(one);
            return exrateInfo;
        }
        if (null == exratedate || SWCStringUtils.isEmpty((String)exctype)) {
            return null;
        }
        DynamicObject exrateObject = SWCExrateServiceHelper.queryExrateObject(curId, orgcurId, exratedate, exratetableId, exctype);
        if (exrateObject != null) {
            exrateInfo.setExrateValue(exrateObject.getBigDecimal("excval"));
            exrateInfo.setExrateRowId(Long.valueOf(exrateObject.getLong("id")));
        }
        return exrateInfo;
    }

    public static DynamicObject queryExrateObject(Long curId, Long orgcurId, Date exratedate, Long exratetableId, String exctype) {
        QFilter[] filters;
        DynamicObject[] exrateTrees;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("bd_exrate_tree");
        String properties = "id,cur,orgcur,excval,indirectexrate,effectdate";
        QFilter filter_date = new QFilter("effectdate", "=", (Object)exratedate);
        QFilter filter_less_date = new QFilter("effectdate", "<=", (Object)exratedate);
        QFilter filter_table = new QFilter("exctable", "=", (Object)exratetableId);
        QFilter curFilter = new QFilter("cur", "=", (Object)curId);
        QFilter orgcurFilter = new QFilter("orgcur", "=", (Object)orgcurId);
        QFilter exctypeFilter = new QFilter("exctype", "like", (Object)exctype);
        QFilter defaultFilter = SWCExrateServiceHelper.getDefaultFilter();
        if (SWCStringUtils.equals((String)"1", (String)exctype)) {
            QFilter[] filters2 = new QFilter[]{curFilter, orgcurFilter, filter_date, filter_table, defaultFilter};
            return helper.queryOne(properties, filters2);
        }
        if (SWCStringUtils.equals((String)"2", (String)exctype) && (exrateTrees = helper.query(properties, filters = new QFilter[]{curFilter, orgcurFilter, exctypeFilter, filter_table, filter_less_date, defaultFilter}, "effectdate desc")) != null && exrateTrees.length > 0) {
            return exrateTrees[0];
        }
        return null;
    }

    private static QFilter getDefaultFilter() {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        return filter;
    }

    public static SWCExrateInfo getExrate(DynamicObject cur, DynamicObject orgcur, Date exratedate, DynamicObject exratetable, String exctype) {
        BigDecimal one = new BigDecimal("1");
        SWCExrateInfo exrateInfo = new SWCExrateInfo();
        if (null == cur || null == orgcur) {
            return null;
        }
        if (SWCObjectUtils.equals((Object)cur.getLong("id"), (Object)orgcur.getLong("id"))) {
            exrateInfo.setExrateValue(one);
            return exrateInfo;
        }
        if (null == exratedate || SWCStringUtils.isEmpty((String)exctype)) {
            return null;
        }
        return SWCExrateServiceHelper.getExrate(cur.getLong("id"), orgcur.getLong("id"), exratedate, exratetable.getLong("id"), exctype);
    }
}

