/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.servicehelper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hsbp.business.history.BaseDataHistoryHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCHisBaseDataHelper {
    private SWCHisBaseDataHelper() {
    }

    public static List<String> getEntryEntitys(MainEntityType mainEntityType) {
        ArrayList<String> entitys = new ArrayList<String>();
        Map entityTypeMap = mainEntityType.getAllEntities();
        for (Map.Entry entry : entityTypeMap.entrySet()) {
            if (!(entry.getValue() instanceof EntryType) || entry.getValue() instanceof SubEntryType) continue;
            entitys.add((String)entry.getKey());
        }
        return entitys;
    }

    public static Map<String, List<String>> getSubEntryEntitys(MainEntityType mainEntityType) {
        HashMap<String, List<String>> subEntryEntityMap = new HashMap<String, List<String>>();
        Map entityTypeMap = mainEntityType.getAllEntities();
        for (Map.Entry entry : entityTypeMap.entrySet()) {
            if (!(entry.getValue() instanceof SubEntryType)) continue;
            String entryEntity = ((EntityType)entry.getValue()).getParent().getName();
            String subEntryEntity = (String)entry.getKey();
            ArrayList<String> subEntryentitys = (ArrayList<String>)subEntryEntityMap.get(entryEntity);
            if (subEntryentitys == null) {
                subEntryentitys = new ArrayList<String>();
                subEntryEntityMap.put(entryEntity, subEntryentitys);
            }
            subEntryentitys.add(subEntryEntity);
        }
        return subEntryEntityMap;
    }

    public static List<String> getAllEntitys(MainEntityType mainEntityType) {
        Map entityTypeMap = mainEntityType.getAllEntities();
        Iterator entries = entityTypeMap.entrySet().iterator();
        ArrayList<String> entitys = new ArrayList<String>(entityTypeMap.size());
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            entitys.add((String)entry.getKey());
        }
        return entitys;
    }

    public static Map<String, List<String>> getEntityFieldsMap(MainEntityType mainEntityType) {
        Map entityTypeMap = mainEntityType.getAllEntities();
        HashMap<String, List<String>> entityFieldsMap = new HashMap<String, List<String>>(entityTypeMap.size());
        for (Map.Entry entry : entityTypeMap.entrySet()) {
            String entity = (String)entry.getKey();
            EntityType entityType = (EntityType)entry.getValue();
            Map fieldsMap = entityType.getFields();
            ArrayList<String> fields = new ArrayList<String>(fieldsMap.size());
            for (Map.Entry entry01 : fieldsMap.entrySet()) {
                IDataEntityProperty entityProperty = (IDataEntityProperty)entry01.getValue();
                fields.add(entityProperty.getName());
            }
            entityFieldsMap.put(entity, fields);
        }
        return entityFieldsMap;
    }

    public static Map<String, List<IDataEntityProperty>> getEntityPropertiesMap(MainEntityType mainEntityType) {
        Map entityTypeMap = mainEntityType.getAllEntities();
        HashMap<String, List<IDataEntityProperty>> entityFieldsMap = new HashMap<String, List<IDataEntityProperty>>(entityTypeMap.size());
        for (Map.Entry entry : entityTypeMap.entrySet()) {
            String entity = (String)entry.getKey();
            EntityType entityType = (EntityType)entry.getValue();
            Map fieldsMap = entityType.getFields();
            ArrayList<IDataEntityProperty> fields = new ArrayList<IDataEntityProperty>(fieldsMap.size());
            for (Map.Entry entry01 : fieldsMap.entrySet()) {
                IDataEntityProperty entityProperty = (IDataEntityProperty)entry01.getValue();
                fields.add(entityProperty);
            }
            entityFieldsMap.put(entity, fields);
        }
        return entityFieldsMap;
    }

    public static String getSelectProperties(MainEntityType mainEntityType) {
        List<String> allFields = SWCHisBaseDataHelper.getAllFields(mainEntityType);
        Map entityTypes = mainEntityType.getAllEntities();
        for (EntityType entityType : entityTypes.values()) {
            if (!(entityType instanceof EntryType)) continue;
            allFields.add(entityType.getName() + "." + ((EntryType)entityType).getSeqProperty().getName());
        }
        return SWCBaseUtils.join(allFields, (String)",");
    }

    public static String getSelectProperties(String entityNumber) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return SWCHisBaseDataHelper.getSelectProperties(mainEntityType);
    }

    public static List<String> getAllFields(MainEntityType mainEntityType) {
        ArrayList<String> fields = new ArrayList<String>();
        Map fieldTypeMap = mainEntityType.getAllFields();
        for (Map.Entry entry : fieldTypeMap.entrySet()) {
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            if (entityProperty instanceof BasedataProp) {
                fields.add(entityProperty.getName() + ".id");
            } else {
                fields.add(entityProperty.getName());
            }
            if (!(entityProperty instanceof LargeTextProp)) continue;
            fields.add(entityProperty.getName() + "_tag");
        }
        return fields;
    }

    public static List<String> getFields(MainEntityType mainEntityType) {
        Map fieldTypeMap = mainEntityType.getFields();
        Iterator entries = fieldTypeMap.entrySet().iterator();
        ArrayList<String> fields = new ArrayList<String>(fieldTypeMap.size());
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            fields.add(entityProperty.getName());
        }
        return fields;
    }

    public static List<IDataEntityProperty> getEntityPropeties(MainEntityType mainEntityType) {
        Map fieldTypeMap = mainEntityType.getFields();
        Iterator entries = fieldTypeMap.entrySet().iterator();
        ArrayList<IDataEntityProperty> propeties = new ArrayList<IDataEntityProperty>(fieldTypeMap.size());
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            propeties.add(entityProperty);
        }
        return propeties;
    }

    public static List<String> getEntityFields(MainEntityType mainEntityType, String entryEntity) {
        EntityType type = (EntityType)mainEntityType.getAllEntities().get(entryEntity);
        Map fieldsMap = type.getFields();
        Iterator entries = fieldsMap.entrySet().iterator();
        ArrayList<String> fields = new ArrayList<String>(fieldsMap.size());
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            fields.add(entityProperty.getName());
        }
        return fields;
    }

    public static List<String> getEntityFieldsOnlyId(MainEntityType mainEntityType, String entryEntity) {
        EntityType type = (EntityType)mainEntityType.getAllEntities().get(entryEntity);
        Map fieldsMap = type.getFields();
        Iterator entries = fieldsMap.entrySet().iterator();
        ArrayList<String> fields = new ArrayList<String>(fieldsMap.size());
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            if (SWCStringUtils.isEmpty((String)entityProperty.getAlias())) continue;
            if (entityProperty instanceof BasedataProp) {
                fields.add(entityProperty.getName() + ".id");
                continue;
            }
            fields.add(entityProperty.getName());
        }
        return fields;
    }

    public static List<IDataEntityProperty> getEntityPropeties(MainEntityType mainEntityType, String entryEntity) {
        EntityType type = (EntityType)mainEntityType.getAllEntities().get(entryEntity);
        Map fieldsMap = type.getFields();
        Iterator entries = fieldsMap.entrySet().iterator();
        ArrayList<IDataEntityProperty> fields = new ArrayList<IDataEntityProperty>(fieldsMap.size());
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            fields.add(entityProperty);
        }
        return fields;
    }

    public static String getCurrEntityByHis(String hisEntity) {
        return hisEntity.substring(0, hisEntity.length() - 3);
    }

    public static String getHisEntityByCurr(String currEntity) {
        return currEntity + "his";
    }

    private static void addNewSubEntryEntitys(Map<String, List<String>> subEntryEntityMap, Map<String, List<IDataEntityProperty>> fieldMaps, SWCDataServiceHelper serviceHelper, DynamicObject newDynamicObject, String entryEntity, DynamicObjectCollection coll) {
        List<String> entryEntityList = subEntryEntityMap.get(entryEntity);
        for (String subEntry : entryEntityList) {
            SWCHisBaseDataHelper.addNewSubEntryEntitysForOne(fieldMaps, serviceHelper, newDynamicObject, entryEntity, coll, subEntry);
        }
    }

    private static void addNewSubEntryEntitysForOne(Map<String, List<IDataEntityProperty>> fieldMaps, SWCDataServiceHelper serviceHelper, DynamicObject newDynamicObject, String entryEntity, DynamicObjectCollection coll, String subEntry) {
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject dyObj = (DynamicObject)coll.get(i);
            DynamicObjectCollection subEntryEntityColl = dyObj.getDynamicObjectCollection(subEntry);
            if (subEntryEntityColl == null || subEntryEntityColl.isEmpty()) continue;
            DynamicObjectCollection entryEntityColl = newDynamicObject.getDynamicObjectCollection(entryEntity);
            DynamicObjectCollection subEntryEntityEmptyColl = ((DynamicObject)entryEntityColl.get(i)).getDynamicObjectCollection(subEntry);
            int index = 1;
            for (DynamicObject entryDynamicObject : subEntryEntityColl) {
                DynamicObject newSubDynamicObject = serviceHelper.generateEmptyEntryDynamicObject(newDynamicObject, subEntry);
                List<IDataEntityProperty> subEntryFields = fieldMaps.get(subEntry);
                for (IDataEntityProperty property : subEntryFields) {
                    String entryField = property.getName();
                    if (property instanceof MulBasedataProp) {
                        SWCHisBaseDataHelper.copyMulBaseDataField(entryDynamicObject, newSubDynamicObject, entryField);
                    } else {
                        newSubDynamicObject.set(entryField, entryDynamicObject.get(entryField));
                    }
                    if (!(property instanceof LargeTextProp)) continue;
                    newSubDynamicObject.set(entryField + "_tag", entryDynamicObject.get(entryField + "_tag"));
                }
                newSubDynamicObject.set("seq", (Object)index);
                subEntryEntityEmptyColl.add((Object)newSubDynamicObject);
                ++index;
            }
        }
    }

    private static void addNewEntryEntitys(SWCDataServiceHelper serviceHelper, DynamicObject newDynamicObject, String entryEntity, List<IDataEntityProperty> entryFields, DynamicObjectCollection coll) {
        DynamicObjectCollection newColl = newDynamicObject.getDynamicObjectCollection(entryEntity);
        int index = 1;
        for (DynamicObject entryDdynamicObject : coll) {
            DynamicObject newEntryDy = serviceHelper.generateEmptyEntryDynamicObject(newDynamicObject, entryEntity);
            for (IDataEntityProperty property : entryFields) {
                String entryField = property.getName();
                if (property instanceof MulBasedataProp) {
                    SWCHisBaseDataHelper.copyMulBaseDataField(entryDdynamicObject, newEntryDy, entryField);
                } else {
                    newEntryDy.set(entryField, entryDdynamicObject.get(entryField));
                }
                if (!(property instanceof LargeTextProp)) continue;
                newEntryDy.set(entryField + "_tag", entryDdynamicObject.get(entryField + "_tag"));
            }
            newEntryDy.set("seq", (Object)index);
            newColl.add((Object)newEntryDy);
            ++index;
        }
    }

    public static ILocaleString getAndSetHisShowName(DynamicObject newHisDynamicObject) {
        return null;
    }

    public static final ListShowParameter getBaseDataHisListShowParemeter(String parentPageId, String currFormId, Long boId) {
        ListShowParameter showParam = new ListShowParameter();
        return showParam;
    }

    public static final BillShowParameter getBaseDataHisPageBillShowParameter(String parentPageId, String currFormId, Long boId, Long mvid, Long vid, String showName) {
        HashMap map = new HashMap();
        BillShowParameter showParam = (BillShowParameter)BillShowParameter.createFormShowParameter(map);
        return showParam;
    }

    public static final DynamicObject[] getHisDataList(String entityNumber, Long boId, Long currVid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityNumber);
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties(mainEntityType);
        QFilter filter = new QFilter("boid", "=", (Object)boId);
        filter.and("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        if (currVid != 0L) {
            filter.and("id", "<>", (Object)currVid);
        }
        return helper.query(selectProperties, new QFilter[]{filter}, "bsed desc");
    }

    public static final void setBredAndBrled(DynamicObject[] dataEntities) {
        for (DynamicObject data : dataEntities) {
            SWCHisBaseDataHelper.setBredAndBrled(data);
        }
    }

    public static final void setBredAndBrled(DynamicObject data) {
        if (data.getDate("bsed") == null) {
            data.set("bsed", (Object)SWCDateTimeUtils.getTodayDateWithoutTime());
        } else {
            data.set("bsed", (Object)SWCDateTimeUtils.truncateDate((Date)data.getDate("bsed")));
        }
        if (data.getDate("bsled") == null) {
            data.set("bsled", (Object)BaseDataHistoryHelper.getDefBsled());
        } else {
            data.set("bsled", (Object)SWCDateTimeUtils.truncateDate((Date)data.getDate("bsled")));
        }
    }

    public static void setModifyInfo(DynamicObject[] dataEntities) {
        String nowUserId = RequestContext.get().getUserId();
        Date nowDate = new Date();
        for (DynamicObject dynamicObject : dataEntities) {
            dynamicObject.set("modifier", (Object)nowUserId);
            dynamicObject.set("modifytime", (Object)nowDate);
        }
    }

    public static final boolean isDateEqualsMaxBrled(Date date) {
        if (date == null) {
            return true;
        }
        String dateStr = SWCDateTimeUtils.formatDate((Date)date, null);
        return "2999-12-31".equals(dateStr);
    }

    public static void copyMulBaseDataField(DynamicObject oldDynamicObject, DynamicObject newDynamicObject, String mulBaseDataField) {
        DynamicObjectCollection newMulBasedataColl = new DynamicObjectCollection();
        DynamicObjectCollection mulBasedataColl = oldDynamicObject.getDynamicObjectCollection(mulBaseDataField);
        for (DynamicObject mulBasedataDy : mulBasedataColl) {
            DynamicObject copyDynObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)mulBasedataDy, (boolean)false, (boolean)true);
            copyDynObj.getDataEntityState().setDirty(true);
            newMulBasedataColl.add((Object)copyDynObj);
        }
        newDynamicObject.set(mulBaseDataField, (Object)newMulBasedataColl);
    }

    public static DynamicObjectCollection getMulBaseDataDyColl(String entityName, List<Long> fieldValueIds, String fieldName, String mulBasedataEntity) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        DynamicObject dyObj = helper.generateEmptyDynamicObject();
        DynamicObjectCollection dyColl = dyObj.getDynamicObjectCollection(fieldName);
        DynamicObjectType dynamicObjectType = dyColl.getDynamicObjectType();
        for (int i = 0; i < fieldValueIds.size(); ++i) {
            DynamicObject mulBasedataDy = new DynamicObject(dynamicObjectType);
            DynamicObject personDy = helper.generateEmptyDynamicObject(mulBasedataEntity);
            personDy.set("id", (Object)fieldValueIds.get(i));
            mulBasedataDy.set("fbasedataid", (Object)personDy);
            dyColl.add((Object)mulBasedataDy);
        }
        return dyColl;
    }

    public static void setMulBaseDataFieldValue(DynamicObject dynamicObject, String mulBaseDataField, List<Long> baseDataIds) {
        MulBasedataProp mulBasedataProp = (MulBasedataProp)dynamicObject.getDataEntityType().getProperties().get((Object)mulBaseDataField);
        DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        BasedataProp basedataProp = (BasedataProp)subEntityType.getProperties().get((Object)"fbasedataid");
        DynamicObjectCollection rows = (DynamicObjectCollection)mulBasedataProp.getValue((Object)dynamicObject);
        for (Long baseDataId : baseDataIds) {
            DynamicObject newRow = new DynamicObject(subEntityType);
            rows.add((Object)newRow);
            DynamicObject newBasedataObj = BusinessDataServiceHelper.loadSingleFromCache((Object)baseDataId, (DynamicObjectType)basedataProp.getDynamicComplexPropertyType());
            basedataProp.setValue((Object)newRow, (Object)newBasedataObj);
        }
    }

    public static DynamicObject transferDynamicObject(DynamicObject from, String toEntity, Set<String> ignoreField, Map<String, String> mappingField) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(toEntity);
        DynamicObject newDynamicObject = serviceHelper.generateEmptyDynamicObject();
        SWCHisBaseDataHelper.transferDynamicObject(from, newDynamicObject, ignoreField, mappingField);
        return newDynamicObject;
    }

    public static void transferDynamicObject(DynamicObject from, DynamicObject to, Set<String> ignoreField, Map<String, String> mappingField) {
        MainEntityType fromMainEntityType = (MainEntityType)from.getDataEntityType();
        String toEntity = to.getDataEntityType().getName();
        MainEntityType toMainEntityType = (MainEntityType)to.getDataEntityType();
        List<String> entryEntitys = SWCHisBaseDataHelper.getEntryEntitys(toMainEntityType);
        Map<String, List<String>> subEntryEntityMap = SWCHisBaseDataHelper.getSubEntryEntitys(toMainEntityType);
        Map<String, List<IDataEntityProperty>> fieldMaps = SWCHisBaseDataHelper.getEntityPropertiesMap(toMainEntityType);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(toEntity);
        for (IDataEntityProperty property : fieldMaps.get(toEntity)) {
            String fieldName = property.getName();
            if (ignoreField != null && ignoreField.contains(fieldName)) continue;
            SWCHisBaseDataHelper.setFieldValue(from, to, fromMainEntityType, property, fieldName, mappingField);
        }
        for (String entryEntity : entryEntitys) {
            to.getDynamicObjectCollection(entryEntity).clear();
            DynamicObjectCollection coll = from.getDynamicObjectCollection(entryEntity);
            if (coll == null || coll.isEmpty()) continue;
            List<IDataEntityProperty> entryFields = fieldMaps.get(entryEntity);
            SWCHisBaseDataHelper.addNewEntryEntitys(serviceHelper, to, entryEntity, entryFields, coll);
            if (!subEntryEntityMap.containsKey(entryEntity)) continue;
            SWCHisBaseDataHelper.addNewSubEntryEntitys(subEntryEntityMap, fieldMaps, serviceHelper, to, entryEntity, coll);
        }
    }

    private static void setFieldValue(DynamicObject from, DynamicObject to, MainEntityType fromMainEntityType, IDataEntityProperty property, String fieldName, Map<String, String> mappingField) {
        String fromField = null;
        if (mappingField != null) {
            fromField = mappingField.get(fieldName);
        }
        if (fromField != null) {
            to.set(fieldName, from.get(fromField));
            return;
        }
        fromField = fieldName;
        if (!fromMainEntityType.getProperties().containsKey((Object)fromField)) {
            return;
        }
        if (property instanceof MulBasedataProp) {
            SWCHisBaseDataHelper.copyMulBaseDataField(from, to, fieldName);
        } else {
            to.set(fieldName, from.get(fieldName));
        }
        if (property instanceof LargeTextProp) {
            to.set(fieldName + "_tag", from.get(fieldName + "_tag"));
        }
    }
}

