/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.servicehelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCPersonServiceHelper {
    private static final String SELECT_PROPS = "id, fuid, number, name, phone, email, gender, birthday, idcard";

    public static Map<String, Object> getUserInfoByNumber(String userNumber) {
        Map<String, Object> userInfo = new HashMap<String, Object>(16);
        QFilter numberFilter = new QFilter("number", "=", (Object)userNumber);
        Object[] userDyobjs = BusinessDataServiceHelper.load((String)"bos_user", (String)SELECT_PROPS, (QFilter[])new QFilter[]{numberFilter});
        if (!SWCArrayUtils.isEmpty((Object[])userDyobjs)) {
            Object userDyobj = userDyobjs[0];
            userInfo = SWCPersonServiceHelper.putDyobjToMap((DynamicObject)userDyobj);
        }
        return userInfo;
    }

    public static List<Map<String, Object>> getUserInfoByNumber(List<String> userNumber) {
        QFilter numberFilter = new QFilter("number", "in", userNumber);
        DynamicObject[] userDyobjs = BusinessDataServiceHelper.load((String)"bos_user", (String)SELECT_PROPS, (QFilter[])new QFilter[]{numberFilter});
        ArrayList<Map<String, Object>> userInfos = new ArrayList<Map<String, Object>>(userDyobjs.length);
        for (DynamicObject userInfoDyobj : userDyobjs) {
            Map<String, Object> userInfo = SWCPersonServiceHelper.putDyobjToMap(userInfoDyobj);
            userInfos.add(userInfo);
        }
        return userInfos;
    }

    public static List<Map<String, Object>> getUserInfoByMap(Map<String, String> userMap) {
        ArrayList<Map<String, Object>> userInfos = new ArrayList<Map<String, Object>>();
        String number = userMap.get("number");
        if (!SWCStringUtils.isEmpty((String)number)) {
            DynamicObject[] userDyobjs;
            QFilter qFilters = new QFilter("number", "=", (Object)number);
            for (Map.Entry<String, String> entry : userMap.entrySet()) {
                String mapKey = entry.getKey();
                String mapValue = entry.getValue();
                if (SWCStringUtils.isEmpty((String)mapValue) || SWCStringUtils.equals((String)mapKey, (String)"number") || SWCStringUtils.equals((String)mapKey, (String)"name")) continue;
                qFilters.or(new QFilter(mapKey, "=", (Object)mapValue));
            }
            for (DynamicObject userDyobj : userDyobjs = BusinessDataServiceHelper.load((String)"bos_user", (String)SELECT_PROPS, (QFilter[])new QFilter[]{qFilters})) {
                Map<String, Object> userInfo = SWCPersonServiceHelper.putDyobjToMap(userDyobj);
                userInfos.add(userInfo);
            }
        }
        return userInfos;
    }

    private static Map<String, Object> putDyobjToMap(DynamicObject userDyobj) {
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("userID", userDyobj.getLong("id"));
        userInfo.put("uid", userDyobj.getString("fuid"));
        userInfo.put("number", userDyobj.getString("number"));
        userInfo.put("name", userDyobj.getString("name"));
        userInfo.put("phone", userDyobj.getString("phone"));
        userInfo.put("email", userDyobj.getString("email"));
        userInfo.put("type", "1");
        userInfo.put("gender", userDyobj.getString("gender"));
        userInfo.put("birthday", userDyobj.getDate("birthday"));
        userInfo.put("idcard", userDyobj.getString("idcard"));
        return userInfo;
    }

    public static Map<String, String> getTargetValueAndNumByTargetValue(List<String> targetValue, String target) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!targetValue.isEmpty()) {
            DynamicObject[] userDyobjs;
            QFilter qFilter = new QFilter(target, "in", targetValue);
            for (DynamicObject userDyobj : userDyobjs = BusinessDataServiceHelper.load((String)"bos_user", (String)(target + ", number"), (QFilter[])new QFilter[]{qFilter})) {
                map.put(userDyobj.getString(target), userDyobj.getString("number"));
            }
        }
        return map;
    }
}

