/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.servicehelper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.IListView;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCShowFormServiceHelper {
    private SWCShowFormServiceHelper() {
    }

    public static final FormShowParameter getOperationResultParameter(String operateName, String title, List<String> failList) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("hsbp_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)operateName);
        parameters.setCustomParam("title", (Object)title);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int len = failList.size();
        for (int index = 0; index < 5 && index < len; ++index) {
            buf.append(failList.get(index)).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)(failList.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        parameters.setCustomParam("failList", failList);
        return parameters;
    }

    public static final FormShowParameter getOperationResultParameter(String operateName, String title, List<String> failList, boolean isSort) {
        ArrayList<String> sortedFailList = new ArrayList<String>(failList);
        if (isSort) {
            Collections.sort(sortedFailList);
        }
        return SWCShowFormServiceHelper.getOperationResultParameter(operateName, title, sortedFailList);
    }

    public static final FormShowParameter getOperationConfirmParameter(CloseCallBack closeCallback, String operateName, String title, List<String> failList) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("hsbp_operationconfirm");
        parameters.setShowTitle(false);
        parameters.setCloseCallBack(closeCallback);
        parameters.setCustomParam("operateName", (Object)operateName);
        parameters.setCustomParam("title", (Object)title);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int len = failList.size();
        for (int index = 0; index < 5 && index < len; ++index) {
            buf.append(failList.get(index)).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)(failList.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        parameters.setCustomParam("failList", failList);
        return parameters;
    }

    public static final FormShowParameter getOperationConfirmParameter(CloseCallBack closeCallback, String operateName, String title, List<String> failList, boolean isSort) {
        ArrayList<String> sortedFailList = new ArrayList<String>(failList);
        if (isSort) {
            Collections.sort(sortedFailList);
        }
        return SWCShowFormServiceHelper.getOperationConfirmParameter(closeCallback, operateName, title, sortedFailList);
    }

    @Deprecated
    public static final BaseShowParameter getBaseShowParameter(IListView listview) {
        long pkId = 0L;
        ListSelectedRow row = null;
        if (listview.getFocusRowPkId() != null) {
            pkId = (Long)listview.getFocusRowPkId();
            row = listview.getCurrentSelectedRowInfo();
        } else if (listview.getSelectedRows() != null && !listview.getSelectedRows().isEmpty()) {
            pkId = (Long)listview.getSelectedRows().get(0).getPrimaryKeyValue();
            row = listview.getSelectedRows().get(0);
        }
        if (row == null) {
            return null;
        }
        String status = row.getBillStatus();
        BillOperationStatus operationStatus = SWCShowFormServiceHelper.getBillOperationStatus(status);
        String formId = listview.getBillFormId();
        if (SWCShowFormServiceHelper.isExists(pkId, formId)) {
            String showName = row.getName();
            if (SWCStringUtils.isEmpty((String)showName)) {
                showName = row.getNumber();
            }
            return SWCShowFormServiceHelper.getShowParamter(formId, pkId, operationStatus, showName);
        }
        return null;
    }

    public static void setShowParameter(BillShowParameter showParameter, IListView listView) {
        long pkId = 0L;
        ListSelectedRow row = null;
        if (listView.getFocusRowPkId() != null) {
            pkId = (Long)listView.getFocusRowPkId();
            row = listView.getCurrentSelectedRowInfo();
        } else if (listView.getSelectedRows() != null && !listView.getSelectedRows().isEmpty()) {
            pkId = (Long)listView.getSelectedRows().get(0).getPrimaryKeyValue();
            row = listView.getSelectedRows().get(0);
        }
        if (row == null) {
            return;
        }
        String status = row.getBillStatus();
        BillOperationStatus operationStatus = SWCShowFormServiceHelper.getBillOperationStatus(status);
        String formId = listView.getBillFormId();
        if (SWCShowFormServiceHelper.isExists(pkId, formId)) {
            String showName = row.getName();
            if (SWCStringUtils.isEmpty((String)showName)) {
                showName = row.getNumber();
            }
            if (BillOperationStatus.VIEW.equals((Object)operationStatus)) {
                showParameter.setStatus(OperationStatus.VIEW);
            } else {
                showParameter.setStatus(OperationStatus.EDIT);
            }
            showParameter.setBillStatus(operationStatus);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
            String caption = mainEntityType.getDisplayName().getLocaleValue();
            if (!SWCStringUtils.isEmpty((String)showName)) {
                caption = mainEntityType.getDisplayName() + " - " + showName;
            }
            showParameter.setCaption(caption);
        }
    }

    @Deprecated
    private static BaseShowParameter getShowParamter(String formId, long pkId, BillOperationStatus operationStatus, String showName) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setBillStatus(operationStatus);
        if (BillOperationStatus.VIEW.equals((Object)operationStatus)) {
            showParameter.setStatus(OperationStatus.VIEW);
        }
        showParameter.setPkId((Object)pkId);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        String caption = mainEntityType.getDisplayName().getLocaleValue();
        if (!SWCStringUtils.isEmpty((String)showName)) {
            caption = mainEntityType.getDisplayName() + " - " + showName;
        }
        showParameter.setCaption(caption);
        String pageId = RequestContext.getOrCreate().getGlobalSessionId() + "modify" + pkId;
        showParameter.setPageId(pageId);
        return showParameter;
    }

    public static FormShowParameter getDateConfirmFormShowParameter(String caption, String tipsContent, boolean mustInput, CloseCallBack cb, String title, String dateCaption, String minDate) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hsbp_brledconfirm");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(caption);
        parameter.setCustomParam("tipsContent", (Object)tipsContent);
        parameter.setCustomParam("mustInput", (Object)mustInput);
        parameter.setCustomParam("title", (Object)title);
        parameter.setCustomParam("dateCaption", (Object)dateCaption);
        parameter.setCustomParam("minDate", (Object)minDate);
        parameter.setCloseCallBack(cb);
        return parameter;
    }

    public static FormShowParameter getBsledConfirmFormShowParameter(String caption, String tipsContent, boolean mustInput, CloseCallBack cb) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hsbp_brledconfirm");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(caption);
        parameter.setCustomParam("tipsContent", (Object)tipsContent);
        parameter.setCustomParam("mustInput", (Object)mustInput);
        parameter.setCloseCallBack(cb);
        return parameter;
    }

    public static BillOperationStatus getBillOperationStatus(String status) {
        if (SWCStringUtils.isEmpty((String)status)) {
            return BillOperationStatus.VIEW;
        }
        switch (status) {
            case "A": {
                return BillOperationStatus.VIEW;
            }
            case "B": {
                return BillOperationStatus.SUBMIT;
            }
            case "C": 
            case "D": 
            case "E": {
                return BillOperationStatus.AUDIT;
            }
        }
        return BillOperationStatus.VIEW;
    }

    public static boolean isExists(Object pkId, String formId) {
        return new SWCDataServiceHelper(formId).isExists(pkId);
    }
}

