/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.taxservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaxCalServiceHelper {
    private static final String HSBS_TAX_CAL_PARAM = "hsbs_tax_cal_param";
    private static final String TAXSERVICE_CALCULATE = "taxservice_calculate";

    public static void setTaxCalCacheMap() {
        Map<String, Object> paramMap = SWCSalaryParameterServiceHelper.getSalaryParam(TAXSERVICE_CALCULATE);
        ISWCAppCache appCache = SWCAppCache.get((String)HSBS_TAX_CAL_PARAM);
        appCache.put(HSBS_TAX_CAL_PARAM, paramMap);
    }

    public static Boolean getTaxCalEnableStatus() {
        ISWCAppCache appCache = SWCAppCache.get((String)HSBS_TAX_CAL_PARAM);
        Map<String, Object> paramMap = (Map<String, Object>)appCache.get(HSBS_TAX_CAL_PARAM, Map.class);
        if (paramMap == null) {
            paramMap = SWCSalaryParameterServiceHelper.getSalaryParam(TAXSERVICE_CALCULATE);
            if (paramMap != null) {
                appCache.put(HSBS_TAX_CAL_PARAM, paramMap);
                Boolean enable = (Boolean)paramMap.get("enableTaxCal");
                return enable == null ? Boolean.FALSE : enable;
            }
            paramMap = new HashMap<String, Object>(16);
            appCache.put(HSBS_TAX_CAL_PARAM, paramMap);
            return Boolean.FALSE;
        }
        Boolean enableTaxCal = (Boolean)paramMap.get("enableTaxCal");
        if (null == enableTaxCal) {
            enableTaxCal = Boolean.FALSE;
        }
        return enableTaxCal;
    }

    public static Boolean getTaxCalEnableStatusByCountryId(long countryId) {
        ISWCAppCache appCache = SWCAppCache.get((String)HSBS_TAX_CAL_PARAM);
        Map<String, Object> paramMap = (Map<String, Object>)appCache.get(HSBS_TAX_CAL_PARAM, Map.class);
        if (paramMap == null && ((paramMap = SWCSalaryParameterServiceHelper.getSalaryParam(TAXSERVICE_CALCULATE)) == null || paramMap.size() == 0)) {
            paramMap = new HashMap<String, Object>(16);
            appCache.put(HSBS_TAX_CAL_PARAM, paramMap);
            return Boolean.FALSE;
        }
        List countryList = (List)paramMap.get("countryInfo");
        if (countryList == null || countryList.size() == 0) {
            return Boolean.FALSE;
        }
        for (Map countryMap : countryList) {
            Object cacheCountryIdObj = countryMap.get("countryId");
            long cacheCountryId = 0L;
            if (cacheCountryIdObj instanceof Long) {
                cacheCountryId = (Long)cacheCountryIdObj;
            } else if (cacheCountryIdObj instanceof Integer) {
                cacheCountryId = Long.parseLong(String.valueOf(cacheCountryIdObj));
            }
            if (countryId != cacheCountryId) continue;
            Boolean enableTaxCal = (Boolean)countryMap.get("enableTaxCal");
            return enableTaxCal;
        }
        return Boolean.FALSE;
    }

    public static Boolean getTaxCalEnableStatusByTaskId(Long taskId) {
        DynamicObject taskObj = new SWCDataServiceHelper("hsas_calpayrolltask").queryOriginalOne("calrulev.id,calrulev.opentaxcal", taskId);
        if (taskObj == null) {
            return Boolean.FALSE;
        }
        return TaxCalServiceHelper.getTaxCalEnableStatusByTask(taskObj);
    }

    public static Boolean getTaxCalEnableStatusByTask(DynamicObject taskObj) {
        String openTaxCal = taskObj.getString("calrulev.opentaxcal");
        if (SWCStringUtils.isEmpty((String)openTaxCal) || SWCStringUtils.equals((String)"0", (String)openTaxCal)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean getTaxCalEnableStatusByCountryNumber(String countryNumber) {
        ISWCAppCache appCache = SWCAppCache.get((String)HSBS_TAX_CAL_PARAM);
        Map<String, Object> paramMap = (Map<String, Object>)appCache.get(HSBS_TAX_CAL_PARAM, Map.class);
        if (paramMap == null && ((paramMap = SWCSalaryParameterServiceHelper.getSalaryParam(TAXSERVICE_CALCULATE)) == null || paramMap.size() == 0)) {
            paramMap = new HashMap<String, Object>(16);
            appCache.put(HSBS_TAX_CAL_PARAM, paramMap);
            return Boolean.FALSE;
        }
        List countryList = (List)paramMap.get("countryInfo");
        if (countryList == null || countryList.size() == 0) {
            return Boolean.FALSE;
        }
        for (Map countryMap : countryList) {
            String cacheCountryNumber = (String)countryMap.get("countryNumber");
            if (!SWCStringUtils.equals((String)cacheCountryNumber, (String)countryNumber)) continue;
            Boolean enableTaxCal = (Boolean)countryMap.get("enableTaxCal");
            return enableTaxCal;
        }
        return Boolean.FALSE;
    }
}

