/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.url;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.control.UrlUtil;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.svc.util.PermissionParam;
import kd.bos.url.UrlService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class SWCURLHelper {
    public static String getSafeUrl(String appNumber, String entityNumber, String downloadUrl) {
        DynamicObject dynamicObject = SWCURLHelper.buildExportLogObj(entityNumber, downloadUrl);
        return SWCURLHelper.convertUrl(appNumber, entityNumber, dynamicObject.getLong("id"));
    }

    private static String convertUrl(String appId, String entityNum, long id) {
        String attachIdOld;
        List permissionParamList;
        String attachId = PermissionParam.genAttacId((String)appId, (String)entityNum, (String)"bos_exportlog", (Object)id, (String)"");
        String url = UrlService.getDomainContextUrl() + "/attachment/download.do?attachId=" + attachId;
        boolean checkFilePermission = ((IAttachmentService)ServiceFactory.getService(IAttachmentService.class)).checkFilePermission();
        String downloadUrl = url + "&a=t";
        if (checkFilePermission && !CollectionUtils.isEmpty((Collection)(permissionParamList = PermissionParam.getPermissionParamList((String)(attachIdOld = UrlUtil.getParam((String)url, (String)"attachId")))))) {
            String attachIdNew = PermissionParam.cachePermissionParam((Map)((Map)permissionParamList.get(0)));
            downloadUrl = url.replace(attachIdOld, attachIdNew) + "&a=t";
        }
        return downloadUrl;
    }

    public static DynamicObject buildExportLogObj(String entityNum, String downloadUrl) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_exportlog");
        DynamicObject obj = (DynamicObject)objType.createInstance();
        ICodeRuleService codeRule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billNo = codeRule.getNumber("bos_exportlog", obj, null);
        obj.set("bizobject", (Object)entityNum);
        obj.set("billstatus", (Object)"C");
        obj.set("exportstatus", (Object)"0");
        obj.set("createtime", (Object)TimeServiceHelper.now());
        obj.set("creator", (Object)RequestContext.get().getCurrUserId());
        obj.set("expttype", (Object)"");
        obj.set("billno", (Object)billNo);
        obj.set("id", (Object)DBServiceHelper.genGlobalLongId());
        obj.set("downloadurl", (Object)downloadUrl);
        SWCDataServiceHelper logHelper = new SWCDataServiceHelper("bos_exportlog");
        logHelper.saveOne(obj);
        return obj;
    }
}

