/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.common.util;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbs.common.vo.ApiXmlData;
import kd.swc.hsbs.common.vo.ApiXmlParam;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XmlUtils {
    private static final Log LOGGER = LogFactory.getLog((String)"XmlUtils");

    private XmlUtils() {
    }

    public static ApiXmlData parse(String xmlData) {
        Document document;
        try (ByteArrayInputStream is = new ByteArrayInputStream(xmlData.getBytes("utf-8"));){
            SAXReader reader = new SAXReader();
            reader.setEncoding("utf-8");
            document = reader.read((InputStream)is);
        }
        catch (Exception e) {
            LOGGER.error("xml \u6587\u4ef6\u8f6c\u6362\u6d41\u5f02\u5e38, \u5185\u5bb9 -> {}", (Object)xmlData);
            throw new KDException((Throwable)e, BosErrorCode.openFileFailed, new Object[]{ResManager.loadResFormat((String)ResManager.loadKDString((String)"%s XML\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef,{0}", (String)"XMLUtils_0", (String)"swc-hsbs-common", (Object[])new Object[]{e.getMessage()}), (String)xmlData, (Object[])new Object[0])});
        }
        Element rootElement = document.getRootElement();
        ApiXmlData apiXmlData = XmlUtils.parseApiMainData(rootElement);
        apiXmlData.setOutputParams(XmlUtils.parseOutputParams(rootElement, apiXmlData));
        apiXmlData.setInputParams(XmlUtils.parseInputParams(rootElement, apiXmlData));
        return apiXmlData;
    }

    private static List<ApiXmlParam> parseInputParams(Element rootElement, ApiXmlData apiXmlData) {
        return new ArrayList<ApiXmlParam>();
    }

    private static ApiXmlData parseApiMainData(Element rootElement) {
        ApiXmlData apiXmlData = new ApiXmlData();
        apiXmlData.setApiType(rootElement.elementText("ApiType"));
        apiXmlData.setBizCloudId(rootElement.elementText("BizCloudId"));
        apiXmlData.setBizAppId(rootElement.elementText("BizAppId"));
        apiXmlData.setId(Long.valueOf(rootElement.elementText("Id")));
        apiXmlData.setNumber(rootElement.elementText("Number"));
        apiXmlData.setKey(rootElement.elementText("Key"));
        apiXmlData.setName(rootElement.elementText("Name"));
        apiXmlData.setDescription(rootElement.elementText("Description"));
        apiXmlData.setService(rootElement.elementText("Service"));
        apiXmlData.setMethod(rootElement.elementText("Method"));
        return apiXmlData;
    }

    private static List<ApiXmlParam> parseOutputParams(Element rootElement, ApiXmlData apiXmlData) {
        List apiEntityElement = Optional.ofNullable(rootElement.element("APIDataXml").elements("APIEntity")).orElseGet(Collections::emptyList);
        ArrayList<ApiXmlParam> resultList = new ArrayList<ApiXmlParam>();
        if (CollectionUtils.isEmpty((Collection)apiEntityElement)) {
            return resultList;
        }
        for (Element entity : apiEntityElement) {
            List<ApiXmlParam> params = XmlUtils.getDataEntityList(rootElement, entity);
            resultList.addAll(params);
        }
        return resultList;
    }

    private static List<ApiXmlParam> getDataEntityList(Element rootElement, Element entityElement) {
        List elements = entityElement.element("APIFields").elements("APIField");
        ArrayList result = Lists.newArrayListWithExpectedSize((int)elements.size());
        String apiName = rootElement.elementText("Name");
        String apiId = rootElement.elementText("Id");
        String apiNumber = rootElement.elementText("Number");
        String apiType = rootElement.elementText("ApiType");
        for (Object data : elements) {
            Element element = (Element)data;
            ApiXmlParam param = new ApiXmlParam();
            if ("2".equals(apiType)) {
                param.setEntityName(apiName);
                param.setEntityNumber(apiId);
            } else {
                param.setEntityName(entityElement.elementText("Description"));
                param.setEntityNumber(entityElement.elementText("Entity"));
            }
            param.setEntityType(apiType);
            param.setKey(element.elementText("Key"));
            param.setName(element.elementText("Name"));
            param.setType(element.elementText("Type"));
            param.setEnable(element.elementText("Enable"));
            param.setQueryField(element.elementText("QueryField"));
            param.setQueryFieldName(element.elementText("QueryFieldName"));
            param.setQueryFieldRelEntity(element.elementText("QueryFieldRelEntity"));
            param.setBaseEntityName(element.elementText("BaseEntityName"));
            result.add(param);
        }
        return result;
    }
}

