/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.basedata.fetchconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.ConditionValueTypeEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.FetchItemCheckResultVo;
import org.apache.commons.collections4.CollectionUtils;

public class FetchConfigHelper {
    public static void saveFetchConfigItem(List<Map<String, Object>> list) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        long configId = (Long)list.get(0).get("fetchConfigId");
        String filterField = FetchConfigHelper.assembleFilterField("1");
        QFilter filter = new QFilter(filterField, "=", (Object)configId);
        helper.deleteByFilter(new QFilter[]{filter});
        ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(10);
        long userId = RequestContext.get().getCurrUserId();
        for (Map<String, Object> single : list) {
            DynamicObject object = helper.generateEmptyDynamicObject();
            object.set("resultfetchconfig", single.get("fetchConfigId"));
            object.set("fetchfieldentry", single.get("fetchFieldEntryId"));
            object.set("fetchitem", single.get("fetchitem"));
            object.set("enable", single.get("enable"));
            object.set("createtime", (Object)new Date());
            object.set("modifytime", (Object)new Date());
            object.set("creator", (Object)userId);
            object.set("modifier", (Object)userId);
            object.set("configtype", single.get("configType"));
            dyList.add(object);
        }
        helper.save(dyList.toArray(new DynamicObject[dyList.size()]));
    }

    public static void updateFetchConfigItem(List<Map<String, Object>> list, String type) {
        SWCDataServiceHelper deleteHelper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter(type, "=", list.get(0).get(type));
        deleteHelper.deleteByFilter(new QFilter[]{filter});
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(10);
        long userId = RequestContext.get().getCurrUserId();
        for (Map<String, Object> single : list) {
            DynamicObject object = helper.generateEmptyDynamicObject();
            object.set("fetchconfig", single.get("fetchconfig"));
            object.set("custfetchconfig", single.get("custfetchconfig"));
            object.set("fetchfieldentry", single.get("fetchfieldentry"));
            object.set("fetchitem", single.get("fetchitem"));
            object.set("enable", single.get("enable"));
            object.set("createtime", (Object)new Date());
            object.set("modifytime", (Object)new Date());
            object.set("creator", (Object)userId);
            object.set("modifier", (Object)userId);
            object.set("configtype", single.get("configType"));
            dyList.add(object);
        }
        helper.save(dyList.toArray(new DynamicObject[dyList.size()]));
    }

    public static FetchItemCheckResultVo checkFetchItemCycle(long relateItemId, List<Long> fetchItemList) {
        if (fetchItemList.contains(relateItemId)) {
            return new FetchItemCheckResultVo("1", FetchConfigHelper.getRelateConfigNameByItemId(fetchItemList));
        }
        if (fetchItemList.size() > 5) {
            return new FetchItemCheckResultVo("2");
        }
        fetchItemList.add(relateItemId);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("fetchitem", "=", (Object)relateItemId);
        filter.and("enable", "=", (Object)"1");
        DynamicObject object = helper.queryOne("fetchfieldentry", new QFilter[]{filter});
        if (object != null && object.getLong("fetchfieldentry") > 0L) {
            helper = new SWCDataServiceHelper("t_hsbs_calitemmatchentry");
            QFilter entryFilter = new QFilter("id", "=", (Object)object.getLong("fetchfieldentry"));
            entryFilter.and("matchfetchitem.id", "=", (Object)relateItemId);
            DynamicObject entryObj = helper.queryOne((Object)"itemtype,fetchitementry.id");
            if (entryObj != null && SWCStringUtils.equals((String)"4", (String)entryObj.getString("itemtype"))) {
                return FetchConfigHelper.checkFetchItemCycle(entryObj.getLong("fetchitementry.id"), fetchItemList);
            }
            return new FetchItemCheckResultVo("0");
        }
        return new FetchItemCheckResultVo("0");
    }

    public static FetchItemCheckResultVo checkBatchFetchItemEnableByIds(List<Long> fetchItemIds, long fetchConfigId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("fetchitem", "in", fetchItemIds);
        filter.and("enable", "=", (Object)"1");
        String fields = "fetchconfig,fetchfieldentry,fetchitem.name,enable,resultfetchconfig,custfetchconfig,configtype";
        DynamicObjectCollection fetchConfigItems = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)fetchConfigItems)) {
            return new FetchItemCheckResultVo("0");
        }
        ArrayList<String> relatedItemList = new ArrayList<String>(10);
        for (DynamicObject obj : fetchConfigItems) {
            String configType = obj.getString("configtype");
            long configId = SWCStringUtils.equals((String)"0", (String)configType) ? obj.getLong("fetchconfig") : (SWCStringUtils.equals((String)"1", (String)configType) ? obj.getLong("resultfetchconfig") : obj.getLong("custfetchconfig"));
            if (configId <= 0L || configId == fetchConfigId) continue;
            relatedItemList.add(obj.getString("fetchitem.name"));
        }
        if (SWCListUtils.isEmpty(relatedItemList)) {
            return new FetchItemCheckResultVo("0");
        }
        return new FetchItemCheckResultVo("3", relatedItemList);
    }

    public static FetchItemCheckResultVo checkBatchFetchItemEnableByEntryIds(List<Long> entryIds, long fetchConfigId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter entryFilter = new QFilter("fetchfieldentry", "in", entryIds);
        DynamicObjectCollection fetchConfigItemObjs = helper.queryOriginalCollection("fetchitem.id", new QFilter[]{entryFilter});
        Set itemIdSet = fetchConfigItemObjs.stream().map(single -> single.getLong("fetchitem.id")).collect(Collectors.toSet());
        if (itemIdSet == null || itemIdSet.size() == 0) {
            return new FetchItemCheckResultVo("0");
        }
        QFilter filter = new QFilter("fetchitem", "in", itemIdSet);
        filter.and("enable", "=", (Object)"1");
        String fields = "fetchconfig,fetchfieldentry,fetchitem.name,enable,resultfetchconfig,custfetchconfig,configtype";
        DynamicObjectCollection fetchConfigItems = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)fetchConfigItems)) {
            return new FetchItemCheckResultVo("0");
        }
        ArrayList<String> relatedItemList = new ArrayList<String>(10);
        for (DynamicObject obj : fetchConfigItems) {
            String configType = obj.getString("configtype");
            long configId = SWCStringUtils.equals((String)"0", (String)configType) ? obj.getLong("fetchconfig") : (SWCStringUtils.equals((String)"1", (String)configType) ? obj.getLong("resultfetchconfig") : obj.getLong("custfetchconfig"));
            if (configId <= 0L || configId == fetchConfigId) continue;
            relatedItemList.add(obj.getString("fetchitem.name"));
        }
        if (SWCListUtils.isEmpty(relatedItemList)) {
            return new FetchItemCheckResultVo("0");
        }
        return new FetchItemCheckResultVo("3", relatedItemList);
    }

    public static FetchItemCheckResultVo checkFetchConfigCycle(long configId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfig");
        QFilter filter = new QFilter("relationentity.valuetype", "=", (Object)ConditionValueTypeEnum.TYPE_FTITEM.getCode());
        filter.and("id", "=", (Object)configId);
        DynamicObjectCollection configItemObjs = helper.queryOriginalCollection("id,name,relationentity.comparevalue,enable", new QFilter[]{filter});
        HashSet<String> itemCodeSet = new HashSet<String>(16);
        if (!SWCListUtils.isEmpty((List)configItemObjs)) {
            for (DynamicObject obj : configItemObjs) {
                String itemCode = obj.getString("relationentity.comparevalue");
                if (SWCStringUtils.isEmpty((String)itemCode)) continue;
                if (itemCode.contains(";")) {
                    String[] itemArr = itemCode.split(";");
                    Collections.addAll(itemCodeSet, itemArr);
                    continue;
                }
                itemCodeSet.add(itemCode);
            }
        }
        if (itemCodeSet.size() > 0) {
            return FetchConfigHelper.checkFetchConfigItemCycle(configId, new ArrayList<String>(itemCodeSet));
        }
        return new FetchItemCheckResultVo("0");
    }

    public static FetchItemCheckResultVo checkFetchConfigItemCycle(long configId, List<String> relationItemList) {
        ArrayList<Long> errConfigList;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("1", "=", (Object)1);
        DynamicObjectCollection fetchConfigItems = helper.queryOriginalCollection("fetchitem.uniquecode,fetchconfig.id,resultfetchconfig.id,custfetchconfig.id,configtype", new QFilter[]{filter});
        HashSet<Long> configIdSet = new HashSet<Long>(16);
        ArrayList<Long> enableConfigList = new ArrayList<Long>(10);
        HashMap<Long, String> configNameMap = new HashMap<Long, String>(16);
        Map<Long, List<String>> allConfigFilterItemMap = FetchConfigHelper.assembleAllConfigFilterItemMap(configIdSet, enableConfigList, configNameMap);
        ArrayList<String> configPathList = new ArrayList<String>(10);
        Map<String, Long> itemConfigMap = FetchConfigHelper.assembleItemConfigMap(fetchConfigItems, configIdSet);
        Set<Long> curFilterConfigSet = FetchConfigHelper.assembleConfigItemMap(relationItemList, itemConfigMap);
        boolean checkFlag = FetchConfigHelper.execCheckCycle(true, configId, configPathList, null, curFilterConfigSet, allConfigFilterItemMap, itemConfigMap, errConfigList = new ArrayList<Long>(10), enableConfigList);
        if (!checkFlag) {
            return new FetchItemCheckResultVo("1", FetchConfigHelper.getConfigNameById(errConfigList, configNameMap));
        }
        for (String configPath : configPathList) {
            String[] configArr = configPath.split("#");
            if (configArr.length <= 5) continue;
            return new FetchItemCheckResultVo("2");
        }
        return new FetchItemCheckResultVo("0");
    }

    private static boolean execCheckCycle(boolean isFirst, long configId, List<String> configPathList, StringBuilder configPathSb, Set<Long> curFilterConfigSet, Map<Long, List<String>> allConfigFilterItemMap, Map<String, Long> itemConfigMap, List<Long> errConfigList, List<Long> enableConfigList) {
        for (Long filterConfigId : curFilterConfigSet) {
            if (isFirst) {
                configPathSb = new StringBuilder(String.valueOf(configId));
            }
            if (filterConfigId - configId == 0L) {
                FetchConfigHelper.addErrConfig(configPathSb, errConfigList);
                return false;
            }
            if (!enableConfigList.contains(filterConfigId)) continue;
            if (configPathSb.toString().contains(filterConfigId + "")) {
                FetchConfigHelper.addErrConfig(configPathSb, errConfigList);
                return false;
            }
            configPathSb.append('#').append(filterConfigId);
            List<String> filterItemList = allConfigFilterItemMap.get(filterConfigId);
            if (SWCListUtils.isEmpty(filterItemList)) {
                configPathList.add(configPathSb.toString());
                continue;
            }
            Set<Long> filterConfigSet = FetchConfigHelper.assembleConfigItemMap(filterItemList, itemConfigMap);
            boolean flag = FetchConfigHelper.execCheckCycle(false, configId, configPathList, configPathSb, filterConfigSet, allConfigFilterItemMap, itemConfigMap, errConfigList, enableConfigList);
            if (flag) continue;
            return flag;
        }
        return true;
    }

    private static void addErrConfig(StringBuilder configPathSb, List<Long> errConfigList) {
        String[] errConfigArr = configPathSb.toString().split("#");
        List errConfigs = Arrays.stream(errConfigArr).map(Long::parseLong).collect(Collectors.toList());
        errConfigList.addAll(errConfigs);
    }

    private static Map<Long, List<String>> assembleAllConfigFilterItemMap(Set<Long> configIdSet, List<Long> enableConfigList, Map<Long, String> configMap) {
        List itemList;
        HashMap<Long, List<String>> allConfigFilterItemMap = new HashMap<Long, List<String>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfig");
        QFilter filter = new QFilter("relationentity.valuetype", "=", (Object)ConditionValueTypeEnum.TYPE_FTITEM.getCode());
        DynamicObjectCollection configItemObjs = helper.queryOriginalCollection("id,name,relationentity.comparevalue,enable", new QFilter[]{filter});
        for (Object obj : configItemObjs) {
            long configId = obj.getLong("id");
            String enable = obj.getString("enable");
            String itemCode = obj.getString("relationentity.comparevalue");
            String configName = obj.getString("name");
            List itemList2 = allConfigFilterItemMap.computeIfAbsent(configId, list -> new ArrayList(10));
            if (SWCStringUtils.isEmpty((String)itemCode)) continue;
            if (itemCode.contains(";")) {
                String[] itemArr = itemCode.split(";");
                Collections.addAll(itemList2, itemArr);
            } else {
                itemList2.add(itemCode);
            }
            configIdSet.add(configId);
            configMap.put(configId, configName);
            if (!SWCStringUtils.equals((String)"1", (String)enable)) continue;
            enableConfigList.add(configId);
        }
        helper = new SWCDataServiceHelper("hsbs_resultfetchconfig");
        filter = new QFilter("1", "=", (Object)1);
        DynamicObjectCollection resultConfigItemObjs = helper.queryOriginalCollection("id,name,startitem.uniquecode,enditem.uniquecode,enable", new QFilter[]{filter});
        for (DynamicObject retObj : resultConfigItemObjs) {
            long configId = retObj.getLong("id");
            String enable = retObj.getString("enable");
            String startItemCode = retObj.getString("startitem.uniquecode");
            String endItemCode = retObj.getString("enditem.uniquecode");
            String retConfigName = retObj.getString("name");
            itemList = allConfigFilterItemMap.computeIfAbsent(configId, list -> new ArrayList(10));
            if (SWCStringUtils.isEmpty((String)startItemCode) && SWCStringUtils.isEmpty((String)endItemCode)) continue;
            if (!SWCStringUtils.isEmpty((String)startItemCode)) {
                itemList.add(startItemCode);
            }
            if (!SWCStringUtils.isEmpty((String)endItemCode)) {
                itemList.add(endItemCode);
            }
            configIdSet.add(configId);
            configMap.put(configId, retConfigName);
            if (!SWCStringUtils.equals((String)"1", (String)enable)) continue;
            enableConfigList.add(configId);
        }
        helper = new SWCDataServiceHelper("hsbs_custfetchconfig");
        filter = new QFilter("inputfieldentry.inputparamitemtype", "=", (Object)"2");
        DynamicObjectCollection custConfigItemObjs = helper.queryOriginalCollection("id,name,inputfieldentry.inputparamfetchitem.uniquecode,enable", new QFilter[]{filter});
        for (DynamicObject custObj : custConfigItemObjs) {
            long configId = custObj.getLong("id");
            String enable = custObj.getString("enable");
            String itemCode = custObj.getString("inputfieldentry.inputparamfetchitem.uniquecode");
            String custConfigName = custObj.getString("name");
            itemList = allConfigFilterItemMap.computeIfAbsent(configId, list -> new ArrayList(10));
            if (SWCStringUtils.isEmpty((String)itemCode)) continue;
            itemList.add(itemCode);
            configIdSet.add(configId);
            configMap.put(configId, custConfigName);
            if (!SWCStringUtils.equals((String)"1", (String)enable)) continue;
            enableConfigList.add(configId);
        }
        return allConfigFilterItemMap;
    }

    private static Set<Long> assembleConfigItemMap(List<String> relationItemList, Map<String, Long> itemConfigMap) {
        HashSet<Long> configSet = new HashSet<Long>(16);
        for (String itemCode : relationItemList) {
            Long configId = itemConfigMap.get(itemCode);
            configSet.add(configId);
        }
        return configSet;
    }

    private static Map<String, Long> assembleItemConfigMap(DynamicObjectCollection fetchConfigItems, Set<Long> configIdSet) {
        HashMap<String, Long> itemConfigMap = new HashMap<String, Long>(16);
        for (DynamicObject obj : fetchConfigItems) {
            String itemCode = obj.getString("fetchitem.uniquecode");
            String configType = obj.getString("configtype");
            long config = SWCStringUtils.equals((String)"0", (String)configType) ? obj.getLong("fetchconfig.id") : (SWCStringUtils.equals((String)"1", (String)configType) ? obj.getLong("resultfetchconfig.id") : obj.getLong("custfetchconfig.id"));
            itemConfigMap.put(itemCode, config);
            configIdSet.add(config);
        }
        return itemConfigMap;
    }

    public static List<Long> getRelatedFetchItemId() {
        ArrayList<Long> itemIdList = new ArrayList<Long>(10);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("fetchitem.id", new QFilter[]{filter});
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return itemIdList;
        }
        for (DynamicObject obj : dynamicObjects) {
            itemIdList.add(obj.getLong("fetchitem.id"));
        }
        return itemIdList;
    }

    public static DynamicObject getRelatedFetchItemInfo(QFilter filter, String fieldStr) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        return helper.queryOne(fieldStr, new QFilter[]{filter});
    }

    public static List<Long> getRelatedFetchItemIdByDimensionality(String dimensionality) {
        ArrayList<Long> codeList = new ArrayList<Long>(10);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("configtype", "!=", (Object)""));
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("configtype,fetchitem.id,fetchconfig.id,fetchconfig.dimensionality,fetchconfig.calculationfetch,custfetchconfig.id,custfetchconfig.dimensionality,resultfetchconfig.id", new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return codeList;
        }
        dynamicObjects.forEach(param -> {
            if (SWCStringUtils.equals((String)dimensionality, (String)"0")) {
                String calculationFetch = param.getString("fetchconfig.calculationfetch");
                if (!SWCStringUtils.equals((String)"true", (String)calculationFetch)) {
                    codeList.add(param.getLong("fetchitem.id"));
                }
            } else if (SWCStringUtils.equals((String)dimensionality, (String)param.getString("fetchconfig.dimensionality")) || SWCStringUtils.equals((String)dimensionality, (String)param.getString("custfetchconfig.dimensionality"))) {
                codeList.add(param.getLong("fetchitem.id"));
            }
        });
        return codeList;
    }

    public static List<Long> getRelatedFetchItemIdByFetchConfigId(Long fetchConfigId) {
        DynamicObjectCollection dynamicObjects;
        ArrayList<Long> codeList = new ArrayList<Long>(10);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("configtype", "!=", (Object)""));
        if (fetchConfigId != 0L) {
            filter.and(new QFilter("fetchconfig", "!=", (Object)fetchConfigId));
        }
        if (CollectionUtils.isEmpty((Collection)(dynamicObjects = helper.queryOriginalCollection("fetchitem,fetchconfig", new QFilter[]{filter})))) {
            return codeList;
        }
        for (DynamicObject obj : dynamicObjects) {
            long fetchItemId = obj.getLong("fetchitem");
            if (fetchItemId == 0L) continue;
            codeList.add(fetchItemId);
        }
        return codeList;
    }

    public static Map<Long, DynamicObject> getRelatedFetchItemList(List<Long> list) {
        SWCDataServiceHelper fetchHelper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter fetchFilter = new QFilter("enable", "=", (Object)"1");
        fetchFilter.and(new QFilter("fetchitem", "in", list));
        DynamicObjectCollection dynamicObjects = fetchHelper.queryOriginalCollection("fetchitem.id,fetchitem.name,fetchconfig.id,fetchconfig.name,fetchconfig.dimensionality,fetchconfig.calculationfetch,resultfetchconfig.id,resultfetchconfig.name,custfetchconfig.id,custfetchconfig.name,custfetchconfig.dimensionality,configtype", new QFilter[]{fetchFilter});
        HashMap<Long, DynamicObject> fetchConfigItemMap = new HashMap<Long, DynamicObject>(16);
        dynamicObjects.forEach(param -> fetchConfigItemMap.put(param.getLong("fetchitem.id"), (DynamicObject)param));
        return fetchConfigItemMap;
    }

    public static List<DynamicObject> getFetchSpItemDyObjList(List<String> list, String entity) {
        SWCDataServiceHelper fetchHelper = new SWCDataServiceHelper(entity);
        QFilter fetchFilter = new QFilter("uniquecode", "in", list);
        DynamicObjectCollection dynamicObjects = fetchHelper.queryOriginalCollection("uniquecode,areatype,country.id", new QFilter[]{fetchFilter});
        if (SWCListUtils.isEmpty((List)dynamicObjects)) {
            return new ArrayList<DynamicObject>(0);
        }
        return dynamicObjects.stream().collect(Collectors.toList());
    }

    public static List<String> selectRelatedFetchItem(String calItemLevel) {
        QFilter[] filters;
        ArrayList fetchConfigIdList = new ArrayList(10);
        ArrayList retFetchConfigIdList = new ArrayList(10);
        ArrayList custFetchConfigIdList = new ArrayList(10);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_resultfetchconfig");
        DynamicObjectCollection retFetchConfigObjs = helper.queryOriginalCollection("id", new QFilter[]{filter});
        retFetchConfigObjs.stream().forEach(obj -> retFetchConfigIdList.add(obj.getLong("id")));
        helper = new SWCDataServiceHelper("hsbs_custfetchconfig");
        DynamicObjectCollection custFetchConfigObjs = helper.queryOriginalCollection("id", new QFilter[]{filter});
        custFetchConfigObjs.stream().forEach(obj -> custFetchConfigIdList.add(obj.getLong("id")));
        helper = new SWCDataServiceHelper("hsbs_fetchconfig");
        if (SWCStringUtils.isNotEmpty((String)calItemLevel)) {
            QFilter filterConfig = new QFilter("dimensionality", "=", (Object)calItemLevel);
            filters = new QFilter[]{filter, filterConfig};
        } else {
            filters = new QFilter[]{filter};
        }
        DynamicObjectCollection fetchConfigObjs = helper.queryOriginalCollection("id", filters);
        fetchConfigObjs.stream().forEach(obj -> fetchConfigIdList.add(obj.getLong("id")));
        ArrayList<String> fetchItemCodeList = new ArrayList<String>(10);
        QFilter fetchConfigFilter = new QFilter("fetchconfig", "in", fetchConfigIdList);
        QFilter retFetchConfigFilter = new QFilter("resultfetchconfig", "in", retFetchConfigIdList);
        QFilter custFetchConfigFilter = new QFilter("custfetchconfig", "in", custFetchConfigIdList);
        if (SWCStringUtils.isNotEmpty((String)calItemLevel) && SWCStringUtils.equals((String)calItemLevel, (String)"1")) {
            filter.and(fetchConfigFilter);
        } else {
            filter.and(fetchConfigFilter.or(retFetchConfigFilter).or(custFetchConfigFilter));
        }
        helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        DynamicObjectCollection items = helper.queryOriginalCollection("fetchitem.uniquecode", new QFilter[]{filter});
        items.stream().forEach(code -> fetchItemCodeList.add(code.getString("fetchitem.uniquecode")));
        return fetchItemCodeList;
    }

    public static boolean checkResultFetchConfigEnable(long fetchConfigId, String type) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_resultfetchconfig");
        String fields = "id,enable";
        QFilter filter = new QFilter("id", "=", (Object)fetchConfigId);
        DynamicObject obj = helper.queryOne(fields, new QFilter[]{filter});
        if (obj != null) {
            if (SWCStringUtils.equals((String)"0", (String)type)) {
                return SWCStringUtils.equals((String)"0", (String)obj.getString("enable")) || SWCStringUtils.equals((String)"10", (String)obj.getString("enable"));
            }
            if (SWCStringUtils.equals((String)"1", (String)type)) {
                return SWCStringUtils.equals((String)type, (String)obj.getString("enable"));
            }
        }
        return false;
    }

    public static boolean deleteFetchConfig(List<Long> pkIds, String type) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("fetchconfig", "in", pkIds);
        filter.and(new QFilter("enable", "=", (Object)type));
        helper.deleteByFilter(new QFilter[]{filter});
        SWCDataServiceHelper configHelper = new SWCDataServiceHelper("hsbs_fetchconfig");
        QFilter configFilter = new QFilter("id", "in", pkIds);
        configFilter.and(new QFilter("enable", "=", (Object)type));
        int configRows = configHelper.deleteByFilter(new QFilter[]{configFilter});
        return configRows == pkIds.size();
    }

    public static DynamicObject selectDyObjByType(Long id, String entity) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entity);
        return helper.queryOriginalOne("datatype.storagetype,uniquecode", new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    public static List<String> getConfigNameById(List<Long> idList, Map<Long, String> configNameMap) {
        ArrayList<String> nameList = new ArrayList<String>(10);
        idList.stream().forEach(single -> nameList.add((String)configNameMap.get(single)));
        return nameList;
    }

    public static List<String> getRelateConfigNameByItemId(List<Long> idList) {
        HashSet configNameSet = new HashSet(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchitem");
        QFilter filter = new QFilter("id", "in", idList);
        DynamicObject[] dynamicObjects = helper.queryOriginalArray("uniquecode", new QFilter[]{filter});
        List uniquecodeList = Arrays.stream(dynamicObjects).map(dy -> dy.getString("uniquecode")).collect(Collectors.toList());
        helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        filter = new QFilter("fetchitem.id", "in", idList);
        DynamicObject[] fetchConfigObjs = helper.queryOriginalArray("configtype,fetchconfig.name", new QFilter[]{filter});
        if (fetchConfigObjs.length > 0) {
            Set collect = Arrays.stream(fetchConfigObjs).map(single -> single.getString("fetchconfig.name")).collect(Collectors.toSet());
            configNameSet.addAll(collect);
        }
        helper = new SWCDataServiceHelper("hsbs_fetchconfig");
        filter = new QFilter("relationentity.comparevalue", "in", uniquecodeList);
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] configObjs = helper.query("name", new QFilter[]{filter});
        if (configObjs.length > 0) {
            Set configSet = Arrays.stream(configObjs).map(config -> config.getString("name")).collect(Collectors.toSet());
            configNameSet.addAll(configSet);
        }
        return new ArrayList<String>(configNameSet);
    }

    public static String getItemUniqueCodeByEntityAndId(String entity, Long itemId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entity);
        DynamicObject itemObj = helper.queryOne((Object)itemId);
        if (itemObj != null) {
            return itemObj.getString("uniquecode");
        }
        return "";
    }

    public static String getItemIdByEntityAndUniquecode(String entity, String uniquecode) {
        if (SWCStringUtils.isEmpty((String)uniquecode)) {
            return "";
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entity);
        String[] uniquecodes = uniquecode.split(";");
        QFilter filter = new QFilter("uniquecode", "in", (Object)uniquecodes);
        DynamicObjectCollection itemObjs = helper.queryOriginalCollection("id", new QFilter[]{filter});
        if (!SWCListUtils.isEmpty((List)itemObjs)) {
            StringBuilder sb = new StringBuilder();
            for (DynamicObject itemObj : itemObjs) {
                if (sb.length() > 0) {
                    sb.append(';');
                }
                sb.append(itemObj.getLong("id"));
            }
            return sb.toString();
        }
        return "";
    }

    public static void updateFetchConfigItemEnable(String type, List<Long> configIdList, String configType) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        String filterField = FetchConfigHelper.assembleFilterField(configType);
        QFilter filter = new QFilter(filterField, "in", configIdList);
        String fields = "id,fetchconfig,enable,modifier,modifytime,creator,createtime,fetchfieldentry,fetchitem.uniquecode";
        DynamicObject[] objects = helper.query(fields, new QFilter[]{filter});
        long userId = RequestContext.get().getCurrUserId();
        if (objects != null && objects.length > 0) {
            for (DynamicObject obj : objects) {
                obj.set("enable", (Object)type);
                obj.set("modifytime", (Object)new Date());
                obj.set("modifier", (Object)userId);
            }
            helper.update(objects);
        }
    }

    public static void batchUpdateFetchConfigItemEnable(String type, List<Long> fetchConfigIds, String configType) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        String filterField = FetchConfigHelper.assembleFilterField(configType);
        QFilter filter = new QFilter(filterField, "in", fetchConfigIds);
        String fields = "id,fetchconfig,enable,modifier,modifytime,creator,createtime,fetchfieldentry,fetchitem.uniquecode";
        DynamicObject[] dynamicObjects = helper.query(fields, new QFilter[]{filter});
        long userId = RequestContext.get().getCurrUserId();
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject obj : dynamicObjects) {
                obj.set("enable", (Object)type);
                obj.set("modifytime", (Object)new Date());
                obj.set("modifier", (Object)userId);
            }
            helper.update(dynamicObjects);
        }
    }

    private static String assembleFilterField(String configType) {
        String filterField;
        switch (configType) {
            case "0": {
                filterField = "fetchconfig";
                break;
            }
            case "1": {
                filterField = "resultfetchconfig";
                break;
            }
            case "2": {
                filterField = "custfetchconfig";
                break;
            }
            default: {
                filterField = "";
            }
        }
        return filterField;
    }

    public static String checkConfigFetchItemEnable(long fetchConfigId, String configType) {
        StringBuilder resultMsg = new StringBuilder();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        String fields = "id,fetchconfig,enable,fetchitem.uniquecode";
        String filterField = FetchConfigHelper.assembleFilterField(configType);
        QFilter filter = new QFilter(filterField, "=", (Object)fetchConfigId);
        DynamicObject[] objects = helper.query(fields, new QFilter[]{filter});
        if (objects == null || objects.length == 0) {
            return resultMsg.toString();
        }
        for (DynamicObject obj : objects) {
            boolean fetchItemEnable = FetchConfigHelper.checkFetchItemEnable(obj.getString("fetchitem.uniquecode"));
            if (!fetchItemEnable) continue;
            if (resultMsg.length() > 0) {
                resultMsg.append('\uff0c');
            }
            resultMsg.append(obj.getString("fetchitem.name"));
        }
        return resultMsg.toString();
    }

    public static boolean checkFetchItemEnable(String fetchitemcode) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        String fields = "id,enable,fetchitem.uniquecode";
        QFilter filter = new QFilter("fetchitem.uniquecode", "=", (Object)fetchitemcode);
        DynamicObject[] objects = helper.query(fields, new QFilter[]{filter});
        if (objects != null && objects.length > 0) {
            for (DynamicObject obj : objects) {
                if (!SWCStringUtils.equals((String)"1", (String)obj.getString("enable"))) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Long> selectRelatedFetchItemIdList(QFilter qFilter) {
        ArrayList<Long> fetchItemIdList = new ArrayList<Long>(10);
        if (ObjectUtils.isEmpty((Object)qFilter)) {
            return fetchItemIdList;
        }
        Object value = qFilter.getValue();
        String cp = qFilter.getCP();
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        if (!SWCStringUtils.equals((String)cp, (String)"=") || !SWCStringUtils.equals((String)value.toString(), (String)"EMPTY")) {
            filter.and(new QFilter("fetchconfig.name", cp, value).or(new QFilter("resultfetchconfig.name", cp, value)).or(new QFilter("custfetchconfig.name", cp, value)));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        DynamicObjectCollection fetchConfigItems = helper.queryOriginalCollection("fetchitem", new QFilter[]{filter});
        fetchConfigItems.stream().forEach(obj -> fetchItemIdList.add(obj.getLong("fetchitem")));
        return fetchItemIdList;
    }

    public static void deleteResultFetchConfigItem(long resultFetchConfigId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("resultfetchconfig", "=", (Object)resultFetchConfigId);
        helper.deleteByFilter(new QFilter[]{filter});
    }

    public DynamicObject[] selectFetchConfigList(List<Long> ids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfig");
        QFilter filter = new QFilter("id", "in", ids);
        return helper.query("id,name,number,enable,calculationfetch,dimensionality", new QFilter[]{filter});
    }

    public static Map<String, String> selectFetchConfigEntityList(List<Long> fetchItemIds) {
        HashMap<String, String> configItemMap = new HashMap<String, String>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchitem");
        DynamicObjectCollection itemObjs = helper.queryOriginalCollection("name,uniquecode", new QFilter[]{new QFilter("id", "in", fetchItemIds)});
        if (SWCListUtils.isEmpty((List)itemObjs)) {
            return configItemMap;
        }
        Map<String, String> itemMap = itemObjs.stream().collect(Collectors.toMap(code -> code.getString("uniquecode"), name -> name.getString("name")));
        Set uniqueCodeSet = itemObjs.stream().map(single -> single.getString("uniquecode")).collect(Collectors.toSet());
        helper = new SWCDataServiceHelper("hsbs_fetchconfig");
        QFilter filter = new QFilter("relationentity.comparevalue", "in", uniqueCodeSet);
        filter.and(new QFilter("relationentity.valuetype", "=", (Object)ConditionValueTypeEnum.TYPE_FTITEM.getCode()));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection configItemObjs = helper.queryOriginalCollection("name,relationentity.comparevalue", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)configItemObjs)) {
            return configItemMap;
        }
        for (DynamicObject configItemObj : configItemObjs) {
            String configName = configItemObj.getString("name");
            String uniqueCode = configItemObj.getString("relationentity.comparevalue");
            String itemName = itemMap.get(uniqueCode);
            configItemMap.put(configName, itemName);
        }
        return configItemMap;
    }

    public DynamicObject[] selectFetchItemList(List<Long> ids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("fetchconfig", "in", ids);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        return helper.query("id,fetchitem,fetchconfig", new QFilter[]{filter});
    }

    public DynamicObject[] selectFetchItemListByCode(List<String> itemCodeList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("fetchitem.uniquecode", "in", itemCodeList);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        return helper.query("id,fetchitem,fetchconfig", new QFilter[]{filter});
    }

    public DynamicObject[] selectFetchItemListByCustId(List<Long> id) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("custfetchconfig", "in", id);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        return helper.query("id,fetchitem,custfetchconfig", new QFilter[]{filter});
    }

    public DynamicObject[] selectResultFetchConfigList(List<Long> ids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_resultfetchconfig");
        QFilter filter = new QFilter("startitem", "in", ids);
        filter.or(new QFilter("enditem", "in", ids));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        return helper.query("id,name,startitem,enditem", new QFilter[]{filter});
    }

    public DynamicObject[] selectCustFetchConfigList(List<Long> ids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_custfetchconfig");
        QFilter filter = new QFilter("id", "in", ids);
        return helper.query("id,name,number,enable,dimensionality", new QFilter[]{filter});
    }

    public DynamicObject[] selectCustFetchConfigEntityList(List<Long> ids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_custfetchconfig");
        QFilter filter = new QFilter("inputfieldentry.inputparamfetchitem", "in", ids);
        filter.and(new QFilter("inputfieldentry.inputparamitemtype", "=", (Object)"2"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        return helper.query("inputparamitemtype,inputparamfetchitem.name,name", new QFilter[]{filter});
    }

    public String checkFetchConfigQuote(List<Long> fetchItemList) {
        Map<String, String> configItemMap = FetchConfigHelper.selectFetchConfigEntityList(fetchItemList);
        String message = "";
        if (configItemMap.size() > 0) {
            for (Map.Entry<String, String> entry : configItemMap.entrySet()) {
                String fetchConfigName = entry.getKey();
                String fetchItemName = entry.getValue();
                if (!SWCStringUtils.isNotEmpty((String)fetchItemName)) continue;
                message = ResManager.loadKDString((String)"\u201c{0}\u201d\u88ab\u53d6\u6570\u914d\u7f6e\u201c{1}\u201d\u5173\u8054\u3002 {2}", (String)"FetchConfigHelper_0", (String)"swc-hsbs-business", (Object[])new Object[]{fetchItemName, fetchConfigName, message});
            }
        }
        return message;
    }

    public String checkCustFetchConfigQuote(List<Long> fetchItemList) {
        DynamicObject[] fetchConfigEntitys = this.selectCustFetchConfigEntityList(fetchItemList);
        String message = "";
        if (fetchConfigEntitys != null) {
            for (DynamicObject dynamicObject : fetchConfigEntitys) {
                StringBuilder sb = new StringBuilder();
                String custFetchConfigName = dynamicObject.getString("name");
                DynamicObjectCollection inputFieldEntry = dynamicObject.getDynamicObjectCollection("inputfieldentry");
                inputFieldEntry.removeIf(single -> !SWCStringUtils.equals((String)single.getString("inputparamitemtype"), (String)"2"));
                for (int i = 0; i < inputFieldEntry.size(); ++i) {
                    if (i == 0) {
                        sb.append(((DynamicObject)inputFieldEntry.get(i)).getString("inputparamfetchitem.name"));
                        continue;
                    }
                    sb.append(",").append(((DynamicObject)inputFieldEntry.get(i)).getString("inputparamfetchitem.name"));
                }
                if (sb.length() <= 0) continue;
                message = ResManager.loadKDString((String)"\u201c{0}\u201d\u88ab\u63d2\u4ef6\u53d6\u6570\u914d\u7f6e\u201c{1}\u201d\u5173\u8054\u3002{2}", (String)"FetchConfigHelper_3", (String)"swc-hsbs-business", (Object[])new Object[]{sb.toString(), custFetchConfigName, message});
            }
        }
        return message;
    }

    public String checkResultFetchConfigQuote(List<Long> fetchItemList) {
        DynamicObject[] fetchConfigEntitys = this.selectResultFetchConfigList(fetchItemList);
        String message = "";
        if (fetchConfigEntitys != null) {
            for (DynamicObject dynamicObject : fetchConfigEntitys) {
                String resultFetchConfigName = dynamicObject.getString("name");
                String startItem = dynamicObject.getString("startitem.name");
                String endItem = dynamicObject.getString("enditem.name");
                if (SWCStringUtils.isNotEmpty((String)startItem)) {
                    message = ResManager.loadKDString((String)"[{0}]\u88ab\u85aa\u916c\u7ed3\u679c\u53d6\u6570\u914d\u7f6e[{1}]\u5173\u8054\r\n{2}", (String)"FetchConfigHelper_4", (String)"swc-hsbs-business", (Object[])new Object[]{startItem, resultFetchConfigName, message});
                }
                if (!SWCStringUtils.isNotEmpty((String)endItem)) continue;
                message = ResManager.loadKDString((String)"[{0}]\u88ab\u85aa\u916c\u7ed3\u679c\u53d6\u6570\u914d\u7f6e[{1}]\u5173\u8054\r\n{2}", (String)"FetchConfigHelper_4", (String)"swc-hsbs-business", (Object[])new Object[]{endItem, resultFetchConfigName, message});
            }
        }
        return message;
    }
}

