/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.basedata.schedule;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbs.business.basedata.schedule.ISchConfig;

public class SchConfigCreateService {
    public static SchConfigCreateService getInstance() {
        return new SchConfigCreateService();
    }

    public void doCreate(ISchConfig schConfig) {
        Map<Long, String> taskTplAndSchIdMap = schConfig.getBizIdAndSchIdMap();
        if (taskTplAndSchIdMap == null) {
            return;
        }
        Collection<String> scheduleIds = taskTplAndSchIdMap.values();
        DynamicObjectCollection planDys = schConfig.queryPlanDyObj(scheduleIds);
        if (planDys == null) {
            return;
        }
        Set<String> existSchCfgIds = schConfig.queryExistSchCfgId(scheduleIds);
        schConfig.assembleParamAndSave(taskTplAndSchIdMap, planDys, existSchCfgIds);
        schConfig.compensate();
    }

    public Map<Long, String> getBizIdAndSchIdMap(String entity, String cfgFieldNumber, String planFieldNumber) {
        DynamicObjectCollection calTaskTpls;
        SWCDataServiceHelper calTaskTplHelper = new SWCDataServiceHelper(entity);
        QFilter qFilter = new QFilter(cfgFieldNumber, "=", (Object)0);
        qFilter.or(QFilter.isNull((String)cfgFieldNumber));
        if (planFieldNumber.contains(".id")) {
            qFilter.and(new QFilter("schedule", "!=", (Object)" "));
        }
        if ((calTaskTpls = calTaskTplHelper.queryOriginalCollection("id, " + planFieldNumber, new QFilter[]{qFilter})) == null || calTaskTpls.isEmpty()) {
            return null;
        }
        Map taskTplAndSchIdMap = calTaskTpls.stream().collect(Collectors.toMap(calTaskTpl -> calTaskTpl.getLong("id"), calTaskTpl -> calTaskTpl.getString(planFieldNumber), (a1, b1) -> b1, () -> new HashMap(calTaskTpls.size())));
        return taskTplAndSchIdMap;
    }
}

