/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.basedata.schedule.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.schedule.SwcBizSchConfigConstants;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbs.business.basedata.schedule.ISchConfig;
import kd.swc.hsbs.business.basedata.schedule.SchConfigCreateService;
import org.jetbrains.annotations.Nullable;

public class CalTaskTplSchConfigImpl
implements ISchConfig {
    private static final String SCH_SCHEDULE = "sch_schedule";
    private static final String KEY_SCHEDULE = "schedule";
    private static final String KEY_USEOBJ = "useobj";
    private static final String KEY_SCHCONFIG = "schconfig";
    private static final Log logger = LogFactory.getLog(CalTaskTplSchConfigImpl.class);

    @Override
    @Nullable
    public Map<Long, String> getBizIdAndSchIdMap() {
        return new SchConfigCreateService().getBizIdAndSchIdMap("hsas_caltasknewtpl", KEY_SCHCONFIG, KEY_SCHEDULE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assembleParamAndSave(Map<Long, String> taskTplAndSchIdMap, DynamicObjectCollection planDys, Set<String> existSchCfgIds) {
        String desc = ResManager.loadKDString((String)"\u7cfb\u7edf\u5347\u7ea7\u6570\u636e\u3002", (String)"CalTaskTplSchConfigImpl_0", (String)"swc-hsbs-business", (Object[])new Object[0]);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsbs_schplancfg");
        Date createTime = new Date();
        HashMap<Object, Long> planAndScgIdMap = new HashMap<Object, Long>(16);
        DynamicObjectCollection schCfgDys = new DynamicObjectCollection();
        long[] schCfgIds = DB.genLongIds((String)"T_HSBS_SCHPLANCFG", (int)planDys.size());
        int index = 0;
        for (DynamicObject planDy : planDys) {
            String planId = planDy.getString("id");
            if (existSchCfgIds != null && existSchCfgIds.contains(planId)) {
                logger.error("\u8c03\u5ea6\u8ba1\u5212\u5bf9\u5e94\u7684\u8c03\u5ea6\u8ba1\u5212\u914d\u7f6e\u5df2\u5b58\u5728\uff0c\u8c03\u5ea6\u8ba1\u5212id = {}", (Object)planId);
                continue;
            }
            DynamicObject dynamicObject = (DynamicObject)type.createInstance();
            dynamicObject.set("id", (Object)schCfgIds[index]);
            dynamicObject.set("masterid", (Object)schCfgIds[index]);
            dynamicObject.set("number", (Object)planDy.getString("number"));
            String name = planDy.getString("name");
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = planDy.getString("number");
            }
            dynamicObject.set("name", (Object)name);
            dynamicObject.set(KEY_SCHEDULE, (Object)planId);
            dynamicObject.set(KEY_USEOBJ, (Object)SwcBizSchConfigConstants.PRE_DATA_CAL_TASK_TPL);
            dynamicObject.set("description", (Object)desc);
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("enable", (Object)"1");
            dynamicObject.set("createtime", (Object)createTime);
            dynamicObject.set("starttime", (Object)planDy.getDate("starttime"));
            dynamicObject.set("endtime", (Object)planDy.getDate("endtime"));
            schCfgDys.add((Object)dynamicObject);
            planAndScgIdMap.put(planId, schCfgIds[index]);
            ++index;
        }
        String updateSql = "UPDATE T_HSAS_CALTASKNEWTPL SET FSCHCONFIGID = ? WHERE FID = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(taskTplAndSchIdMap.size());
        for (Map.Entry entry : taskTplAndSchIdMap.entrySet()) {
            Object[] param = new Object[2];
            param[1] = entry.getKey();
            param[0] = planAndScgIdMap.get(entry.getValue());
            if (param[0] == null) {
                param[0] = 0L;
                logger.error("\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u66f4\u65b0\u8c03\u5ea6\u8ba1\u5212\u914d\u7f6e\u5931\u8d25\uff0c\u6838\u7b97\u4efb\u52a1\u6a21\u677fid = {}", entry.getKey());
            }
            params.add(param);
        }
        if (schCfgDys.isEmpty()) {
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            new SWCDataServiceHelper("hsbs_schplancfg").save(schCfgDys);
            SWCDbUtil.executeBatch((DBRoute)new DBRoute("swc"), (String)updateSql, params);
        }
    }

    @Override
    public void compensate() {
        SWCDataServiceHelper calTaskTplHelper = new SWCDataServiceHelper("hsas_caltasknewtpl");
        QFilter qFilter = new QFilter(KEY_SCHCONFIG, "=", (Object)0);
        qFilter.or(QFilter.isNull((String)KEY_SCHCONFIG));
        DynamicObject[] calTaskTpls = calTaskTplHelper.query("id, schconfig, schedule", new QFilter[]{qFilter});
        if (calTaskTpls == null || calTaskTpls.length <= 0) {
            return;
        }
        SWCDataServiceHelper schCfgHelper = new SWCDataServiceHelper("hsbs_schplancfg");
        Set schIds = Arrays.stream(calTaskTpls).map(calTaskTpl -> calTaskTpl.getString(KEY_SCHEDULE)).collect(Collectors.toCollection(() -> new HashSet(16)));
        DynamicObjectCollection existSchCfgs = schCfgHelper.queryOriginalCollection("id,schedule", new QFilter(KEY_SCHEDULE, "in", (Object)schIds).toArray());
        if (existSchCfgs == null || existSchCfgs.isEmpty()) {
            return;
        }
        Map schAndSchCfgIdMap = existSchCfgs.stream().collect(Collectors.toMap(existSchCfg -> existSchCfg.getString(KEY_SCHEDULE), existSchCfg -> existSchCfg.getLong("id"), (a1, b1) -> b1, () -> new HashMap(16)));
        for (DynamicObject calTaskTpl2 : calTaskTpls) {
            String scheduleId = calTaskTpl2.getString(KEY_SCHEDULE);
            calTaskTpl2.set(KEY_SCHCONFIG, schAndSchCfgIdMap.get(scheduleId));
        }
        calTaskTplHelper.save(calTaskTpls);
    }
}

