/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.basedata.schedule.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.swc.hsbp.business.schedule.SwcBizSchConfigConstants;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbs.business.basedata.schedule.ISchConfig;
import kd.swc.hsbs.business.basedata.schedule.SchConfigCreateService;
import org.jetbrains.annotations.Nullable;

public class TaskRuleSchConfigImpl
implements ISchConfig {
    private static final String KEY_SCHCONFIG = "schconfig";
    private static final String HPDI_TASKRULESCHPLAN = "hpdi_taskruleschplan";
    private static final String SCH_SCHEDULE = "sch_schedule";
    private static final String SCH_JOB = "sch_job";
    private static final String KEY_EXECPLANJSON = "execplanjson";
    private static final String KEY_SCHEDULE = "schedule";
    private static final Log logger = LogFactory.getLog(TaskRuleSchConfigImpl.class);

    @Override
    @Nullable
    public Map<Long, String> getBizIdAndSchIdMap() {
        Map<Long, String> bizIdAndSchIdMap = new SchConfigCreateService().getBizIdAndSchIdMap("hpdi_taskrule", KEY_SCHCONFIG, "schedule.id");
        Map<Long, String> bizIdAndSchIdMap2 = this.dealSaveSubmitData();
        if (bizIdAndSchIdMap == null) {
            return bizIdAndSchIdMap2;
        }
        if (bizIdAndSchIdMap2 == null) {
            return bizIdAndSchIdMap;
        }
        for (Map.Entry<Long, String> longStringEntry : bizIdAndSchIdMap2.entrySet()) {
            bizIdAndSchIdMap.put(longStringEntry.getKey(), longStringEntry.getValue());
        }
        return bizIdAndSchIdMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assembleParamAndSave(Map<Long, String> taskTplAndSchIdMap, DynamicObjectCollection planDys, Set<String> existSchCfgIds) {
        String desc = ResManager.loadKDString((String)"\u7cfb\u7edf\u5347\u7ea7\u6570\u636e\u3002", (String)"TaskRuleSchConfigImpl_0", (String)"swc-hsbs-business", (Object[])new Object[0]);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsbs_schplancfg");
        Date createTime = new Date();
        HashMap<Object, Long> planAndScgIdMap = new HashMap<Object, Long>(16);
        DynamicObjectCollection schCfgDys = new DynamicObjectCollection();
        long[] schCfgIds = DB.genLongIds((String)"T_HSBS_SCHPLANCFG", (int)planDys.size());
        int index = 0;
        for (DynamicObject planDy : planDys) {
            String planId = planDy.getString("id");
            if (existSchCfgIds != null && existSchCfgIds.contains(planId)) {
                logger.error("\u8c03\u5ea6\u8ba1\u5212\u5bf9\u5e94\u7684\u8c03\u5ea6\u8ba1\u5212\u914d\u7f6e\u5df2\u5b58\u5728\uff0c\u8c03\u5ea6\u8ba1\u5212id = {}", (Object)planId);
                continue;
            }
            DynamicObject dynamicObject = (DynamicObject)type.createInstance();
            dynamicObject.set("id", (Object)schCfgIds[index]);
            dynamicObject.set("masterid", (Object)schCfgIds[index]);
            dynamicObject.set("number", (Object)planDy.getString("number"));
            String name = planDy.getString("name");
            if (StringUtils.isEmpty((String)name)) {
                name = planDy.getString("number");
            }
            dynamicObject.set("name", (Object)name);
            dynamicObject.set(KEY_SCHEDULE, (Object)planId);
            dynamicObject.set("useobj", (Object)SwcBizSchConfigConstants.PRE_DATA_TASK_RULE);
            dynamicObject.set("description", (Object)desc);
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("enable", (Object)"1");
            dynamicObject.set("createtime", (Object)createTime);
            dynamicObject.set("starttime", (Object)planDy.getDate("starttime"));
            dynamicObject.set("endtime", (Object)planDy.getDate("endtime"));
            schCfgDys.add((Object)dynamicObject);
            planAndScgIdMap.put(planId, schCfgIds[index]);
            ++index;
        }
        String updateSql = "UPDATE T_HPDI_TASKRULE SET FSCHCONFIGID = ? WHERE FID = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(taskTplAndSchIdMap.size());
        for (Map.Entry entry : taskTplAndSchIdMap.entrySet()) {
            String value = (String)entry.getValue();
            if (StringUtils.isEmpty((String)value)) continue;
            Object[] param = new Object[2];
            param[1] = entry.getKey();
            param[0] = planAndScgIdMap.get(value);
            if (param[0] == null) {
                param[0] = 0L;
                logger.error("\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u66f4\u65b0\u8c03\u5ea6\u8ba1\u5212\u914d\u7f6e\u5931\u8d25\uff0c\u534f\u4f5c\u4efb\u52a1\u7f16\u6392id = {}", entry.getKey());
            }
            params.add(param);
        }
        if (schCfgDys.isEmpty()) {
            return;
        }
        new SWCDataServiceHelper("hsbs_schplancfg").save(schCfgDys);
        try (TXHandle txHandle = TX.requiresNew();){
            SWCDbUtil.executeBatch((DBRoute)new DBRoute("hpdi"), (String)updateSql, params);
        }
    }

    @Override
    public void compensate() {
        SWCDataServiceHelper taskRuleHelper = new SWCDataServiceHelper("hpdi_taskrule");
        QFilter qFilter = new QFilter(KEY_SCHCONFIG, "=", (Object)0);
        qFilter.or(QFilter.isNull((String)KEY_SCHCONFIG));
        qFilter.and(new QFilter(KEY_SCHEDULE, "!=", (Object)" "));
        DynamicObject[] taskRules = taskRuleHelper.query("id, schconfig, schedule.id", new QFilter[]{qFilter});
        if (taskRules == null || taskRules.length <= 0) {
            return;
        }
        SWCDataServiceHelper schCfgHelper = new SWCDataServiceHelper("hsbs_schplancfg");
        Set schIds = Arrays.stream(taskRules).map(calTaskTpl -> calTaskTpl.getString("schedule.id")).collect(Collectors.toCollection(() -> new HashSet(16)));
        DynamicObjectCollection existSchCfgs = schCfgHelper.queryOriginalCollection("id,schedule", new QFilter(KEY_SCHEDULE, "in", (Object)schIds).toArray());
        if (existSchCfgs == null || existSchCfgs.isEmpty()) {
            return;
        }
        Map schAndSchCfgIdMap = existSchCfgs.stream().collect(Collectors.toMap(existSchCfg -> existSchCfg.getString(KEY_SCHEDULE), existSchCfg -> existSchCfg.getLong("id"), (a1, b1) -> b1, () -> new HashMap(16)));
        for (DynamicObject calTaskTpl2 : taskRules) {
            String scheduleId = calTaskTpl2.getString("schedule.id");
            calTaskTpl2.set(KEY_SCHCONFIG, schAndSchCfgIdMap.get(scheduleId));
        }
        taskRuleHelper.save(taskRules);
    }

    private Map<Long, String> dealSaveSubmitData() {
        SWCDataServiceHelper calTaskTplHelper = new SWCDataServiceHelper("hpdi_taskrule");
        QFilter qFilter = new QFilter(KEY_SCHCONFIG, "=", (Object)0);
        qFilter.or(QFilter.isNull((String)KEY_SCHCONFIG));
        qFilter.and(new QFilter(KEY_EXECPLANJSON, "!=", (Object)" "));
        qFilter.and(new QFilter(KEY_SCHEDULE, "=", (Object)" "));
        qFilter.and(new QFilter("immediately", "=", (Object)Boolean.FALSE));
        qFilter.and(new QFilter("status", "in", (Object)new String[]{"A", "B"}));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection taskRuleDys = calTaskTplHelper.queryOriginalCollection("id,number,name, execplanjson", new QFilter[]{qFilter});
        if (taskRuleDys == null || taskRuleDys.isEmpty()) {
            return null;
        }
        HashMap<Long, String> bizIdAndSchIdMap = new HashMap<Long, String>(taskRuleDys.size());
        String[] schIds = DB.genStringIds((String)SCH_SCHEDULE, (int)taskRuleDys.size());
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)SCH_SCHEDULE);
        ArrayList<DynamicObject> schPlanDys = new ArrayList<DynamicObject>(10);
        DcJsonSerializer schDcSerializer = new DcJsonSerializer((DcBinder)new DynamicObjectSerializationBinder(new DynamicObjectType(HPDI_TASKRULESCHPLAN)));
        for (int index = 0; index < taskRuleDys.size(); ++index) {
            DynamicObject taskRuleDy = (DynamicObject)taskRuleDys.get(index);
            String execPlanJson = taskRuleDy.getString(KEY_EXECPLANJSON);
            if (StringUtils.isEmpty((String)execPlanJson)) continue;
            DynamicObject schPlanObj = (DynamicObject)schDcSerializer.deserializeFromString(execPlanJson, (Object)new SWCDataServiceHelper(HPDI_TASKRULESCHPLAN).generateEmptyDynamicObject());
            DynamicObject schPlanDy = (DynamicObject)type.createInstance();
            schPlanDy.set("id", (Object)schIds[index]);
            this.setPlanDyByDy(schPlanObj, schPlanDy, taskRuleDy.getString("name"), taskRuleDy.getString("number"));
            schPlanDys.add(schPlanDy);
            bizIdAndSchIdMap.put(taskRuleDy.getLong("id"), schIds[index]);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SCH_SCHEDULE);
        helper.save(schPlanDys.toArray(new DynamicObject[0]));
        return bizIdAndSchIdMap;
    }

    private void setPlanDyByDy(DynamicObject schPlanObj, DynamicObject schPlanDy, String name, String number) {
        DynamicObject jobDy = this.saveJobInfo(name, number);
        String nameSuf = "_HPDI";
        schPlanDy.set("name", (Object)(name + nameSuf));
        schPlanDy.set("number", (Object)(number + nameSuf));
        schPlanDy.set("job", (Object)jobDy);
        schPlanDy.set("combdorw", schPlanObj.get("combdorw"));
        schPlanDy.set("cyclenum", schPlanObj.get("cyclenum"));
        schPlanDy.set("endtime", schPlanObj.get("endtime"));
        schPlanDy.set("starttime", schPlanObj.get("starttime"));
        schPlanDy.set("plan", schPlanObj.get("plan"));
        schPlanDy.set("repeatmode", schPlanObj.get("repeatmode"));
        schPlanDy.set("txtdesc", schPlanObj.get("txtdesc"));
    }

    private DynamicObject saveJobInfo(String name, String number) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SCH_JOB);
        DynamicObject jobInfo = helper.generateEmptyDynamicObject();
        String nameSuf = "_HPDI";
        jobInfo.set("name", (Object)(name + nameSuf));
        jobInfo.set("number", (Object)(number + nameSuf));
        jobInfo.set("jobtype", (Object)"BIZ");
        jobInfo.set("classname", (Object)"kd.swc.hpdi.business.task.TaskRuleExecTask");
        jobInfo.set("taskclassname", (Object)"1367996048022191105");
        HashMap<String, String> scheduleParams = new HashMap<String, String>(16);
        scheduleParams.put("useEntityCode", "hpdi_taskrule");
        jobInfo.set("params", (Object)SerializationUtils.toJsonString(scheduleParams));
        jobInfo.set("status", (Object)"1");
        jobInfo.set("runbyuser", (Object)100);
        jobInfo.set("runmode", (Object)"0");
        jobInfo.set("runconcurrent", (Object)false);
        jobInfo.set("strategy", (Object)"1");
        jobInfo.set("creator", (Object)RequestContext.get().getCurrUserId());
        jobInfo.set("createtime", (Object)new Date());
        helper.saveOne(jobInfo);
        return jobInfo;
    }
}

