/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.calperiod;

import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsbp.common.enums.CalFrequencyEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbs.business.calperiod.AbstractCalPeriodFrequency;
import kd.swc.hsbs.business.calperiod.CalPeriodDayFrequencyImpl;
import kd.swc.hsbs.business.calperiod.CalPeriodFrequencyService;
import kd.swc.hsbs.business.calperiod.CalPeriodHalfMonthFrequencyImpl;
import kd.swc.hsbs.business.calperiod.CalPeriodMonthFrequencyImpl;
import kd.swc.hsbs.business.calperiod.CalPeriodWeekFrequencyImpl;
import kd.swc.hsbs.business.calperiod.DefaultFrequencyImpl;

public class CalPeriodFrequencyFactory {
    public static CalPeriodFrequencyService getCalPeriodFrequencyService(String frequency, AbstractFormPlugin abstractFormPlugin, IDataModel model) {
        AbstractCalPeriodFrequency calPeriodFrequencyService;
        if (SWCStringUtils.isEmpty((String)frequency)) {
            return new DefaultFrequencyImpl(abstractFormPlugin, model);
        }
        CalFrequencyEnum calFrequencyEnum = CalFrequencyEnum.valueOf((String)frequency);
        switch (calFrequencyEnum) {
            case MONTH: {
                calPeriodFrequencyService = new CalPeriodMonthFrequencyImpl(abstractFormPlugin, model);
                break;
            }
            case WEEK: 
            case BIWEEKLY: {
                calPeriodFrequencyService = new CalPeriodWeekFrequencyImpl(abstractFormPlugin, model);
                break;
            }
            case HALF_MONTH: {
                calPeriodFrequencyService = new CalPeriodHalfMonthFrequencyImpl(abstractFormPlugin, model);
                break;
            }
            case DAY: {
                calPeriodFrequencyService = new CalPeriodDayFrequencyImpl(abstractFormPlugin, model);
                break;
            }
            default: {
                calPeriodFrequencyService = new DefaultFrequencyImpl(abstractFormPlugin, model);
            }
        }
        return calPeriodFrequencyService;
    }
}

