/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.calperiod;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbs.business.calperiod.AbstractCalPeriodFrequency;
import kd.swc.hsbs.business.calperiod.CalPeriodMonthFrequencyImpl;
import kd.swc.hsbs.common.vo.BatchGenerateReturnInfo;

public class CalPeriodHalfMonthFrequencyImpl
extends AbstractCalPeriodFrequency {
    private static final Log logger = LogFactory.getLog(CalPeriodHalfMonthFrequencyImpl.class);
    private static HashSet<Integer> lastDay = new HashSet(16);

    public CalPeriodHalfMonthFrequencyImpl(AbstractFormPlugin abstractFormPlugin, IDataModel model) {
        this.abstractFormPlugin = abstractFormPlugin;
        this.model = model;
    }

    @Override
    public boolean parametersMandatory() {
        DynamicObject dataEntity = this.model.getDataEntity();
        int secSelectDay = dataEntity.getInt("halfmonthsecday");
        int firstSelectDay = dataEntity.getInt("halfmonthfirstday");
        return firstSelectDay == 0 || secSelectDay == 0;
    }

    @Override
    public void setVisible(IDataModel model) {
        IFormView view = this.abstractFormPlugin.getView();
        this.setFieldMustInput(true, this.abstractFormPlugin, "halfmonthfirstday", "halfmonthsecday");
        this.setFieldMustInput(false, this.abstractFormPlugin, "monthday", "weekday");
        view.setVisible(Boolean.TRUE, new String[]{"salfmonthfrequencyrule", "batchgenerate"});
        view.setVisible(Boolean.FALSE, new String[]{"monthfrequencyrule", "weekfrequencyrule"});
        model.setValue("monthday", null);
        model.setValue("weekday", null);
        this.setCountryVisible();
    }

    @Override
    public boolean checkButtonEnable(BeforeDoOperationEventArgs args, Map<String, Object> map) {
        DynamicObject dataEntity = this.model.getDataEntity();
        int secSelectDay = dataEntity.getInt("halfmonthsecday");
        int firstSelectDay = dataEntity.getInt("halfmonthfirstday");
        map.put("halfmonthfirstday", firstSelectDay);
        map.put("halfmonthsecday", secSelectDay);
        FormOperate operate = (FormOperate)args.getSource();
        if (operate.getOption().tryGetVariableValue("operation", new RefObject())) {
            return true;
        }
        if (firstSelectDay == 0 || secSelectDay == 0) {
            return false;
        }
        int interval = Math.abs(secSelectDay - firstSelectDay);
        if (interval < 13 || interval > 16) {
            args.setCancel(true);
            map.put("code", -2);
            return false;
        }
        return true;
    }

    @Override
    public int[] batchGenerateCalPeriod(BatchGenerateReturnInfo batchGenerateReturnInfo) {
        int firstSelectDay = batchGenerateReturnInfo.getHalfMonthFirstDay();
        int secSelectDay = batchGenerateReturnInfo.getHalfMonthSecDay();
        Date startDate = batchGenerateReturnInfo.getStartDate();
        int createRowCount = batchGenerateReturnInfo.getCreateRowCount();
        if (secSelectDay == Integer.parseInt(SWCDateTimeUtils.format((Date)startDate, (String)"dd")) || lastDay.contains(Integer.parseInt(SWCDateTimeUtils.format((Date)startDate, (String)"dd"))) && secSelectDay == 31) {
            int temp = firstSelectDay;
            firstSelectDay = secSelectDay;
            secSelectDay = temp;
        }
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.model;
        abstractFormDataModel.beginInit();
        TableValueSetter entry = this.createTableValueSetter();
        String rateDateUseField = batchGenerateReturnInfo.getRateDateUseField();
        String rateDateRule = batchGenerateReturnInfo.getRateDateRule();
        int rateDateDay = batchGenerateReturnInfo.getRateDateDay();
        String payDateUseField = batchGenerateReturnInfo.getPayDateUseField();
        String payDateRule = batchGenerateReturnInfo.getPayDateRule();
        int payDateDay = batchGenerateReturnInfo.getPayDateDay();
        String periodDateUseField = batchGenerateReturnInfo.getPeriodDateUseField();
        Date endDate = this.getEndDate(startDate, firstSelectDay, secSelectDay);
        for (int index = 0; index < createRowCount; ++index) {
            Date endDateValue = SWCDateTimeUtils.addDay((Date)endDate, (long)-1L);
            if (createRowCount == 1) {
                batchGenerateReturnInfo.setLastPeriod(startDate, endDateValue);
                batchGenerateReturnInfo.setFirstPeriod(startDate, endDateValue);
            } else if (index == 0) {
                batchGenerateReturnInfo.setFirstPeriod(startDate, endDateValue);
            } else if (index == createRowCount - 1) {
                batchGenerateReturnInfo.setLastPeriod(startDate, endDateValue);
            }
            try {
                Date rateDate = "startdate".equals(rateDateUseField) ? this.addDayByRule(startDate, rateDateRule, rateDateDay) : this.addDayByRule(endDateValue, rateDateRule, rateDateDay);
                Date payDate = "startdate".equals(payDateUseField) ? this.addDayByRule(startDate, payDateRule, payDateDay) : this.addDayByRule(endDateValue, payDateRule, payDateDay);
                entry.addRow(new Object[]{batchGenerateReturnInfo.getCalFrequencyPkValue(), startDate, endDateValue, rateDate, payDate, this.getDate(periodDateUseField, startDate, endDateValue, payDate, "yyyy"), this.getDate(periodDateUseField, startDate, endDateValue, payDate, "yyyy-MM")});
            }
            catch (ParseException e) {
                logger.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
            }
            Date temp = endDate;
            if (firstSelectDay == 31) {
                if (index % 2 == 0) {
                    endDate = CalPeriodMonthFrequencyImpl.getLastDayOfMonth(temp);
                    startDate = temp;
                    continue;
                }
                endDate = CalPeriodHalfMonthFrequencyImpl.addMonth(startDate, 1);
                startDate = CalPeriodMonthFrequencyImpl.getLastDayOfMonth(temp);
                continue;
            }
            if (secSelectDay == 31) {
                endDate = index % 2 == 0 ? CalPeriodHalfMonthFrequencyImpl.addMonth(startDate, 1) : CalPeriodMonthFrequencyImpl.getLastDayOfMonth(CalPeriodHalfMonthFrequencyImpl.addMonth(startDate, 1));
                startDate = temp;
                continue;
            }
            endDate = CalPeriodHalfMonthFrequencyImpl.addMonth(startDate, 1);
            startDate = temp;
        }
        int[] createNewEntryRow = abstractFormDataModel.batchCreateNewEntryRow("entryentity", entry);
        abstractFormDataModel.endInit();
        return createNewEntryRow;
    }

    public static Date addMonth(Date startDate, int month) {
        LocalDateTime localDateTime = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().plusMonths(month);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    private Date getEndDate(Date startDate, int firstSelectDay, int secSelectDay) {
        Date endDate;
        Calendar cal = Calendar.getInstance();
        if (firstSelectDay < secSelectDay) {
            if (secSelectDay == 31) {
                endDate = CalPeriodMonthFrequencyImpl.getLastDayOfMonth(startDate);
            } else {
                cal.setTime(startDate);
                cal.set(5, secSelectDay);
                endDate = cal.getTime();
            }
        } else {
            cal.setTime(startDate);
            cal.add(2, 1);
            cal.set(5, secSelectDay);
            endDate = cal.getTime();
        }
        return endDate;
    }

    static {
        lastDay.add(29);
        lastDay.add(30);
        lastDay.add(31);
    }
}

