/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.calperiod;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbs.business.calperiod.AbstractCalPeriodFrequency;
import kd.swc.hsbs.common.vo.BatchGenerateReturnInfo;

public class CalPeriodMonthFrequencyImpl
extends AbstractCalPeriodFrequency {
    private static final Log logger = LogFactory.getLog(CalPeriodMonthFrequencyImpl.class);

    public CalPeriodMonthFrequencyImpl(AbstractFormPlugin abstractFormPlugin, IDataModel model) {
        this.abstractFormPlugin = abstractFormPlugin;
        this.model = model;
    }

    @Override
    public boolean parametersMandatory() {
        int selectDay = this.model.getDataEntity().getInt("monthday");
        return selectDay == 0;
    }

    @Override
    public void setVisible(IDataModel model) {
        IFormView view = this.abstractFormPlugin.getView();
        this.setFieldMustInput(true, this.abstractFormPlugin, "monthday");
        this.setFieldMustInput(false, this.abstractFormPlugin, "halfmonthfirstday", "halfmonthsecday", "weekday");
        view.setVisible(Boolean.TRUE, new String[]{"monthfrequencyrule", "batchgenerate"});
        view.setVisible(Boolean.FALSE, new String[]{"salfmonthfrequencyrule", "weekfrequencyrule"});
        view.setVisible(Boolean.FALSE, new String[]{"salfmonthfrequencyrule", "weekfrequencyrule"});
        model.setValue("halfmonthfirstday", null);
        model.setValue("halfmonthsecday", null);
        model.setValue("weekday", null);
        this.setCountryVisible();
    }

    @Override
    public boolean checkButtonEnable(BeforeDoOperationEventArgs args, Map<String, Object> map) {
        int selectDay = this.model.getDataEntity().getInt("monthday");
        if (selectDay == 0) {
            return false;
        }
        map.put("monthday", selectDay);
        return true;
    }

    @Override
    public int[] batchGenerateCalPeriod(BatchGenerateReturnInfo batchGenerateReturnInfo) {
        int createRowCount = batchGenerateReturnInfo.getCreateRowCount();
        int startDay = batchGenerateReturnInfo.getMonthDay();
        Date startDate = batchGenerateReturnInfo.getStartDate();
        boolean flag = true;
        if (startDay == 31) {
            flag = false;
        }
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.model;
        abstractFormDataModel.beginInit();
        TableValueSetter entry = this.createTableValueSetter();
        String rateDateUseField = batchGenerateReturnInfo.getRateDateUseField();
        String rateDateRule = batchGenerateReturnInfo.getRateDateRule();
        int rateDateDay = batchGenerateReturnInfo.getRateDateDay();
        String payDateUseField = batchGenerateReturnInfo.getPayDateUseField();
        String payDateRule = batchGenerateReturnInfo.getPayDateRule();
        int payDateDay = batchGenerateReturnInfo.getPayDateDay();
        String periodDateUseField = batchGenerateReturnInfo.getPeriodDateUseField();
        for (int index = 0; index < createRowCount; ++index) {
            Date endDate = flag ? CalPeriodMonthFrequencyImpl.addMonth(startDate, 1) : CalPeriodMonthFrequencyImpl.getLastDayOfMonth(CalPeriodMonthFrequencyImpl.addMonth(startDate, 1));
            Date endDateValue = SWCDateTimeUtils.addDay((Date)endDate, (long)-1L);
            if (createRowCount == 1) {
                batchGenerateReturnInfo.setLastPeriod(startDate, endDateValue);
                batchGenerateReturnInfo.setFirstPeriod(startDate, endDateValue);
            } else if (index == 0) {
                batchGenerateReturnInfo.setFirstPeriod(startDate, endDateValue);
            } else if (index == createRowCount - 1) {
                batchGenerateReturnInfo.setLastPeriod(startDate, endDateValue);
            }
            try {
                Date payDate = "startdate".equals(payDateUseField) ? this.addDayByRule(startDate, payDateRule, payDateDay) : this.addDayByRule(endDateValue, payDateRule, payDateDay);
                entry.addRow(new Object[]{batchGenerateReturnInfo.getCalFrequencyPkValue(), startDate, endDateValue, "startdate".equals(rateDateUseField) ? this.addDayByRule(startDate, rateDateRule, rateDateDay) : this.addDayByRule(endDateValue, rateDateRule, rateDateDay), payDate, this.getDate(periodDateUseField, startDate, endDateValue, payDate, "yyyy"), this.getDate(periodDateUseField, startDate, endDateValue, payDate, "yyyy-MM")});
            }
            catch (ParseException e) {
                logger.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
            }
            startDate = endDate;
        }
        int[] createNewEntryRow = abstractFormDataModel.batchCreateNewEntryRow("entryentity", entry);
        abstractFormDataModel.endInit();
        return createNewEntryRow;
    }

    public static Date addMonth(Date startDate, int month) {
        LocalDateTime localDateTime = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().plusMonths(month);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int last = cal.getActualMaximum(5);
        cal.set(5, last);
        return cal.getTime();
    }
}

