/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.calperiod;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.enums.CalFrequencyEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbs.business.calperiod.AbstractCalPeriodFrequency;
import kd.swc.hsbs.common.vo.BatchGenerateReturnInfo;

public class CalPeriodWeekFrequencyImpl
extends AbstractCalPeriodFrequency {
    private static final Log logger = LogFactory.getLog(CalPeriodWeekFrequencyImpl.class);

    public CalPeriodWeekFrequencyImpl(AbstractFormPlugin abstractFormPlugin, IDataModel model) {
        this.abstractFormPlugin = abstractFormPlugin;
        this.model = model;
    }

    @Override
    public boolean parametersMandatory() {
        int weekday = this.model.getDataEntity().getInt("weekday");
        return weekday == 0;
    }

    @Override
    public void setVisible(IDataModel model) {
        IFormView view = this.abstractFormPlugin.getView();
        this.setFieldMustInput(true, this.abstractFormPlugin, "weekday");
        this.setFieldMustInput(false, this.abstractFormPlugin, "halfmonthfirstday", "halfmonthsecday", "monthday");
        view.setVisible(Boolean.TRUE, new String[]{"weekfrequencyrule", "batchgenerate"});
        view.setVisible(Boolean.FALSE, new String[]{"monthfrequencyrule", "salfmonthfrequencyrule"});
        model.setValue("halfmonthfirstday", null);
        model.setValue("halfmonthsecday", null);
        model.setValue("monthday", null);
        this.setCountryVisible();
    }

    @Override
    public boolean checkButtonEnable(BeforeDoOperationEventArgs args, Map<String, Object> map) {
        int weekday = this.model.getDataEntity().getInt("weekday");
        if (weekday == 0) {
            return false;
        }
        map.put("weekday", weekday);
        return true;
    }

    @Override
    public int[] batchGenerateCalPeriod(BatchGenerateReturnInfo batchGenerateReturnInfo) {
        Date startDate = batchGenerateReturnInfo.getStartDate();
        int createRowCount = batchGenerateReturnInfo.getCreateRowCount();
        String frequency = batchGenerateReturnInfo.getCalFrequencyType();
        int interval = CalFrequencyEnum.valueOf((String)frequency).equals((Object)CalFrequencyEnum.WEEK) ? 6 : 13;
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.model;
        abstractFormDataModel.beginInit();
        TableValueSetter entry = this.createTableValueSetter();
        String rateDateUseField = batchGenerateReturnInfo.getRateDateUseField();
        String rateDateRule = batchGenerateReturnInfo.getRateDateRule();
        int rateDateDay = batchGenerateReturnInfo.getRateDateDay();
        String payDateUseField = batchGenerateReturnInfo.getPayDateUseField();
        String payDateRule = batchGenerateReturnInfo.getPayDateRule();
        int payDateDay = batchGenerateReturnInfo.getPayDateDay();
        String periodDateUseField = batchGenerateReturnInfo.getPeriodDateUseField();
        for (int index = 0; index < createRowCount; ++index) {
            Date endDate = SWCDateTimeUtils.addDay((Date)startDate, (long)interval);
            if (createRowCount == 1) {
                batchGenerateReturnInfo.setLastPeriod(startDate, endDate);
                batchGenerateReturnInfo.setFirstPeriod(startDate, endDate);
            } else if (index == 0) {
                batchGenerateReturnInfo.setFirstPeriod(startDate, endDate);
            } else if (index == createRowCount - 1) {
                batchGenerateReturnInfo.setLastPeriod(startDate, endDate);
            }
            try {
                Date payDate = "startdate".equals(payDateUseField) ? this.addDayByRule(startDate, payDateRule, payDateDay) : this.addDayByRule(endDate, payDateRule, payDateDay);
                entry.addRow(new Object[]{batchGenerateReturnInfo.getCalFrequencyPkValue(), startDate, endDate, "startdate".equals(rateDateUseField) ? this.addDayByRule(startDate, rateDateRule, rateDateDay) : this.addDayByRule(endDate, rateDateRule, rateDateDay), payDate, this.getDate(periodDateUseField, startDate, endDate, payDate, "yyyy"), this.getDate(periodDateUseField, startDate, endDate, payDate, "yyyy-MM")});
            }
            catch (ParseException e) {
                logger.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
            }
            startDate = SWCDateTimeUtils.addDay((Date)endDate, (long)1L);
        }
        int[] createNewEntryRow = abstractFormDataModel.batchCreateNewEntryRow("entryentity", entry);
        abstractFormDataModel.endInit();
        return createNewEntryRow;
    }
}

