/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.cloudcolla.migrate;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class HSBSCloudCollaBizAppUpdateHelper {
    public static HSBSCloudCollaBizAppUpdateHelper getInstance() {
        return Load.INSTANCE;
    }

    private HSBSCloudCollaBizAppUpdateHelper() {
    }

    public void execute() {
        this.triggerCollaUpdate();
        this.payRollActUpdate();
        this.payRollActTplUpdate();
    }

    private void triggerCollaUpdate() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_triggercolla");
        QFilter filter = QFilter.isNotNull((String)"entityobject").and(QFilter.emptyOrNotExists((String)"bizapp"));
        DynamicObject[] queryDatas = helper.query("id,entityobject,entityobject.bizappid,bizapp", new QFilter[]{filter});
        if (queryDatas == null || queryDatas.length == 0) {
            return;
        }
        SWCDataServiceHelper objectOrm = new SWCDataServiceHelper("bos_entityobject");
        Set objectSet = Arrays.stream(queryDatas).map(item -> item.getString("entityobject.id")).collect(Collectors.toSet());
        DynamicObject[] apps = objectOrm.query("id,number,bizappid", new QFilter[]{new QFilter("id", "in", objectSet)});
        if (apps == null || apps.length == 0) {
            return;
        }
        Map<String, String> objectAppMap = Arrays.stream(apps).collect(Collectors.toMap(item -> item.getString("id"), item -> item.getString("bizappid.id"), (v1, v2) -> v1));
        for (DynamicObject triggerColla : queryDatas) {
            String entityObjectId = triggerColla.getString("entityobject.id");
            triggerColla.set("bizapp", (Object)objectAppMap.get(entityObjectId));
        }
        helper.save(queryDatas);
    }

    private void payRollActUpdate() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_payrollact");
        DynamicObject[] queryDatas = helper.query("id,bizapp,triggercolla.bizapp", new QFilter[]{QFilter.emptyOrNotExists((String)"bizapp")});
        if (queryDatas == null || queryDatas.length == 0) {
            return;
        }
        HashSet triggerIds = new HashSet(queryDatas.length);
        for (DynamicObject queryData : queryDatas) {
            DynamicObjectCollection entryEntity = queryData.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) continue;
            Set tempIds = entryEntity.stream().map(item -> item.getLong("triggercolla.id")).collect(Collectors.toSet());
            triggerIds.addAll(tempIds);
        }
        SWCDataServiceHelper triggerCollaHelper = new SWCDataServiceHelper("hsbs_triggercolla");
        DynamicObject[] triggers = triggerCollaHelper.query("id,number,bizapp", new QFilter[]{new QFilter("id", "in", triggerIds)});
        if (triggers == null || triggers.length == 0) {
            return;
        }
        Map<Long, String> triggerAppMap = Arrays.stream(triggers).filter(item -> SWCStringUtils.isNotEmpty((String)item.getString("bizapp.id"))).collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getString("bizapp.id"), (v1, v2) -> v1));
        for (DynamicObject queryData : queryDatas) {
            Long triggerCollaId;
            DynamicObjectCollection entryEntity = queryData.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity) || (triggerCollaId = Long.valueOf(((DynamicObject)entryEntity.get(0)).getLong("triggercolla.id"))) == null || triggerCollaId == 0L) continue;
            queryData.set("bizapp", (Object)triggerAppMap.get(triggerCollaId));
        }
        helper.save(queryDatas);
    }

    private void payRollActTplUpdate() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_payrollactgtpl");
        DynamicObject[] queryDatas = helper.query("id,bizapp,payrollact.bizapp", new QFilter[]{QFilter.emptyOrNotExists((String)"bizapp")});
        if (queryDatas == null || queryDatas.length == 0) {
            return;
        }
        HashSet triggerIds = new HashSet(queryDatas.length);
        for (DynamicObject queryData : queryDatas) {
            DynamicObjectCollection entryEntity = queryData.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) continue;
            Set tempIds = entryEntity.stream().filter(item -> item.getLong("payrollact.id") != 0L).map(item -> item.getLong("payrollact.id")).collect(Collectors.toSet());
            triggerIds.addAll(tempIds);
        }
        SWCDataServiceHelper payRollActHelper = new SWCDataServiceHelper("hsbs_payrollact");
        DynamicObject[] payRollActs = payRollActHelper.query("id,number,bizapp", new QFilter[]{new QFilter("id", "in", triggerIds)});
        if (payRollActs == null || payRollActs.length == 0) {
            return;
        }
        Map<Long, String> payRollActAppMap = Arrays.stream(payRollActs).filter(item -> SWCStringUtils.isNotEmpty((String)item.getString("bizapp.id"))).collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getString("bizapp.id"), (v1, v2) -> v1));
        for (DynamicObject queryData : queryDatas) {
            DynamicObjectCollection entryEntity = queryData.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) continue;
            Long payRollActId = ((DynamicObject)entryEntity.get(0)).getLong("payrollact.id");
            queryData.set("bizapp", (Object)payRollActAppMap.get(payRollActId));
        }
        helper.save(queryDatas);
    }

    static class Load {
        private static HSBSCloudCollaBizAppUpdateHelper INSTANCE = new HSBSCloudCollaBizAppUpdateHelper();

        Load() {
        }
    }
}

