/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.datareader;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IconProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.TextProp;
import kd.swc.hsbp.common.enums.ConditionFieldTypeEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class DataReaderHelper {
    public static Map<String, Map<String, String>> getPropertyClassMap(Map<String, EntityType> propertieCollection) {
        HashMap<String, Map<String, String>> dataMap = new HashMap<String, Map<String, String>>(2);
        Map propertyClassMap = dataMap.computeIfAbsent("codeMap", codeMap -> new HashMap(16));
        Map propertyNameMap = dataMap.computeIfAbsent("nameMap", nameMap -> new HashMap(16));
        Map sourceMap = dataMap.computeIfAbsent("sourceMap", nameMap -> new HashMap(16));
        for (Map.Entry<String, EntityType> entry : propertieCollection.entrySet()) {
            String key = entry.getKey();
            EntityType entityType = entry.getValue();
            Map fields = entityType.getFields();
            String prix = entityType instanceof EntryType ? key + "." : "";
            propertyClassMap.put("id", ConditionFieldTypeEnum.TYPE_ID.getCode());
            propertyNameMap.put("id", ConditionFieldTypeEnum.TYPE_ID.getCode());
            List<IDataEntityProperty> propertyList = fields.values().stream().collect(Collectors.toList());
            DataReaderHelper.doGetPropertyClassMap(propertyClassMap, propertyNameMap, prix, propertyList, "", sourceMap);
        }
        return dataMap;
    }

    public static void doGetPropertyClassMap(Map<String, String> propertyClassMap, Map<String, String> propertyNameMap, String prix, List<IDataEntityProperty> properties, String namePrix, Map<String, String> sourceMap) {
        for (IDataEntityProperty property : properties) {
            if (property instanceof MulComboProp) continue;
            if (property instanceof TextProp || property instanceof PictureProp || property instanceof IconProp || property instanceof AdminDivisionProp) {
                propertyClassMap.put(prix + property.getName(), ConditionFieldTypeEnum.TYPE_TEXT.getCode());
                propertyNameMap.put(prix + property.getName(), namePrix + property.getDisplayName());
                continue;
            }
            if (property instanceof ComboProp || property instanceof BooleanProp) {
                propertyClassMap.put(prix + property.getName(), ConditionFieldTypeEnum.TYPE_ENUM.getCode());
                propertyNameMap.put(prix + property.getName(), namePrix + property.getDisplayName());
                continue;
            }
            if (property instanceof DateTimeProp) {
                propertyClassMap.put(prix + property.getName(), ConditionFieldTypeEnum.TYPE_DATE.getCode());
                propertyNameMap.put(prix + property.getName(), namePrix + property.getDisplayName());
                continue;
            }
            if (property instanceof DecimalProp) {
                if (SWCStringUtils.equals((String)"boid", (String)property.getName())) {
                    propertyClassMap.put(prix + property.getName(), ConditionFieldTypeEnum.TYPE_ID.getCode());
                    propertyNameMap.put(prix + property.getName(), namePrix + property.getDisplayName());
                    continue;
                }
                propertyClassMap.put(prix + property.getName(), ConditionFieldTypeEnum.TYPE_NUM.getCode());
                propertyNameMap.put(prix + property.getName(), namePrix + property.getDisplayName());
                continue;
            }
            if (!(property instanceof BasedataProp)) continue;
            DataEntityPropertyCollection childProperties = ((BasedataProp)property).getDynamicComplexPropertyType().getProperties();
            List<IDataEntityProperty> childPropertieList = childProperties.stream().collect(Collectors.toList());
            String baseEntityId = ((BasedataProp)property).getBaseEntityId();
            propertyClassMap.put(prix + property.getName(), ConditionFieldTypeEnum.TYPE_ID.getCode());
            propertyNameMap.put(prix + property.getName(), "id");
            sourceMap.put(prix + property.getName() + ".id", baseEntityId);
            DataReaderHelper.doGetPropertyClassMap(propertyClassMap, propertyNameMap, prix + property.getName() + ".", childPropertieList, namePrix + property.getDisplayName() + ".", sourceMap);
        }
    }

    public static Set<String> getBaseDataKeySet(Collection<IDataEntityProperty> propertieCollection) {
        String prix = "";
        HashSet<String> baseDataKeySet = new HashSet<String>(16);
        baseDataKeySet.add("id");
        baseDataKeySet.add("bo");
        List<IDataEntityProperty> propertyList = propertieCollection.stream().collect(Collectors.toList());
        DataReaderHelper.doGetBaseDataKeySet(baseDataKeySet, prix, propertyList);
        return baseDataKeySet;
    }

    private static void doGetBaseDataKeySet(Set<String> baseDataKeySet, String prix, List<IDataEntityProperty> properties) {
        for (IDataEntityProperty property : properties) {
            if (property instanceof BasedataProp) {
                baseDataKeySet.add(prix + property.getName());
                DataEntityPropertyCollection childProperties = ((BasedataProp)property).getDynamicComplexPropertyType().getProperties();
                List<IDataEntityProperty> childPropertieList = childProperties.stream().collect(Collectors.toList());
                DataReaderHelper.doGetBaseDataKeySet(baseDataKeySet, prix + property.getName() + ".", childPropertieList);
                continue;
            }
            if (!(property instanceof BigIntProp)) continue;
            baseDataKeySet.add(prix + property.getName());
        }
    }
}

